from wthings_gateway.storage.event_storage import EventStorage, log
import queue
from logging import getLogger


class MemoryEventStorage(EventStorage):
    def __init__(self, config):
        self.__queue_len = config.get("max_records_count", 10000)
        self.__events_per_time = config.get("read_records_count", 1000)
        self.__events_queue = queue.Queue(self.__queue_len)
        self.__event_pack = []

    def put(self, event):
        if not self.__events_queue.full():
            self.__events_queue.put(event)
            return True
        else:
            return False

    def get_event_pack(self):
        if self.__event_pack:
            return self.__event_pack
        elif not self.__events_queue.empty():
            self.__event_pack = [self.__events_queue.get(False) for _ in range(min(self.__events_per_time, self.__events_queue.qsize()))]
            return self.__event_pack

    def event_pack_processing_done(self):
        self.__event_pack = []


