from unittest import TestCase

from .. import __version__
from ..config_generation import make_lax_baseline_mypy_config, make_strict_baseline_mypy_config
from ..own_config import TypingCopilotConfig


class ConfigGenerationTests(TestCase):
    def test_make_lax_config_with_empty_settings(self) -> None:
        own_config = TypingCopilotConfig.empty()

        expected_content = f"""\
# Autogenerated by typing_copilot v{__version__}
[mypy]
no_implicit_optional = False
strict_optional = False
warn_redundant_casts = False
check_untyped_defs = False
disallow_untyped_calls = False
disallow_incomplete_defs = False
disallow_untyped_defs = False
disallow_untyped_decorators = False
ignore_missing_imports = True
"""
        self.assertEqual(expected_content, make_lax_baseline_mypy_config(own_config))

    def test_make_strict_config_with_empty_settings(self) -> None:
        own_config = TypingCopilotConfig.empty()

        expected_content = f"""\
# Autogenerated by typing_copilot v{__version__}
[mypy]
no_implicit_optional = True
strict_optional = True
warn_redundant_casts = True
check_untyped_defs = True
disallow_untyped_calls = True
disallow_incomplete_defs = True
disallow_untyped_defs = True
disallow_untyped_decorators = True
ignore_missing_imports = False
"""
        self.assertEqual(expected_content, make_strict_baseline_mypy_config(own_config))
