"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const elasticloadbalancingv2_generated_1 = require("../elasticloadbalancingv2.generated");
/**
 * Base class for listeners
 */
class BaseListener extends core_1.Resource {
    constructor(scope, id, additionalProps) {
        super(scope, id);
        const resource = new elasticloadbalancingv2_generated_1.CfnListener(this, 'Resource', {
            ...additionalProps,
            defaultActions: core_1.Lazy.anyValue({ produce: () => this.defaultAction ? this.defaultAction.renderActions() : [] }),
        });
        this.listenerArn = resource.ref;
    }
    /**
     * Validate this listener
     */
    validate() {
        if (!this.defaultAction) {
            return ['Listener needs at least one default action or target group (call addTargetGroups or addAction)'];
        }
        return [];
    }
    /**
     * Configure the default action
     *
     * @internal
     */
    _setDefaultAction(action) {
        // It might make sense to 'throw' here.
        //
        // However, programs may already exist out there which configured an action twice,
        // in which case the second action accidentally overwrite the initial action, and in some
        // way ended up with a program that did what the author intended. If we were to add throw now,
        // the previously working program would be broken.
        //
        // Instead, signal this through a warning.
        // @deprecate: upon the next major version bump, replace this with a `throw`
        if (this.defaultAction) {
            this.node.addWarning('A default Action already existed on this Listener and was replaced. Configure exactly one default Action.');
        }
        this.defaultAction = action;
    }
}
exports.BaseListener = BaseListener;
//# sourceMappingURL=data:application/json;base64,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