# This file was generated by mettle.genes.braze.GenPy3 [ver 2.1] on Wed May 11 09:28:46 2022
#

import datetime
import uuid
import dataclasses
import typing
import mettle.braze
import mettle.lib

import traceback

from mettle.braze.iserver_interface import IServerInterface
from mettle.braze.iserver_marshaler import IServerMarshaler
from mettle.io.istream import IStream
from mettle.braze.server import Server
from mettle.lib.xmettle import xMettle
from .fura_async_server_interface import FuraAsyncServerInterface

from bs_fura.db.tables import tConfig
from bs_fura.db.tables import tFunc
from bs_fura.db.tables import tFuncGrp
from bs_fura.db.tables import tRole
from bs_fura.db.tables import tSiteCfg
from bs_fura.db.tables import tSite
from bs_fura.db.tables import tUsr
from bs_fura.db.tables import tUsrType

from .bauth_policy import bAuthPolicy
from .buser_login import bUserLogin
from .brole_func_rel import bRoleFuncRel

class FuraAsyncServerMarshaler(IServerMarshaler, FuraAsyncServerInterface):

    def __init__(self, server_impl: IServerInterface):
        """
        Constructor.

        :param server_impl: braze client object.
        """
        self._server   = None
        self._simpl    = server_impl

    def _signature(self) -> str:
        """
        Gets the server signature.

        :return: the signature of this server.
        """
        return 'Fura'

    def _server_impl(self) -> IServerInterface:
        """
        Gets the server implementation.

        :return: the overloaded server interface/server implementation object.
        """
        return self._simpl

    async def _serve_async(self, server: Server, remote_sig: "str|int", in_stream: IStream, impl_data: dict = None):
        """
        The main server entry point to the marshaler.

        :param server: The server object to use.
        :param remote_sig: The client rpc signature.
        :param in_stream:  The input stream.
        :param impl_data: Any optional impl server data.
        :return: a tuple of (out_stream, err_code, err_msg)
        """
        self._server = server
        out_stream   = None

        try:
            self._simpl._set_impl_data(impl_data)

            if remote_sig == 'authPolicyRead':
                out_stream = await self.auth_policy_read(in_stream)
            elif remote_sig == 'configCreate':
                out_stream = await self.config_create(in_stream)
            elif remote_sig == 'configRead':
                out_stream = await self.config_read(in_stream)
            elif remote_sig == 'configUpdate':
                out_stream = await self.config_update(in_stream)
            elif remote_sig == 'configDelete':
                out_stream = await self.config_delete(in_stream)
            elif remote_sig == 'funcRead':
                out_stream = await self.func_read(in_stream)
            elif remote_sig == 'funcGrpRead':
                out_stream = await self.func_grp_read(in_stream)
            elif remote_sig == 'roleCreate':
                out_stream = await self.role_create(in_stream)
            elif remote_sig == 'roleRead':
                out_stream = await self.role_read(in_stream)
            elif remote_sig == 'roleUpdate':
                out_stream = await self.role_update(in_stream)
            elif remote_sig == 'roleDelete':
                out_stream = await self.role_delete(in_stream)
            elif remote_sig == 'roleFuncAdd':
                out_stream = await self.role_func_add(in_stream)
            elif remote_sig == 'roleFuncRem':
                out_stream = await self.role_func_rem(in_stream)
            elif remote_sig == 'roleFuncRead':
                out_stream = await self.role_func_read(in_stream)
            elif remote_sig == 'siteCfgCreate':
                out_stream = await self.site_cfg_create(in_stream)
            elif remote_sig == 'siteCfgRead':
                out_stream = await self.site_cfg_read(in_stream)
            elif remote_sig == 'siteCfgUpdate':
                out_stream = await self.site_cfg_update(in_stream)
            elif remote_sig == 'siteCfgDelete':
                out_stream = await self.site_cfg_delete(in_stream)
            elif remote_sig == 'siteCreate':
                out_stream = await self.site_create(in_stream)
            elif remote_sig == 'siteRead':
                out_stream = await self.site_read(in_stream)
            elif remote_sig == 'siteUpdate':
                out_stream = await self.site_update(in_stream)
            elif remote_sig == 'siteDelete':
                out_stream = await self.site_delete(in_stream)
            elif remote_sig == 'userCreate':
                out_stream = await self.user_create(in_stream)
            elif remote_sig == 'userRead':
                out_stream = await self.user_read(in_stream)
            elif remote_sig == 'userUpdate':
                out_stream = await self.user_update(in_stream)
            elif remote_sig == 'userDelete':
                out_stream = await self.user_delete(in_stream)
            elif remote_sig == 'userRec':
                out_stream = await self.user_rec(in_stream)
            elif remote_sig == 'userFuncs':
                out_stream = await self.user_funcs(in_stream)
            elif remote_sig == 'userLogin':
                out_stream = await self.user_login(in_stream)
            elif remote_sig == 'userLogout':
                out_stream = await self.user_logout(in_stream)
            elif remote_sig == 'userRole':
                out_stream = await self.user_role(in_stream)
            elif remote_sig == 'userIsSuperUser':
                out_stream = await self.user_is_super_user(in_stream)
            elif remote_sig == 'userAuthChange':
                out_stream = await self.user_auth_change(in_stream)
            elif remote_sig == 'userAuthReset':
                out_stream = await self.user_auth_reset(in_stream)
            elif remote_sig == 'userTokenReset':
                out_stream = await self.user_token_reset(in_stream)
            elif remote_sig == 'userAuthResetAdmin':
                out_stream = await self.user_auth_reset_admin(in_stream)
            elif remote_sig == 'userTokenResetAdmin':
                out_stream = await self.user_token_reset_admin(in_stream)
            elif remote_sig == 'userTokenRead':
                out_stream = await self.user_token_read(in_stream)
            elif remote_sig == 'userSetNewAuth':
                out_stream = await self.user_set_new_auth(in_stream)
            elif remote_sig == 'userActivate':
                out_stream = await self.user_activate(in_stream)
            elif remote_sig == 'userDisable':
                out_stream = await self.user_disable(in_stream)
            elif remote_sig == 'userSuspend':
                out_stream = await self.user_suspend(in_stream)
            elif remote_sig == 'userSetRole':
                out_stream = await self.user_set_role(in_stream)
            elif remote_sig == 'userConfirmContact':
                out_stream = await self.user_confirm_contact(in_stream)
            elif remote_sig == 'userConfirmContactReqOtp':
                out_stream = await self.user_confirm_contact_req_otp(in_stream)
            elif remote_sig == 'userTypeCreate':
                out_stream = await self.user_type_create(in_stream)
            elif remote_sig == 'userTypeRead':
                out_stream = await self.user_type_read(in_stream)
            elif remote_sig == 'userTypeUpdate':
                out_stream = await self.user_type_update(in_stream)
            elif remote_sig == 'userTypeDelete':
                out_stream = await self.user_type_delete(in_stream)
            else:
                raise xMettle("Remote signature not known [%s]" % remote_sig)
        except xMettle as x:
            self._server.logger().error("Exception caught [client_address:%s, msg:%s, trace:%s]" % (self._server.get_transport().client_address(), str(x), traceback.format_exc()))

            if x.get_error_code() == xMettle.eCode.TerminalException:
                raise x

            return out_stream, x.get_error_code(), str(x)

        except Exception as x:
            self._server.logger().error("Exception caught [client_address:%s, msg:%s, trace:%s]" % (self._server.get_transport().client_address(), str(x), traceback.format_exc()))

            return out_stream, xMettle.eCode.UnknownException, str(x)

        return out_stream, 0, None

    async def auth_policy_read(self, _i):
        self._server.logger().debug("[auth_policy_read - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("authPolicyRead_IN")
        auth_type = _r.read_char("authType")
        site_code = _r.read_string("siteCode")
        _r.read_end("authPolicyRead_IN")

        self._simpl._set_rpc_token_data(None)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("authPolicyRead", _dvc)

        _dvc.clear()
        _dvc.add_targ("auth_type", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['P','S','T']))
        _dvc.validate("auth_type", auth_type)

        _dvc.clear()
        _dvc.add_targ("site_code", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 32))
        _dvc.validate("site_code", site_code)

        _x = await self._simpl.auth_policy_read(auth_type,
                                                site_code)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("authPolicyRead_OUT")
        _x._serialize(_w)
        _w.write_end("authPolicyRead_OUT")

        self._server.logger().debug("[auth_policy_read - Done]")

        return _o

    async def config_create(self, _i):
        self._server.logger().debug("[config_create - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        rec = tConfig()

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("configCreate_IN")
        rec._deserialize(_r, "rec")
        _r.read_end("configCreate_IN")

        tok = await self._server.auth_async("configCreate", "fura.cfg.create", {"rec":rec})
        self._simpl._set_rpc_token_data(tok)

        _x = await self._simpl.config_create(rec)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("configCreate_OUT")
        _x._serialize(_w)
        _w.write_end("configCreate_OUT")

        self._server.logger().debug("[config_create - Done]")

        return _o

    async def config_read(self, _i):
        self._server.logger().debug("[config_read - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("configRead_IN")
        cfg_id = _r.read_string("cfgId")
        _r.read_end("configRead_IN")

        tok = await self._server.auth_async("configRead", "fura.cfg.read", {"cfgId":cfg_id})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("configRead", _dvc)

        _dvc.clear()
        _dvc.add_targ("cfg_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        _dvc.validate("cfg_id", cfg_id)

        _x = await self._simpl.config_read(cfg_id)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("configRead_OUT")
        _x._serialize(_w)
        _w.write_end("configRead_OUT")

        self._server.logger().debug("[config_read - Done]")

        return _o

    async def config_update(self, _i):
        self._server.logger().debug("[config_update - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        rec = tConfig()

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("configUpdate_IN")
        rec._deserialize(_r, "rec")
        _r.read_end("configUpdate_IN")

        tok = await self._server.auth_async("configUpdate", "fura.cfg.update", {"rec":rec})
        self._simpl._set_rpc_token_data(tok)

        _x = await self._simpl.config_update(rec)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("configUpdate_OUT")
        _x._serialize(_w)
        _w.write_end("configUpdate_OUT")

        self._server.logger().debug("[config_update - Done]")

        return _o

    async def config_delete(self, _i):
        self._server.logger().debug("[config_delete - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("configDelete_IN")
        cfg_id = _r.read_string("cfgId")
        _r.read_end("configDelete_IN")

        tok = await self._server.auth_async("configDelete", "fura.cfg.delete", {"cfgId":cfg_id})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("configDelete", _dvc)

        _dvc.clear()
        _dvc.add_targ("cfg_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("cfg_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        _dvc.validate("cfg_id", cfg_id)

        await self._simpl.config_delete(cfg_id)

        self._server.logger().debug("[config_delete - Done]")

        return _o

    async def func_read(self, _i):
        self._server.logger().debug("[func_read - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("funcRead_IN")
        func_id = _r.read_string("funcId")
        func_grp_id = _r.read_string("funcGrpId")
        _r.read_end("funcRead_IN")

        tok = await self._server.auth_async("funcRead", "fura.func.read", {"funcId":func_id, "funcGrpId":func_grp_id})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("funcRead", _dvc)

        _dvc.clear()
        _dvc.add_targ("func_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        _dvc.validate("func_id", func_id)

        _dvc.clear()
        _dvc.add_targ("func_grp_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        _dvc.validate("func_grp_id", func_grp_id)

        _x = await self._simpl.func_read(func_id,
                                         func_grp_id)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("funcRead_OUT")
        _x._serialize(_w)
        _w.write_end("funcRead_OUT")

        self._server.logger().debug("[func_read - Done]")

        return _o

    async def func_grp_read(self, _i):
        self._server.logger().debug("[func_grp_read - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("funcGrpRead_IN")
        func_grp_id = _r.read_string("funcGrpId")
        _r.read_end("funcGrpRead_IN")

        tok = await self._server.auth_async("funcGrpRead", "fura.funcgrp.read", {"funcGrpId":func_grp_id})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("funcGrpRead", _dvc)

        _dvc.clear()
        _dvc.add_targ("func_grp_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        _dvc.validate("func_grp_id", func_grp_id)

        _x = await self._simpl.func_grp_read(func_grp_id)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("funcGrpRead_OUT")
        _x._serialize(_w)
        _w.write_end("funcGrpRead_OUT")

        self._server.logger().debug("[func_grp_read - Done]")

        return _o

    async def role_create(self, _i):
        self._server.logger().debug("[role_create - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        rec = tRole()

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("roleCreate_IN")
        rec._deserialize(_r, "rec")
        _r.read_end("roleCreate_IN")

        tok = await self._server.auth_async("roleCreate", "fura.role.create", {"rec":rec})
        self._simpl._set_rpc_token_data(tok)

        _x = await self._simpl.role_create(rec)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("roleCreate_OUT")
        _x._serialize(_w)
        _w.write_end("roleCreate_OUT")

        self._server.logger().debug("[role_create - Done]")

        return _o

    async def role_read(self, _i):
        self._server.logger().debug("[role_read - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("roleRead_IN")
        role_id = _r.read_string("roleId")
        _r.read_end("roleRead_IN")

        tok = await self._server.auth_async("roleRead", "fura.role.read", {"roleId":role_id})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("roleRead", _dvc)

        _dvc.clear()
        _dvc.add_targ("role_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        _dvc.validate("role_id", role_id)

        _x = await self._simpl.role_read(role_id)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("roleRead_OUT")
        _x._serialize(_w)
        _w.write_end("roleRead_OUT")

        self._server.logger().debug("[role_read - Done]")

        return _o

    async def role_update(self, _i):
        self._server.logger().debug("[role_update - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        rec = tRole()

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("roleUpdate_IN")
        rec._deserialize(_r, "rec")
        _r.read_end("roleUpdate_IN")

        tok = await self._server.auth_async("roleUpdate", "fura.role.update", {"rec":rec})
        self._simpl._set_rpc_token_data(tok)

        _x = await self._simpl.role_update(rec)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("roleUpdate_OUT")
        _x._serialize(_w)
        _w.write_end("roleUpdate_OUT")

        self._server.logger().debug("[role_update - Done]")

        return _o

    async def role_delete(self, _i):
        self._server.logger().debug("[role_delete - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("roleDelete_IN")
        role_id = _r.read_string("roleId")
        _r.read_end("roleDelete_IN")

        tok = await self._server.auth_async("roleDelete", "fura.role.delete", {"roleId":role_id})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("roleDelete", _dvc)

        _dvc.clear()
        _dvc.add_targ("role_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("role_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        _dvc.validate("role_id", role_id)

        await self._simpl.role_delete(role_id)

        self._server.logger().debug("[role_delete - Done]")

        return _o

    async def role_func_add(self, _i):
        self._server.logger().debug("[role_func_add - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None

        rfs = mettle.braze.StringList()

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("roleFuncAdd_IN")
        role_id = _r.read_string("roleId")
        rfs._deserialize(_r, "rfs")
        _r.read_end("roleFuncAdd_IN")

        tok = await self._server.auth_async("roleFuncAdd", "fura.rfr.add", {"roleId":role_id, "rfs":rfs})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("roleFuncAdd", _dvc)

        _dvc.clear()
        _dvc.add_targ("role_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("role_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        _dvc.validate("role_id", role_id)

        await self._simpl.role_func_add(role_id,
                                        rfs)

        self._server.logger().debug("[role_func_add - Done]")

        return _o

    async def role_func_rem(self, _i):
        self._server.logger().debug("[role_func_rem - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None

        rfs = mettle.braze.StringList()

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("roleFuncRem_IN")
        role_id = _r.read_string("roleId")
        rfs._deserialize(_r, "rfs")
        _r.read_end("roleFuncRem_IN")

        tok = await self._server.auth_async("roleFuncRem", "fura.rfr.rem", {"roleId":role_id, "rfs":rfs})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("roleFuncRem", _dvc)

        _dvc.clear()
        _dvc.add_targ("role_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("role_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        _dvc.validate("role_id", role_id)

        await self._simpl.role_func_rem(role_id,
                                        rfs)

        self._server.logger().debug("[role_func_rem - Done]")

        return _o

    async def role_func_read(self, _i):
        self._server.logger().debug("[role_func_read - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("roleFuncRead_IN")
        role_id = _r.read_string("roleId")
        func_grp_id = _r.read_string("funcGrpId")
        _r.read_end("roleFuncRead_IN")

        tok = await self._server.auth_async("roleFuncRead", "fura.rfr.read", {"roleId":role_id, "funcGrpId":func_grp_id})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("roleFuncRead", _dvc)

        _dvc.clear()
        _dvc.add_targ("role_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("role_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        _dvc.validate("role_id", role_id)

        _dvc.clear()
        _dvc.add_targ("func_grp_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("func_grp_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        _dvc.validate("func_grp_id", func_grp_id)

        _x = await self._simpl.role_func_read(role_id,
                                              func_grp_id)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("roleFuncRead_OUT")
        _x._serialize(_w)
        _w.write_end("roleFuncRead_OUT")

        self._server.logger().debug("[role_func_read - Done]")

        return _o

    async def site_cfg_create(self, _i):
        self._server.logger().debug("[site_cfg_create - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        rec = tSiteCfg()

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("siteCfgCreate_IN")
        rec._deserialize(_r, "rec")
        _r.read_end("siteCfgCreate_IN")

        tok = await self._server.auth_async("siteCfgCreate", "fura.sitecfg.create", {"rec":rec})
        self._simpl._set_rpc_token_data(tok)

        _x = await self._simpl.site_cfg_create(rec)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("siteCfgCreate_OUT")
        _x._serialize(_w)
        _w.write_end("siteCfgCreate_OUT")

        self._server.logger().debug("[site_cfg_create - Done]")

        return _o

    async def site_cfg_read(self, _i):
        self._server.logger().debug("[site_cfg_read - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("siteCfgRead_IN")
        site_cfg_id = _r.read_string("siteCfgId")
        _r.read_end("siteCfgRead_IN")

        tok = await self._server.auth_async("siteCfgRead", "fura.sitecfg.read", {"siteCfgId":site_cfg_id})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("siteCfgRead", _dvc)

        _dvc.clear()
        _dvc.add_targ("site_cfg_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        _dvc.validate("site_cfg_id", site_cfg_id)

        _x = await self._simpl.site_cfg_read(site_cfg_id)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("siteCfgRead_OUT")
        _x._serialize(_w)
        _w.write_end("siteCfgRead_OUT")

        self._server.logger().debug("[site_cfg_read - Done]")

        return _o

    async def site_cfg_update(self, _i):
        self._server.logger().debug("[site_cfg_update - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        rec = tSiteCfg()

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("siteCfgUpdate_IN")
        rec._deserialize(_r, "rec")
        _r.read_end("siteCfgUpdate_IN")

        tok = await self._server.auth_async("siteCfgUpdate", "fura.sitecfg.update", {"rec":rec})
        self._simpl._set_rpc_token_data(tok)

        _x = await self._simpl.site_cfg_update(rec)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("siteCfgUpdate_OUT")
        _x._serialize(_w)
        _w.write_end("siteCfgUpdate_OUT")

        self._server.logger().debug("[site_cfg_update - Done]")

        return _o

    async def site_cfg_delete(self, _i):
        self._server.logger().debug("[site_cfg_delete - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("siteCfgDelete_IN")
        site_cfg_id = _r.read_string("siteCfgId")
        _r.read_end("siteCfgDelete_IN")

        tok = await self._server.auth_async("siteCfgDelete", "fura.sitecfg.delete", {"siteCfgId":site_cfg_id})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("siteCfgDelete", _dvc)

        _dvc.clear()
        _dvc.add_targ("site_cfg_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("site_cfg_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        _dvc.validate("site_cfg_id", site_cfg_id)

        await self._simpl.site_cfg_delete(site_cfg_id)

        self._server.logger().debug("[site_cfg_delete - Done]")

        return _o

    async def site_create(self, _i):
        self._server.logger().debug("[site_create - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        site_rec = tSite()

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("siteCreate_IN")
        site_rec._deserialize(_r, "siteRec")
        admin_email = _r.read_string("adminEmail")
        admin_passwd = _r.read_string("adminPasswd")
        _r.read_end("siteCreate_IN")

        tok = await self._server.auth_async("siteCreate", "fura.site.create", {"siteRec":site_rec, "adminEmail":admin_email, "adminPasswd":admin_passwd})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("siteCreate", _dvc)

        _dvc.clear()
        _dvc.add_targ("admin_email", mettle.lib.Dav(mettle.lib.Dav.eDavType.Regex, "valid-email"))
        _dvc.add_targ("admin_email", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("admin_email", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        _dvc.validate("admin_email", admin_email)

        _dvc.clear()
        _dvc.add_targ("admin_passwd", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("admin_passwd", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        _dvc.add_targ("admin_passwd", mettle.lib.Dav(mettle.lib.Dav.eDavType.Func, "valid-passwd"))
        _dvc.validate("admin_passwd", admin_passwd)

        _x = await self._simpl.site_create(site_rec,
                                           admin_email,
                                           admin_passwd)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("siteCreate_OUT")
        _w.write_int32("return", _x)
        _w.write_end("siteCreate_OUT")

        self._server.logger().debug("[site_create - Done]")

        return _o

    async def site_read(self, _i):
        self._server.logger().debug("[site_read - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("siteRead_IN")
        site_code = _r.read_string("siteCode")
        _r.read_end("siteRead_IN")

        tok = await self._server.auth_async("siteRead", "fura.site.read", {"siteCode":site_code})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("siteRead", _dvc)

        _dvc.clear()
        _dvc.add_targ("site_code", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 32))
        _dvc.validate("site_code", site_code)

        _x = await self._simpl.site_read(site_code)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("siteRead_OUT")
        _x._serialize(_w)
        _w.write_end("siteRead_OUT")

        self._server.logger().debug("[site_read - Done]")

        return _o

    async def site_update(self, _i):
        self._server.logger().debug("[site_update - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        rec = tSite()

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("siteUpdate_IN")
        rec._deserialize(_r, "rec")
        _r.read_end("siteUpdate_IN")

        tok = await self._server.auth_async("siteUpdate", "fura.site.update", {"rec":rec})
        self._simpl._set_rpc_token_data(tok)

        _x = await self._simpl.site_update(rec)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("siteUpdate_OUT")
        _x._serialize(_w)
        _w.write_end("siteUpdate_OUT")

        self._server.logger().debug("[site_update - Done]")

        return _o

    async def site_delete(self, _i):
        self._server.logger().debug("[site_delete - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("siteDelete_IN")
        site_id = _r.read_int32("siteId")
        _r.read_end("siteDelete_IN")

        tok = await self._server.auth_async("siteDelete", "fura.site.delete", {"siteId":site_id})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("siteDelete", _dvc)

        _dvc.clear()
        _dvc.add_targ("site_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotIn, ['1']))
        _dvc.validate("site_id", site_id)

        await self._simpl.site_delete(site_id)

        self._server.logger().debug("[site_delete - Done]")

        return _o

    async def user_create(self, _i):
        self._server.logger().debug("[user_create - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        rec = tUsr()

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userCreate_IN")
        rec._deserialize(_r, "rec")
        _r.read_end("userCreate_IN")

        tok = await self._server.auth_async("userCreate", "fura.usr.create", {"rec":rec})
        self._simpl._set_rpc_token_data(tok)

        _x = await self._simpl.user_create(rec)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("userCreate_OUT")
        _x._serialize(_w)
        _w.write_end("userCreate_OUT")

        self._server.logger().debug("[user_create - Done]")

        return _o

    async def user_read(self, _i):
        self._server.logger().debug("[user_read - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userRead_IN")
        usr_id = _r.read_string("usrId")
        usr_type = _r.read_string("usrType")
        _r.read_end("userRead_IN")

        tok = await self._server.auth_async("userRead", "fura.usr.read", {"usrId":usr_id, "usrType":usr_type})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("userRead", _dvc)

        _dvc.clear()
        _dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        _dvc.validate("usr_id", usr_id)

        _dvc.clear()
        _dvc.add_targ("usr_type", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 32))
        _dvc.validate("usr_type", usr_type)

        _x = await self._simpl.user_read(usr_id,
                                         usr_type)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("userRead_OUT")
        _x._serialize(_w)
        _w.write_end("userRead_OUT")

        self._server.logger().debug("[user_read - Done]")

        return _o

    async def user_update(self, _i):
        self._server.logger().debug("[user_update - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        rec = tUsr()

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userUpdate_IN")
        rec._deserialize(_r, "rec")
        _r.read_end("userUpdate_IN")

        tok = await self._server.auth_async("userUpdate", "fura.usr.update", {"rec":rec})
        self._simpl._set_rpc_token_data(tok)

        _x = await self._simpl.user_update(rec)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("userUpdate_OUT")
        _x._serialize(_w)
        _w.write_end("userUpdate_OUT")

        self._server.logger().debug("[user_update - Done]")

        return _o

    async def user_delete(self, _i):
        self._server.logger().debug("[user_delete - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userDelete_IN")
        usr_id = _r.read_string("usrId")
        _r.read_end("userDelete_IN")

        tok = await self._server.auth_async("userDelete", "fura.usr.delete", {"usrId":usr_id})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("userDelete", _dvc)

        _dvc.clear()
        _dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotIn, ['admin']))
        _dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        _dvc.validate("usr_id", usr_id)

        await self._simpl.user_delete(usr_id)

        self._server.logger().debug("[user_delete - Done]")

        return _o

    async def user_rec(self, _i):
        self._server.logger().debug("[user_rec - Start]")

        _o = self._server.get_transport().new_stream()
        _w = None
        _x = None

        tok = await self._server.auth_async("userRec", "_LOGGED_IN_", {})
        self._simpl._set_rpc_token_data(tok)

        _x = await self._simpl.user_rec()

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("userRec_OUT")
        _x._serialize(_w)
        _w.write_end("userRec_OUT")

        self._server.logger().debug("[user_rec - Done]")

        return _o

    async def user_funcs(self, _i):
        self._server.logger().debug("[user_funcs - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userFuncs_IN")
        func_prefix = _r.read_string("funcPrefix")
        _r.read_end("userFuncs_IN")

        tok = await self._server.auth_async("userFuncs", "_LOGGED_IN_", {"funcPrefix":func_prefix})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("userFuncs", _dvc)

        _dvc.clear()
        _dvc.add_targ("func_prefix", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("func_prefix", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        _dvc.validate("func_prefix", func_prefix)

        _x = await self._simpl.user_funcs(func_prefix)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("userFuncs_OUT")
        _x._serialize(_w)
        _w.write_end("userFuncs_OUT")

        self._server.logger().debug("[user_funcs - Done]")

        return _o

    async def user_login(self, _i):
        self._server.logger().debug("[user_login - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        ul_rec = bUserLogin()

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userLogin_IN")
        ul_rec._deserialize(_r, "ulRec")
        _r.read_end("userLogin_IN")

        self._simpl._set_rpc_token_data(None)

        _x = await self._simpl.user_login(ul_rec)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("userLogin_OUT")
        _w.write_int32("return", _x)
        _w.write_end("userLogin_OUT")

        self._server.logger().debug("[user_login - Done]")

        return _o

    async def user_logout(self, _i):
        self._server.logger().debug("[user_logout - Start]")

        _o = self._server.get_transport().new_stream()
        _w = None
        _x = None

        tok = await self._server.auth_async("userLogout", "_LOGGED_IN_", {})
        self._simpl._set_rpc_token_data(tok)

        _x = await self._simpl.user_logout()

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("userLogout_OUT")
        _w.write_int32("return", _x)
        _w.write_end("userLogout_OUT")

        self._server.logger().debug("[user_logout - Done]")

        return _o

    async def user_role(self, _i):
        self._server.logger().debug("[user_role - Start]")

        _o = self._server.get_transport().new_stream()
        _w = None
        _x = None

        tok = await self._server.auth_async("userRole", "_LOGGED_IN_", {})
        self._simpl._set_rpc_token_data(tok)

        _x = await self._simpl.user_role()

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("userRole_OUT")
        _x._serialize(_w)
        _w.write_end("userRole_OUT")

        self._server.logger().debug("[user_role - Done]")

        return _o

    async def user_is_super_user(self, _i):
        self._server.logger().debug("[user_is_super_user - Start]")

        _o = self._server.get_transport().new_stream()
        _w = None
        _x = None

        tok = await self._server.auth_async("userIsSuperUser", "_LOGGED_IN_", {})
        self._simpl._set_rpc_token_data(tok)

        _x = await self._simpl.user_is_super_user()

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("userIsSuperUser_OUT")
        _w.write_bool("return", _x)
        _w.write_end("userIsSuperUser_OUT")

        self._server.logger().debug("[user_is_super_user - Done]")

        return _o

    async def user_auth_change(self, _i):
        self._server.logger().debug("[user_auth_change - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userAuthChange_IN")
        auth_type = _r.read_char("authType")
        new_data = _r.read_string("newData")
        old_data = _r.read_string("oldData")
        _r.read_end("userAuthChange_IN")

        tok = await self._server.auth_async("userAuthChange", "_LOGGED_IN_", {"authType":auth_type, "newData":new_data, "oldData":old_data})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("userAuthChange", _dvc)

        _dvc.clear()
        _dvc.add_targ("auth_type", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['P','S','T']))
        _dvc.validate("auth_type", auth_type)

        _dvc.clear()
        _dvc.add_targ("new_data", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("new_data", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        _dvc.validate("new_data", new_data)

        _dvc.clear()
        _dvc.add_targ("old_data", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("old_data", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        _dvc.validate("old_data", old_data)

        await self._simpl.user_auth_change(auth_type,
                                           new_data,
                                           old_data)

        self._server.logger().debug("[user_auth_change - Done]")

        return _o

    async def user_auth_reset(self, _i):
        self._server.logger().debug("[user_auth_reset - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userAuthReset_IN")
        site_code = _r.read_string("siteCode")
        usr_id = _r.read_string("usrId")
        auth_type = _r.read_char("authType")
        reset_method = _r.read_char("resetMethod")
        _r.read_end("userAuthReset_IN")

        self._simpl._set_rpc_token_data(None)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("userAuthReset", _dvc)

        _dvc.clear()
        _dvc.add_targ("site_code", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("site_code", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 32))
        _dvc.validate("site_code", site_code)

        _dvc.clear()
        _dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        _dvc.validate("usr_id", usr_id)

        _dvc.clear()
        _dvc.add_targ("auth_type", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['P','S','T']))
        _dvc.validate("auth_type", auth_type)

        _dvc.clear()
        _dvc.add_targ("reset_method", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['E','S']))
        _dvc.validate("reset_method", reset_method)

        await self._simpl.user_auth_reset(site_code,
                                          usr_id,
                                          auth_type,
                                          reset_method)

        self._server.logger().debug("[user_auth_reset - Done]")

        return _o

    async def user_token_reset(self, _i):
        self._server.logger().debug("[user_token_reset - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userTokenReset_IN")
        auth_type = _r.read_char("authType")
        _r.read_end("userTokenReset_IN")

        tok = await self._server.auth_async("userTokenReset", "fura.usr.reset-token", {"authType":auth_type})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("userTokenReset", _dvc)

        _dvc.clear()
        _dvc.add_targ("auth_type", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['P','S','T']))
        _dvc.validate("auth_type", auth_type)

        await self._simpl.user_token_reset(auth_type)

        self._server.logger().debug("[user_token_reset - Done]")

        return _o

    async def user_auth_reset_admin(self, _i):
        self._server.logger().debug("[user_auth_reset_admin - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userAuthResetAdmin_IN")
        usr_id = _r.read_string("usrId")
        auth_type = _r.read_char("authType")
        email_addr = _r.read_string("emailAddr")
        _r.read_end("userAuthResetAdmin_IN")

        tok = await self._server.auth_async("userAuthResetAdmin", "fura.usr.reset-auth", {"usrId":usr_id, "authType":auth_type, "emailAddr":email_addr})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("userAuthResetAdmin", _dvc)

        _dvc.clear()
        _dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        _dvc.validate("usr_id", usr_id)

        _dvc.clear()
        _dvc.add_targ("auth_type", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['P','S','T']))
        _dvc.validate("auth_type", auth_type)

        _dvc.clear()
        _dvc.add_targ("email_addr", mettle.lib.Dav(mettle.lib.Dav.eDavType.Regex, "valid-email"))
        _dvc.add_targ("email_addr", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("email_addr", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        _dvc.validate("email_addr", email_addr)

        await self._simpl.user_auth_reset_admin(usr_id,
                                                auth_type,
                                                email_addr)

        self._server.logger().debug("[user_auth_reset_admin - Done]")

        return _o

    async def user_token_reset_admin(self, _i):
        self._server.logger().debug("[user_token_reset_admin - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userTokenResetAdmin_IN")
        usr_id = _r.read_string("usrId")
        auth_type = _r.read_char("authType")
        _r.read_end("userTokenResetAdmin_IN")

        tok = await self._server.auth_async("userTokenResetAdmin", "fura.usr.reset-token", {"usrId":usr_id, "authType":auth_type})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("userTokenResetAdmin", _dvc)

        _dvc.clear()
        _dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        _dvc.validate("usr_id", usr_id)

        _dvc.clear()
        _dvc.add_targ("auth_type", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['P','S','T']))
        _dvc.validate("auth_type", auth_type)

        await self._simpl.user_token_reset_admin(usr_id,
                                                 auth_type)

        self._server.logger().debug("[user_token_reset_admin - Done]")

        return _o

    async def user_token_read(self, _i):
        self._server.logger().debug("[user_token_read - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userTokenRead_IN")
        auth_type = _r.read_char("authType")
        _r.read_end("userTokenRead_IN")

        tok = await self._server.auth_async("userTokenRead", "fura.usr.read-token", {"authType":auth_type})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("userTokenRead", _dvc)

        _dvc.clear()
        _dvc.add_targ("auth_type", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['P','S','T']))
        _dvc.validate("auth_type", auth_type)

        _x = await self._simpl.user_token_read(auth_type)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("userTokenRead_OUT")
        _w.write_string("return", _x)
        _w.write_end("userTokenRead_OUT")

        self._server.logger().debug("[user_token_read - Done]")

        return _o

    async def user_set_new_auth(self, _i):
        self._server.logger().debug("[user_set_new_auth - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None

        ul_rec = bUserLogin()

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userSetNewAuth_IN")
        ul_rec._deserialize(_r, "ulRec")
        tok = _r.read_string("tok")
        reset_method = _r.read_char("resetMethod")
        _r.read_end("userSetNewAuth_IN")

        self._simpl._set_rpc_token_data(None)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("userSetNewAuth", _dvc)

        _dvc.clear()
        _dvc.add_targ("tok", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("tok", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        _dvc.validate("tok", tok)

        _dvc.clear()
        _dvc.add_targ("reset_method", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['E','S']))
        _dvc.validate("reset_method", reset_method)

        await self._simpl.user_set_new_auth(ul_rec,
                                            tok,
                                            reset_method)

        self._server.logger().debug("[user_set_new_auth - Done]")

        return _o

    async def user_activate(self, _i):
        self._server.logger().debug("[user_activate - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userActivate_IN")
        usr_id = _r.read_string("usrId")
        _r.read_end("userActivate_IN")

        tok = await self._server.auth_async("userActivate", "fura.usr.activate", {"usrId":usr_id})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("userActivate", _dvc)

        _dvc.clear()
        _dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        _dvc.validate("usr_id", usr_id)

        await self._simpl.user_activate(usr_id)

        self._server.logger().debug("[user_activate - Done]")

        return _o

    async def user_disable(self, _i):
        self._server.logger().debug("[user_disable - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userDisable_IN")
        usr_id = _r.read_string("usrId")
        _r.read_end("userDisable_IN")

        tok = await self._server.auth_async("userDisable", "fura.usr.susp", {"usrId":usr_id})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("userDisable", _dvc)

        _dvc.clear()
        _dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        _dvc.validate("usr_id", usr_id)

        await self._simpl.user_disable(usr_id)

        self._server.logger().debug("[user_disable - Done]")

        return _o

    async def user_suspend(self, _i):
        self._server.logger().debug("[user_suspend - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userSuspend_IN")
        usr_id = _r.read_string("usrId")
        _r.read_end("userSuspend_IN")

        tok = await self._server.auth_async("userSuspend", "fura.usr.susp", {"usrId":usr_id})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("userSuspend", _dvc)

        _dvc.clear()
        _dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        _dvc.validate("usr_id", usr_id)

        await self._simpl.user_suspend(usr_id)

        self._server.logger().debug("[user_suspend - Done]")

        return _o

    async def user_set_role(self, _i):
        self._server.logger().debug("[user_set_role - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userSetRole_IN")
        usr_id = _r.read_string("usrId")
        role_id = _r.read_string("roleId")
        _r.read_end("userSetRole_IN")

        tok = await self._server.auth_async("userSetRole", "fura.usr.setrole", {"usrId":usr_id, "roleId":role_id})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("userSetRole", _dvc)

        _dvc.clear()
        _dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        _dvc.validate("usr_id", usr_id)

        _dvc.clear()
        _dvc.add_targ("role_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("role_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        _dvc.validate("role_id", role_id)

        _x = await self._simpl.user_set_role(usr_id,
                                             role_id)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("userSetRole_OUT")
        _x._serialize(_w)
        _w.write_end("userSetRole_OUT")

        self._server.logger().debug("[user_set_role - Done]")

        return _o

    async def user_confirm_contact(self, _i):
        self._server.logger().debug("[user_confirm_contact - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userConfirmContact_IN")
        otp = _r.read_string("otp")
        _r.read_end("userConfirmContact_IN")

        tok = await self._server.auth_async("userConfirmContact", "_LOGGED_IN_", {"otp":otp})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("userConfirmContact", _dvc)

        _dvc.clear()
        _dvc.add_targ("otp", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("otp", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        _dvc.validate("otp", otp)

        await self._simpl.user_confirm_contact(otp)

        self._server.logger().debug("[user_confirm_contact - Done]")

        return _o

    async def user_confirm_contact_req_otp(self, _i):
        self._server.logger().debug("[user_confirm_contact_req_otp - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userConfirmContactReqOtp_IN")
        contact_addr = _r.read_string("contactAddr")
        _r.read_end("userConfirmContactReqOtp_IN")

        tok = await self._server.auth_async("userConfirmContactReqOtp", "_LOGGED_IN_", {"contactAddr":contact_addr})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("userConfirmContactReqOtp", _dvc)

        _dvc.clear()
        _dvc.add_targ("contact_addr", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("contact_addr", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        _dvc.validate("contact_addr", contact_addr)

        await self._simpl.user_confirm_contact_req_otp(contact_addr)

        self._server.logger().debug("[user_confirm_contact_req_otp - Done]")

        return _o

    async def user_type_create(self, _i):
        self._server.logger().debug("[user_type_create - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        rec = tUsrType()

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userTypeCreate_IN")
        rec._deserialize(_r, "rec")
        _r.read_end("userTypeCreate_IN")

        tok = await self._server.auth_async("userTypeCreate", "fura.usrtype.create", {"rec":rec})
        self._simpl._set_rpc_token_data(tok)

        _x = await self._simpl.user_type_create(rec)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("userTypeCreate_OUT")
        _x._serialize(_w)
        _w.write_end("userTypeCreate_OUT")

        self._server.logger().debug("[user_type_create - Done]")

        return _o

    async def user_type_read(self, _i):
        self._server.logger().debug("[user_type_read - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userTypeRead_IN")
        usr_type_id = _r.read_string("usrTypeId")
        _r.read_end("userTypeRead_IN")

        tok = await self._server.auth_async("userTypeRead", "fura.usrtype.read", {"usrTypeId":usr_type_id})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("userTypeRead", _dvc)

        _dvc.clear()
        _dvc.add_targ("usr_type_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 32))
        _dvc.validate("usr_type_id", usr_type_id)

        _x = await self._simpl.user_type_read(usr_type_id)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("userTypeRead_OUT")
        _x._serialize(_w)
        _w.write_end("userTypeRead_OUT")

        self._server.logger().debug("[user_type_read - Done]")

        return _o

    async def user_type_update(self, _i):
        self._server.logger().debug("[user_type_update - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None
        _w = None
        _x = None

        rec = tUsrType()

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userTypeUpdate_IN")
        rec._deserialize(_r, "rec")
        _r.read_end("userTypeUpdate_IN")

        tok = await self._server.auth_async("userTypeUpdate", "fura.usrtype.update", {"rec":rec})
        self._simpl._set_rpc_token_data(tok)

        _x = await self._simpl.user_type_update(rec)

        _w = self._server.get_transport().new_writer(_o)
        _w.write_start("userTypeUpdate_OUT")
        _x._serialize(_w)
        _w.write_end("userTypeUpdate_OUT")

        self._server.logger().debug("[user_type_update - Done]")

        return _o

    async def user_type_delete(self, _i):
        self._server.logger().debug("[user_type_delete - Start]")

        _o = self._server.get_transport().new_stream()
        _r = None

        _r = self._server.get_transport().new_reader(_i)
        _r.read_start("userTypeDelete_IN")
        usr_type_id = _r.read_string("usrTypeId")
        _r.read_end("userTypeDelete_IN")

        tok = await self._server.auth_async("userTypeDelete", "fura.usrtype.delete", {"usrTypeId":usr_type_id})
        self._simpl._set_rpc_token_data(tok)

        _dvc = mettle.lib.DavCache()
        self._server_impl()._init_dav_cache("userTypeDelete", _dvc)

        _dvc.clear()
        _dvc.add_targ("usr_type_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        _dvc.add_targ("usr_type_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 32))
        _dvc.validate("usr_type_id", usr_type_id)

        await self._simpl.user_type_delete(usr_type_id)

        self._server.logger().debug("[user_type_delete - Done]")

        return _o

