# This file was generated by mettle.genes.braze.GenPy3 [ver 2.1] on Wed May 11 09:28:46 2022
#

import datetime
import uuid
import dataclasses
import typing
import mettle.braze
import mettle.lib

from .fura_client_interface import FuraClientInterface
from .fura_server_interface import FuraServerInterface

from bs_fura.db.tables import tConfig
from bs_fura.db.tables import tFunc
from bs_fura.db.tables import tFuncGrp
from bs_fura.db.tables import tRole
from bs_fura.db.tables import tSiteCfg
from bs_fura.db.tables import tSite
from bs_fura.db.tables import tUsr
from bs_fura.db.tables import tUsrType

from .bauth_policy import bAuthPolicy
from .buser_login import bUserLogin
from .brole_func_rel import bRoleFuncRel

class FuraClientServerImpl(FuraClientInterface):
    """
    A direct client to server client interface implementation (wrapper).
    """

    def __init__(self, serverInterface):
        """
        Constructor.

        :param serverInterface: FuraServerInterface, the implemented server interface object.
        """
        self._impl = serverInterface

    def auth_policy_read(self,
                         auth_type: str,
                         site_code: str) -> bAuthPolicy:
        return self._impl.auth_policy_read(auth_type, site_code)

    def config_create(self,
                      rec: tConfig) -> tConfig:
        return self._impl.config_create(rec)

    def config_read(self,
                    cfg_id: str) -> tConfig.List:
        return self._impl.config_read(cfg_id)

    def config_update(self,
                      rec: tConfig) -> tConfig:
        return self._impl.config_update(rec)

    def config_delete(self,
                      cfg_id: str):
        self._impl.config_delete(cfg_id)

    def func_read(self,
                  func_id: str,
                  func_grp_id: str) -> tFunc.List:
        return self._impl.func_read(func_id, func_grp_id)

    def func_grp_read(self,
                      func_grp_id: str) -> tFuncGrp.List:
        return self._impl.func_grp_read(func_grp_id)

    def role_create(self,
                    rec: tRole) -> tRole:
        return self._impl.role_create(rec)

    def role_read(self,
                  role_id: str) -> tRole.List:
        return self._impl.role_read(role_id)

    def role_update(self,
                    rec: tRole) -> tRole:
        return self._impl.role_update(rec)

    def role_delete(self,
                    role_id: str):
        self._impl.role_delete(role_id)

    def role_func_add(self,
                      role_id: str,
                      rfs: mettle.braze.StringList):
        self._impl.role_func_add(role_id, rfs)

    def role_func_rem(self,
                      role_id: str,
                      rfs: mettle.braze.StringList):
        self._impl.role_func_rem(role_id, rfs)

    def role_func_read(self,
                       role_id: str,
                       func_grp_id: str) -> bRoleFuncRel.List:
        return self._impl.role_func_read(role_id, func_grp_id)

    def site_cfg_create(self,
                        rec: tSiteCfg) -> tSiteCfg:
        return self._impl.site_cfg_create(rec)

    def site_cfg_read(self,
                      site_cfg_id: str) -> tSiteCfg.List:
        return self._impl.site_cfg_read(site_cfg_id)

    def site_cfg_update(self,
                        rec: tSiteCfg) -> tSiteCfg:
        return self._impl.site_cfg_update(rec)

    def site_cfg_delete(self,
                        site_cfg_id: str):
        self._impl.site_cfg_delete(site_cfg_id)

    def site_create(self,
                    site_rec: tSite,
                    admin_email: str,
                    admin_passwd: str) -> int:
        return self._impl.site_create(site_rec, admin_email, admin_passwd)

    def site_read(self,
                  site_code: str) -> tSite.List:
        return self._impl.site_read(site_code)

    def site_update(self,
                    rec: tSite) -> tSite:
        return self._impl.site_update(rec)

    def site_delete(self,
                    site_id: int):
        self._impl.site_delete(site_id)

    def user_create(self,
                    rec: tUsr) -> tUsr:
        return self._impl.user_create(rec)

    def user_read(self,
                  usr_id: str,
                  usr_type: str) -> tUsr.List:
        return self._impl.user_read(usr_id, usr_type)

    def user_update(self,
                    rec: tUsr) -> tUsr:
        return self._impl.user_update(rec)

    def user_delete(self,
                    usr_id: str):
        self._impl.user_delete(usr_id)

    def user_rec(self) -> tUsr:
        return self._impl.user_rec()

    def user_funcs(self,
                   func_prefix: str) -> mettle.braze.StringList:
        return self._impl.user_funcs(func_prefix)

    def user_login(self,
                   ul_rec: bUserLogin) -> int:
        return self._impl.user_login(ul_rec)

    def user_logout(self) -> int:
        return self._impl.user_logout()

    def user_role(self) -> tRole:
        return self._impl.user_role()

    def user_is_super_user(self) -> bool:
        return self._impl.user_is_super_user()

    def user_auth_change(self,
                         auth_type: str,
                         new_data: str,
                         old_data: str):
        self._impl.user_auth_change(auth_type, new_data, old_data)

    def user_auth_reset(self,
                        site_code: str,
                        usr_id: str,
                        auth_type: str,
                        reset_method: str):
        self._impl.user_auth_reset(site_code, usr_id, auth_type, reset_method)

    def user_token_reset(self,
                         auth_type: str):
        self._impl.user_token_reset(auth_type)

    def user_auth_reset_admin(self,
                              usr_id: str,
                              auth_type: str,
                              email_addr: str):
        self._impl.user_auth_reset_admin(usr_id, auth_type, email_addr)

    def user_token_reset_admin(self,
                               usr_id: str,
                               auth_type: str):
        self._impl.user_token_reset_admin(usr_id, auth_type)

    def user_token_read(self,
                        auth_type: str) -> str:
        return self._impl.user_token_read(auth_type)

    def user_set_new_auth(self,
                          ul_rec: bUserLogin,
                          tok: str,
                          reset_method: str):
        self._impl.user_set_new_auth(ul_rec, tok, reset_method)

    def user_activate(self,
                      usr_id: str):
        self._impl.user_activate(usr_id)

    def user_disable(self,
                     usr_id: str):
        self._impl.user_disable(usr_id)

    def user_suspend(self,
                     usr_id: str):
        self._impl.user_suspend(usr_id)

    def user_set_role(self,
                      usr_id: str,
                      role_id: str) -> tUsr:
        return self._impl.user_set_role(usr_id, role_id)

    def user_confirm_contact(self,
                             otp: str):
        self._impl.user_confirm_contact(otp)

    def user_confirm_contact_req_otp(self,
                                     contact_addr: str):
        self._impl.user_confirm_contact_req_otp(contact_addr)

    def user_type_create(self,
                         rec: tUsrType) -> tUsrType:
        return self._impl.user_type_create(rec)

    def user_type_read(self,
                       usr_type_id: str) -> tUsrType.List:
        return self._impl.user_type_read(usr_type_id)

    def user_type_update(self,
                         rec: tUsrType) -> tUsrType:
        return self._impl.user_type_update(rec)

    def user_type_delete(self,
                         usr_type_id: str):
        self._impl.user_type_delete(usr_type_id)

