# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:46 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.ieatok_search import iEatokSearch
from bs_fura.db.tables.oeatok_search import oEatokSearch

class dEatokSearch:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iEatokSearch()
        self.orec     = oEatokSearch()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  tok: str,
                  site_id: int) -> "dEatokSearch":
        """
        Execute the query by setting all the inputs.

        :param tok: str
        :param site_id: int
        :return: Self for convenience.
        """
        self.irec.tok = tok
        self.irec.site_id = site_id

        return self.exec()

    def exec(self, irec: iEatokSearch = None) -> "dEatokSearch":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("EatokSearch", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  t.id
from
  eatok t
where
  t.tok     = :tok and
  t.site_id = :siteid""")

        self._dbstmnt.bind_in("tok", self.irec.tok, str)
        self._dbstmnt.bind_in("siteId", self.irec.site_id, int, 4)

        self._dbstmnt.bind_out("id", int, 8)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.id = self._dbstmnt.result[0]

        return True

    def fetch_all(self, outList: oEatokSearch.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

