# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:46 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.eatok_key import tEatokKey
from bs_fura.db.tables.eatok import tEatok

class dEatokSelectOne:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tEatokKey()
        self.orec     = tEatok()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  id: int) -> "dEatokSelectOne":
        """
        Execute the query by setting all the inputs.

        :param id: int
        :return: Self for convenience.
        """
        self.irec.id = id

        return self.exec()

    def exec(self, irec: tEatokKey = None) -> "dEatokSelectOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("EatokSelectOne", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  id,
  tok,
  site_id,
  usr_id,
  func_id,
  grant_usr_id,
  created,
  expires,
  max_usages,
  usages
from
  fura.Eatok
where
  id = :id""")

        self._dbstmnt.bind_in("id", self.irec.id, int, 8)

        self._dbstmnt.bind_out("id", int, 8)
        self._dbstmnt.bind_out("tok", str, 256)
        self._dbstmnt.bind_out("site_id", int, 4)
        self._dbstmnt.bind_out("usr_id", str, 128)
        self._dbstmnt.bind_out("func_id", str, 128)
        self._dbstmnt.bind_out("grant_usr_id", str, 128)
        self._dbstmnt.bind_out("created", datetime.datetime)
        self._dbstmnt.bind_out("expires", datetime.datetime)
        self._dbstmnt.bind_out("max_usages", int, 4)
        self._dbstmnt.bind_out("usages", int, 4)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.id = self._dbstmnt.result[0]
        self.orec.tok = self._dbstmnt.result[1]
        self.orec.site_id = self._dbstmnt.result[2]
        self.orec.usr_id = self._dbstmnt.result[3]
        self.orec.func_id = self._dbstmnt.result[4]
        self.orec.grant_usr_id = self._dbstmnt.result[5]
        self.orec.created = self._dbstmnt.result[6]
        self.orec.expires = self._dbstmnt.result[7]
        self.orec.max_usages = self._dbstmnt.result[8]
        self.orec.usages = self._dbstmnt.result[9]

        return True

    def fetch_all(self, outList: tEatok.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

