# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:46 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.site import tSite

class dSiteSelectAll:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.orec     = tSite()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec(self) -> "dSiteSelectAll":
        """
        Execute the query.

        :return: Self for convenience.
        """
        self._destroy()

        self._dbstmnt = self._dbcon.statement("SiteSelectAll", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  id,
  code,
  descr,
  status,
  cc,
  ccy,
  dc,
  modified_by,
  tm_stamp
from
  fura.Site
order by
  id""")

        self._dbstmnt.bind_out("id", int, 4)
        self._dbstmnt.bind_out("code", str, 32)
        self._dbstmnt.bind_out("descr", str, 256)
        self._dbstmnt.bind_out("status", str, 1)
        self._dbstmnt.bind_out("cc", str, 2)
        self._dbstmnt.bind_out("ccy", str, 3)
        self._dbstmnt.bind_out("dc", str, 3)
        self._dbstmnt.bind_out("modified_by", str, 128)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)

        self._dbcon.execute(self._dbstmnt)

        return self

    def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.id = self._dbstmnt.result[0]
        self.orec.code = self._dbstmnt.result[1]
        self.orec.descr = self._dbstmnt.result[2]
        self.orec.status = self._dbstmnt.result[3]
        self.orec.cc = self._dbstmnt.result[4]
        self.orec.ccy = self._dbstmnt.result[5]
        self.orec.dc = self._dbstmnt.result[6]
        self.orec.modified_by = self._dbstmnt.result[7]
        self.orec.tm_stamp = self._dbstmnt.result[8]

        return True

    def fetch_all(self, outList: tSite.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

