# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:46 2022
#  Target Database = postgresql
#
import asyncio
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.token_sentry import tTokenSentry
from bs_fura.db.tables.token_sentry_key import tTokenSentryKey

from .token_sentry_select_one import dTokenSentrySelectOne
from .token_sentry_update import dTokenSentryUpdate
from .token_sentry_insert import dTokenSentryInsert

class dTokenSentry:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self.rec    = tTokenSentry()
        self._dbcon = dbcon

    def __enter__(self):
        """
        DAO enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        DAO exit.
        """
        pass

    def try_select_one(self) -> bool:
        """
        Attempt to select the record.

        :return: True if the record was found.
        """
        _key = tTokenSentryKey()

        self.rec._write_key(_key)

        return self.try_select_one_by_key(_key)

    def try_select_one_with(self, _rec: tTokenSentry) -> bool:
        """
        Attempt to select the record using a table rec.

        :param _rec: The table rec to select with and into.
        :return: True if the row as selectd.
        """
        _key = tTokenSentryKey()
        _rec._write_key(_key)

        if not self.try_select_one_by_key(_key):
            return False

        _rec._copy_from(self.rec)

        return True

    def try_select_one_deft(self,
                            site_id: int) -> bool:
        """
        Attempt to select the record by it's primary key columns.

        :param site_id: int
        :return: True if the row as selectd.
        """
        _key = tTokenSentryKey()

        _key.site_id = site_id

        return self.try_select_one_by_key(_key)

    def try_select_one_by_key(self, _key: tTokenSentryKey) -> bool:
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :returns: True if row was selected.
        """
        with dTokenSentrySelectOne(self._dbcon) as _qry:
            _qry.exec(_key)
            if not _qry.fetch():
                return False

            self.rec = _qry.orec

        return True

    def select_one(self) -> "dTokenSentry":
        """
        Selects the record, raises and error if it does not exist.

        :return: Self for convenience.
        """
        if not self.try_select_one():
            raise mettle.lib.xMettle("SelectOne failed to return a record (dTokenSentry)")

        return self

    def select_one_with(self, _rec: tTokenSentry) -> "dTokenSentry":
        """
        Attempt to select the record with the table record.

        :param _rec: Table record.
        :returns: Self for convenience.
        """
        if not self.try_select_one_with(_rec):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dTokenSentry)")

        return self

    def select_one_deft(self,
                        site_id: int) -> "dTokenSentry":
        """
        Selects the record by its primary key columns, raises and error if it does not exist.

        :param site_id: int
        """
        _key = tTokenSentryKey()

        _key.site_id = site_id

        if not self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dTokenSentry)")

        return self

    def select_one_by_key(self, _key: tTokenSentryKey) -> "dTokenSentry":
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :return: Self for convenience.
        """
        if not self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dTokenSentry)")

        return self

    def update_deft(self,
                    site_id: int,
                    token_cnt: int,
                    last_poll: datetime.datetime):
        """
        Update the record by setting all column values.

        :param site_id: int
        :param token_cnt: int
        :param last_poll: datetime.datetime
        """
        self.rec.site_id = site_id
        self.rec.token_cnt = token_cnt
        self.rec.last_poll = last_poll

        self.update()

    def update(self, irec: tTokenSentry = None):
        """
        Update the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to update the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dTokenSentryUpdate(self._dbcon) as _qry:
            _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

    def insert_deft(self,
                    site_id: int,
                    token_cnt: int,
                    last_poll: datetime.datetime):
        """
        Insert the record setting all column values.

        :param site_id: int
        :param token_cnt: int
        :param last_poll: datetime.datetime
        """
        self.rec.site_id = site_id
        self.rec.token_cnt = token_cnt
        self.rec.last_poll = last_poll

        self.insert()

    def insert(self, irec: tTokenSentry = None):
        """
        Insert the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to insert into the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dTokenSentryInsert(self._dbcon) as _qry:
            _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

