# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:46 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.iusr_search import iUsrSearch
from bs_fura.db.tables.usr import tUsr

class dUsrSearch:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iUsrSearch()
        self.orec     = tUsr()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  site_id: int,
                  criteria: str) -> "dUsrSearch":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param criteria: str
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.criteria = criteria

        return self.exec()

    def exec(self, irec: iUsrSearch = None) -> "dUsrSearch":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("UsrSearch", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  u.*
from
  fura.usr u
where
  u.site_id = :siteId
  [criteria]""")

        self._dbstmnt.dynamic("[criteria]", self.irec.criteria)

        self._dbstmnt.bind_in("siteId", self.irec.site_id, int, 4)

        self._dbstmnt.bind_out("site_id", int, 4)
        self._dbstmnt.bind_out("id", str, 128)
        self._dbstmnt.bind_out("role_id", str, 128)
        self._dbstmnt.bind_out("status", str, 1)
        self._dbstmnt.bind_out("name_first", str, 128)
        self._dbstmnt.bind_out("name_last", str, 128)
        self._dbstmnt.bind_out("title", str, 5)
        self._dbstmnt.bind_out("date_activate", datetime.date)
        self._dbstmnt.bind_out("date_expire", datetime.date)
        self._dbstmnt.bind_out("email1", str, 256)
        self._dbstmnt.bind_out("email2", str, 256)
        self._dbstmnt.bind_out("cellno1", str, 32)
        self._dbstmnt.bind_out("cellno2", str, 32)
        self._dbstmnt.bind_out("modified_by", str, 128)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)
        self._dbstmnt.bind_out("usrtype_id", str, 32)
        self._dbstmnt.bind_out("email1_conf", bool)
        self._dbstmnt.bind_out("email2_conf", bool)
        self._dbstmnt.bind_out("cellno1_conf", bool)
        self._dbstmnt.bind_out("cellno2_conf", bool)
        self._dbstmnt.bind_out("opt_system", bool)
        self._dbstmnt.bind_out("opt_market", bool)
        self._dbstmnt.bind_out("opt_fail_login", bool)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.site_id = self._dbstmnt.result[0]
        self.orec.id = self._dbstmnt.result[1]
        self.orec.role_id = self._dbstmnt.result[2]
        self.orec.status = self._dbstmnt.result[3]
        self.orec.name_first = self._dbstmnt.result[4]
        self.orec.name_last = self._dbstmnt.result[5]
        self.orec.title = self._dbstmnt.result[6]
        self.orec.date_activate = self._dbstmnt.result[7]
        self.orec.date_expire = self._dbstmnt.result[8]
        self.orec.email1 = self._dbstmnt.result[9]
        self.orec.email2 = self._dbstmnt.result[10]
        self.orec.cellno1 = self._dbstmnt.result[11]
        self.orec.cellno2 = self._dbstmnt.result[12]
        self.orec.modified_by = self._dbstmnt.result[13]
        self.orec.tm_stamp = self._dbstmnt.result[14]
        self.orec.usrtype_id = self._dbstmnt.result[15]
        self.orec.email1_conf = self._dbstmnt.result[16]
        self.orec.email2_conf = self._dbstmnt.result[17]
        self.orec.cellno1_conf = self._dbstmnt.result[18]
        self.orec.cellno2_conf = self._dbstmnt.result[19]
        self.orec.opt_system = self._dbstmnt.result[20]
        self.orec.opt_market = self._dbstmnt.result[21]
        self.orec.opt_fail_login = self._dbstmnt.result[22]

        return True

    def fetch_all(self, outList: tUsr.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

