# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:46 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.ifunc_role_func_search import iFuncRoleFuncSearch
from bs_fura.db.tables.ofunc_role_func_search import oFuncRoleFuncSearch

class dFuncRoleFuncSearch:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iFuncRoleFuncSearch()
        self.orec     = oFuncRoleFuncSearch()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        site_id: int,
                        role_id: str,
                        prefix: str) -> "dFuncRoleFuncSearch":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param role_id: str
        :param prefix: str
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.role_id = role_id
        self.irec.prefix = prefix

        return await self.exec()

    async def exec(self, irec: iFuncRoleFuncSearch = None) -> "dFuncRoleFuncSearch":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("FuncRoleFuncSearch", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  f.id
from
  fura.func f
    cross join
  fura.role r
where
  r.site_id  = :siteId and
  r.id       = :roleId and
  r.status   = 'S'     and
  f.id like :prefix
union
select
  f.id
from
  fura.role r
    join
  fura.rolefuncrel rfr
    on rfr.role_id = r.id and
       rfr.site_id = r.site_id
    join
  fura.func f
    on f.id = rfr.func_id
where
  r.status  = 'A'     and
  r.id      = :roleId and
  r.site_id = :siteId and
  f.id like :prefix""")

        self._dbstmnt.bind_in("siteId", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("roleId", self.irec.role_id, str)
        self._dbstmnt.bind_in("prefix", self.irec.prefix, str)

        self._dbstmnt.bind_out("func_id", str)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    async def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.func_id = self._dbstmnt.result[0]

        return True

    async def fetch_all(self, outList: oFuncRoleFuncSearch.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while await self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

