# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:46 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.irole_func_rel_delete_by_role import iRoleFuncRelDeleteByRole

class dRoleFuncRelDeleteByRole:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iRoleFuncRelDeleteByRole()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        site_id: int,
                        role_id: str) -> "dRoleFuncRelDeleteByRole":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param role_id: str
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.role_id = role_id

        return await self.exec()

    async def exec(self, irec: iRoleFuncRelDeleteByRole = None) -> "dRoleFuncRelDeleteByRole":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("RoleFuncRelDeleteByRole", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""delete from
  fura.rolefuncrel r
where
  r.site_id != 1 and
  r.site_id  = :siteId and
  r.role_id  = :roleId""")

        self._dbstmnt.bind_in("siteId", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("roleId", self.irec.role_id, str, 128)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

