# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:46 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.site_cfg_key import tSiteCfgKey
from bs_fura.db.tables.site_cfg import tSiteCfg

class dSiteCfgLockOne:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tSiteCfgKey()
        self.orec     = tSiteCfg()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        site_id: int,
                        id: str) -> "dSiteCfgLockOne":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param id: str
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.id = id

        return await self.exec()

    async def exec(self, irec: tSiteCfgKey = None) -> "dSiteCfgLockOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("SiteCfgLockOne", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  site_id,
  id,
  descr,
  value,
  modified_by,
  tm_stamp
from
  fura.SiteCfg
where
  site_id = :site_id and
  id = :id for update nowait""")

        self._dbstmnt.bind_in("site_id", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("id", self.irec.id, str, 256)

        self._dbstmnt.bind_out("site_id", int, 4)
        self._dbstmnt.bind_out("id", str, 256)
        self._dbstmnt.bind_out("descr", str, 256)
        self._dbstmnt.bind_out("value", str, 4096)
        self._dbstmnt.bind_out("modified_by", str, 64)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)

        await self._dbcon.lock(self._dbstmnt)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    async def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.site_id = self._dbstmnt.result[0]
        self.orec.id = self._dbstmnt.result[1]
        self.orec.descr = self._dbstmnt.result[2]
        self.orec.value = self._dbstmnt.result[3]
        self.orec.modified_by = self._dbstmnt.result[4]
        self.orec.tm_stamp = self._dbstmnt.result[5]

        return True

    async def fetch_all(self, outList: tSiteCfg.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while await self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

