# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:46 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.usr import tUsr

class dUsrUpdate:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tUsr()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        site_id: int,
                        id: str,
                        role_id: str,
                        status: str,
                        name_first: str,
                        name_last: str,
                        title: str,
                        date_activate: datetime.date,
                        date_expire: datetime.date,
                        email1: str,
                        email2: str,
                        cellno1: str,
                        cellno2: str,
                        modified_by: str,
                        usrtype_id: str,
                        email1_conf: bool,
                        email2_conf: bool,
                        cellno1_conf: bool,
                        cellno2_conf: bool,
                        opt_system: bool,
                        opt_market: bool,
                        opt_fail_login: bool) -> "dUsrUpdate":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param id: str
        :param role_id: str
        :param status: str
        :param name_first: str
        :param name_last: str
        :param title: str
        :param date_activate: datetime.date
        :param date_expire: datetime.date
        :param email1: str
        :param email2: str
        :param cellno1: str
        :param cellno2: str
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :param usrtype_id: str
        :param email1_conf: bool
        :param email2_conf: bool
        :param cellno1_conf: bool
        :param cellno2_conf: bool
        :param opt_system: bool
        :param opt_market: bool
        :param opt_fail_login: bool
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.id = id
        self.irec.role_id = role_id
        self.irec.status = status
        self.irec.name_first = name_first
        self.irec.name_last = name_last
        self.irec.title = title
        self.irec.date_activate = date_activate
        self.irec.date_expire = date_expire
        self.irec.email1 = email1
        self.irec.email2 = email2
        self.irec.cellno1 = cellno1
        self.irec.cellno2 = cellno2
        self.irec.modified_by = modified_by
        self.irec.usrtype_id = usrtype_id
        self.irec.email1_conf = email1_conf
        self.irec.email2_conf = email2_conf
        self.irec.cellno1_conf = cellno1_conf
        self.irec.cellno2_conf = cellno2_conf
        self.irec.opt_system = opt_system
        self.irec.opt_market = opt_market
        self.irec.opt_fail_login = opt_fail_login

        return await self.exec()

    async def exec(self, irec: tUsr = None) -> "dUsrUpdate":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("UsrUpdate", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""update
  fura.Usr
set
  role_id = :role_id,
  status = :status,
  name_first = :name_first,
  name_last = :name_last,
  title = :title,
  date_activate = :date_activate,
  date_expire = :date_expire,
  email1 = :email1,
  email2 = :email2,
  cellno1 = :cellno1,
  cellno2 = :cellno2,
  modified_by = :modified_by,
  tm_stamp = :tm_stamp,
  usrtype_id = :usrtype_id,
  email1_conf = :email1_conf,
  email2_conf = :email2_conf,
  cellno1_conf = :cellno1_conf,
  cellno2_conf = :cellno2_conf,
  opt_system = :opt_system,
  opt_market = :opt_market,
  opt_fail_login = :opt_fail_login
where
  site_id = :site_id and
  id = :id""")

        self.irec.tm_stamp = await self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("site_id", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("id", self.irec.id, str, 128)
        self._dbstmnt.bind_in("role_id", self.irec.role_id, str, 128)
        self._dbstmnt.bind_in("status", self.irec.status, str, 1)
        self._dbstmnt.bind_in("name_first", self.irec.name_first, str, 128)
        self._dbstmnt.bind_in("name_last", self.irec.name_last, str, 128)
        self._dbstmnt.bind_in("title", self.irec.title, str, 5)
        self._dbstmnt.bind_in("date_activate", self.irec.date_activate, datetime.date)
        self._dbstmnt.bind_in("date_expire", self.irec.date_expire, datetime.date)
        self._dbstmnt.bind_in("email1", self.irec.email1, str, 256)
        self._dbstmnt.bind_in("email2", self.irec.email2, str, 256)
        self._dbstmnt.bind_in("cellno1", self.irec.cellno1, str, 32)
        self._dbstmnt.bind_in("cellno2", self.irec.cellno2, str, 32)
        self._dbstmnt.bind_in("modified_by", self.irec.modified_by, str, 128)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)
        self._dbstmnt.bind_in("usrtype_id", self.irec.usrtype_id, str, 32)
        self._dbstmnt.bind_in("email1_conf", self.irec.email1_conf, bool)
        self._dbstmnt.bind_in("email2_conf", self.irec.email2_conf, bool)
        self._dbstmnt.bind_in("cellno1_conf", self.irec.cellno1_conf, bool)
        self._dbstmnt.bind_in("cellno2_conf", self.irec.cellno2_conf, bool)
        self._dbstmnt.bind_in("opt_system", self.irec.opt_system, bool)
        self._dbstmnt.bind_in("opt_market", self.irec.opt_market, bool)
        self._dbstmnt.bind_in("opt_fail_login", self.irec.opt_fail_login, bool)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

