# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class FirewallServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def firewall_service_create_firewall_from_components(self, body, project_id, **kwargs):  # noqa: E501
        """CreateFirewallFromComponents  # noqa: E501

        Creates a Firewall instance in BE/DB based on the provided user-defined components (config, rules, thresholds).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_create_firewall_from_components(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ComponentsProjectIdBody body: (required)
        :param str project_id: (required)
        :return: RimeCreateFirewallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.firewall_service_create_firewall_from_components_with_http_info(body, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.firewall_service_create_firewall_from_components_with_http_info(body, project_id, **kwargs)  # noqa: E501
            return data

    def firewall_service_create_firewall_from_components_with_http_info(self, body, project_id, **kwargs):  # noqa: E501
        """CreateFirewallFromComponents  # noqa: E501

        Creates a Firewall instance in BE/DB based on the provided user-defined components (config, rules, thresholds).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_create_firewall_from_components_with_http_info(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ComponentsProjectIdBody body: (required)
        :param str project_id: (required)
        :return: RimeCreateFirewallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method firewall_service_create_firewall_from_components" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `firewall_service_create_firewall_from_components`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `firewall_service_create_firewall_from_components`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/firewall/components/{projectId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeCreateFirewallResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def firewall_service_create_firewall_from_test_run_id(self, body, project_id, **kwargs):  # noqa: E501
        """CreateFirewallFromTestRunID  # noqa: E501

        Creates a Firewall instance in BE/DB based on a specified stress test run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_create_firewall_from_test_run_id(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FirewallProjectIdBody body: (required)
        :param str project_id: (required)
        :return: RimeCreateFirewallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.firewall_service_create_firewall_from_test_run_id_with_http_info(body, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.firewall_service_create_firewall_from_test_run_id_with_http_info(body, project_id, **kwargs)  # noqa: E501
            return data

    def firewall_service_create_firewall_from_test_run_id_with_http_info(self, body, project_id, **kwargs):  # noqa: E501
        """CreateFirewallFromTestRunID  # noqa: E501

        Creates a Firewall instance in BE/DB based on a specified stress test run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_create_firewall_from_test_run_id_with_http_info(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FirewallProjectIdBody body: (required)
        :param str project_id: (required)
        :return: RimeCreateFirewallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method firewall_service_create_firewall_from_test_run_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `firewall_service_create_firewall_from_test_run_id`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `firewall_service_create_firewall_from_test_run_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/firewall/{projectId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeCreateFirewallResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def firewall_service_delete_firewall(self, firewall_id, **kwargs):  # noqa: E501
        """DeleteFirewall  # noqa: E501

        Deletes a Firewall instance in BE/DB.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_delete_firewall(firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id: (required)
        :return: RimeDeleteFirewallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.firewall_service_delete_firewall_with_http_info(firewall_id, **kwargs)  # noqa: E501
        else:
            (data) = self.firewall_service_delete_firewall_with_http_info(firewall_id, **kwargs)  # noqa: E501
            return data

    def firewall_service_delete_firewall_with_http_info(self, firewall_id, **kwargs):  # noqa: E501
        """DeleteFirewall  # noqa: E501

        Deletes a Firewall instance in BE/DB.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_delete_firewall_with_http_info(firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id: (required)
        :return: RimeDeleteFirewallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['firewall_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method firewall_service_delete_firewall" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'firewall_id' is set
        if ('firewall_id' not in params or
                params['firewall_id'] is None):
            raise ValueError("Missing the required parameter `firewall_id` when calling `firewall_service_delete_firewall`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_id' in params:
            path_params['firewallId'] = params['firewall_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/firewall/{firewallId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeDeleteFirewallResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def firewall_service_get_model_status(self, firewall_id, **kwargs):  # noqa: E501
        """GetModelStatus  # noqa: E501

        Returns the model status for the corresponding test run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_get_model_status(firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id: (required)
        :param str test_run_id: if this is not specified, use latest test run
        :return: RimeGetModelStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.firewall_service_get_model_status_with_http_info(firewall_id, **kwargs)  # noqa: E501
        else:
            (data) = self.firewall_service_get_model_status_with_http_info(firewall_id, **kwargs)  # noqa: E501
            return data

    def firewall_service_get_model_status_with_http_info(self, firewall_id, **kwargs):  # noqa: E501
        """GetModelStatus  # noqa: E501

        Returns the model status for the corresponding test run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_get_model_status_with_http_info(firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id: (required)
        :param str test_run_id: if this is not specified, use latest test run
        :return: RimeGetModelStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['firewall_id', 'test_run_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method firewall_service_get_model_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'firewall_id' is set
        if ('firewall_id' not in params or
                params['firewall_id'] is None):
            raise ValueError("Missing the required parameter `firewall_id` when calling `firewall_service_get_model_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_id' in params:
            path_params['firewallId'] = params['firewall_id']  # noqa: E501

        query_params = []
        if 'test_run_id' in params:
            query_params.append(('testRunId', params['test_run_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/firewall/{firewallId}/model-status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetModelStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def firewall_service_get_service_metrics(self, firewall_id, **kwargs):  # noqa: E501
        """GetServiceMetrics  # noqa: E501

        Gets service metrics associated with a firewall.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_get_service_metrics(firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id: (required)
        :return: RimeGetServiceMetricsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.firewall_service_get_service_metrics_with_http_info(firewall_id, **kwargs)  # noqa: E501
        else:
            (data) = self.firewall_service_get_service_metrics_with_http_info(firewall_id, **kwargs)  # noqa: E501
            return data

    def firewall_service_get_service_metrics_with_http_info(self, firewall_id, **kwargs):  # noqa: E501
        """GetServiceMetrics  # noqa: E501

        Gets service metrics associated with a firewall.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_get_service_metrics_with_http_info(firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id: (required)
        :return: RimeGetServiceMetricsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['firewall_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method firewall_service_get_service_metrics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'firewall_id' is set
        if ('firewall_id' not in params or
                params['firewall_id'] is None):
            raise ValueError("Missing the required parameter `firewall_id` when calling `firewall_service_get_service_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_id' in params:
            path_params['firewallId'] = params['firewall_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/firewall/{firewallId}/service-metrics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetServiceMetricsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def firewall_service_get_summary_times(self, firewall_id, **kwargs):  # noqa: E501
        """GetSummaryTimes  # noqa: E501

        Gets the Earliest/Latest Times for Batch/Datapoint Summaries  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_get_summary_times(firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id: (required)
        :param bool mask_earliest_batch:
        :param bool mask_latest_batch:
        :param bool mask_earliest_datapoint:
        :param bool mask_latest_datapoint:
        :return: RimeGetSummaryTimesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.firewall_service_get_summary_times_with_http_info(firewall_id, **kwargs)  # noqa: E501
        else:
            (data) = self.firewall_service_get_summary_times_with_http_info(firewall_id, **kwargs)  # noqa: E501
            return data

    def firewall_service_get_summary_times_with_http_info(self, firewall_id, **kwargs):  # noqa: E501
        """GetSummaryTimes  # noqa: E501

        Gets the Earliest/Latest Times for Batch/Datapoint Summaries  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_get_summary_times_with_http_info(firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id: (required)
        :param bool mask_earliest_batch:
        :param bool mask_latest_batch:
        :param bool mask_earliest_datapoint:
        :param bool mask_latest_datapoint:
        :return: RimeGetSummaryTimesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['firewall_id', 'mask_earliest_batch', 'mask_latest_batch', 'mask_earliest_datapoint', 'mask_latest_datapoint']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method firewall_service_get_summary_times" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'firewall_id' is set
        if ('firewall_id' not in params or
                params['firewall_id'] is None):
            raise ValueError("Missing the required parameter `firewall_id` when calling `firewall_service_get_summary_times`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_id' in params:
            path_params['firewallId'] = params['firewall_id']  # noqa: E501

        query_params = []
        if 'mask_earliest_batch' in params:
            query_params.append(('mask.earliestBatch', params['mask_earliest_batch']))  # noqa: E501
        if 'mask_latest_batch' in params:
            query_params.append(('mask.latestBatch', params['mask_latest_batch']))  # noqa: E501
        if 'mask_earliest_datapoint' in params:
            query_params.append(('mask.earliestDatapoint', params['mask_earliest_datapoint']))  # noqa: E501
        if 'mask_latest_datapoint' in params:
            query_params.append(('mask.latestDatapoint', params['mask_latest_datapoint']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/firewall/{firewallId}/summary-times', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetSummaryTimesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def firewall_service_list_aggregate_issues(self, firewall_id, **kwargs):  # noqa: E501
        """ListAggregateIssues  # noqa: E501

        This RPC fetches aggregate issues for firewall over a given time interval. If no interval is provided, the backend will choose an interval to aggregate over. These aggregate issues include information like \"for the unseen categorical test, we saw 5000 occurrences of the value 'bing-bong' for feature 'widget' over the last 30 bins.\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_list_aggregate_issues(firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id: (required)
        :param datetime interval_start_time_epoch_seconds: inclusive start timestamp
        :param datetime interval_end_time_epoch_seconds: exclusive end timestamp
        :return: RimeListAggregateIssuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.firewall_service_list_aggregate_issues_with_http_info(firewall_id, **kwargs)  # noqa: E501
        else:
            (data) = self.firewall_service_list_aggregate_issues_with_http_info(firewall_id, **kwargs)  # noqa: E501
            return data

    def firewall_service_list_aggregate_issues_with_http_info(self, firewall_id, **kwargs):  # noqa: E501
        """ListAggregateIssues  # noqa: E501

        This RPC fetches aggregate issues for firewall over a given time interval. If no interval is provided, the backend will choose an interval to aggregate over. These aggregate issues include information like \"for the unseen categorical test, we saw 5000 occurrences of the value 'bing-bong' for feature 'widget' over the last 30 bins.\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_list_aggregate_issues_with_http_info(firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id: (required)
        :param datetime interval_start_time_epoch_seconds: inclusive start timestamp
        :param datetime interval_end_time_epoch_seconds: exclusive end timestamp
        :return: RimeListAggregateIssuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['firewall_id', 'interval_start_time_epoch_seconds', 'interval_end_time_epoch_seconds']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method firewall_service_list_aggregate_issues" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'firewall_id' is set
        if ('firewall_id' not in params or
                params['firewall_id'] is None):
            raise ValueError("Missing the required parameter `firewall_id` when calling `firewall_service_list_aggregate_issues`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_id' in params:
            path_params['firewallId'] = params['firewall_id']  # noqa: E501

        query_params = []
        if 'interval_start_time_epoch_seconds' in params:
            query_params.append(('interval.startTimeEpochSeconds', params['interval_start_time_epoch_seconds']))  # noqa: E501
        if 'interval_end_time_epoch_seconds' in params:
            query_params.append(('interval.endTimeEpochSeconds', params['interval_end_time_epoch_seconds']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/firewall/{firewallId}/aggregate-issues', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListAggregateIssuesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def firewall_service_list_datapoint_bins(self, firewall_id, **kwargs):  # noqa: E501
        """ListDatapointBins  # noqa: E501

        Returns action summaries based on the time range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_list_datapoint_bins(firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id: (required)
        :param datetime select_range_start_time_epoch_seconds: inclusive start timestamp
        :param datetime select_range_end_time_epoch_seconds: exclusive end timestamp
        :param list[str] firewall_actions: Specify the group of actions we want to look at
        :param bool send_total_info: Get total info for all buckets, even if there are no requested firewall actions in those buckets
        :return: StreamResultOfRimeListDatapointBinsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.firewall_service_list_datapoint_bins_with_http_info(firewall_id, **kwargs)  # noqa: E501
        else:
            (data) = self.firewall_service_list_datapoint_bins_with_http_info(firewall_id, **kwargs)  # noqa: E501
            return data

    def firewall_service_list_datapoint_bins_with_http_info(self, firewall_id, **kwargs):  # noqa: E501
        """ListDatapointBins  # noqa: E501

        Returns action summaries based on the time range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_list_datapoint_bins_with_http_info(firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id: (required)
        :param datetime select_range_start_time_epoch_seconds: inclusive start timestamp
        :param datetime select_range_end_time_epoch_seconds: exclusive end timestamp
        :param list[str] firewall_actions: Specify the group of actions we want to look at
        :param bool send_total_info: Get total info for all buckets, even if there are no requested firewall actions in those buckets
        :return: StreamResultOfRimeListDatapointBinsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['firewall_id', 'select_range_start_time_epoch_seconds', 'select_range_end_time_epoch_seconds', 'firewall_actions', 'send_total_info']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method firewall_service_list_datapoint_bins" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'firewall_id' is set
        if ('firewall_id' not in params or
                params['firewall_id'] is None):
            raise ValueError("Missing the required parameter `firewall_id` when calling `firewall_service_list_datapoint_bins`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_id' in params:
            path_params['firewallId'] = params['firewall_id']  # noqa: E501

        query_params = []
        if 'select_range_start_time_epoch_seconds' in params:
            query_params.append(('selectRange.startTimeEpochSeconds', params['select_range_start_time_epoch_seconds']))  # noqa: E501
        if 'select_range_end_time_epoch_seconds' in params:
            query_params.append(('selectRange.endTimeEpochSeconds', params['select_range_end_time_epoch_seconds']))  # noqa: E501
        if 'firewall_actions' in params:
            query_params.append(('firewallActions', params['firewall_actions']))  # noqa: E501
            collection_formats['firewallActions'] = 'multi'  # noqa: E501
        if 'send_total_info' in params:
            query_params.append(('sendTotalInfo', params['send_total_info']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/firewall/{firewallId}/datapoints/bins', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StreamResultOfRimeListDatapointBinsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def firewall_service_list_datapoint_result_details(self, firewall_id, **kwargs):  # noqa: E501
        """ListDatapointResultDetails  # noqa: E501

        Fetches a single FW Details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_list_datapoint_result_details(firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id: (required)
        :param str request_id:
        :return: RimeListDatapointResultDetailsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.firewall_service_list_datapoint_result_details_with_http_info(firewall_id, **kwargs)  # noqa: E501
        else:
            (data) = self.firewall_service_list_datapoint_result_details_with_http_info(firewall_id, **kwargs)  # noqa: E501
            return data

    def firewall_service_list_datapoint_result_details_with_http_info(self, firewall_id, **kwargs):  # noqa: E501
        """ListDatapointResultDetails  # noqa: E501

        Fetches a single FW Details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_list_datapoint_result_details_with_http_info(firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id: (required)
        :param str request_id:
        :return: RimeListDatapointResultDetailsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['firewall_id', 'request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method firewall_service_list_datapoint_result_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'firewall_id' is set
        if ('firewall_id' not in params or
                params['firewall_id'] is None):
            raise ValueError("Missing the required parameter `firewall_id` when calling `firewall_service_list_datapoint_result_details`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_id' in params:
            path_params['firewallId'] = params['firewall_id']  # noqa: E501

        query_params = []
        if 'request_id' in params:
            query_params.append(('requestId', params['request_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/firewall/{firewallId}/datapoints/details', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListDatapointResultDetailsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def firewall_service_list_datapoint_result_summaries(self, firewall_id, **kwargs):  # noqa: E501
        """ListDatapointResultSummaries  # noqa: E501

        Lists a page of FW summaries based on request. This may request for a specific single Summary using requestID. This may also request for multiple Summaries using TimeRange.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_list_datapoint_result_summaries(firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id: (required)
        :param list[str] first_page_req_filter_firewall_actions:
        :param datetime first_page_req_filter_time_range_start_time_epoch_seconds: inclusive start timestamp
        :param datetime first_page_req_filter_time_range_end_time_epoch_seconds: exclusive end timestamp
        :param str first_page_req_filter_request_id:
        :param str first_page_req_sort_sort_order:
        :param str first_page_req_sort_sort_by:
        :param str page_token:
        :param str page_size:
        :return: RimeListDatapointResultSummariesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.firewall_service_list_datapoint_result_summaries_with_http_info(firewall_id, **kwargs)  # noqa: E501
        else:
            (data) = self.firewall_service_list_datapoint_result_summaries_with_http_info(firewall_id, **kwargs)  # noqa: E501
            return data

    def firewall_service_list_datapoint_result_summaries_with_http_info(self, firewall_id, **kwargs):  # noqa: E501
        """ListDatapointResultSummaries  # noqa: E501

        Lists a page of FW summaries based on request. This may request for a specific single Summary using requestID. This may also request for multiple Summaries using TimeRange.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_list_datapoint_result_summaries_with_http_info(firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id: (required)
        :param list[str] first_page_req_filter_firewall_actions:
        :param datetime first_page_req_filter_time_range_start_time_epoch_seconds: inclusive start timestamp
        :param datetime first_page_req_filter_time_range_end_time_epoch_seconds: exclusive end timestamp
        :param str first_page_req_filter_request_id:
        :param str first_page_req_sort_sort_order:
        :param str first_page_req_sort_sort_by:
        :param str page_token:
        :param str page_size:
        :return: RimeListDatapointResultSummariesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['firewall_id', 'first_page_req_filter_firewall_actions', 'first_page_req_filter_time_range_start_time_epoch_seconds', 'first_page_req_filter_time_range_end_time_epoch_seconds', 'first_page_req_filter_request_id', 'first_page_req_sort_sort_order', 'first_page_req_sort_sort_by', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method firewall_service_list_datapoint_result_summaries" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'firewall_id' is set
        if ('firewall_id' not in params or
                params['firewall_id'] is None):
            raise ValueError("Missing the required parameter `firewall_id` when calling `firewall_service_list_datapoint_result_summaries`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_id' in params:
            path_params['firewallId'] = params['firewall_id']  # noqa: E501

        query_params = []
        if 'first_page_req_filter_firewall_actions' in params:
            query_params.append(('firstPageReq.filter.firewallActions', params['first_page_req_filter_firewall_actions']))  # noqa: E501
            collection_formats['firstPageReq.filter.firewallActions'] = 'multi'  # noqa: E501
        if 'first_page_req_filter_time_range_start_time_epoch_seconds' in params:
            query_params.append(('firstPageReq.filter.timeRange.startTimeEpochSeconds', params['first_page_req_filter_time_range_start_time_epoch_seconds']))  # noqa: E501
        if 'first_page_req_filter_time_range_end_time_epoch_seconds' in params:
            query_params.append(('firstPageReq.filter.timeRange.endTimeEpochSeconds', params['first_page_req_filter_time_range_end_time_epoch_seconds']))  # noqa: E501
        if 'first_page_req_filter_request_id' in params:
            query_params.append(('firstPageReq.filter.requestId', params['first_page_req_filter_request_id']))  # noqa: E501
        if 'first_page_req_sort_sort_order' in params:
            query_params.append(('firstPageReq.sort.sortOrder', params['first_page_req_sort_sort_order']))  # noqa: E501
        if 'first_page_req_sort_sort_by' in params:
            query_params.append(('firstPageReq.sort.sortBy', params['first_page_req_sort_sort_by']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/firewall/{firewallId}/datapoints/summaries', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListDatapointResultSummariesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def firewall_service_list_feature_subset_metrics(self, firewall_id, feature_id, **kwargs):  # noqa: E501
        """ListFeatureSubsetMetrics  # noqa: E501

        Returns all the subset metrics for a feature for a given time range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_list_feature_subset_metrics(firewall_id, feature_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id: (required)
        :param str feature_id: (required)
        :param datetime interval_start_time_epoch_seconds: inclusive start timestamp
        :param datetime interval_end_time_epoch_seconds: exclusive end timestamp
        :return: RimeListFeatureSubsetMetricsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.firewall_service_list_feature_subset_metrics_with_http_info(firewall_id, feature_id, **kwargs)  # noqa: E501
        else:
            (data) = self.firewall_service_list_feature_subset_metrics_with_http_info(firewall_id, feature_id, **kwargs)  # noqa: E501
            return data

    def firewall_service_list_feature_subset_metrics_with_http_info(self, firewall_id, feature_id, **kwargs):  # noqa: E501
        """ListFeatureSubsetMetrics  # noqa: E501

        Returns all the subset metrics for a feature for a given time range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_list_feature_subset_metrics_with_http_info(firewall_id, feature_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id: (required)
        :param str feature_id: (required)
        :param datetime interval_start_time_epoch_seconds: inclusive start timestamp
        :param datetime interval_end_time_epoch_seconds: exclusive end timestamp
        :return: RimeListFeatureSubsetMetricsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['firewall_id', 'feature_id', 'interval_start_time_epoch_seconds', 'interval_end_time_epoch_seconds']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method firewall_service_list_feature_subset_metrics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'firewall_id' is set
        if ('firewall_id' not in params or
                params['firewall_id'] is None):
            raise ValueError("Missing the required parameter `firewall_id` when calling `firewall_service_list_feature_subset_metrics`")  # noqa: E501
        # verify the required parameter 'feature_id' is set
        if ('feature_id' not in params or
                params['feature_id'] is None):
            raise ValueError("Missing the required parameter `feature_id` when calling `firewall_service_list_feature_subset_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_id' in params:
            path_params['firewallId'] = params['firewall_id']  # noqa: E501
        if 'feature_id' in params:
            path_params['featureId'] = params['feature_id']  # noqa: E501

        query_params = []
        if 'interval_start_time_epoch_seconds' in params:
            query_params.append(('interval.startTimeEpochSeconds', params['interval_start_time_epoch_seconds']))  # noqa: E501
        if 'interval_end_time_epoch_seconds' in params:
            query_params.append(('interval.endTimeEpochSeconds', params['interval_end_time_epoch_seconds']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/firewall/{firewallId}/{featureId}/subset-metrics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListFeatureSubsetMetricsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def firewall_service_list_firewalls(self, **kwargs):  # noqa: E501
        """ListFirewalls  # noqa: E501

        Lists multiple Firewall instances.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_list_firewalls(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] firewall_ids:
        :param bool mask_id:
        :param bool mask_name:
        :param bool mask_stress_test_run_id:
        :param bool mask_project_id:
        :param bool mask_batch_metadata:
        :param bool mask_web_app_url:
        :param bool mask_run_ct_schedule:
        :param bool mask_cli_config: If specified, this will control listing the cli configs (Prior to V19) and typed cli configs (Post V19)
        :param bool mask_firewall_rules:
        :param bool mask_data_location_info:
        :param bool mask_managed_image:
        :param bool mask_reference_set_source:
        :return: RimeListFirewallsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.firewall_service_list_firewalls_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.firewall_service_list_firewalls_with_http_info(**kwargs)  # noqa: E501
            return data

    def firewall_service_list_firewalls_with_http_info(self, **kwargs):  # noqa: E501
        """ListFirewalls  # noqa: E501

        Lists multiple Firewall instances.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_list_firewalls_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] firewall_ids:
        :param bool mask_id:
        :param bool mask_name:
        :param bool mask_stress_test_run_id:
        :param bool mask_project_id:
        :param bool mask_batch_metadata:
        :param bool mask_web_app_url:
        :param bool mask_run_ct_schedule:
        :param bool mask_cli_config: If specified, this will control listing the cli configs (Prior to V19) and typed cli configs (Post V19)
        :param bool mask_firewall_rules:
        :param bool mask_data_location_info:
        :param bool mask_managed_image:
        :param bool mask_reference_set_source:
        :return: RimeListFirewallsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['firewall_ids', 'mask_id', 'mask_name', 'mask_stress_test_run_id', 'mask_project_id', 'mask_batch_metadata', 'mask_web_app_url', 'mask_run_ct_schedule', 'mask_cli_config', 'mask_firewall_rules', 'mask_data_location_info', 'mask_managed_image', 'mask_reference_set_source']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method firewall_service_list_firewalls" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'firewall_ids' in params:
            query_params.append(('firewallIds', params['firewall_ids']))  # noqa: E501
            collection_formats['firewallIds'] = 'multi'  # noqa: E501
        if 'mask_id' in params:
            query_params.append(('mask.id', params['mask_id']))  # noqa: E501
        if 'mask_name' in params:
            query_params.append(('mask.name', params['mask_name']))  # noqa: E501
        if 'mask_stress_test_run_id' in params:
            query_params.append(('mask.stressTestRunId', params['mask_stress_test_run_id']))  # noqa: E501
        if 'mask_project_id' in params:
            query_params.append(('mask.projectId', params['mask_project_id']))  # noqa: E501
        if 'mask_batch_metadata' in params:
            query_params.append(('mask.batchMetadata', params['mask_batch_metadata']))  # noqa: E501
        if 'mask_web_app_url' in params:
            query_params.append(('mask.webAppUrl', params['mask_web_app_url']))  # noqa: E501
        if 'mask_run_ct_schedule' in params:
            query_params.append(('mask.runCtSchedule', params['mask_run_ct_schedule']))  # noqa: E501
        if 'mask_cli_config' in params:
            query_params.append(('mask.cliConfig', params['mask_cli_config']))  # noqa: E501
        if 'mask_firewall_rules' in params:
            query_params.append(('mask.firewallRules', params['mask_firewall_rules']))  # noqa: E501
        if 'mask_data_location_info' in params:
            query_params.append(('mask.dataLocationInfo', params['mask_data_location_info']))  # noqa: E501
        if 'mask_managed_image' in params:
            query_params.append(('mask.managedImage', params['mask_managed_image']))  # noqa: E501
        if 'mask_reference_set_source' in params:
            query_params.append(('mask.referenceSetSource', params['mask_reference_set_source']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/firewall', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListFirewallsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def firewall_service_list_latest_model_statuses(self, **kwargs):  # noqa: E501
        """ListLatestModelStatuses  # noqa: E501

        Returns the latest model status for multiple firewalls.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_list_latest_model_statuses(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] firewall_ids: Will use the latest CT test run for a firewall. If no firewallIds are specified, an error will be returned.
        :return: RimeListLatestModelStatusesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.firewall_service_list_latest_model_statuses_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.firewall_service_list_latest_model_statuses_with_http_info(**kwargs)  # noqa: E501
            return data

    def firewall_service_list_latest_model_statuses_with_http_info(self, **kwargs):  # noqa: E501
        """ListLatestModelStatuses  # noqa: E501

        Returns the latest model status for multiple firewalls.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_list_latest_model_statuses_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] firewall_ids: Will use the latest CT test run for a firewall. If no firewallIds are specified, an error will be returned.
        :return: RimeListLatestModelStatusesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['firewall_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method firewall_service_list_latest_model_statuses" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'firewall_ids' in params:
            query_params.append(('firewallIds', params['firewall_ids']))  # noqa: E501
            collection_formats['firewallIds'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/firewall/latest-model-statuses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListLatestModelStatusesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def firewall_service_list_test_run_summaries(self, firewall_id, **kwargs):  # noqa: E501
        """ListTestRunSummaries i  # noqa: E501

        Revamped version of `ListBatchSummaries` that returns all the test run batch summaries for a given time range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_list_test_run_summaries(firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id: (required)
        :param datetime interval_start_time_epoch_seconds: inclusive start timestamp
        :param datetime interval_end_time_epoch_seconds: exclusive end timestamp
        :return: RimeListTestRunSummariesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.firewall_service_list_test_run_summaries_with_http_info(firewall_id, **kwargs)  # noqa: E501
        else:
            (data) = self.firewall_service_list_test_run_summaries_with_http_info(firewall_id, **kwargs)  # noqa: E501
            return data

    def firewall_service_list_test_run_summaries_with_http_info(self, firewall_id, **kwargs):  # noqa: E501
        """ListTestRunSummaries i  # noqa: E501

        Revamped version of `ListBatchSummaries` that returns all the test run batch summaries for a given time range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_list_test_run_summaries_with_http_info(firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id: (required)
        :param datetime interval_start_time_epoch_seconds: inclusive start timestamp
        :param datetime interval_end_time_epoch_seconds: exclusive end timestamp
        :return: RimeListTestRunSummariesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['firewall_id', 'interval_start_time_epoch_seconds', 'interval_end_time_epoch_seconds']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method firewall_service_list_test_run_summaries" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'firewall_id' is set
        if ('firewall_id' not in params or
                params['firewall_id'] is None):
            raise ValueError("Missing the required parameter `firewall_id` when calling `firewall_service_list_test_run_summaries`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_id' in params:
            path_params['firewallId'] = params['firewall_id']  # noqa: E501

        query_params = []
        if 'interval_start_time_epoch_seconds' in params:
            query_params.append(('interval.startTimeEpochSeconds', params['interval_start_time_epoch_seconds']))  # noqa: E501
        if 'interval_end_time_epoch_seconds' in params:
            query_params.append(('interval.endTimeEpochSeconds', params['interval_end_time_epoch_seconds']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/firewall/{firewallId}/test-run-summaries', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListTestRunSummariesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def firewall_service_update_firewall_components(self, body, firewall_id, **kwargs):  # noqa: E501
        """UpdateFirewallComponents  # noqa: E501

        Updates an existing Firewall instance in the BE/DB based on the explicit user-defined configuration. All provided values will be used to overwrite the corresponding values in the BE/DB.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_update_firewall_components(body, firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ComponentsFirewallIdBody body: (required)
        :param str firewall_id: (required)
        :return: RimeUpdateFirewallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.firewall_service_update_firewall_components_with_http_info(body, firewall_id, **kwargs)  # noqa: E501
        else:
            (data) = self.firewall_service_update_firewall_components_with_http_info(body, firewall_id, **kwargs)  # noqa: E501
            return data

    def firewall_service_update_firewall_components_with_http_info(self, body, firewall_id, **kwargs):  # noqa: E501
        """UpdateFirewallComponents  # noqa: E501

        Updates an existing Firewall instance in the BE/DB based on the explicit user-defined configuration. All provided values will be used to overwrite the corresponding values in the BE/DB.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_update_firewall_components_with_http_info(body, firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ComponentsFirewallIdBody body: (required)
        :param str firewall_id: (required)
        :return: RimeUpdateFirewallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'firewall_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method firewall_service_update_firewall_components" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `firewall_service_update_firewall_components`")  # noqa: E501
        # verify the required parameter 'firewall_id' is set
        if ('firewall_id' not in params or
                params['firewall_id'] is None):
            raise ValueError("Missing the required parameter `firewall_id` when calling `firewall_service_update_firewall_components`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_id' in params:
            path_params['firewallId'] = params['firewall_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/firewall/components/{firewallId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeUpdateFirewallResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def firewall_service_update_firewall_test_run_id(self, body, firewall_id, **kwargs):  # noqa: E501
        """UpdateFirewallTestRunID  # noqa: E501

        Updates an existing Firewall instance in the BE/DB based on a stress test run. This overwrites the CLIConfig, rules, and thresholds based on those configured from that run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_update_firewall_test_run_id(body, firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FirewallFirewallIdBody body: (required)
        :param str firewall_id: (required)
        :return: RimeUpdateFirewallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.firewall_service_update_firewall_test_run_id_with_http_info(body, firewall_id, **kwargs)  # noqa: E501
        else:
            (data) = self.firewall_service_update_firewall_test_run_id_with_http_info(body, firewall_id, **kwargs)  # noqa: E501
            return data

    def firewall_service_update_firewall_test_run_id_with_http_info(self, body, firewall_id, **kwargs):  # noqa: E501
        """UpdateFirewallTestRunID  # noqa: E501

        Updates an existing Firewall instance in the BE/DB based on a stress test run. This overwrites the CLIConfig, rules, and thresholds based on those configured from that run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_update_firewall_test_run_id_with_http_info(body, firewall_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FirewallFirewallIdBody body: (required)
        :param str firewall_id: (required)
        :return: RimeUpdateFirewallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'firewall_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method firewall_service_update_firewall_test_run_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `firewall_service_update_firewall_test_run_id`")  # noqa: E501
        # verify the required parameter 'firewall_id' is set
        if ('firewall_id' not in params or
                params['firewall_id'] is None):
            raise ValueError("Missing the required parameter `firewall_id` when calling `firewall_service_update_firewall_test_run_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_id' in params:
            path_params['firewallId'] = params['firewall_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/firewall/{firewallId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeUpdateFirewallResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
