/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.runtime.JSON;

import com.alachisoft.ncache.runtime.JSON.JsonDataType;
import com.alachisoft.ncache.runtime.JSON.JsonNull;
import com.alachisoft.ncache.runtime.JSON.JsonValue;
import com.alachisoft.ncache.runtime.JSON.JsonValueBase;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class JsonArray
extends JsonValueBase
implements Serializable,
Iterable<JsonValueBase> {
    private List<JsonValueBase> _jsonItems = new ArrayList<JsonValueBase>();

    public JsonValueBase getItem(int index) {
        this.verifyIndex(index);
        return this._jsonItems.get(index);
    }

    @Override
    public Iterator<JsonValueBase> iterator() {
        return this.getIterator();
    }

    public void setItem(int index, JsonValueBase value) throws OperationFailedException {
        if (value == null) {
            throw new UnsupportedOperationException("Updating to null value is not supported with indexer.");
        }
        if (index > -1 && index < this.getCount()) {
            this.updateValue(index, value);
        } else {
            this.addAt(index, value);
        }
    }

    public int getCount() {
        return this._jsonItems == null ? 0 : this._jsonItems.size();
    }

    private boolean getIsReadOnly() {
        return false;
    }

    @Override
    public Object getValue() {
        return this;
    }

    @Override
    protected int getSize() {
        int size = super.getSize();
        if (this._jsonItems != null) {
            for (JsonValueBase item : this._jsonItems) {
                size += item.getSize();
            }
        }
        return size;
    }

    @Override
    protected int getInMemorySize() {
        int inMemorySize = super.getInMemorySize() + 8;
        if (this._jsonItems != null) {
            for (JsonValueBase item : this._jsonItems) {
                inMemorySize += item.getInMemorySize();
            }
        }
        return inMemorySize;
    }

    public JsonArray() {
        super(null, JsonDataType.Array);
    }

    public JsonArray(String json) {
        this();
        JsonArray.parse(this, json);
    }

    public void add(JsonValue item) throws OperationFailedException {
        this.add((JsonValueBase)(item instanceof JsonValueBase ? item : null));
    }

    public void add(JsonValueBase item) throws OperationFailedException {
        this.verifyJsonItem(item);
        this._jsonItems.add(item);
    }

    public void copyTo(JsonValueBase[] array, int arrayIndex) {
        if (array == null) {
            throw new IllegalArgumentException("Value cannot be null.\r\nParameter name: Array");
        }
        if (arrayIndex < 0) {
            throw new IllegalArgumentException("'Array index was less than the array's lower bound.");
        }
        if (arrayIndex > array.length) {
            throw new IllegalArgumentException("'Array index was greater than the array's upper bound.");
        }
        if (array.length - arrayIndex < this._jsonItems.size()) {
            throw new IllegalArgumentException("Array was not long enough. Check arrayindex and length, and the array's lower bounds.");
        }
        if (this._jsonItems != null) {
            JsonValueBase[] tempArray = this.toArray();
            System.arraycopy(tempArray, 0, array, arrayIndex, tempArray.length);
        }
    }

    public boolean remove(JsonValue item) throws OperationFailedException {
        return this.remove((JsonValueBase)(item instanceof JsonValueBase ? item : null));
    }

    public boolean remove(JsonValueBase item) throws OperationFailedException {
        if (this._jsonItems == null) {
            return false;
        }
        this.verifyJsonItem(item);
        return this._jsonItems.remove(item);
    }

    public boolean contains(JsonValue item) throws OperationFailedException {
        return this.contains((JsonValueBase)(item instanceof JsonValueBase ? item : null));
    }

    public boolean contains(JsonValueBase item) throws OperationFailedException {
        if (this._jsonItems == null) {
            return false;
        }
        this.verifyJsonItem(item);
        return this._jsonItems.contains(item);
    }

    public void clear() {
        this._jsonItems.clear();
    }

    public Iterator<JsonValueBase> getIterator() {
        return this._jsonItems.iterator();
    }

    private void verifyIndex(int index) {
        if (index < 0 || index > this.getCount()) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void verifyJsonItem(JsonValueBase jsonItem) throws OperationFailedException {
        if (jsonItem == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: jsonItem");
        }
        if (jsonItem == this) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot contain an item that is a reference to self.");
        }
        HashMap<JsonValueBase, Byte> map = new HashMap<JsonValueBase, Byte>();
        map.put(this, (byte)0);
        jsonItem.invalidateParentReference(map);
    }

    private void updateValue(int index, JsonValueBase jsonItem) throws OperationFailedException {
        this.verifyIndex(index);
        this.verifyJsonItem(jsonItem);
        this._jsonItems.set(index, jsonItem);
    }

    private void addAt(int index, JsonValueBase jsonItem) throws OperationFailedException {
        this.verifyJsonItem(jsonItem);
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index < this.getCount()) {
            JsonNull existingItem = (JsonNull)(this._jsonItems.get(index) instanceof JsonNull ? this._jsonItems.get(index) : null);
            if (existingItem == null) {
                throw new UnsupportedOperationException("A value already exists at the specified index.");
            }
            this.updateValue(index, jsonItem);
        } else {
            int aheadFactor = index - this.getCount();
            for (int i = 0; i < aheadFactor; ++i) {
                this.add(new JsonNull());
            }
            this.add(jsonItem);
        }
    }

    private JsonValueBase[] toArray() {
        return this._jsonItems.toArray(new JsonValueBase[this._jsonItems.size()]);
    }

    public boolean equals(Object obj) {
        JsonArray otherJsonArray = (JsonArray)(obj instanceof JsonArray ? obj : null);
        if (otherJsonArray == null) {
            return false;
        }
        if (otherJsonArray.getCount() != this.getCount()) {
            return false;
        }
        Iterator<JsonValueBase> currentEnumerator = this.getIterator();
        Iterator<JsonValueBase> otherEnumerator = otherJsonArray.iterator();
        while (currentEnumerator.hasNext()) {
            if (!otherEnumerator.hasNext()) {
                return false;
            }
            JsonValueBase jsonValueOther = otherEnumerator.next();
            JsonValueBase jsonValueCurrent = currentEnumerator.next();
            if (jsonValueCurrent.getDataType() != jsonValueOther.getDataType()) {
                return false;
            }
            if (jsonValueCurrent.equals(jsonValueOther)) continue;
            return false;
        }
        return !otherEnumerator.hasNext();
    }

    public String toString() {
        StringBuilder jsonBuilder = new StringBuilder();
        jsonBuilder.append('[');
        int i = 0;
        for (JsonValueBase item : this._jsonItems) {
            jsonBuilder.append(i++ != 0 ? ", " : " ").append(item.toString());
        }
        jsonBuilder.append(jsonBuilder.length() > 1 ? " " : "");
        jsonBuilder.append(']');
        return jsonBuilder.toString();
    }
}

