/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.runtime.JSON;

import com.alachisoft.ncache.runtime.JSON.JsonDataType;
import com.alachisoft.ncache.runtime.JSON.JsonValueBase;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class JsonValue
extends JsonValueBase
implements Serializable {
    protected JsonValue(Object value, JsonDataType jsonType) {
        super(value, jsonType);
    }

    public JsonValue(Object value) {
        this(value, JsonDataType.Object);
    }

    public JsonValue(boolean value) {
        this(value, JsonDataType.Boolean);
    }

    public JsonValue(byte value) {
        this(value, JsonDataType.Number);
    }

    public JsonValue(short value) {
        this(value, JsonDataType.Number);
    }

    public JsonValue(int value) {
        this(value, JsonDataType.Number);
    }

    public JsonValue(long value) {
        this(value, JsonDataType.Number);
    }

    public JsonValue(float value) {
        this(Float.valueOf(value), JsonDataType.Number);
    }

    public JsonValue(BigDecimal value) {
        this(value, JsonDataType.Number);
    }

    public JsonValue(double value) {
        this(value, JsonDataType.Number);
    }

    public JsonValue(Date value) {
        this(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSZ").format(value), JsonDataType.String);
    }

    public JsonValue(String value) {
        this(value, JsonDataType.String);
    }

    public boolean toBoolean() {
        return Boolean.parseBoolean(this.getValue().toString());
    }

    public byte toByte() {
        return Byte.parseByte(this.getValue().toString());
    }

    public short toInt16() {
        return Short.parseShort(this.getValue().toString());
    }

    public int toInt32() {
        return Integer.parseInt(this.getValue().toString());
    }

    public long toInt64() {
        return Long.parseLong(this.getValue().toString());
    }

    public float toFloat() {
        return Float.parseFloat(this.getValue().toString());
    }

    public double toDouble() {
        return Double.parseDouble(this.getValue().toString());
    }

    public BigDecimal toDecimal() {
        return new BigDecimal(String.valueOf(this.getValue()));
    }

    public Date toDate() throws ParseException {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSZ").parse(this.getValue().toString());
    }

    public String toStringValue() {
        return String.valueOf(this.getValue());
    }

    public boolean equals(Object obj) {
        JsonValue otherJsonValue = (JsonValue)(obj instanceof JsonValue ? obj : null);
        if (otherJsonValue == null) {
            return false;
        }
        if (this.getDataType() != otherJsonValue.getDataType()) {
            return false;
        }
        switch (otherJsonValue.getDataType()) {
            case Boolean: {
                return new Boolean(this.toBoolean()).equals(otherJsonValue.toBoolean());
            }
            case Number: {
                return this.compareNumber(otherJsonValue);
            }
            case String: {
                return this.toStringValue().equals(otherJsonValue.toStringValue());
            }
        }
        return false;
    }

    public String toString() {
        switch (this.getDataType()) {
            case Boolean: {
                return (Boolean)this.getValue() != false ? "true" : "false";
            }
            case String: {
                return "\"" + (String)this.getValue() + "\"";
            }
            case Number: {
                return this.getValue().toString();
            }
            case Null: {
                return null;
            }
        }
        if (this.getValue() instanceof String) {
            return (String)this.getValue();
        }
        return this.getValue().toString();
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    private boolean compareNumber(JsonValue otherJsonValue) {
        Object value = otherJsonValue.getValue();
        if (value != null) {
            if (Byte.class.equals(value.getClass()) || BigInteger.class.equals(value.getClass()) || Integer.class.equals(value.getClass()) || Short.class.equals(value.getClass()) || Long.class.equals(value.getClass())) {
                return new Long(this.toInt64()).equals(otherJsonValue.toInt64());
            }
            if (Float.class.equals(value.getClass()) || Double.class.equals(value.getClass())) {
                return new Double(this.toDouble()).equals(this.toDouble());
            }
            if (BigDecimal.class.equals(value.getClass())) {
                return this.toDecimal().equals(otherJsonValue.toDecimal());
            }
        }
        return false;
    }
}

