/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.runtime.dependencies;

import com.alachisoft.ncache.runtime.dependencies.CacheDependency;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.util.HelperFxn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class FileDependency
extends CacheDependency {
    private List<String> _fileNames;
    private long _startAfterTicks;

    FileDependency() {
    }

    public FileDependency(String fileName) throws OperationFailedException {
        this.validateFileName(fileName);
        this.initialize(List.of(fileName), new Date());
    }

    public FileDependency(Iterable<String> fileNames) throws OperationFailedException {
        this.initialize(fileNames, new Date());
    }

    public FileDependency(String fileName, Date startAfter) throws OperationFailedException {
        this.validateFileName(fileName);
        this.initialize(List.of(fileName), startAfter);
    }

    public FileDependency(Iterable<String> fileNames, Date startAfter) throws OperationFailedException {
        this.initialize(fileNames, startAfter);
    }

    void initialize(Iterable<String> fileNames, Date startAfter) throws OperationFailedException {
        if (fileNames == null) {
            throw new OperationFailedException("One of the dependency file(s) does not exist. ");
        }
        if (startAfter == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: startAfter");
        }
        if (this._fileNames == null) {
            this._fileNames = new ArrayList<String>();
        }
        for (String file : fileNames) {
            if (file == null) continue;
            this._fileNames.add(file);
        }
        if (this._fileNames.size() == 0) {
            throw new OperationFailedException("One of the dependency file(s) does not exist. ");
        }
        this._startAfterTicks = HelperFxn.getTicks(startAfter);
    }

    public Collection<String> getFileNames() {
        return this._fileNames;
    }

    public long getStartAfterTicks() {
        return this._startAfterTicks;
    }

    void setFileNames(Collection<String> fileNames) {
        this._fileNames = (List)fileNames;
    }

    void setStartAfterTicks(long ticks) {
        this._startAfterTicks = ticks;
    }

    private void validateFileName(String fileName) throws OperationFailedException {
        if (fileName == null || fileName.isEmpty()) {
            throw new OperationFailedException("One of the dependency file(s) does not exist. ");
        }
    }
}

