/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.runtime.dependencies;

import com.alachisoft.ncache.runtime.dependencies.CacheDependency;
import com.alachisoft.ncache.runtime.dependencies.KeyDependencyType;
import com.alachisoft.ncache.runtime.errorhandling.ErrorMessages;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.util.HelperFxn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class KeyDependency
extends CacheDependency {
    private List<String> _cacheKeys;
    private long _startAfterTicks;
    private KeyDependencyType _keyDependencyType;

    public Collection<String> getCacheKeys() {
        return this._cacheKeys;
    }

    void setCacheKeys(Collection<String> keys) {
        this._cacheKeys = (List)keys;
    }

    public final KeyDependencyType getKeyDependencyType() {
        return this._keyDependencyType;
    }

    public final void setKeyDependencyType(KeyDependencyType value) {
        this._keyDependencyType = value;
    }

    public long getStartAfterTicks() {
        return this._startAfterTicks;
    }

    void setStartAfterTicks(long ticks) {
        this._startAfterTicks = ticks;
    }

    KeyDependency() {
    }

    public KeyDependency(String key) throws OperationFailedException {
        this.validateKey(key);
        this.initialize(List.of(key), HelperFxn.getCurrentTime(), KeyDependencyType.UpdateOrRemove);
    }

    public KeyDependency(String key, Date startAfter) throws OperationFailedException {
        this.validateKey(key);
        this.initialize(List.of(key), startAfter, KeyDependencyType.UpdateOrRemove);
    }

    public KeyDependency(String key, KeyDependencyType keyDependencyType) throws OperationFailedException {
        this.validateKey(key);
        this.initialize(List.of(key), HelperFxn.getCurrentTime(), keyDependencyType);
    }

    public KeyDependency(String key, Date startAfter, KeyDependencyType keyDependencyType) throws OperationFailedException {
        this.validateKey(key);
        this.initialize(List.of(key), startAfter, keyDependencyType);
    }

    public KeyDependency(List<String> keys) throws OperationFailedException {
        this(keys, HelperFxn.getCurrentTime(), KeyDependencyType.UpdateOrRemove);
    }

    public KeyDependency(List<String> keys, Date startAfter) throws OperationFailedException {
        this(keys, startAfter, KeyDependencyType.UpdateOrRemove);
    }

    public KeyDependency(List<String> keys, KeyDependencyType keyDependencyType) throws OperationFailedException {
        this(keys, HelperFxn.getCurrentTime(), keyDependencyType);
    }

    public KeyDependency(List<String> keys, Date startAfter, KeyDependencyType keyDependencyType) throws OperationFailedException {
        this.initialize(keys, startAfter, keyDependencyType);
    }

    private void findNull(List<String> keys) throws OperationFailedException {
        for (int i = 0; i < keys.size(); ++i) {
            this.validateKey(keys.get(i));
        }
    }

    private List<String> getDistinctKeys(List<String> keys) throws OperationFailedException {
        ArrayList<String> tempKeysList = new ArrayList<String>();
        for (int index = 0; index < keys.size(); ++index) {
            String key = keys.get(index);
            if (tempKeysList.contains(key)) continue;
            tempKeysList.add(key);
        }
        if (tempKeysList.size() < 1) {
            throw new OperationFailedException(17512, ErrorMessages.getErrorMessage(17512, new String[0]));
        }
        return tempKeysList;
    }

    private void validateKey(String key) throws OperationFailedException {
        if (key == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
        }
        if (key.isEmpty()) {
            throw new OperationFailedException(17511, ErrorMessages.getErrorMessage(17511, new String[0]));
        }
    }

    private void initialize(List<String> keys, Date startAfter, KeyDependencyType keyDependencyType) throws OperationFailedException {
        if (keys == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: keys");
        }
        if (startAfter == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: startAfter");
        }
        if (keys.size() > 1) {
            this.findNull(keys);
            this._cacheKeys = this.getDistinctKeys(keys);
        } else {
            this._cacheKeys = keys;
        }
        this._keyDependencyType = keyDependencyType;
        this._startAfterTicks = HelperFxn.getTicks(startAfter);
    }
}

