/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.runtime.dependencies;

import com.alachisoft.ncache.runtime.dependencies.CacheDependency;
import com.alachisoft.ncache.runtime.dependencies.CommandType;
import com.alachisoft.ncache.runtime.dependencies.Edition;
import com.alachisoft.ncache.runtime.dependencies.OracleCmdParams;
import com.alachisoft.ncache.runtime.dependencies.OracleCommandType;
import java.util.HashMap;
import java.util.Map;

public final class OracleCacheDependency
extends CacheDependency {
    private String _connectionString;
    private String _cmdText;
    private CommandType _cmdType;
    private Map<String, OracleCmdParams> _cmdParams;

    OracleCacheDependency() {
    }

    public OracleCacheDependency(String connectionString, String cmdText) {
        this(connectionString, cmdText, OracleCommandType.Text, new HashMap<String, OracleCmdParams>());
    }

    public OracleCacheDependency(String connectionString, String cmdText, OracleCommandType cmdType, Map<String, OracleCmdParams> cmdParams) {
        if (Edition.isExpress() || Edition.isProfessional()) {
            throw new UnsupportedOperationException("Oracle Cache Dependecny is not supported in this edition of NCache.");
        }
        if (cmdType == OracleCommandType.Text) {
            this._cmdType = CommandType.Text;
        } else if (cmdType == OracleCommandType.StoredProcedure) {
            this._cmdType = CommandType.StoredProcedure;
        }
        this._cmdText = cmdText;
        this._connectionString = connectionString;
        this._cmdParams = cmdParams;
    }

    public String getConnectionString() {
        return this._connectionString;
    }

    public String getCommandText() {
        return this._cmdText;
    }

    public CommandType getCommandType() {
        return this._cmdType;
    }

    public Map<String, OracleCmdParams> getCommandParams() {
        return this._cmdParams;
    }

    void setConnectionString(String connectionString) {
        this._connectionString = connectionString;
    }

    void setCommandText(String commandText) {
        this._cmdText = commandText;
    }

    void setCommandType(CommandType type) {
        this._cmdType = type;
    }

    void setCommandParams(Map<String, OracleCmdParams> commandParameters) {
        this._cmdParams = commandParameters;
    }
}

