/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.security;

import com.alachisoft.ncache.security.IAuthorizationProvider;
import com.alachisoft.ncache.security.OperationCode;
import com.alachisoft.ncache.security.SecurityConfiguration;
import java.io.File;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CacheXMLAuthorizationProviderAPI
implements IAuthorizationProvider {
    public static boolean securityEnabled = false;
    public static String LDAP = "";
    public static String LDAPPort = "";
    public HashMap cacheUsers = new HashMap();

    public CacheXMLAuthorizationProviderAPI() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CacheXMLAuthorizationProviderAPI(String cacheId) {
        String filePath = SecurityConfiguration.getConfigurationPathAPI();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            Document document = null;
            DocumentBuilder db = dbf.newDocumentBuilder();
            File file = new File(filePath);
            if (!file.exists()) {
                return;
            }
            document = db.parse(file);
            Element docEle = document.getDocumentElement();
            NodeList cacheConfigList = docEle.getElementsByTagName("cache-config");
            boolean done = false;
            if (cacheConfigList == null) return;
            if (cacheConfigList.getLength() <= 0) return;
            for (int nodeItem = 0; nodeItem < cacheConfigList.getLength(); ++nodeItem) {
                Node cacheNode = cacheConfigList.item(nodeItem);
                if (cacheNode.getNodeType() == 1) {
                    Element securityElement;
                    Node securityNode;
                    Element cacheElement = (Element)cacheNode;
                    if (!cacheId.equals(cacheElement.getAttribute("name"))) {
                        return;
                    }
                    NodeList CacheNodeProperties = cacheElement.getElementsByTagName("security");
                    if (CacheNodeProperties != null && CacheNodeProperties.getLength() > 0 && (securityNode = CacheNodeProperties.item(0)).getNodeType() == 1 && "security".equals((securityElement = (Element)securityNode).getNodeName())) {
                        String enabled = securityElement.getAttribute("enable");
                        if (enabled.equals("true")) {
                            securityEnabled = true;
                        }
                        LDAP = securityElement.getAttribute("domain_controler");
                        LDAP = securityElement.getAttribute("port");
                        return;
                    }
                }
                if (done) return;
            }
            return;
        }
        catch (Exception e) {
            new Exception("Can not open " + filePath + " Error:" + e.toString());
            return;
        }
    }

    @Override
    public final boolean Authorize(String context) {
        throw new RuntimeException("The method or operation is not implemented.");
    }

    @Override
    public final boolean AuthorizeNode(String context) {
        throw new RuntimeException("The method or operation is not implemented.");
    }

    @Override
    public final boolean AuthorizeAPI(String userId, OperationCode context, String cacheId) {
        String filePath = SecurityConfiguration.getConfigurationPathAPI();
        try {
            int nodeItem;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            Document document = null;
            DocumentBuilder db = dbf.newDocumentBuilder();
            File file = new File(filePath);
            if (!file.exists()) {
                return false;
            }
            document = db.parse(file);
            Element docEle = document.getDocumentElement();
            NodeList cacheConfigList = docEle.getElementsByTagName("cache-config");
            boolean done = false;
            if (cacheConfigList != null && cacheConfigList.getLength() > 0 && (nodeItem = 0) < cacheConfigList.getLength()) {
                Node cacheNode = cacheConfigList.item(nodeItem);
                if (cacheNode.getNodeType() == 1) {
                    Element securityElement;
                    Node securityNode;
                    Element cacheElement = (Element)cacheNode;
                    if (!cacheId.equals(cacheElement.getAttribute("name"))) {
                        return false;
                    }
                    NodeList CacheNodeProperties = cacheElement.getElementsByTagName("security");
                    if (CacheNodeProperties != null && CacheNodeProperties.getLength() > 0 && (securityNode = CacheNodeProperties.item(0)).getNodeType() == 1 && "security".equals((securityElement = (Element)securityNode).getNodeName())) {
                        String enabled = securityElement.getAttribute("enable");
                        if (enabled.equals("true")) {
                            securityEnabled = true;
                        }
                        LDAP = securityElement.getAttribute("domain_controler");
                        LDAP = securityElement.getAttribute("port");
                        NodeList users = securityElement.getElementsByTagName("users");
                        if (users != null && users.getLength() > 0) {
                            for (int usersItem = 0; usersItem < users.getLength(); ++usersItem) {
                                Element userElement;
                                Node userNode = CacheNodeProperties.item(usersItem);
                                if (userNode.getNodeType() != 1 || (userElement = (Element)userNode).getAttribute("id") == null || userElement.getAttribute("domain") == null) continue;
                                this.cacheUsers.put(userElement.getAttribute("id"), userElement.getAttribute("domain"));
                            }
                        }
                    }
                }
                done = true;
            }
            return this.cacheUsers.containsKey(userId);
        }
        catch (Exception e) {
            new Exception("Can not open " + filePath + " Error:" + e.toString());
            return false;
        }
    }
}

