/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.security;

import Alachisoft.NCache.Common.AppUtil;
import java.io.File;

public class SecurityConfiguration {
    private static final String DIRNAME = "config";
    private static final String FILENAME = "security.conf";
    private static final String FILENAMEAPI = "config.ncconf";

    public static String getConfigurationPath() {
        String filePath = SecurityConfiguration.GetFileLocalPath(FILENAME);
        if (filePath != null) {
            return filePath;
        }
        filePath = SecurityConfiguration.GetFileGlobalPath(FILENAME, DIRNAME);
        if (filePath != null) {
            return filePath;
        }
        throw new RuntimeException("Missing security config file ");
    }

    public static String getConfigurationPathAPI() {
        String filePath = SecurityConfiguration.GetFileLocalPath(FILENAMEAPI);
        if (filePath != null) {
            return filePath;
        }
        filePath = SecurityConfiguration.GetFileGlobalPath(FILENAMEAPI, DIRNAME);
        if (filePath != null) {
            return filePath;
        }
        throw new RuntimeException("Missing config file ");
    }

    private static String GetFileLocalPath(String fileName) {
        String path = System.getProperty("user.dir") + "\\" + fileName;
        if (new File(path).isFile()) {
            return path;
        }
        return null;
    }

    private static String GetFileGlobalPath(String fileName, String directoryName) {
        String ncacheInstallDirectory = AppUtil.getInstallDir();
        String directoryPath = "";
        String filePath = "";
        if (ncacheInstallDirectory == null) {
            return null;
        }
        File ncacheDir = new File(ncacheInstallDirectory);
        directoryPath = new File(ncacheDir, directoryName).getPath();
        if (!new File(directoryPath).isDirectory()) {
            return null;
        }
        File combineDirPath = new File(directoryPath);
        filePath = new File(combineDirPath, fileName).getPath();
        if (!new File(filePath).isFile()) {
            return null;
        }
        return filePath;
    }
}

