/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.security.encryption;

import Alachisoft.NCache.Common.EncryptionUtil;
import Alachisoft.NCache.Common.IDisposable;
import com.alachisoft.ncache.runtime.encryption.Encryption;
import com.alachisoft.ncache.security.encryption.AESEncryption;
import com.alachisoft.ncache.security.encryption.TripleDESEncryption;
import java.util.HashMap;

public class EncryptionMgr
implements IDisposable {
    private static HashMap<String, EncryptionMgr> _encryptionManagers = new HashMap();
    private String _encryptionKey = null;
    private Encryption _encryptionProvider = null;
    private boolean _enabled = false;

    public static byte[] Encryption(byte[] data, String cacheName) {
        EncryptionMgr mgr = EncryptionMgr.GetEncryptionMgr(cacheName);
        if (mgr != null && mgr._enabled) {
            return mgr._encryptionProvider.Encrypt(data, mgr._encryptionKey);
        }
        return data;
    }

    public static byte[] Decrypt(byte[] data, String cacheName) {
        EncryptionMgr mgr = EncryptionMgr.GetEncryptionMgr(cacheName);
        if (mgr != null && mgr._enabled) {
            return mgr._encryptionProvider.Decrypt(data, mgr._encryptionKey);
        }
        return data;
    }

    public static void InitializeEncryption(boolean enabled, String key, String cacheName, String provider) throws Exception {
        _encryptionManagers.put(cacheName, EncryptionMgr.CreateObject(enabled, key, cacheName, provider));
    }

    private static EncryptionMgr CreateObject(boolean enabled, String key, String cacheName, String provider) throws Exception {
        EncryptionMgr encryptionMgr = new EncryptionMgr();
        encryptionMgr._enabled = enabled;
        if (encryptionMgr._enabled) {
            if (provider == null || provider.isEmpty()) {
                throw new Exception("Encryption provider is Empty or Null");
            }
            encryptionMgr._encryptionKey = EncryptionUtil.DecryptKey((String)key);
            if (provider.contains("AES")) {
                boolean validKeyLength = true;
                if (provider.equals("AES 128")) {
                    validKeyLength = encryptionMgr._encryptionKey.length() == 16;
                } else if (provider.equals("AES 192")) {
                    validKeyLength = encryptionMgr._encryptionKey.length() == 24;
                } else if (provider.equals("AES 256")) {
                    validKeyLength = encryptionMgr._encryptionKey.length() == 32;
                } else {
                    throw new Exception("Invalid AES ecnryption provider is specified");
                }
                if (!validKeyLength) {
                    throw new Exception("Invalid key length for " + provider + " provider");
                }
                encryptionMgr._encryptionProvider = new AESEncryption();
            } else if (provider.contains("DES")) {
                boolean validKeyLength = true;
                if (provider.equals("3DES 128")) {
                    validKeyLength = encryptionMgr._encryptionKey.length() == 16;
                } else if (provider.equals("3DES 192")) {
                    validKeyLength = encryptionMgr._encryptionKey.length() == 24;
                } else {
                    throw new Exception("Invalid 3DES ecnryption provider is specified");
                }
                if (!validKeyLength) {
                    throw new Exception("Invalid key length for " + provider + " provider");
                }
                encryptionMgr._encryptionProvider = new TripleDESEncryption();
            } else {
                throw new Exception("Invalid encryption provider is specified");
            }
        }
        return encryptionMgr;
    }

    private static EncryptionMgr GetEncryptionMgr(String cacheName) {
        if (_encryptionManagers.containsKey(cacheName)) {
            return _encryptionManagers.get(cacheName);
        }
        return null;
    }

    public final void dispose() {
    }
}

