/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.core.io;

import com.alachisoft.ncache.serialization.core.io.EndianBits;
import com.alachisoft.ncache.serialization.core.io.LittleEndianBits;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.math.BigInteger;

public class BlockDataInputStream
extends InputStream
implements DataInput {
    private static final int MAX_BLOCK_SIZE = 2048;
    private static final int MAX_HEADER_SIZE = 4;
    private static final int CHAR_BUF_SIZE = 256;
    private static final int HEADER_BLOCKED = -2;
    private final byte[] buf = new byte[2048];
    private final byte[] hbuf = new byte[4];
    private final char[] cbuf = new char[256];
    private final DataInputStream in;
    private final DataInputStream din;
    private final EndianBits bitfmt;
    private int pos = 0;
    private int end = -1;
    private int unread = 0;
    private boolean defaultDataEnd = false;

    public BlockDataInputStream(InputStream in) {
        this.in = new DataInputStream(in);
        this.din = new DataInputStream(this);
        this.bitfmt = new LittleEndianBits();
        this.pos = 0;
        this.end = 0;
        this.unread = 0;
        try {
            this.refill();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static native void bytesToFloats(byte[] var0, int var1, float[] var2, int var3, int var4);

    private static native void bytesToDoubles(byte[] var0, int var1, double[] var2, int var3, int var4);

    private int readLen(boolean canBlock) throws IOException {
        if (this.defaultDataEnd) {
            return -1;
        }
        try {
            int avail;
            int n = avail = canBlock ? Integer.MAX_VALUE : this.in.available();
            if (avail < 4) {
                return -2;
            }
            this.in.readFully(this.hbuf, 0, 4);
            int len = this.bitfmt.getInt(this.hbuf, 0);
            if (len < 0) {
                throw new StreamCorruptedException("illegal block data header length: " + len);
            }
            return len;
        }
        catch (EOFException ex) {
            throw new StreamCorruptedException("unexpected EOF while reading block data header");
        }
    }

    private void refill() throws IOException {
        try {
            do {
                this.pos = 0;
                if (this.unread > 0) {
                    int n = this.in.read(this.buf, 0, Math.min(this.unread, 2048));
                    if (n >= 0) {
                        this.end = n;
                        this.unread = n;
                        continue;
                    }
                    throw new StreamCorruptedException("unexpected EOF in middle of data block");
                }
                this.unread = 2048;
                this.end = 0;
            } while (this.pos == this.end);
        }
        catch (IOException ex) {
            this.pos = 0;
            this.end = -1;
            this.unread = 0;
            throw ex;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.pos == this.end) {
            this.refill();
        }
        return this.end >= 0 ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.read(b, off, len, false);
    }

    @Override
    public long skip(long len) throws IOException {
        long remain = len;
        while (remain > 0L) {
            if (this.pos == this.end) {
                this.refill();
            }
            if (this.end < 0) break;
            int nread = (int)Math.min(remain, (long)(this.end - this.pos));
            remain -= (long)nread;
            this.pos += nread;
        }
        return len - remain;
    }

    @Override
    public int available() throws IOException {
        if (this.pos == this.end && this.unread == 0) {
            int n;
            while ((n = this.readLen(false)) == 0) {
            }
            switch (n) {
                case -2: {
                    break;
                }
                case -1: {
                    this.pos = 0;
                    this.end = -1;
                    break;
                }
                default: {
                    this.pos = 0;
                    this.end = 0;
                    this.unread = n;
                }
            }
        }
        int unreadAvail = this.unread > 0 ? Math.min(this.in.available(), this.unread) : 0;
        return this.end >= 0 ? this.end - this.pos + unreadAvail : 0;
    }

    @Override
    public void close() throws IOException {
        this.pos = 0;
        this.end = -1;
        this.unread = 0;
        this.in.close();
    }

    int read(byte[] b, int off, int len, boolean copy) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (!copy) {
            if (this.pos == this.end) {
                this.refill();
            }
            if (this.end < 0) {
                return -1;
            }
            int nread = Math.min(len, this.end - this.pos);
            System.arraycopy(this.buf, this.pos, b, off, nread);
            this.pos += nread;
            return nread;
        }
        int nread = this.in.read(this.buf, 0, Math.min(len, 2048));
        if (nread > 0) {
            System.arraycopy(this.buf, 0, b, off, nread);
        }
        return nread;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length, false);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.readFully(b, off, len, false);
    }

    public void readFully(byte[] b, int off, int len, boolean copy) throws IOException {
        while (len > 0) {
            int n = this.read(b, off, len, copy);
            if (n < 0) {
                throw new EOFException();
            }
            off += n;
            len -= n;
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.din.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        int v = this.read();
        if (v < 0) {
            throw new EOFException();
        }
        return v != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int v = this.read();
        if (v < 0) {
            throw new EOFException();
        }
        return (byte)v;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int v = this.read();
        if (v < 0) {
            throw new EOFException();
        }
        return v;
    }

    @Override
    public char readChar() throws IOException {
        if (this.end - this.pos < 2) {
            if (this.end - this.pos != 0) {
                byte[] biteBuff = new byte[2];
                biteBuff[0] = this.buf[this.pos];
                this.refill();
                biteBuff[1] = this.readByte();
                char v = this.bitfmt.getChar(biteBuff, 0);
                return v;
            }
            this.refill();
            char v = this.bitfmt.getChar(this.buf, this.pos);
            this.pos += 2;
            return v;
        }
        char v = this.bitfmt.getChar(this.buf, this.pos);
        this.pos += 2;
        return v;
    }

    @Override
    public short readShort() throws IOException {
        if (this.end - this.pos < 2) {
            if (this.end - this.pos != 0) {
                byte[] biteBuff = new byte[2];
                biteBuff[0] = this.buf[this.pos];
                this.refill();
                biteBuff[1] = this.readByte();
                short v = this.bitfmt.getShort(biteBuff, 0);
                return v;
            }
            this.refill();
            short v = this.bitfmt.getShort(this.buf, this.pos);
            this.pos += 2;
            return v;
        }
        short v = this.bitfmt.getShort(this.buf, this.pos);
        this.pos += 2;
        return v;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        if (this.end - this.pos < 2) {
            if (this.end - this.pos != 0) {
                byte[] biteBuff = new byte[2];
                biteBuff[0] = this.buf[this.pos];
                this.refill();
                biteBuff[1] = this.readByte();
                int v = this.bitfmt.getShort(biteBuff, 0) & 0xFFFF;
                return v;
            }
            this.refill();
            int v = this.bitfmt.getShort(this.buf, this.pos) & 0xFFFF;
            this.pos += 2;
            return v;
        }
        int v = this.bitfmt.getShort(this.buf, this.pos) & 0xFFFF;
        this.pos += 2;
        return v;
    }

    @Override
    public int readInt() throws IOException {
        if (this.end - this.pos < 4) {
            if (this.end - this.pos != 0) {
                int i;
                byte[] biteBuff = new byte[4];
                int toBePurged = this.end - this.pos;
                for (i = 0; i < toBePurged; ++i) {
                    biteBuff[i] = this.buf[this.pos + i];
                }
                this.refill();
                for (i = toBePurged; i < 4; ++i) {
                    biteBuff[i] = this.readByte();
                }
                int v = this.bitfmt.getInt(biteBuff, 0);
                return v;
            }
            this.refill();
            int v = this.bitfmt.getInt(this.buf, this.pos);
            this.pos += 4;
            return v;
        }
        int v = this.bitfmt.getInt(this.buf, this.pos);
        this.pos += 4;
        return v;
    }

    @Override
    public float readFloat() throws IOException {
        if (this.end - this.pos < 4) {
            if (this.end - this.pos != 0) {
                int i;
                byte[] biteBuff = new byte[4];
                int toBePurged = this.end - this.pos;
                for (i = 0; i < toBePurged; ++i) {
                    biteBuff[i] = this.buf[this.pos + i];
                }
                this.refill();
                for (i = toBePurged; i < 4; ++i) {
                    biteBuff[i] = this.readByte();
                }
                float v = this.bitfmt.getFloat(biteBuff, 0);
                return v;
            }
            this.refill();
            float v = this.bitfmt.getFloat(this.buf, this.pos);
            this.pos += 4;
            return v;
        }
        float v = this.bitfmt.getFloat(this.buf, this.pos);
        this.pos += 4;
        return v;
    }

    @Override
    public long readLong() throws IOException {
        if (this.end - this.pos < 8) {
            if (this.end - this.pos != 0) {
                int i;
                byte[] biteBuff = new byte[8];
                int toBePurged = this.end - this.pos;
                for (i = 0; i < toBePurged; ++i) {
                    biteBuff[i] = this.buf[this.pos + i];
                }
                this.refill();
                for (i = toBePurged; i < 8; ++i) {
                    biteBuff[i] = this.readByte();
                }
                long v = this.bitfmt.getLong(biteBuff, 0);
                return v;
            }
            this.refill();
            long v = this.bitfmt.getLong(this.buf, this.pos);
            this.pos += 8;
            return v;
        }
        long v = this.bitfmt.getLong(this.buf, this.pos);
        this.pos += 8;
        return v;
    }

    @Override
    public double readDouble() throws IOException {
        if (this.end - this.pos < 8) {
            if (this.end - this.pos != 0) {
                int i;
                byte[] biteBuff = new byte[8];
                int toBePurged = this.end - this.pos;
                for (i = 0; i < toBePurged; ++i) {
                    biteBuff[i] = this.buf[this.pos + i];
                }
                this.refill();
                for (i = toBePurged; i < 8; ++i) {
                    biteBuff[i] = this.readByte();
                }
                double v = this.bitfmt.getDouble(biteBuff, 0);
                return v;
            }
            this.refill();
            double v = this.bitfmt.getDouble(this.buf, this.pos);
            this.pos += 8;
            return v;
        }
        double v = this.bitfmt.getDouble(this.buf, this.pos);
        this.pos += 8;
        return v;
    }

    @Override
    public String readUTF() throws IOException {
        return this.readUTFBody(this.readInt());
    }

    public int readUInt16() throws IOException {
        byte[] bytes = new byte[2];
        this.read(bytes);
        int value = 0;
        value = (bytes[0] & 0xFF) << 0 | (bytes[1] & 0xFF) << 8 & 0xFFFF;
        return value;
    }

    public long readUInt32() throws IOException {
        byte[] bytes = new byte[4];
        this.read(bytes);
        long value = 0L;
        value = (long)((bytes[0] & 0xFF) << 0 | (bytes[1] & 0xFF) << 8 | (bytes[2] & 0xFF) << 16 | (bytes[3] & 0xFF) << 24) & 0xFFFFFFFFL;
        return value;
    }

    public BigInteger readUInt64() throws IOException {
        byte[] bytes = new byte[8];
        this.read(bytes);
        int j = bytes.length - 1;
        for (int i = 0; j > i; --j, ++i) {
            byte tmp = bytes[j];
            bytes[j] = bytes[i];
            bytes[i] = tmp;
        }
        return new BigInteger(1, bytes);
    }

    @Override
    public String readLine() throws IOException {
        return this.din.readLine();
    }

    public short readUByte() throws IOException {
        return (short)(0xFF & this.readUnsignedByte());
    }

    public void readBooleans(boolean[] v, int off, int len) throws IOException {
        int endoff = off + len;
        while (off < endoff) {
            if (this.end - this.pos < 1) {
                this.refill();
                v[off++] = this.bitfmt.getBoolean(this.buf, this.pos++);
                continue;
            }
            int stop = Math.min(endoff, off + this.end - this.pos);
            while (off < stop) {
                v[off++] = this.bitfmt.getBoolean(this.buf, this.pos++);
            }
        }
    }

    public void readChars(char[] v, int off, int len) throws IOException {
        int endoff = off + len;
        while (off < endoff) {
            if (this.end - this.pos < 2) {
                if (this.end - this.pos != 0) {
                    byte[] biteBuff = new byte[2];
                    biteBuff[0] = this.buf[this.pos];
                    this.refill();
                    biteBuff[1] = this.readByte();
                    v[off++] = this.bitfmt.getChar(biteBuff, 0);
                    continue;
                }
                this.refill();
                v[off++] = this.bitfmt.getChar(this.buf, this.pos);
                this.pos += 2;
                continue;
            }
            int stop = Math.min(endoff, off + (this.end - this.pos));
            while (off < stop) {
                v[off++] = this.bitfmt.getChar(this.buf, this.pos);
                this.pos += 2;
            }
        }
    }

    public void readShorts(short[] v, int off, int len) throws IOException {
        int endoff = off + len;
        while (off < endoff) {
            if (this.end - this.pos < 2) {
                if (this.end - this.pos != 0) {
                    byte[] biteBuff = new byte[2];
                    biteBuff[0] = this.buf[this.pos];
                    this.refill();
                    biteBuff[1] = this.readByte();
                    v[off++] = this.bitfmt.getShort(biteBuff, 0);
                    continue;
                }
                this.refill();
                v[off++] = this.bitfmt.getShort(this.buf, this.pos);
                this.pos += 2;
                continue;
            }
            int stop = Math.min(endoff, off + (this.end - this.pos >> 1));
            while (off < stop) {
                v[off++] = this.bitfmt.getShort(this.buf, this.pos);
                this.pos += 2;
            }
        }
    }

    public void readInts(int[] v, int off, int len) throws IOException {
        int endoff = off + len;
        while (off < endoff) {
            if (this.end - this.pos < 4) {
                if (this.end - this.pos != 0) {
                    int i;
                    byte[] biteBuff = new byte[4];
                    int toBePurged = this.end - this.pos;
                    for (i = 0; i < toBePurged; ++i) {
                        biteBuff[i] = this.buf[this.pos + i];
                    }
                    this.refill();
                    for (i = toBePurged; i < 4; ++i) {
                        biteBuff[i] = this.readByte();
                    }
                    v[off++] = this.bitfmt.getInt(biteBuff, 0);
                    continue;
                }
                this.refill();
                v[off++] = this.bitfmt.getInt(this.buf, this.pos);
                this.pos += 4;
                continue;
            }
            int stop = Math.min(endoff, off + (this.end - this.pos >> 2));
            while (off < stop) {
                v[off++] = this.bitfmt.getInt(this.buf, this.pos);
                this.pos += 4;
            }
        }
    }

    public void readFloats(float[] v, int off, int len) throws IOException {
        int endoff = off + len;
        while (off < endoff) {
            if (this.end - this.pos < 4) {
                if (this.end - this.pos != 0) {
                    int i;
                    byte[] biteBuff = new byte[4];
                    int toBePurged = this.end - this.pos;
                    for (i = 0; i < toBePurged; ++i) {
                        biteBuff[i] = this.buf[this.pos + i];
                    }
                    this.refill();
                    for (i = toBePurged; i < 4; ++i) {
                        biteBuff[i] = this.readByte();
                    }
                    v[off++] = this.bitfmt.getFloat(biteBuff, 0);
                    continue;
                }
                this.refill();
                v[off++] = this.bitfmt.getFloat(this.buf, this.pos);
                this.pos += 4;
                continue;
            }
            int stop = Math.min(endoff, off + (this.end - this.pos >> 2));
            while (off < stop) {
                v[off++] = this.bitfmt.getFloat(this.buf, this.pos);
                this.pos += 4;
            }
        }
    }

    public void readLongs(long[] v, int off, int len) throws IOException {
        int endoff = off + len;
        while (off < endoff) {
            if (this.end - this.pos < 8) {
                if (this.end - this.pos != 0) {
                    int i;
                    byte[] biteBuff = new byte[8];
                    int toBePurged = this.end - this.pos;
                    for (i = 0; i < toBePurged; ++i) {
                        biteBuff[i] = this.buf[this.pos + i];
                    }
                    this.refill();
                    for (i = toBePurged; i < 8; ++i) {
                        biteBuff[i] = this.readByte();
                    }
                    v[off++] = this.bitfmt.getLong(biteBuff, 0);
                    continue;
                }
                this.refill();
                v[off++] = this.bitfmt.getLong(this.buf, this.pos);
                this.pos += 8;
                continue;
            }
            int stop = Math.min(endoff, off + (this.end - this.pos >> 3));
            while (off < stop) {
                v[off++] = this.bitfmt.getLong(this.buf, this.pos);
                this.pos += 8;
            }
        }
    }

    public void readDoubles(double[] v, int off, int len) throws IOException {
        int endoff = off + len;
        while (off < endoff) {
            if (this.end - this.pos < 8) {
                if (this.end - this.pos != 0) {
                    int i;
                    byte[] biteBuff = new byte[8];
                    int toBePurged = this.end - this.pos;
                    for (i = 0; i < toBePurged; ++i) {
                        biteBuff[i] = this.buf[this.pos + i];
                    }
                    this.refill();
                    for (i = toBePurged; i < 8; ++i) {
                        biteBuff[i] = this.readByte();
                    }
                    v[off++] = this.bitfmt.getDouble(biteBuff, 0);
                    continue;
                }
                this.refill();
                v[off++] = this.bitfmt.getDouble(this.buf, this.pos);
                this.pos += 8;
                continue;
            }
            int stop = Math.min(endoff, off + (this.end - this.pos >> 3));
            while (off < stop) {
                v[off++] = this.bitfmt.getDouble(this.buf, this.pos);
                this.pos += 8;
            }
        }
    }

    public String readLongUTF() throws IOException {
        return this.readUTFBody(this.readInt());
    }

    private String readUTFBody(long utflen) throws IOException {
        StringBuilder sbuf = new StringBuilder();
        if (utflen == 0L) {
            return "";
        }
        while (utflen > 0L) {
            int avail = this.end - this.pos;
            if (avail >= 3 || (long)avail == utflen) {
                utflen -= this.readUTFSpan(sbuf, utflen);
                continue;
            }
            utflen -= (long)this.readUTFChar(sbuf, utflen);
        }
        return sbuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long readUTFSpan(StringBuilder sbuf, long utflen) throws IOException {
        int start;
        int cpos;
        block13: {
            cpos = 0;
            start = this.pos;
            int avail = Math.min(this.end - this.pos, 256);
            int stop = this.pos + (utflen > (long)avail ? avail - 2 : (int)utflen);
            boolean outOfBounds = false;
            try {
                block10: while (this.pos < stop) {
                    int b1 = this.buf[this.pos++] & 0xFF;
                    switch (b1 >> 4) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            this.cbuf[cpos++] = (char)b1;
                            continue block10;
                        }
                        case 12: 
                        case 13: {
                            byte b2 = this.buf[this.pos++];
                            if ((b2 & 0xC0) != 128) {
                                throw new UTFDataFormatException();
                            }
                            this.cbuf[cpos++] = (char)((b1 & 0x1F) << 6 | (b2 & 0x3F) << 0);
                            continue block10;
                        }
                        case 14: {
                            byte b3 = this.buf[this.pos + 1];
                            byte b2 = this.buf[this.pos + 0];
                            this.pos += 2;
                            if ((b2 & 0xC0) != 128) throw new UTFDataFormatException();
                            if ((b3 & 0xC0) != 128) {
                                throw new UTFDataFormatException();
                            }
                            this.cbuf[cpos++] = (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | (b3 & 0x3F) << 0);
                            continue block10;
                        }
                    }
                    throw new UTFDataFormatException();
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                outOfBounds = true;
                return (long)outOfBounds;
            }
            finally {
                if (!outOfBounds && (long)(this.pos - start) <= utflen) break block13;
                this.pos = start + (int)utflen;
                throw new UTFDataFormatException();
            }
        }
        sbuf.append(this.cbuf, 0, cpos);
        return this.pos - start;
    }

    private int readUTFChar(StringBuilder sbuf, long utflen) throws IOException {
        int b1 = this.readByte() & 0xFF;
        switch (b1 >> 4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                sbuf.append((char)b1);
                return 1;
            }
            case 12: 
            case 13: {
                if (utflen < 2L) {
                    throw new UTFDataFormatException();
                }
                byte b2 = this.readByte();
                if ((b2 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                sbuf.append((char)((b1 & 0x1F) << 6 | (b2 & 0x3F) << 0));
                return 2;
            }
            case 14: {
                if (utflen < 3L) {
                    if (utflen == 2L) {
                        this.readByte();
                    }
                    throw new UTFDataFormatException();
                }
                byte b2 = this.readByte();
                byte b3 = this.readByte();
                if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                sbuf.append((char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | (b3 & 0x3F) << 0));
                return 3;
            }
        }
        throw new UTFDataFormatException();
    }

    public char readUTF8Char() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        this.readUTFChar(stringBuilder, 3L);
        return stringBuilder.charAt(0);
    }
}

