/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.core.io;

import com.alachisoft.ncache.serialization.core.io.EndianBits;
import com.alachisoft.ncache.serialization.core.io.LittleEndianBits;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.math.BigInteger;

public class BlockDataOutputStream
extends OutputStream
implements DataOutput {
    private static final int MAX_BLOCK_SIZE = 2048;
    private static final int MAX_HEADER_SIZE = 4;
    private static final int CHAR_BUF_SIZE = 256;
    private final byte[] buf = new byte[2048];
    private final byte[] hbuf = new byte[4];
    private final char[] cbuf = new char[256];
    private final OutputStream out;
    private final DataOutputStream dout;
    private final EndianBits bitfmt;
    private int pos = 0;

    public BlockDataOutputStream(OutputStream out) {
        this.out = out;
        this.dout = new DataOutputStream(this);
        this.bitfmt = new LittleEndianBits();
    }

    private static native void floatsToBytes(float[] var0, int var1, byte[] var2, int var3, int var4);

    private static native void doublesToBytes(double[] var0, int var1, byte[] var2, int var3, int var4);

    public final int size() {
        return this.dout.size();
    }

    @Override
    public void write(int b) throws IOException {
        if (this.pos >= 2048) {
            this.drain();
        }
        this.buf[this.pos++] = (byte)b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            if (this.pos >= 2048) {
                this.drain();
            }
            if (len >= 2048 && this.pos == 0) {
                this.out.write(b, off, 2048);
                off += 2048;
                len -= 2048;
                continue;
            }
            int wlen = Math.min(len, 2048 - this.pos);
            System.arraycopy(b, off, this.buf, this.pos, wlen);
            this.pos += wlen;
            off += wlen;
            len -= wlen;
        }
    }

    @Override
    public void flush() throws IOException {
        this.drain();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    void drain() throws IOException {
        if (this.pos == 0) {
            return;
        }
        this.out.write(this.buf, 0, this.pos);
        this.pos = 0;
    }

    private void writeLen(int len) throws IOException {
        this.bitfmt.putInt(this.hbuf, 0, len);
        this.out.write(this.hbuf, 0, 4);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        if (this.pos >= 2048) {
            this.drain();
        }
        this.bitfmt.putBoolean(this.buf, this.pos++, v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        if (this.pos >= 2048) {
            this.drain();
        }
        this.buf[this.pos++] = (byte)v;
    }

    @Override
    public void writeChar(int v) throws IOException {
        if (this.pos + 2 <= 2048) {
            this.bitfmt.putChar(this.buf, this.pos, (char)v);
            this.pos += 2;
        } else {
            this.drain();
            this.writeChar(v);
        }
    }

    @Override
    public void writeShort(int v) throws IOException {
        if (this.pos + 2 <= 2048) {
            this.bitfmt.putShort(this.buf, this.pos, (short)v);
            this.pos += 2;
        } else {
            this.drain();
            this.writeShort(v);
        }
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (this.pos + 4 <= 2048) {
            this.bitfmt.putInt(this.buf, this.pos, v);
            this.pos += 4;
        } else {
            this.drain();
            this.writeInt(v);
        }
    }

    @Override
    public void writeFloat(float v) throws IOException {
        if (this.pos + 4 <= 2048) {
            this.bitfmt.putFloat(this.buf, this.pos, v);
            this.pos += 4;
        } else {
            this.drain();
            this.writeFloat(v);
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        if (this.pos + 8 <= 2048) {
            this.bitfmt.putLong(this.buf, this.pos, v);
            this.pos += 8;
        } else {
            this.drain();
            this.writeLong(v);
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        if (this.pos + 8 <= 2048) {
            this.bitfmt.putDouble(this.buf, this.pos, v);
            this.pos += 8;
        } else {
            this.drain();
            this.writeDouble(v);
        }
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int n;
        int endoff = s.length();
        int cpos = 0;
        int csize = 0;
        for (int off = 0; off < endoff; off += n) {
            if (cpos >= csize) {
                cpos = 0;
                csize = Math.min(endoff - off, 256);
                s.getChars(off, off + csize, this.cbuf, 0);
            }
            if (this.pos >= 2048) {
                this.drain();
            }
            n = Math.min(csize - cpos, 2048 - this.pos);
            int stop = this.pos + n;
            while (this.pos < stop) {
                this.buf[this.pos++] = (byte)this.cbuf[cpos++];
            }
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int csize;
        int endoff = s.length();
        for (int off = 0; off < endoff; off += csize) {
            csize = Math.min(endoff - off, 256);
            s.getChars(off, off + csize, this.cbuf, 0);
            this.writeChars(this.cbuf, 0, csize);
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        if (s == null) {
            this.writeInt(0);
            return;
        }
        this.writeUTF(s, this.getUTFLength(s));
    }

    public void writeBooleans(boolean[] v, int off, int len) throws IOException {
        int endoff = off + len;
        while (off < endoff) {
            if (this.pos >= 2048) {
                this.drain();
            }
            int stop = Math.min(endoff, off + (2048 - this.pos));
            while (off < stop) {
                this.bitfmt.putBoolean(this.buf, this.pos++, v[off++]);
            }
        }
    }

    public void writeChars(char[] v, int off, int len) throws IOException {
        int limit = 2046;
        int endoff = off + len;
        while (off < endoff) {
            if (this.pos <= limit) {
                int avail = 2048 - this.pos >> 1;
                int stop = Math.min(endoff, off + avail);
                while (off < stop) {
                    this.bitfmt.putChar(this.buf, this.pos, v[off++]);
                    this.pos += 2;
                }
                continue;
            }
            this.drain();
        }
    }

    public void writeShorts(short[] v, int off, int len) throws IOException {
        int limit = 2046;
        int endoff = off + len;
        while (off < endoff) {
            if (this.pos <= limit) {
                int avail = 2048 - this.pos >> 1;
                int stop = Math.min(endoff, off + avail);
                while (off < stop) {
                    this.bitfmt.putShort(this.buf, this.pos, v[off++]);
                    this.pos += 2;
                }
                continue;
            }
            this.drain();
        }
    }

    public void writeInts(int[] v, int off, int len) throws IOException {
        int limit = 2044;
        int endoff = off + len;
        while (off < endoff) {
            if (this.pos <= limit) {
                int avail = 2048 - this.pos >> 2;
                int stop = Math.min(endoff, off + avail);
                while (off < stop) {
                    this.bitfmt.putInt(this.buf, this.pos, v[off++]);
                    this.pos += 4;
                }
                continue;
            }
            this.drain();
        }
    }

    public void writeFloats(float[] v, int off, int len) throws IOException {
        int limit = 2044;
        int endoff = off + len;
        while (off < endoff) {
            if (this.pos <= limit) {
                int avail = 2048 - this.pos >> 2;
                int stop = Math.min(endoff, off + avail);
                this.bitfmt.putFloat(this.buf, this.pos, v[off++]);
                this.pos += 4;
                continue;
            }
            this.drain();
        }
    }

    public void writeLongs(long[] v, int off, int len) throws IOException {
        int limit = 2040;
        int endoff = off + len;
        while (off < endoff) {
            if (this.pos <= limit) {
                int avail = 2048 - this.pos >> 3;
                int stop = Math.min(endoff, off + avail);
                while (off < stop) {
                    this.bitfmt.putLong(this.buf, this.pos, v[off++]);
                    this.pos += 8;
                }
                continue;
            }
            this.drain();
        }
    }

    public void writeDoubles(double[] v, int off, int len) throws IOException {
        int limit = 2040;
        int endoff = off + len;
        while (off < endoff) {
            if (this.pos <= limit) {
                int avail = 2048 - this.pos >> 3;
                int stop = Math.min(endoff, off + avail);
                while (off < stop) {
                    this.bitfmt.putDouble(this.buf, this.pos, v[off++]);
                    this.pos += 8;
                }
                continue;
            }
            this.drain();
        }
    }

    int getUTFLength(String s) {
        int csize;
        int len = s.length();
        int utflen = 0;
        for (int off = 0; off < len; off += csize) {
            csize = Math.min(len - off, 256);
            s.getChars(off, off + csize, this.cbuf, 0);
            for (int cpos = 0; cpos < csize; ++cpos) {
                char c = this.cbuf[cpos];
                if (c >= '\u0001' && c <= '\u007f') {
                    ++utflen;
                    continue;
                }
                if (c > '\u07ff') {
                    utflen += 3;
                    continue;
                }
                utflen += 2;
            }
        }
        return utflen;
    }

    void writeUTF(String s, int utflen) throws IOException {
        if ((long)utflen > 65535L) {
            throw new UTFDataFormatException();
        }
        this.writeInt(utflen);
        if ((long)utflen == (long)s.length()) {
            this.writeBytes(s);
        } else {
            this.writeUTFBody(s);
        }
    }

    private void write7BitEncodedInt(int value) throws IOException {
        while (value >= 128) {
            this.writeByte((byte)value | 0x80);
            value >>= 7;
        }
        this.writeByte((byte)value);
    }

    public void writeLongUTF(String s) throws IOException {
        this.writeLongUTF(s, this.getUTFLength(s));
    }

    void writeLongUTF(String s, long utflen) throws IOException {
        this.writeLong(utflen);
        if (utflen == (long)s.length()) {
            this.writeBytes(s);
        } else {
            this.writeUTFBody(s);
        }
    }

    private void writeUTFBody(String s) throws IOException {
        int csize;
        int limit = 2045;
        int len = s.length();
        for (int off = 0; off < len; off += csize) {
            csize = Math.min(len - off, 256);
            s.getChars(off, off + csize, this.cbuf, 0);
            for (int cpos = 0; cpos < csize; ++cpos) {
                char c = this.cbuf[cpos];
                if (this.pos <= limit) {
                    if (c <= '\u007f' && c != '\u0000') {
                        this.buf[this.pos++] = (byte)c;
                        continue;
                    }
                    if (c > '\u07ff') {
                        this.buf[this.pos + 2] = (byte)(0x80 | c >> 0 & 0x3F);
                        this.buf[this.pos + 1] = (byte)(0x80 | c >> 6 & 0x3F);
                        this.buf[this.pos + 0] = (byte)(0xE0 | c >> 12 & 0xF);
                        this.pos += 3;
                        continue;
                    }
                    this.buf[this.pos + 1] = (byte)(0x80 | c >> 0 & 0x3F);
                    this.buf[this.pos + 0] = (byte)(0xC0 | c >> 6 & 0x1F);
                    this.pos += 2;
                    continue;
                }
                if (c <= '\u007f' && c != '\u0000') {
                    this.write(c);
                    continue;
                }
                if (c > '\u07ff') {
                    this.write(0xE0 | c >> 12 & 0xF);
                    this.write(0x80 | c >> 6 & 0x3F);
                    this.write(0x80 | c >> 0 & 0x3F);
                    continue;
                }
                this.write(0xC0 | c >> 6 & 0x1F);
                this.write(0x80 | c >> 0 & 0x3F);
            }
        }
    }

    public final void writeUInt16(int i) throws IOException {
        byte[] ret = new byte[]{(byte)(i & 0xFF), (byte)(i >> 8 & 0xFF)};
        this.write(ret);
    }

    public final void writeUInt32(long i) throws IOException {
        byte[] ret = new byte[]{(byte)(i & 0xFFL), (byte)(i >> 8 & 0xFFL), (byte)(i >> 16 & 0xFFL), (byte)(i >> 24 & 0xFFL)};
        this.write(ret);
    }

    public final void writeUInt64(BigInteger bigInteger) throws IOException {
        byte[] bytes = bigInteger.toByteArray();
        byte[] tmp = new byte[1];
        int j = bytes.length - 1;
        for (int i = 0; j > i; --j, ++i) {
            tmp[0] = bytes[j];
            bytes[j] = bytes[i];
            bytes[i] = tmp[0];
        }
        tmp = new byte[8];
        int count = bytes.length;
        count = count > 8 ? 8 : count;
        for (int k = 0; k < count; ++k) {
            tmp[k] = (byte)(bytes[k] & 0xFF);
        }
        this.write(tmp);
    }

    public final void writeUByte(short sh) throws IOException {
        this.writeByte(0xFF & sh);
    }

    public final void writeUTF8Char(char c) throws IOException {
        String value = new String(new char[]{c});
        byte[] bytes = value.getBytes("UTF-8");
        if (this.pos + bytes.length <= 2048) {
            for (int i = 0; i < bytes.length; ++i) {
                this.buf[this.pos + i] = bytes[i];
            }
            this.pos += bytes.length;
        } else {
            this.drain();
            this.writeUTF8Char(c);
        }
    }
}

