/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.core.io.surrogates;

import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheIOException;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheInstantiationException;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogateBase;

public abstract class SerializationSurrogateImpl
extends SerializationSurrogateBase
implements SerializationSurrogate {
    public SerializationSurrogateImpl(Class type) {
        super(type);
    }

    public Object instantiate(NCacheObjectInput input) throws NCacheInstantiationException {
        return super.createInstance();
    }

    public abstract Object readDirect(NCacheObjectInput var1, Object var2) throws NCacheInstantiationException, NCacheIOException;

    public abstract void writeDirect(NCacheObjectOutput var1, Object var2) throws NCacheIOException;

    public abstract void skipDirect(NCacheObjectInput var1, Object var2) throws NCacheInstantiationException, NCacheIOException;

    @Override
    public Object readObject(NCacheObjectInput input) throws NCacheInstantiationException, NCacheIOException {
        try {
            int cookie = input.readInt();
            Object graph = input.getContext().getObject(cookie);
            if (graph == null) {
                boolean bKnown = false;
                graph = this.instantiate(input);
                if (graph != null) {
                    input.getContext().rememberForRead(graph);
                    bKnown = true;
                }
                if (this.isVersionCompatible()) {
                    int dataLength = 0;
                    dataLength = input.readInt();
                    graph = this.readDirect(input, graph);
                } else {
                    graph = this.readDirect(input, graph);
                }
                if (!bKnown) {
                    input.getContext().rememberForRead(graph);
                }
            }
            return graph;
        }
        catch (NCacheInstantiationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void writeObject(NCacheObjectOutput output, Object graph) throws NCacheIOException {
        try {
            Integer cookie = output.getContext().getCookie(graph);
            if (cookie != -1) {
                output.writeInt(cookie);
                return;
            }
            cookie = output.getContext().rememberForWrite(graph);
            output.writeInt(cookie);
            if (this.isVersionCompatible()) {
                long startPosition = 0L;
                long endPosition = 0L;
                output.writeInt(-1);
                this.writeDirect(output, graph);
            } else {
                this.writeDirect(output, graph);
            }
        }
        catch (Exception ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void skipObject(NCacheObjectInput input) throws NCacheInstantiationException, NCacheIOException {
        try {
            int cookie = input.readInt();
            Object graph = input.getContext().getObject(cookie);
            if (graph == null) {
                graph = this.instantiate(input);
                Object object = this.readDirect(input, graph);
            }
        }
        catch (NCacheInstantiationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new NCacheIOException(ex);
        }
    }
}

