/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard;

import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.serialization.core.io.TypeSurrogateSelector;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogate;
import com.alachisoft.ncache.serialization.standard.io.surrogates.UInt16ArraySerializationSurrogate;
import com.alachisoft.ncache.serialization.standard.io.surrogates.UInt16SerializationSurrogate;
import com.alachisoft.ncache.serialization.standard.io.surrogates.UInt32ArraySerializationSurrogate;
import com.alachisoft.ncache.serialization.standard.io.surrogates.UInt32SerializationSurrogate;
import com.alachisoft.ncache.serialization.standard.io.surrogates.UInt64ArraySerializationSurrogate;
import com.alachisoft.ncache.serialization.standard.io.surrogates.UInt64SerializationSurrogate;
import com.alachisoft.ncache.serialization.standard.io.surrogates.UnsignedByteArraySerializationSurrogate;
import com.alachisoft.ncache.serialization.standard.io.surrogates.UnsignedByteSerializationSurrogate;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;

public class GenerateDynamicCode {
    private static String IDENTIFIER = "temp";
    private static HashMap _attributeOrder = new HashMap();
    private static HashMap _nonCompactFieldsMap = new HashMap();
    private static TypeSurrogateSelector _mSurrogateTypeSelector;
    private static String _cacheContext;

    public static void generateCode(Class obj, StringBuffer serializeCode, StringBuffer deserializeCode, HashMap attributeOrder, boolean portable, short subHandle, TypeSurrogateSelector mSurrogateTypeSelector, String cacheContext, HashMap nonCompactFieldsMap) throws Exception {
        _attributeOrder = attributeOrder;
        if (nonCompactFieldsMap != null) {
            _nonCompactFieldsMap.put(obj, nonCompactFieldsMap);
        }
        _mSurrogateTypeSelector = mSurrogateTypeSelector;
        _cacheContext = cacheContext;
        ArrayList<String> classCookie = new ArrayList<String>();
        classCookie.add(obj.getCanonicalName());
        if (!portable) {
            GenerateDynamicCode.generateSerializationAndDeserializationMethods(obj, serializeCode, deserializeCode, IDENTIFIER, null, classCookie, portable);
        } else {
            GenerateDynamicCode.generatePortableSerializationAndDeserializationMethods(obj, serializeCode, deserializeCode, IDENTIFIER, (String[][])_attributeOrder.get(obj.getCanonicalName()), classCookie, portable, subHandle);
        }
        deserializeCode.append("\n\treturn " + IDENTIFIER + ";");
        serializeCode.append("\n\treturn;");
        if (nonCompactFieldsMap != null) {
            _nonCompactFieldsMap.remove(obj);
        }
    }

    private static void generateSerializationAndDeserializationMethods(Class obj, StringBuffer serializeCode, StringBuffer deserializeCode, String identifier, String[][] attribOrder, ArrayList<String> classCookie, boolean portable) throws Exception {
        serializeCode.append("\n\t" + obj.getCanonicalName() + " " + identifier + "=(" + obj.getCanonicalName() + ")graph;");
        deserializeCode.append("\n\t" + obj.getCanonicalName() + " " + identifier + "=new " + obj.getCanonicalName() + "();");
        serializeCode.append("\n\tshort handle;");
        deserializeCode.append("\n\tjava.lang.Object LOCAL_OBJECT;");
        boolean isParent = false;
        Class originalObject = obj;
        do {
            Field[] fields = obj.getDeclaredFields();
            Field[] javaFields = null;
            HashMap<String, String> unsignedTypes = new HashMap<String, String>();
            if (attribOrder != null && portable) {
                javaFields = GenerateDynamicCode.GetAllFields(obj, attribOrder, fields, unsignedTypes);
            } else if (_nonCompactFieldsMap.containsKey(obj)) {
                HashMap nonCompactFields = (HashMap)_nonCompactFieldsMap.get(obj);
                ArrayList<Field> fieldsList = new ArrayList<Field>();
                int index = -1;
                for (Field f : fields) {
                    if (nonCompactFields.containsKey(f.getName().toLowerCase())) continue;
                    fieldsList.add(f);
                }
                Field[] temp = new Field[fieldsList.size()];
                javaFields = fieldsList.toArray(temp);
            } else {
                javaFields = fields;
            }
            for (Field f : javaFields) {
                if (f == null) {
                    serializeCode.append("\n\toutput.writeObject(new com.alachisoft.ncache.serialization.standard.io.surrogates.EOFDotNetSerializationSurrogate());");
                    deserializeCode.append("\n\tObject obj = input.readObject();");
                    deserializeCode.append("\n\tif(obj != null){return temp;}");
                    continue;
                }
                GenerateDynamicCode.GenerateMethods(originalObject, isParent, f, serializeCode, deserializeCode, identifier, unsignedTypes, classCookie, portable);
            }
            obj = obj.getSuperclass();
            isParent = true;
        } while (obj != null);
    }

    private static void generatePortableSerializationAndDeserializationMethods(Class obj, StringBuffer serializeCode, StringBuffer deserializeCode, String IDENTIFIER, String[][] attribOrder, ArrayList<String> classCookie, boolean portable, short subHandle) throws Exception {
        serializeCode.append("\n\t" + obj.getCanonicalName() + " " + IDENTIFIER + "=(" + obj.getCanonicalName() + ")graph;");
        deserializeCode.append("\n\t" + obj.getCanonicalName() + " " + IDENTIFIER + "=new " + obj.getCanonicalName() + "();");
        serializeCode.append("\n\tshort handle;");
        deserializeCode.append("\n\tjava.lang.Object LOCAL_OBJECT;");
        boolean isParent = false;
        Class originalObject = obj;
        do {
            Field[] fields = obj.getDeclaredFields();
            Field[] javaFields = null;
            HashMap<String, String> unsignedTypes = new HashMap<String, String>();
            javaFields = attribOrder != null && portable && !isParent ? GenerateDynamicCode.GetAllFields(obj, attribOrder, fields, unsignedTypes) : fields;
            for (int i = 0; i < javaFields.length; ++i) {
                Field f = javaFields[i];
                boolean toSkip = false;
                if (i < attribOrder[1].length && attribOrder[1][i].equals("0")) {
                    toSkip = true;
                }
                if (f != null || !toSkip) {
                    if (f == null) {
                        serializeCode.append("\n\toutput.writeObject(new com.alachisoft.ncache.serialization.standard.io.surrogates.EOFJavaSerializationSurrogate());");
                        serializeCode.append("\n\toutput.writeShort(" + subHandle + ");");
                        deserializeCode.append("\n\tObject obj = input.readObject();");
                        deserializeCode.append("\n\tShort eof = (Short)obj ;");
                        deserializeCode.append("\n\tif(this.getSubHandle() != eof.shortValue()){return temp;}");
                        continue;
                    }
                    GenerateDynamicCode.GenerateMethods(originalObject, isParent, f, serializeCode, deserializeCode, IDENTIFIER, unsignedTypes, classCookie, portable);
                    continue;
                }
                serializeCode.append("\n\toutput.writeObject(new com.alachisoft.ncache.serialization.standard.io.surrogates.SkipSerializationSurrogate());");
                deserializeCode.append("\n\tinput.skipObject();");
            }
            obj = obj.getSuperclass();
            isParent = true;
        } while (obj != null);
    }

    private static Field[] GetAllFields(Class obj, String[][] attribOrder, Field[] fields, HashMap<String, String> unsignedTypes) throws Exception {
        if (attribOrder.length != 0) {
            Field[] tempField = new Field[attribOrder[0].length + 1];
            boolean EOF = true;
            for (int i = 0; !(i >= attribOrder[0].length + 1 || i == attribOrder[0].length && EOF); ++i) {
                int number = i;
                if (!EOF) {
                    number = i - 1;
                }
                if (attribOrder[0][number] != "skip.attribute") {
                    if (attribOrder[1][number].equals("-1") && EOF) {
                        tempField[i] = null;
                        EOF = false;
                        continue;
                    }
                    for (int j = 0; j < fields.length; ++j) {
                        if (attribOrder[0][number].contains("unsigned16.") || attribOrder[0][number].contains("unsigned32.") || attribOrder[0][number].contains("unsigned64.") || attribOrder[0][number].contains("unsigned16[].") || attribOrder[0][number].contains("unsigned32[].") || attribOrder[0][number].contains("unsigned64[].") || attribOrder[0][number].contains("unsignedbyte.") || attribOrder[0][number].contains("unsignedbyte[].")) {
                            String[] split = attribOrder[0][number].split("\\.");
                            unsignedTypes.put(split[1], split[0]);
                            attribOrder[0][number] = split[1];
                        }
                        if (!attribOrder[0][number].equals(fields[j].getName().toString())) continue;
                        tempField[i] = fields[j];
                    }
                    if (tempField[i] != null) continue;
                    throw new Exception("Unable to intialize Compact Serialization: Assembly mismatch, The Assembly provided to NCManager is different to the one used locally: Unable to find Field " + attribOrder[0][number] + " in " + obj.getCanonicalName());
                }
                tempField[i] = null;
            }
            return tempField;
        }
        return fields;
    }

    private static void deserializePortableCode(Class obj, boolean isParent, StringBuffer deserializeCode, Field f, String IDENTIFIER) throws OperationFailedException {
        deserializeCode.append("\n\tLOCAL_OBJECT = input.readObject();");
        deserializeCode.append("\n\tif(LOCAL_OBJECT instanceof com.alachisoft.ncache.serialization.standard.io.surrogates.SkipSerializationSurrogate)");
        deserializeCode.append("\n\t{");
        deserializeCode.append("\n\t}");
        deserializeCode.append("\n\telse");
        deserializeCode.append("\n\t{");
        String canonicalName = GenerateDynamicCode.getCanonicalName(f.getType().getCanonicalName());
        String assignmentString = GenerateDynamicCode.getAssignmentString(f.getType().getCanonicalName());
        deserializeCode.append("\n\t\t" + canonicalName + " tempVariable = (" + canonicalName + ")LOCAL_OBJECT;");
        if (Modifier.isPublic(f.getModifiers())) {
            deserializeCode.append("\n\t\t" + IDENTIFIER + "." + f.getName() + " = " + assignmentString + ";");
        } else {
            Method setterMethod;
            StringBuilder sb = new StringBuilder(f.getName());
            char captial = Character.toUpperCase(f.getName().charAt(0));
            sb.setCharAt(0, captial);
            String fieldName = sb.toString();
            String setter = "set" + fieldName;
            Object setterName = "";
            try {
                setterMethod = obj.getMethod(setter, f.getType());
                setterName = setter;
            }
            catch (NoSuchMethodException e) {
                if (!isParent) {
                    throw new OperationFailedException("Corresponding setter \"" + setter + "(" + f.getType().getName() + ")\" for field \"" + f.getName() + "\" is not declared in class \"" + obj.getName() + "\" or any of its parent class.");
                }
                return;
            }
            if (!Modifier.isPublic(setterMethod.getModifiers())) {
                if (!isParent) {
                    throw new OperationFailedException("Corresponding setter \"" + setter + "(" + f.getType().getName() + ")\" for field \"" + f.getName() + "\" is not public in class \"" + obj.getName() + "\"");
                }
                return;
            }
            deserializeCode.append("\n\t\t" + IDENTIFIER + "." + (String)setterName + " ( " + assignmentString + ");");
        }
        deserializeCode.append("\n\t}");
    }

    private static String getCanonicalName(String canonicalName) {
        if (canonicalName.equals("int")) {
            return "java.lang.Integer";
        }
        if (canonicalName.equals("short")) {
            return "java.lang.Short";
        }
        if (canonicalName.equals("long")) {
            return "java.lang.Long";
        }
        if (canonicalName.equals("char")) {
            return "java.lang.Character";
        }
        if (canonicalName.equals("double")) {
            return "java.lang.Double";
        }
        if (canonicalName.equals("byte")) {
            return "java.lang.Byte";
        }
        if (canonicalName.equals("float")) {
            return "java.lang.Float";
        }
        if (canonicalName.equals("boolean")) {
            return "java.lang.Boolean";
        }
        return canonicalName;
    }

    private static void writeClassHandle(StringBuffer serializeCode, short classHandle) {
        serializeCode.append("\n\thandle = " + classHandle + ";");
        serializeCode.append("\n\toutput.writeShort(handle);");
    }

    private static String getAssignmentString(String canonicalName) {
        if (canonicalName.equals("int")) {
            return "tempVariable.intValue()";
        }
        if (canonicalName.equals("short")) {
            return "tempVariable.shortValue()";
        }
        if (canonicalName.equals("long")) {
            return "tempVariable.longValue()";
        }
        if (canonicalName.equals("char")) {
            return "tempVariable.charValue()";
        }
        if (canonicalName.equals("double")) {
            return "tempVariable.doubleValue()";
        }
        if (canonicalName.equals("byte")) {
            return "tempVariable.byteValue()";
        }
        if (canonicalName.equals("float")) {
            return "tempVariable.floatValue()";
        }
        if (canonicalName.equals("boolean")) {
            return "tempVariable.booleanValue()";
        }
        return "tempVariable";
    }

    private static void GenerateMethods(Class obj, boolean isParent, Field f, StringBuffer serializeCode, StringBuffer deserializeCode, String identifier, HashMap<String, String> unsignedTypes, ArrayList<String> classCookie, boolean portable) throws Exception {
        if (Modifier.isPublic(f.getModifiers())) {
            if (f.getType().isPrimitive()) {
                if (f.getType().getName().toLowerCase().equals("int")) {
                    if (unsignedTypes.containsKey(f.getName())) {
                        SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(UInt16SerializationSurrogate.class, _cacheContext);
                        GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                        serializeCode.append("\n\toutput.writeUInt16(" + IDENTIFIER + "." + f.getName() + ");");
                        GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                    } else {
                        SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(Integer.class, _cacheContext);
                        GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                        serializeCode.append("\n\toutput.writeInt(" + IDENTIFIER + "." + f.getName() + ");");
                        GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                    }
                } else if (f.getType().getName().toLowerCase().equals("long")) {
                    if (unsignedTypes.containsKey(f.getName())) {
                        SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(UInt32SerializationSurrogate.class, _cacheContext);
                        GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                        serializeCode.append("\n\toutput.writeUInt32(" + IDENTIFIER + "." + f.getName() + ");");
                        GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                    } else {
                        SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(Long.class, _cacheContext);
                        GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                        serializeCode.append("\n\toutput.writeLong(" + IDENTIFIER + "." + f.getName() + ");");
                        GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                    }
                } else if (f.getType().getName().toLowerCase().equals("double")) {
                    SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(Double.class, _cacheContext);
                    GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                    serializeCode.append("\n\toutput.writeDouble(" + IDENTIFIER + "." + f.getName() + ");");
                    GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                } else if (f.getType().getName().toLowerCase().equals("short")) {
                    if (unsignedTypes.containsKey(f.getName())) {
                        SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(UnsignedByteSerializationSurrogate.class, _cacheContext);
                        GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                        serializeCode.append("\n\toutput.writeUByte(" + IDENTIFIER + "." + f.getName() + ");");
                        GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                    } else {
                        SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(Short.class, _cacheContext);
                        GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                        serializeCode.append("\n\toutput.writeShort(" + IDENTIFIER + "." + f.getName() + ");");
                        GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                    }
                } else if (f.getType().getName().toLowerCase().equals("float")) {
                    SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(Float.class, _cacheContext);
                    GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                    serializeCode.append("\n\toutput.writeFloat(" + IDENTIFIER + "." + f.getName() + ");");
                    GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                } else if (f.getType().getName().toLowerCase().equals("char")) {
                    SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(Character.class, _cacheContext);
                    GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                    serializeCode.append("\n\toutput.writeChar(" + IDENTIFIER + "." + f.getName() + ");");
                    GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                } else if (f.getType().getName().toLowerCase().equals("byte")) {
                    SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(Byte.class, _cacheContext);
                    GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                    serializeCode.append("\n\toutput.writeByte(" + IDENTIFIER + "." + f.getName() + ");");
                    GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                } else if (f.getType().getName().toLowerCase().equals("boolean")) {
                    SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(Boolean.class, _cacheContext);
                    GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                    serializeCode.append("\n\toutput.writeBoolean(" + IDENTIFIER + "." + f.getName() + ");");
                    GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                }
            } else if (!(f.getType().isEnum() || f.getType().isMemberClass() || f.getType().isLocalClass())) {
                if (f.getType().getCanonicalName().equals("double[]") || f.getType().getCanonicalName().equals("float[]")) {
                    serializeCode.append("\n\t" + f.getType().getCanonicalName() + " " + f.getName() + " = " + IDENTIFIER + "." + f.getName() + ";");
                    serializeCode.append("\n\toutput.writeObject(" + f.getName() + ");");
                } else if (f.getType().getCanonicalName().equals("short[]")) {
                    if (unsignedTypes.containsKey(f.getName())) {
                        serializeCode.append("\n\tif(" + IDENTIFIER + "." + f.getName() + " == null)\n\t{");
                        serializeCode.append("\n\t\toutput.writeObject(" + IDENTIFIER + "." + f.getName() + "); \n\t}");
                        serializeCode.append("\n\telse\n\t{");
                        SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(UnsignedByteArraySerializationSurrogate.class, _cacheContext);
                        GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                        serializeCode.append("\n\t\toutput.writeObject(" + IDENTIFIER + "." + f.getName() + ", com.alachisoft.ncache.serialization.standard.io.surrogates.UnsignedByteArraySerializationSurrogate.class);");
                        serializeCode.append("\n\t}");
                    } else {
                        serializeCode.append("\n\toutput.writeObject(" + IDENTIFIER + "." + f.getName() + ");");
                    }
                } else if (f.getType().getCanonicalName().equals("int[]")) {
                    if (unsignedTypes.containsKey(f.getName())) {
                        serializeCode.append("\n\tif(" + IDENTIFIER + "." + f.getName() + " == null)\n\t{");
                        serializeCode.append("\n\t\toutput.writeObject(" + IDENTIFIER + "." + f.getName() + "); \n\t}");
                        serializeCode.append("\n\telse\n\t{");
                        SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(UInt16ArraySerializationSurrogate.class, _cacheContext);
                        GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                        serializeCode.append("\n\t\toutput.writeObject(" + IDENTIFIER + "." + f.getName() + ", com.alachisoft.ncache.serialization.standard.io.surrogates.UInt16ArraySerializationSurrogate.class);");
                        serializeCode.append("\n\t}");
                    } else {
                        serializeCode.append("\n\toutput.writeObject(" + IDENTIFIER + "." + f.getName() + ");");
                    }
                } else if (f.getType().getCanonicalName().equals("long[]")) {
                    serializeCode.append("\n\t" + f.getType().getCanonicalName() + " " + f.getName() + " = " + IDENTIFIER + "." + f.getName() + ";");
                    if (unsignedTypes.containsKey(f.getName())) {
                        serializeCode.append("\n\tif(" + IDENTIFIER + "." + f.getName() + " == null)\n\t{");
                        serializeCode.append("\n\t\toutput.writeObject(" + f.getName() + ");\n\t}");
                        serializeCode.append("\n\telse\n\t{");
                        SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(UInt32ArraySerializationSurrogate.class, _cacheContext);
                        GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                        serializeCode.append("\n\t\toutput.writeObject(" + f.getName() + ", com.alachisoft.ncache.serialization.standard.io.surrogates.UInt32ArraySerializationSurrogate.class);");
                        serializeCode.append("\n\t}");
                    } else {
                        serializeCode.append("\n\toutput.writeObject(" + f.getName() + ");");
                    }
                } else if (f.getType().getCanonicalName().equals("java.math.BigInteger[]")) {
                    if (unsignedTypes.containsKey(f.getName())) {
                        serializeCode.append("\n\tif(" + IDENTIFIER + "." + f.getName() + " == null)\n\t{");
                        serializeCode.append("\n\t\toutput.writeObject(" + IDENTIFIER + "." + f.getName() + "); \n\t}");
                        serializeCode.append("\n\telse\n\t{");
                        SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(UInt64ArraySerializationSurrogate.class, _cacheContext);
                        GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                        serializeCode.append("\n\t\toutput.writeObject(" + IDENTIFIER + "." + f.getName() + ", com.alachisoft.ncache.serialization.standard.io.surrogates.UInt64ArraySerializationSurrogate.class);");
                        serializeCode.append("\n\t}");
                    } else {
                        serializeCode.append("\n\toutput.writeObject(" + IDENTIFIER + "." + f.getName() + ");");
                    }
                } else if (f.getType().getName().equals("java.math.BigInteger") && unsignedTypes.containsKey(f.getName())) {
                    SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(UInt64SerializationSurrogate.class, _cacheContext);
                    GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                    serializeCode.append("\n\toutput.writeUInt64(" + IDENTIFIER + "." + f.getName() + ");");
                } else {
                    serializeCode.append("\n\toutput.writeObject(" + IDENTIFIER + "." + f.getName() + ");");
                }
                if (f.getType().getName().equals("java.math.BigInteger")) {
                    if (unsignedTypes.containsKey(f.getName())) {
                        GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                    } else {
                        GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                    }
                } else {
                    GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                }
            } else if (!classCookie.contains(f.getClass().getCanonicalName())) {
                classCookie.add(f.getClass().getCanonicalName());
                GenerateDynamicCode.generateSerializationAndDeserializationMethods(f.getType(), serializeCode, deserializeCode, IDENTIFIER + "." + f.getName() + ".", null, classCookie, portable);
            }
        } else {
            Method getterMethod;
            StringBuilder sb = new StringBuilder(f.getName());
            char captial = Character.toUpperCase(f.getName().charAt(0));
            sb.setCharAt(0, captial);
            String fieldName = sb.toString();
            String getter = "get" + fieldName;
            Object getterName = "";
            try {
                getterMethod = obj.getMethod(getter, new Class[0]);
                getterName = getter + "()";
            }
            catch (NoSuchMethodException e) {
                if (!isParent) {
                    throw new OperationFailedException("Corresponding Getter \"" + f.getType().getName() + " " + getter + "()\" for field \"" + f.getName() + "\" is not declared in class \"" + obj.getName() + "\" or any of its parent class.");
                }
                return;
            }
            if (!Modifier.isPublic(getterMethod.getModifiers())) {
                if (!isParent) {
                    throw new OperationFailedException("Corresponding Getter \"" + f.getType().getName() + " " + getter + "()\" for field \"" + f.getName() + "\" is not public in class \"" + obj.getName() + "\"");
                }
                return;
            }
            if (f.getType().isPrimitive()) {
                if (f.getType().getName().toLowerCase().equals("int")) {
                    if (unsignedTypes.containsKey(f.getName())) {
                        SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(UInt16SerializationSurrogate.class, _cacheContext);
                        GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                        serializeCode.append("\n\toutput.writeUInt16(" + IDENTIFIER + "." + (String)getterName + ");");
                        GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                    } else {
                        SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(Integer.class, _cacheContext);
                        GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                        serializeCode.append("\n\toutput.writeInt(" + IDENTIFIER + "." + (String)getterName + ");");
                        GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                    }
                } else if (f.getType().getName().toLowerCase().equals("long")) {
                    if (unsignedTypes.containsKey(f.getName())) {
                        SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(UInt32SerializationSurrogate.class, _cacheContext);
                        GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                        serializeCode.append("\n\toutput.writeUInt32(" + IDENTIFIER + "." + (String)getterName + ");");
                        GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                    } else {
                        SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(Long.class, _cacheContext);
                        GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                        serializeCode.append("\n\toutput.writeLong(" + IDENTIFIER + "." + (String)getterName + ");");
                        GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                    }
                } else if (f.getType().getName().toLowerCase().equals("double")) {
                    SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(Double.class, _cacheContext);
                    GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                    serializeCode.append("\n\toutput.writeDouble(" + IDENTIFIER + "." + (String)getterName + ");");
                    GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                } else if (f.getType().getName().toLowerCase().equals("short")) {
                    if (unsignedTypes.containsKey(f.getName())) {
                        SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(UnsignedByteSerializationSurrogate.class, _cacheContext);
                        GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                        serializeCode.append("\n\toutput.writeUByte(" + IDENTIFIER + "." + (String)getterName + ");");
                        GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                    } else {
                        SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(Short.class, _cacheContext);
                        GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                        serializeCode.append("\n\toutput.writeShort(" + IDENTIFIER + "." + (String)getterName + ");");
                        GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                    }
                } else if (f.getType().getName().toLowerCase().equals("float")) {
                    SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(Float.class, _cacheContext);
                    GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                    serializeCode.append("\n\toutput.writeFloat(" + IDENTIFIER + "." + (String)getterName + ");");
                    GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                } else if (f.getType().getName().toLowerCase().equals("char")) {
                    SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(Character.class, _cacheContext);
                    GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                    serializeCode.append("\n\toutput.writeChar(" + IDENTIFIER + "." + (String)getterName + ");");
                    GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                } else if (f.getType().getName().toLowerCase().equals("byte")) {
                    SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(Byte.class, _cacheContext);
                    GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                    serializeCode.append("\n\toutput.writeByte(" + IDENTIFIER + "." + (String)getterName + ");");
                    GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                } else if (f.getType().getName().toLowerCase().equals("boolean")) {
                    SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(Boolean.class, _cacheContext);
                    GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                    serializeCode.append("\n\toutput.writeBoolean(" + IDENTIFIER + "." + (String)getterName + ");");
                    GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                }
            } else if (!(f.getType().isEnum() || f.getType().isMemberClass() || f.getType().isLocalClass())) {
                if (f.getType().getCanonicalName().equals("double[]") || f.getType().getCanonicalName().equals("float[]")) {
                    serializeCode.append("\n\t" + f.getType().getCanonicalName() + " " + f.getName() + " = " + IDENTIFIER + "." + (String)getterName + ";");
                    serializeCode.append("\n\toutput.writeObject(" + f.getName() + ");");
                } else if (f.getType().getCanonicalName().equals("short[]")) {
                    if (unsignedTypes.containsKey(f.getName())) {
                        serializeCode.append("\n\tif(" + IDENTIFIER + "." + (String)getterName + " == null)\n\t{");
                        serializeCode.append("\n\t\toutput.writeObject(" + IDENTIFIER + "." + (String)getterName + "); \n\t}");
                        serializeCode.append("\n\telse\n\t{");
                        SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(UnsignedByteArraySerializationSurrogate.class, _cacheContext);
                        GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                        serializeCode.append("\n\t\toutput.writeObject(" + IDENTIFIER + "." + (String)getterName + ", com.alachisoft.ncache.serialization.standard.io.surrogates.UnsignedByteArraySerializationSurrogate.class);");
                        serializeCode.append("\n\t}");
                    } else {
                        serializeCode.append("\n\toutput.writeObject(" + IDENTIFIER + "." + (String)getterName + ");");
                    }
                } else if (f.getType().getCanonicalName().equals("int[]")) {
                    if (unsignedTypes.containsKey(f.getName())) {
                        serializeCode.append("\n\tif(" + IDENTIFIER + "." + (String)getterName + " == null)\n\t{");
                        serializeCode.append("\n\t\toutput.writeObject(" + IDENTIFIER + "." + (String)getterName + "); \n\t}");
                        serializeCode.append("\n\telse\n\t{");
                        SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(UInt16ArraySerializationSurrogate.class, _cacheContext);
                        GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                        serializeCode.append("\n\t\toutput.writeObject(" + IDENTIFIER + "." + (String)getterName + ", com.alachisoft.ncache.serialization.standard.io.surrogates.UInt16ArraySerializationSurrogate.class);");
                        serializeCode.append("\n\t}");
                    } else {
                        serializeCode.append("\n\toutput.writeObject(" + IDENTIFIER + "." + (String)getterName + ");");
                    }
                } else if (f.getType().getCanonicalName().equals("long[]")) {
                    serializeCode.append("\n\t" + f.getType().getCanonicalName() + " " + f.getName() + " = " + IDENTIFIER + "." + (String)getterName + ";");
                    if (unsignedTypes.containsKey(f.getName())) {
                        serializeCode.append("\n\tif(" + IDENTIFIER + "." + (String)getterName + " == null)\n\t{");
                        serializeCode.append("\n\t\toutput.writeObject(" + (String)getterName + ");\n\t}");
                        serializeCode.append("\n\telse\n\t{");
                        SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(UInt32ArraySerializationSurrogate.class, _cacheContext);
                        GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                        serializeCode.append("\n\t\toutput.writeObject(" + (String)getterName + ", com.alachisoft.ncache.serialization.standard.io.surrogates.UInt32ArraySerializationSurrogate.class);");
                        serializeCode.append("\n\t}");
                    } else {
                        serializeCode.append("\n\toutput.writeObject(" + (String)getterName + ");");
                    }
                } else if (f.getType().getCanonicalName().equals("java.math.BigInteger[]")) {
                    if (unsignedTypes.containsKey(f.getName())) {
                        serializeCode.append("\n\tif(" + IDENTIFIER + "." + (String)getterName + " == null)\n\t{");
                        serializeCode.append("\n\t\toutput.writeObject(" + IDENTIFIER + "." + (String)getterName + "); \n\t}");
                        serializeCode.append("\n\telse\n\t{");
                        SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(UInt64ArraySerializationSurrogate.class, _cacheContext);
                        GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                        serializeCode.append("\n\t\toutput.writeObject(" + IDENTIFIER + "." + (String)getterName + ", com.alachisoft.ncache.serialization.standard.io.surrogates.UInt64ArraySerializationSurrogate.class);");
                        serializeCode.append("\n\t}");
                    } else {
                        serializeCode.append("\n\toutput.writeObject(" + IDENTIFIER + "." + (String)getterName + ");");
                    }
                } else if (f.getType().getName().equals("java.math.BigInteger") && unsignedTypes.containsKey(f.getName())) {
                    SerializationSurrogate surr = _mSurrogateTypeSelector.getSurrogateForType(UInt64SerializationSurrogate.class, _cacheContext);
                    GenerateDynamicCode.writeClassHandle(serializeCode, surr.getClassHandle());
                    serializeCode.append("\n\toutput.writeUInt64(" + IDENTIFIER + "." + (String)getterName + ");");
                } else {
                    serializeCode.append("\n\toutput.writeObject(" + IDENTIFIER + "." + (String)getterName + ");");
                }
                if (f.getType().getName().equals("java.math.BigInteger")) {
                    if (unsignedTypes.containsKey(f.getName())) {
                        GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                    } else {
                        GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                    }
                } else {
                    GenerateDynamicCode.deserializePortableCode(obj, isParent, deserializeCode, f, IDENTIFIER);
                }
            } else if (!classCookie.contains(f.getClass().getCanonicalName())) {
                classCookie.add(f.getClass().getCanonicalName());
                GenerateDynamicCode.generateSerializationAndDeserializationMethods(f.getType(), serializeCode, deserializeCode, IDENTIFIER + "." + f.getName() + ".", null, classCookie, portable);
            }
        }
    }

    static enum Types {
        INT(0),
        SHORT(1),
        LONG(2),
        DOUBLE(3),
        FLOAT(4),
        BOOLEAN(5),
        CHAR(6),
        CHARS(7),
        BYTE(8),
        BYTES(9),
        UTF(10);


        private Types(int v) {
        }
    }
}

