/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard.io;

import com.alachisoft.ncache.serialization.core.io.BlockDataOutputStream;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.core.io.SerializationContext;
import com.alachisoft.ncache.serialization.core.io.TypeSurrogateSelector;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheIOException;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogate;
import com.alachisoft.ncache.serialization.standard.io.TypeSurrogateSelectorImpl;
import com.alachisoft.ncache.serialization.standard.io.surrogates.ObjectSerializationSurrogate;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class ObjectOutputStream
extends OutputStream
implements NCacheObjectOutput {
    private BlockDataOutputStream mOutput;
    private SerializationContext mContext;
    private TypeSurrogateSelector mSelector;
    private String _cacheContext;

    public ObjectOutputStream(OutputStream out, String cacheContext) throws IOException {
        this.mOutput = new BlockDataOutputStream(out);
        this.mSelector = TypeSurrogateSelectorImpl.getDefault();
        this.mContext = new SerializationContext(this.mSelector);
        this.mContext.putUserItem("__bout", this.mOutput);
        this._cacheContext = cacheContext;
    }

    public ObjectOutputStream(OutputStream out, TypeSurrogateSelector selector) throws IOException {
        this.mOutput = new BlockDataOutputStream(out);
        this.mContext = new SerializationContext(selector);
        this.mSelector = this.mContext.getSurrogateSelector();
        this.mContext.putUserItem("__bout", this.mOutput);
    }

    @Override
    public SerializationContext getContext() {
        return this.mContext;
    }

    @Override
    public OutputStream getBaseStream() {
        return this.mOutput;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.mOutput.write(b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.mOutput.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.mOutput.flush();
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.mOutput.writeBoolean(v);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.mOutput.writeByte(v);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.mOutput.writeShort(v);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.mOutput.writeUTF8Char((char)v);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.mOutput.writeInt(v);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.mOutput.writeLong(v);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.mOutput.writeFloat(v);
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.mOutput.writeDouble(v);
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        this.mOutput.writeBytes(s);
    }

    @Override
    public final void writeChars(String s) throws IOException {
        this.mOutput.writeChars(s);
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        this.mOutput.writeUTF(str);
    }

    @Override
    public final void writeUInt16(int i) throws IOException {
        if (i > 65535) {
            throw new IOException("Unable to serialize: Provided integer value [" + Integer.toString(i) + "] is greater than 65,535 and is out of Range of 'UInt16'");
        }
        if (i < 0) {
            throw new IOException("Unable to serialize: Provided integer value [" + Integer.toString(i) + "] is less than '0' and is out of Range of 'UInt16'");
        }
        this.mOutput.writeUInt16(i);
    }

    @Override
    public final void writeUInt32(long i) throws IOException {
        if (i > 0xFFFFFFFFL) {
            throw new IOException("Unable to serialize: Provided long value [" + Long.toString(i) + "] is greater than 4,29,49,67,295 and is out of Range of 'UInt32'");
        }
        if (i < 0L) {
            throw new IOException("Unable to serialize: Provided long value [" + Long.toString(i) + "] is less than '0' and is out of Range of 'UInt32'");
        }
        this.mOutput.writeUInt32(i);
    }

    @Override
    public final void writeUInt64(BigInteger bigInteger) throws IOException {
        if (bigInteger == null) {
            throw new IOException("Unable to serialize: Provided BigInteger value is null which is incompatible with  'UInt64'");
        }
        if (bigInteger.compareTo(new BigInteger("18446744073709551615")) == 1) {
            throw new IOException("Unable to serialize: Provided BigInteger value [" + bigInteger.toString() + "] is greater than 18,446,744,073,709,551,615 and is out of Range of 'UInt64'");
        }
        if (bigInteger.compareTo(new BigInteger("0")) == -1) {
            throw new IOException("Unable to serialize: Provided BigInteger value [" + bigInteger.toString() + "] is less than 0 and is out of Range of 'UInt64'");
        }
        this.mOutput.writeUInt64(bigInteger);
    }

    public final int size() {
        return this.mOutput.size();
    }

    @Override
    public final void writeObject(Object obj) throws IOException {
        try {
            SerializationSurrogate surrogate = this.mSelector.getSurrogateForObject(obj, this._cacheContext);
            if (surrogate instanceof ObjectSerializationSurrogate) {
                SerializationSurrogate testSurrogate = null;
                testSurrogate = this.getType(surrogate, obj.getClass());
                if (testSurrogate != null) {
                    surrogate = testSurrogate;
                }
            }
            surrogate.writeHandle(this, obj);
            if (surrogate.getSubHandle() > 0) {
                surrogate.writeSubHandle(this, obj);
            }
            surrogate.writeObject(this, obj);
        }
        catch (NCacheIOException nCacheIOException) {
            this.writeObject(obj);
            throw new IOException(nCacheIOException.toString() + " is not marked as serializable.");
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    SerializationSurrogate getType(SerializationSurrogate surrogate, Class type) {
        Class<?>[] typeClasses = type.getInterfaces();
        for (int i = 0; i < typeClasses.length; ++i) {
            Class<?> class1 = typeClasses[i];
            surrogate = this.mSelector.getSurrogateForType(class1, true, this._cacheContext);
            if (surrogate != null) {
                return surrogate;
            }
            if ((surrogate = this.getType(surrogate, class1)) == null) continue;
            return surrogate;
        }
        return null;
    }

    @Override
    public void writeObject(Object obj, Class objClass) throws IOException {
        if (obj == null) {
            throw new NullPointerException("obj");
        }
        if (objClass == null) {
            throw new NullPointerException("objClass");
        }
        try {
            SerializationSurrogate surrogate = this.mSelector.getSurrogateForType(objClass, this._cacheContext);
            surrogate.writeObject(this, obj);
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    @Override
    public void writeObject(Object obj, Object objClass) throws IOException {
        this.writeObject(obj, objClass.getClass());
    }

    public void write(boolean v, String type) throws IOException {
        this.writeBoolean(v);
    }

    public void write(int v, String type) throws IOException {
        this.writeInt(v);
    }

    public void write(String v, String type) throws IOException {
        this.writeUTF(v);
    }

    @Override
    public String getCacheContext() {
        return this._cacheContext;
    }

    @Override
    public void writeUByte(short sh) throws IOException {
        if (sh > 255) {
            throw new IOException("Unable to serialize: Provided short value [" + Short.toString(sh) + "] is greater than 255 and is out of Range of 'UnsignedByte'");
        }
        if (sh < 0) {
            throw new IOException("Unable to serialize: Provided integer value [" + Short.toString(sh) + "] is less than '0' and is out of Range of 'UnsignedByte'");
        }
        this.mOutput.writeUByte(sh);
    }
}

