/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard.io.surrogates;

import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.core.io.surrogates.BuiltinSerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheIOException;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheInstantiationException;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogateBase;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class DateSerializationSurrogate
extends SerializationSurrogateBase
implements SerializationSurrogate,
BuiltinSerializationSurrogate {
    protected long DIFF = 621355968000000000L;

    public DateSerializationSurrogate() {
        super(Date.class);
    }

    @Override
    public Object readObject(NCacheObjectInput input) throws NCacheInstantiationException, NCacheIOException {
        try {
            return new NCDateTime(input.readLong()).getDate();
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void writeObject(NCacheObjectOutput output, Object graph) throws NCacheIOException {
        try {
            Calendar c = Calendar.getInstance();
            c.clear();
            c.set(14, 0);
            c.setTime((Date)graph);
            NCDateTime ncdt = new NCDateTime(c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14));
            output.writeLong(ncdt.getTicks());
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
        catch (IllegalArgumentException arg) {
            throw new NCacheIOException(arg);
        }
    }

    @Override
    public void skipObject(NCacheObjectInput input) throws NCacheInstantiationException, NCacheIOException {
        try {
            input.skipLong();
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }
}

