/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard.io.surrogates;

import com.alachisoft.ncache.serialization.core.io.BlockDataInputStream;
import com.alachisoft.ncache.serialization.core.io.BlockDataOutputStream;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.core.io.surrogates.BuiltinSerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheIOException;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheInstantiationException;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogateImpl;
import java.io.IOException;

public class FloatArraySerializationSurrogate
extends SerializationSurrogateImpl
implements BuiltinSerializationSurrogate {
    public FloatArraySerializationSurrogate() {
        super(float[].class);
    }

    @Override
    public Object instantiate(NCacheObjectInput input) throws NCacheInstantiationException {
        try {
            int length = input.readInt();
            return new float[length];
        }
        catch (IOException ex) {
            throw new NCacheInstantiationException(ex);
        }
    }

    @Override
    public Object readDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        float[] array = (float[])graph;
        int len = array.length;
        BlockDataInputStream bin = (BlockDataInputStream)input.getContext().getUserItem("__bin");
        try {
            if (bin != null) {
                bin.readFloats(array, 0, len);
            } else {
                for (int i = 0; i < len; ++i) {
                    array[i] = input.readFloat();
                }
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
        return array;
    }

    @Override
    public void writeDirect(NCacheObjectOutput output, Object graph) throws NCacheIOException {
        float[] array = (float[])graph;
        int len = array.length;
        BlockDataOutputStream bout = (BlockDataOutputStream)output.getContext().getUserItem("__bout");
        try {
            if (bout != null) {
                bout.writeInt(len);
                bout.writeFloats(array, 0, len);
            } else {
                output.writeInt(len);
                for (int i = 0; i < len; ++i) {
                    output.writeFloat(array[i]);
                }
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void skipDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        float[] array = (float[])graph;
        int len = array.length;
        try {
            for (int i = 0; i < len; ++i) {
                input.skipFloat();
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }
}

