/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard.io.surrogates;

import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.core.io.surrogates.BuiltinSerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheIOException;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheInstantiationException;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogateImpl;
import java.io.IOException;
import java.lang.reflect.Array;

public class GenericArraySerializationSurrogate<T>
extends SerializationSurrogateImpl
implements BuiltinSerializationSurrogate {
    private Class mItemType = this.getRealClass().getComponentType();

    public GenericArraySerializationSurrogate(Class<T[]> type) {
        super(type);
    }

    @Override
    public Object instantiate(NCacheObjectInput input) throws NCacheInstantiationException {
        try {
            int length = input.readInt();
            return Array.newInstance(this.mItemType, length);
        }
        catch (IOException ex) {
            throw new NCacheInstantiationException(ex);
        }
    }

    @Override
    public Object readDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        try {
            Object[] array = (Object[])graph;
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                array[i] = input.readObject();
            }
            return array;
        }
        catch (ClassNotFoundException ex) {
            throw new NCacheIOException(ex);
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void writeDirect(NCacheObjectOutput output, Object graph) throws NCacheIOException {
        try {
            Object[] array = (Object[])graph;
            int len = array.length;
            output.writeInt(len);
            for (int i = 0; i < len; ++i) {
                output.writeObject(array[i]);
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void skipDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        try {
            Object[] array = (Object[])graph;
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                input.skipObject();
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }
}

