/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard.io.surrogates;

import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.core.io.surrogates.BuiltinSerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheIOException;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheInstantiationException;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogateImpl;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public abstract class MapSerializationSurrogate<K, V>
extends SerializationSurrogateImpl
implements BuiltinSerializationSurrogate {
    public MapSerializationSurrogate(Class<? extends Map<K, V>> cls) {
        super(cls);
    }

    @Override
    public Object readDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        Map map = (Map)graph;
        try {
            int len = input.readInt();
            for (int i = 0; i < len; ++i) {
                Object key = input.readObject();
                Object value = input.readObject();
                map.put(key, value);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new NCacheIOException(ex);
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
        return graph;
    }

    @Override
    public void writeDirect(NCacheObjectOutput output, Object graph) throws NCacheIOException {
        Map map = (Map)graph;
        Set entries = map.entrySet();
        int len = map.size();
        try {
            output.writeInt(len);
            if (len > 0) {
                Object[] obj = entries.toArray();
                for (int i = 0; i < len; ++i) {
                    Map.Entry entry = (Map.Entry)obj[i];
                    output.writeObject(entry.getKey());
                    output.writeObject(entry.getValue());
                }
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void skipDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        try {
            int len = input.readInt();
            for (int i = 0; i < len; ++i) {
                input.skipObject();
                input.skipObject();
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }
}

