/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard.io.surrogates;

import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.core.io.surrogates.BuiltinSerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheIOException;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheInstantiationException;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogateBase;
import java.io.IOException;

public class StackTraceElementSerializationSurrogate
extends SerializationSurrogateBase
implements SerializationSurrogate,
BuiltinSerializationSurrogate {
    public StackTraceElementSerializationSurrogate() {
        super(StackTraceElement.class);
    }

    @Override
    public Object readObject(NCacheObjectInput input) throws NCacheInstantiationException, NCacheIOException {
        try {
            String className = input.readUTF();
            String mtdName = input.readUTF();
            String fileName = input.readUTF();
            int lineNum = input.readInt();
            return new StackTraceElement(className, mtdName, fileName, lineNum);
        }
        catch (IOException ex) {
            throw new NCacheInstantiationException(ex);
        }
    }

    @Override
    public void writeObject(NCacheObjectOutput output, Object graph) throws NCacheIOException {
        StackTraceElement elem = (StackTraceElement)graph;
        try {
            output.writeUTF(elem.getClassName());
            output.writeUTF(elem.getMethodName());
            output.writeUTF(elem.getFileName());
            output.writeInt(elem.getLineNumber());
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void skipObject(NCacheObjectInput input) throws NCacheInstantiationException, NCacheIOException {
        try {
            input.skipUTF();
            input.skipUTF();
            input.skipUTF();
            input.skipInt();
        }
        catch (IOException ex) {
            throw new NCacheInstantiationException(ex);
        }
    }
}

