/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard.io.surrogates;

import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.core.io.surrogates.BuiltinSerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheIOException;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheInstantiationException;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogateImpl;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ThrowableSerializationSurrogate
extends SerializationSurrogateImpl
implements BuiltinSerializationSurrogate {
    private Constructor mConstructor;

    public ThrowableSerializationSurrogate(Class cls) {
        super(cls);
        try {
            this.mConstructor = cls.getDeclaredConstructor(String.class, Throwable.class);
            this.mConstructor.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object instantiate(NCacheObjectInput input) throws NCacheInstantiationException {
        try {
            String message = input.readUTF();
            Throwable cause = (Throwable)input.readObject();
            if (this.mConstructor != null) {
                return this.mConstructor.newInstance(message, cause);
            }
            throw new NCacheInstantiationException("No constructor found");
        }
        catch (ClassNotFoundException ex) {
            throw new NCacheInstantiationException(ex);
        }
        catch (InstantiationException ex) {
            throw new NCacheInstantiationException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new NCacheInstantiationException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new NCacheInstantiationException(ex);
        }
        catch (IOException ex) {
            throw new NCacheInstantiationException(ex);
        }
    }

    @Override
    public Object readDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        Throwable object = (Throwable)graph;
        try {
            StackTraceElement[] trace = (StackTraceElement[])input.readObject();
            if (trace != null) {
                object.setStackTrace(trace);
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new NCacheIOException(ex);
        }
        return graph;
    }

    @Override
    public void writeDirect(NCacheObjectOutput output, Object graph) throws NCacheIOException {
        Throwable object = (Throwable)graph;
        try {
            output.writeUTF(object.getMessage());
            output.writeObject(object.getCause());
            output.writeObject(object.getStackTrace());
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void skipDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        try {
            input.skipObject();
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }
}

