/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.AlertsPropagators;

import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Config.NewDom.EmailNotifications;
import Alachisoft.NCache.Config.NewDom.NotificationRecipient;
import java.util.HashMap;
import java.util.Map;

public class EmailNotifierArgs {
    private EmailNotifications _emailNotification;
    private CacheRuntimeContext _context;

    public EmailNotifierArgs(Map properties, CacheRuntimeContext context) {
        this._context = context;
        this._emailNotification = new EmailNotifications();
        if (properties.containsKey("email-notification-enabled")) {
            this._emailNotification.setEmailNotificationEnabled(Boolean.parseBoolean((String)properties.get("email-notification-enabled")));
        }
        if (properties.containsKey("sender")) {
            this._emailNotification.setSender(properties.get("sender") instanceof String ? properties.get("sender") : null);
        }
        if (properties.containsKey("smtp-server")) {
            this._emailNotification.setSmtpServer(properties.get("smtp-server") instanceof String ? properties.get("smtp-server") : null);
        }
        if (properties.containsKey("smtp-port")) {
            this._emailNotification.setSmtpPort(Integer.parseInt((String)properties.get("smtp-port")));
        }
        if (properties.containsKey("ssl")) {
            this._emailNotification.setSSL(Boolean.parseBoolean((String)properties.get("ssl")));
        }
        if (properties.containsKey("authentication")) {
            this._emailNotification.setAuthentication(Boolean.parseBoolean((String)properties.get("authentication")));
        }
        if (properties.containsKey("sender-login")) {
            this._emailNotification.setLogin(properties.get("sender-login") instanceof String ? properties.get("sender-login") : null);
        }
        if (properties.containsKey("sender-password")) {
            this._emailNotification.setPassword(properties.get("sender-password") instanceof String ? properties.get("sender-password") : null);
        }
        if (properties.containsKey("recipients")) {
            HashMap recipients = (HashMap)Common.as(properties.get("recipients"), HashMap.class);
            this._emailNotification.setRecipients(this.GetRecipients(recipients));
        }
    }

    public EmailNotifications getEmailNotifications() {
        return this._emailNotification;
    }

    public final CacheRuntimeContext getCacheRuntimeContext() {
        return this._context;
    }

    private NotificationRecipient[] GetRecipients(HashMap settings) {
        NotificationRecipient[] recipients = null;
        if (settings.size() != 0) {
            recipients = new NotificationRecipient[settings.size()];
            int index = 0;
            for (Map.Entry entry : settings.entrySet()) {
                recipients[index] = new NotificationRecipient();
                recipients[index].setID((String)entry.getValue());
                ++index;
            }
        }
        return recipients;
    }
}

