/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.AutoExpiration;

import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHintType;
import Alachisoft.NCache.Caching.AutoExpiration.ExtensibleDependency;
import Alachisoft.NCache.Caching.AutoExpiration.FileDependency;
import Alachisoft.NCache.Caching.AutoExpiration.FixedExpiration;
import Alachisoft.NCache.Caching.AutoExpiration.IExpirationEventSink;
import Alachisoft.NCache.Caching.AutoExpiration.IdleExpiration;
import Alachisoft.NCache.Caching.AutoExpiration.KeyDependency;
import Alachisoft.NCache.Caching.AutoExpiration.NodeExpiration;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Common.EventArgs;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Net.Address;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class AggregateExpirationHint
extends ExpirationHint
implements IExpirationEventSink,
ICompactSerializable,
Serializable,
Iterable {
    private ArrayList _hints = new ArrayList();

    public AggregateExpirationHint() {
        this._hintType = ExpirationHintType.AggregateExpirationHint;
    }

    public AggregateExpirationHint(ExpirationHint ... hints) {
        this._hintType = ExpirationHintType.AggregateExpirationHint;
        this.Initialize(hints);
    }

    @Override
    protected void DisposeInternal() {
        for (int i = 0; i < this._hints.size(); ++i) {
            ((IDisposable)this._hints.get(i)).dispose();
        }
    }

    public final ExpirationHint[] getHints() {
        return this._hints.toArray(new ExpirationHint[0]);
    }

    public final Iterator iterator() {
        return this._hints.iterator();
    }

    @Override
    public void setCacheKey(String value) {
        for (int i = 0; i < this._hints.size(); ++i) {
            ((ExpirationHint)this._hints.get(i)).setCacheKey(value);
        }
    }

    @Override
    public boolean SetBit(int bit) {
        boolean result = false;
        if (bit == 2) {
            for (int i = 0; i < this._hints.size(); ++i) {
                result = ((ExpirationHint)this._hints.get(i)).SetBit(bit);
                if (result) continue;
                return result;
            }
        }
        return super.SetBit(bit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Add(ExpirationHint eh) {
        AggregateExpirationHint aggregateExpirationHint = this;
        synchronized (aggregateExpirationHint) {
            if (!eh.getIsRoutable()) {
                this.SetBit(8);
            }
            if (eh.getIsVariant()) {
                this.SetBit(4);
            }
            eh.SetExpirationEventSink(this);
            AggregateExpirationHint aggregate = (AggregateExpirationHint)(eh instanceof AggregateExpirationHint ? eh : null);
            if (aggregate != null) {
                for (ExpirationHint expirationHint : aggregate._hints) {
                    this._hints.add(expirationHint);
                }
            } else {
                this._hints.add(eh);
            }
            boolean isFixed = false;
            for (int i = this._hints.size() - 1; i >= 0; --i) {
                if (isFixed && this._hints.get(i) instanceof FixedExpiration) {
                    this._hints.remove(i);
                    break;
                }
                if (isFixed || !(this._hints.get(i) instanceof FixedExpiration)) continue;
                isFixed = true;
            }
        }
    }

    @Override
    public int getSortKey() {
        ExpirationHint minHint = (ExpirationHint)this._hints.get(0);
        for (int i = 0; i < this._hints.size(); ++i) {
            if (((Comparable)this._hints.get(i)).compareTo(minHint) >= 0) continue;
            minHint = (ExpirationHint)this._hints.get(i);
        }
        return minHint.getSortKey();
    }

    protected final void Initialize(ExpirationHint[] hints) {
        int i;
        if (hints == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: hints");
        }
        for (i = 0; i < hints.length; ++i) {
            this._hints.add(hints[i]);
        }
        for (i = 0; i < this._hints.size(); ++i) {
            if (!((ExpirationHint)this._hints.get(i)).getIsRoutable()) {
                this.SetBit(8);
            }
            if (((ExpirationHint)this._hints.get(i)).getIsVariant()) {
                this.SetBit(4);
            }
            ((ExpirationHint)this._hints.get(i)).SetExpirationEventSink(this);
        }
    }

    @Override
    public boolean DetermineExpiration(CacheRuntimeContext context) {
        if (this.getHasExpired()) {
            return true;
        }
        for (int i = 0; i < this._hints.size(); ++i) {
            if (!((ExpirationHint)this._hints.get(i)).DetermineExpiration(context)) continue;
            this.NotifyExpiration(this._hints.get(i), null);
            break;
        }
        return this.getHasExpired();
    }

    @Override
    public boolean CheckExpired(CacheRuntimeContext context) {
        if (this.getHasExpired()) {
            return true;
        }
        for (int i = 0; i < this._hints.size(); ++i) {
            if (!((ExpirationHint)this._hints.get(i)).CheckExpired(context)) continue;
            this.NotifyExpiration(this._hints.get(i), null);
            break;
        }
        return this.getHasExpired();
    }

    @Override
    public boolean Reset(CacheRuntimeContext context) throws OperationFailedException {
        boolean flag = super.Reset(context);
        for (int i = 0; i < this._hints.size(); ++i) {
            if (!((ExpirationHint)this._hints.get(i)).Reset(context)) continue;
            flag = true;
        }
        return flag;
    }

    @Override
    public void ResetVariant(CacheRuntimeContext context) throws OperationFailedException {
        for (int i = 0; i < this._hints.size(); ++i) {
            ExpirationHint hint = (ExpirationHint)this._hints.get(i);
            if (!hint.getIsVariant()) continue;
            hint.Reset(context);
        }
    }

    public String toString() {
        Object toString;
        toString = !(this._hints.get(0) instanceof IdleExpiration) && !(this._hints.get(0) instanceof FixedExpiration) ? (toString = "INNER\r\n") : "";
        for (int i = 0; i < this._hints.size(); ++i) {
            if (i >= 1 && (this._hints.get(i - 1) instanceof KeyDependency && this._hints.get(i) instanceof KeyDependency || this._hints.get(i - 1) instanceof FileDependency && this._hints.get(i) instanceof FileDependency)) {
                toString = (String)toString + "INNER\r\n";
            }
            toString = this._hints.get(i) instanceof ExtensibleDependency ? (String)toString + "EXTDEPENDENCY \"\r\n" : (String)toString + this._hints.get(i).toString();
        }
        return toString;
    }

    @Override
    public void DependentExpired(Object sender, EventArgs e) {
        this.NotifyExpiration(sender, e);
    }

    @Override
    public final void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        super.deserialize(reader);
        int length = reader.readInt();
        if (this._hints == null) {
            this._hints = new ArrayList(length);
        }
        for (int i = 0; i < length; ++i) {
            this._hints.add(i, reader.readObject());
        }
    }

    @Override
    public final void serialize(NCacheObjectOutput writer) throws IOException {
        super.serialize(writer);
        writer.writeInt(this._hints.size());
        for (int i = 0; i < this._hints.size(); ++i) {
            writer.writeObject(this._hints.get(i));
        }
    }

    public final AggregateExpirationHint GetRoutableClone(Address sourceNode) {
        if (this._hints == null || this._hints.isEmpty()) {
            return null;
        }
        AggregateExpirationHint hint = new AggregateExpirationHint();
        NodeExpiration ne = null;
        for (int i = 0; i < this._hints.size(); ++i) {
            ExpirationHint eh = (ExpirationHint)this._hints.get(i);
            if (!eh.getIsRoutable() && ne == null) {
                ne = new NodeExpiration(sourceNode);
                hint.Add(ne);
                continue;
            }
            hint.Add(eh);
        }
        return hint;
    }
}

