/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.AutoExpiration;

import Alachisoft.NCache.Caching.AutoExpiration.CacheDbSyncManager;
import Alachisoft.NCache.Caching.AutoExpiration.DependencyHint;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHintType;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBCacheDependency
extends DependencyHint
implements ICompactSerializable,
Serializable {
    public transient CacheDbSyncManager _cdbSyncManager = null;
    public transient Connection _connection = null;
    protected String _dbCacheKey = "";
    protected String _cacheName = "";
    protected String _connectionString = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean SetSyncData() throws SQLException {
        String modifiedStr = "0";
        Object[] tableInfo = new Object[]{"tgcache_db_sync", this._dbCacheKey, this._cacheName, modifiedStr};
        ResultSet reader = null;
        Statement command = null;
        boolean exists = false;
        Boolean modified = null;
        boolean oldAutoCommit = false;
        Connection connection = this._connection;
        synchronized (connection) {
            String sql;
            oldAutoCommit = this._connection.getAutoCommit();
            this._connection.setAutoCommit(false);
            try {
                command = this._connection.createStatement();
                sql = String.format("SELECT MODIFIED FROM %1$s WHERE CACHE_KEY = '%2$s' AND CACHE_ID = '%3$s'", tableInfo);
                reader = command.executeQuery(sql);
                if (reader.next()) {
                    modified = reader.getBoolean("MODIFIED");
                    exists = true;
                }
            }
            catch (Exception ex) {
                this.getNCacheLog().Error("DBCacheDependency", ex.toString());
                exists = false;
            }
            finally {
                if (reader != null) {
                    reader.close();
                    reader = null;
                }
                if (command != null) {
                    command.close();
                    command = null;
                }
            }
            if (!exists) {
                try {
                    command = this._connection.createStatement();
                    sql = String.format("INSERT INTO %1$s VALUES ('%2$s', '%3$s', %4$s, 0)", tableInfo);
                    command.executeUpdate(sql);
                    exists = true;
                }
                catch (Exception ex) {
                    this.getNCacheLog().Error("DBCacheDependency", ex.toString());
                    this._connection.rollback();
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (reader != null) {
                        reader.close();
                        reader = null;
                    }
                    if (command != null) {
                        command.close();
                        command = null;
                    }
                }
            }
            if (((Boolean)modified).booleanValue()) {
                exists = false;
                try {
                    command = this._connection.createStatement();
                    sql = String.format("UPDATE %1$s SET MODIFIED = %4$s, WORK_IN_PROGRESS = %4$s WHERE CACHE_KEY = '%2$s' AND CACHE_ID = '%3$s'", tableInfo);
                    command.executeUpdate(sql);
                    exists = true;
                }
                catch (Exception ex) {
                    this.getNCacheLog().Error("DBCacheDependency", ex.toString());
                    this._connection.rollback();
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (reader != null) {
                        reader.close();
                        reader = null;
                    }
                    if (command != null) {
                        command.close();
                        command = null;
                    }
                }
            }
            this._connection.commit();
            this._connection.setAutoCommit(oldAutoCommit);
            return exists;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean RemoveSyncData() {
        Object[] tableInfo = new Object[]{"tgcache_db_sync", this._cacheName, this._dbCacheKey};
        Statement command = null;
        try {
            command = this._connection.createStatement();
            command.executeUpdate(String.format("DELETE FROM %1$s WHERE CACHE_ID = '%2$s' AND CACHE_KEY = '%3$s'", tableInfo));
            this._connection.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            this.getNCacheLog().Error("DBCacheDependency", ex.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            if (command != null) {
                try {
                    command.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(DBCacheDependency.class.getName()).log(Level.SEVERE, null, ex);
                }
                command = null;
            }
        }
    }

    @Override
    public boolean getHasChanged() {
        return false;
    }

    @Override
    protected void DisposeInternal() {
        if (this._cdbSyncManager != null) {
            this.RemoveSyncData();
            this._cdbSyncManager.RemoveDBMapping(this._dbCacheKey);
            if (this._hintType == ExpirationHintType.OracleCacheDependency) {
                this._cdbSyncManager.RemoveFromSqlConnectionPool(this._connectionString);
            } else {
                this._cdbSyncManager.RemoveFromOleDbConnectionPool(this._connectionString);
            }
        }
    }

    @Override
    public void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        super.deserialize(reader);
        Object tempVar = reader.readObject();
        this.setCacheKey(tempVar != null ? (String)(tempVar instanceof String ? tempVar : null) : null);
        tempVar = reader.readObject().toString();
        this._dbCacheKey = (String)(tempVar instanceof String ? tempVar : null);
        tempVar = reader.readObject().toString();
        this._cacheName = (String)(tempVar instanceof String ? tempVar : null);
        tempVar = reader.readObject().toString();
        this._connectionString = (String)(tempVar instanceof String ? tempVar : null);
    }

    @Override
    public void serialize(NCacheObjectOutput writer) throws IOException {
        super.serialize(writer);
        writer.writeObject((Object)this.getCacheKey());
        writer.writeObject((Object)this._dbCacheKey);
        writer.writeObject((Object)this._cacheName);
        writer.writeObject((Object)this._connectionString);
    }
}

