/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.AutoExpiration;

import Alachisoft.NCache.Caching.AutoExpiration.AggregateExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.ExtensibleDependency;
import Alachisoft.NCache.Caching.AutoExpiration.FileDependency;
import Alachisoft.NCache.Caching.AutoExpiration.FixedExpiration;
import Alachisoft.NCache.Caching.AutoExpiration.IdleExpiration;
import Alachisoft.NCache.Caching.AutoExpiration.KeyDependency;
import Alachisoft.NCache.Caching.AutoExpiration.OleDbCacheDependency;
import Alachisoft.NCache.Caching.AutoExpiration.OracleCacheDependency;
import Alachisoft.NCache.Caching.AutoExpiration.OracleCommandParams;
import Alachisoft.NCache.Caching.AutoExpiration.Sql7CacheDependency;
import Alachisoft.NCache.Caching.AutoExpiration.SqlCmdParams;
import Alachisoft.NCache.Caching.AutoExpiration.SqlYukonCacheDependency;
import com.alachisoft.ncache.runtime.caching.expiration.ExpirationConstants;
import com.alachisoft.ncache.runtime.dependencies.AggregateCacheDependency;
import com.alachisoft.ncache.runtime.dependencies.CacheDependency;
import com.alachisoft.ncache.runtime.dependencies.CommandType;
import com.alachisoft.ncache.runtime.dependencies.DBCacheDependency;
import com.alachisoft.ncache.runtime.dependencies.DBDependencyFactory;
import com.alachisoft.ncache.runtime.dependencies.OracleCmdParams;
import com.alachisoft.ncache.runtime.dependencies.OracleCommandType;
import com.alachisoft.ncache.runtime.dependencies.OracleParameterDirection;
import com.alachisoft.ncache.runtime.dependencies.SqlCacheDependency;
import com.alachisoft.ncache.runtime.dependencies.SqlCommandType;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import tangible.RefObject;

public class DependencyHelper {
    public static CacheDependency GetCacheDependency(ExpirationHint hint, RefObject<Date> absoluteExpiration, RefObject<TimeSpan> slidingExpiration) throws OperationFailedException {
        DBCacheDependency cacheDependency = null;
        if (hint != null) {
            if (hint instanceof AggregateExpirationHint) {
                AggregateExpirationHint aggregate = (AggregateExpirationHint)hint;
                if (aggregate.getHints() != null && aggregate.getHints().length > 0) {
                    for (ExpirationHint h : aggregate.getHints()) {
                        RefObject tempRef_cacheDependency = new RefObject((Object)cacheDependency);
                        DependencyHelper.AddAggregateCacheDependency((RefObject<CacheDependency>)tempRef_cacheDependency, DependencyHelper.GetCacheDependency(h, absoluteExpiration, slidingExpiration));
                        cacheDependency = (CacheDependency)tempRef_cacheDependency.argvalue;
                    }
                }
            } else if (hint instanceof FixedExpiration) {
                long ticks = ((FixedExpiration)hint).getTicks();
                absoluteExpiration.argvalue = new NCDateTime(ticks).getLocalizedDate();
            } else if (hint instanceof IdleExpiration) {
                slidingExpiration.argvalue = ((IdleExpiration)hint).getSlidingTime();
            } else if (hint instanceof KeyDependency) {
                KeyDependency keyDep = (KeyDependency)hint;
                RefObject temp_CacheDependency = new RefObject(cacheDependency);
                DependencyHelper.addToDependency((RefObject<CacheDependency>)temp_CacheDependency, (CacheDependency)new com.alachisoft.ncache.runtime.dependencies.KeyDependency(Arrays.asList(keyDep.getCacheKeys()), new Date(keyDep.getStartAfterTicks())));
                cacheDependency = (CacheDependency)temp_CacheDependency.argvalue;
            } else if (hint instanceof FileDependency) {
                FileDependency fileDep = (FileDependency)hint;
                cacheDependency = new com.alachisoft.ncache.runtime.dependencies.FileDependency(Arrays.asList(fileDep.getfileNames()), new Date(fileDep.getStartAfterTicks()));
            } else if (hint instanceof OleDbCacheDependency) {
                try {
                    OleDbCacheDependency oleDbDep = (OleDbCacheDependency)hint;
                    cacheDependency = DBDependencyFactory.createOleDbCacheDependency((String)oleDbDep.getConnectionString(), (String)oleDbDep.getDbCacheKey());
                }
                catch (Exception oleDbDep) {}
            } else if (hint instanceof OracleCacheDependency) {
                try {
                    OracleCacheDependency oracleDep = (OracleCacheDependency)hint;
                    LinkedHashMap<String, OracleCmdParams> parameters = new LinkedHashMap<String, OracleCmdParams>();
                    for (Map.Entry enuPair : oracleDep.getCommandParams().entrySet()) {
                        String key = enuPair.getKey().toString();
                        OracleCommandParams cmdParam = (OracleCommandParams)enuPair.getValue();
                        OracleCmdParams commandParam = new OracleCmdParams();
                        commandParam.setDirection(OracleParameterDirection.getOracleParameterDirection((int)cmdParam.getDirection()));
                        commandParam.setType(cmdParam.getType());
                        commandParam.setValue(cmdParam.getValue());
                        parameters.put(key, commandParam);
                    }
                    com.alachisoft.ncache.runtime.dependencies.OracleCacheDependency oraDep = new com.alachisoft.ncache.runtime.dependencies.OracleCacheDependency(oracleDep.getConnectionString(), oracleDep.getQueryString(), OracleCommandType.getOracleCommandType((CommandType)oracleDep.getCommandType()), parameters);
                    RefObject tempRef_cacheDependency7 = new RefObject((Object)cacheDependency);
                    cacheDependency = oraDep;
                }
                catch (Exception oracleDep) {}
            } else if (hint instanceof SqlYukonCacheDependency) {
                SqlYukonCacheDependency yukonDep = (SqlYukonCacheDependency)hint;
                HashMap<String, com.alachisoft.ncache.runtime.dependencies.SqlCmdParams> parameters = new HashMap<String, com.alachisoft.ncache.runtime.dependencies.SqlCmdParams>();
                if (yukonDep.getCommandParams() != null) {
                    for (Map.Entry entry : yukonDep.getCommandParams().entrySet()) {
                        String key = entry.getKey().toString();
                        SqlCmdParams param = (SqlCmdParams)entry.getValue();
                        com.alachisoft.ncache.runtime.dependencies.SqlCmdParams yukonCmdParam = new com.alachisoft.ncache.runtime.dependencies.SqlCmdParams();
                        yukonCmdParam.setSqlParameterDirection(param.getDirection());
                        yukonCmdParam.setCmdParamsType(param.getDbType());
                        yukonCmdParam.setIsNullable(param.getIsNullable());
                        yukonCmdParam.setLocaleId(param.getLocaleID());
                        yukonCmdParam.setoffset(param.getOffset());
                        yukonCmdParam.setprecision(param.getPrecision());
                        yukonCmdParam.setScale(param.getScale());
                        yukonCmdParam.setSize(param.getParamSize());
                        yukonCmdParam.setSourceColumn(param.getSourceColumn());
                        yukonCmdParam.setSourceColumnNullMapping(param.getSourceColumnNullMapping());
                        yukonCmdParam.setSqlValue(param.getSqlValue());
                        yukonCmdParam.setSourceVersion(param.getSrcVersion());
                        yukonCmdParam.setTypeName(param.getTypeName());
                        yukonCmdParam.setUdtTypeName(param.getUdtName());
                        yukonCmdParam.setValue(param.getValue());
                        parameters.put(key, yukonCmdParam);
                    }
                }
                SqlCacheDependency sqlDep = new SqlCacheDependency(yukonDep.getConnectionString(), yukonDep.getQueryString(), SqlCommandType.getSqlCommandType((int)yukonDep.getCommandType().getValue()), parameters);
                RefObject tempRef_cacheDependency8 = new RefObject((Object)cacheDependency);
                DependencyHelper.addToDependency((RefObject<CacheDependency>)tempRef_cacheDependency8, (CacheDependency)sqlDep);
                cacheDependency = (CacheDependency)tempRef_cacheDependency8.argvalue;
            }
        }
        return cacheDependency;
    }

    private static void AddAggregateCacheDependency(RefObject<CacheDependency> cacheDependency, CacheDependency newDependency) {
        if (newDependency != null) {
            if (cacheDependency.argvalue == null) {
                cacheDependency.argvalue = new AggregateCacheDependency();
            }
            AggregateCacheDependency dependency = (AggregateCacheDependency)cacheDependency.argvalue;
            dependency.getDependencies().add(newDependency);
        }
    }

    public static ExpirationHint GetExpirationHint(CacheDependency dependency, Date absoluteExpiration, TimeSpan slidingExpiration) throws IllegalArgumentException {
        ExpirationHint hint = DependencyHelper.GetExpirationHint(absoluteExpiration, slidingExpiration);
        if (hint == null) {
            return DependencyHelper.GetExpirationHint(dependency);
        }
        ExpirationHint hint2 = DependencyHelper.GetExpirationHint(dependency);
        if (hint2 == null) {
            return hint;
        }
        AggregateExpirationHint aggregateHint = null;
        if (hint2 instanceof AggregateExpirationHint) {
            aggregateHint = (AggregateExpirationHint)(hint2 instanceof AggregateExpirationHint ? hint2 : null);
            aggregateHint.Add(hint);
            return aggregateHint;
        }
        aggregateHint = new AggregateExpirationHint();
        aggregateHint.Add(hint);
        aggregateHint.Add(hint2);
        return aggregateHint;
    }

    public static ExpirationHint GetExpirationHint(CacheDependency dependency) {
        AggregateExpirationHint aggregateHint = new AggregateExpirationHint();
        return DependencyHelper.GetExpirationHint(dependency, aggregateHint);
    }

    private static ExpirationHint GetExpirationHint(Date absoluteExpiration, TimeSpan slidingExpiration) throws IllegalArgumentException {
        ExpirationHint hint = null;
        if (absoluteExpiration == null && slidingExpiration == null) {
            return null;
        }
        if (ExpirationConstants.AbsoluteNoneExpiration.equals(absoluteExpiration) && ExpirationConstants.SlidingNoneExpiration.equals(slidingExpiration)) {
            return null;
        }
        if (absoluteExpiration == null) {
            hint = new IdleExpiration(slidingExpiration);
        } else {
            TimeZone utc = TimeZone.getTimeZone("UTC");
            Calendar cal = Calendar.getInstance(utc);
            cal.set(14, 0);
            cal.setTime(absoluteExpiration);
            NCDateTime ncDate = new NCDateTime(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
            absoluteExpiration = ncDate.getLocalizedDate();
            hint = new FixedExpiration(absoluteExpiration, ncDate.getTicks());
        }
        return hint;
    }

    private static ExpirationHint GetExpirationHint(CacheDependency cacheDependency, AggregateExpirationHint aggregateHint) {
        if (cacheDependency == null) {
            return null;
        }
        ExpirationHint hint = null;
        if (cacheDependency instanceof com.alachisoft.ncache.runtime.dependencies.KeyDependency) {
            com.alachisoft.ncache.runtime.dependencies.KeyDependency keyDependency = (com.alachisoft.ncache.runtime.dependencies.KeyDependency)(cacheDependency instanceof com.alachisoft.ncache.runtime.dependencies.KeyDependency ? cacheDependency : null);
            NCDateTime nct = new NCDateTime(keyDependency.getStartAfterTicks());
            hint = new KeyDependency((String[])Iterables.toArray((Iterable)keyDependency.getCacheKeys(), String.class), nct.getDate());
            aggregateHint.Add(hint);
        } else if (cacheDependency instanceof com.alachisoft.ncache.runtime.dependencies.FileDependency) {
            com.alachisoft.ncache.runtime.dependencies.FileDependency fileDependency = (com.alachisoft.ncache.runtime.dependencies.FileDependency)(cacheDependency instanceof com.alachisoft.ncache.runtime.dependencies.FileDependency ? cacheDependency : null);
            NCDateTime nct = new NCDateTime(fileDependency.getStartAfterTicks());
            hint = new FileDependency((String[])Iterables.toArray((Iterable)fileDependency.getFileNames(), String.class), nct.getDate());
            aggregateHint.Add(hint);
        } else if (cacheDependency instanceof DBCacheDependency) {
            DBCacheDependency dbDependency = (DBCacheDependency)(cacheDependency instanceof DBCacheDependency ? cacheDependency : null);
            switch (dbDependency.getDBDependencyType()) {
                case OleDbCacheDependency: {
                    hint = new OleDbCacheDependency(dbDependency.getConnectionString(), dbDependency.getPrimaryKey());
                    break;
                }
                case SqlCacheDependency: {
                    hint = new Sql7CacheDependency(dbDependency.getConnectionString(), dbDependency.getPrimaryKey());
                }
            }
            aggregateHint.Add(hint);
        } else if (cacheDependency instanceof com.alachisoft.ncache.runtime.dependencies.OracleCacheDependency) {
            com.alachisoft.ncache.runtime.dependencies.OracleCacheDependency oracleDependency = (com.alachisoft.ncache.runtime.dependencies.OracleCacheDependency)(cacheDependency instanceof com.alachisoft.ncache.runtime.dependencies.OracleCacheDependency ? cacheDependency : null);
            LinkedHashMap parameters = new LinkedHashMap();
            if (oracleDependency.getCommandParams() != null) {
                for (Map.Entry pair : oracleDependency.getCommandParams().entrySet()) {
                    OracleCmdParams oracleCommandParams = (OracleCmdParams)pair.getValue();
                    OracleCommandParams commandParam = new OracleCommandParams(oracleCommandParams.getType(), oracleCommandParams.getValue(), oracleCommandParams.getDirection().ordinal());
                    parameters.put(pair.getKey(), commandParam);
                }
            }
            hint = new OracleCacheDependency(oracleDependency.getConnectionString(), oracleDependency.getCommandText(), oracleDependency.getCommandType(), parameters);
            aggregateHint.Add(hint);
        } else if (cacheDependency instanceof SqlCacheDependency) {
            SqlCacheDependency sqlDependency = (SqlCacheDependency)cacheDependency;
            Hashtable parameters = new Hashtable();
            if (sqlDependency.getCommandParams() != null) {
                for (Map.Entry pair : sqlDependency.getCommandParams().entrySet()) {
                    com.alachisoft.ncache.runtime.dependencies.SqlCmdParams param = (com.alachisoft.ncache.runtime.dependencies.SqlCmdParams)pair.getValue();
                    SqlCmdParams commandParam = new SqlCmdParams();
                    commandParam.setCmpInfo(param.getCompareInfo());
                    commandParam.setDirection(param.getSqlParameterDirection());
                    commandParam.setIsNullable(param.getIsNullable());
                    commandParam.setLocaleID(param.getLocaleId());
                    commandParam.setOffset(param.getoffset());
                    commandParam.setPrecision(param.getPrecision());
                    commandParam.setScale(param.getScale());
                    commandParam.setParamSize(param.getSize());
                    commandParam.setSourceColumn(param.getSourceColumn());
                    commandParam.setSourceColumnNullMapping(param.getSourceColumnNullMapping());
                    commandParam.setSqlValue(param.getSqlValue());
                    commandParam.setSrcVersion(param.getSourceVersion());
                    commandParam.setDbType(param.getCmdParamsType());
                    commandParam.setTypeName(param.getTypeName());
                    commandParam.setUdtName(param.getUdtTypeName());
                    commandParam.setValue(param.getValue());
                    parameters.put(pair.getKey(), commandParam);
                }
            }
            hint = new SqlYukonCacheDependency(sqlDependency.getConnectionString(), sqlDependency.getCommandText(), sqlDependency.getCommandType(), parameters);
            aggregateHint.Add(hint);
        } else if (cacheDependency instanceof com.alachisoft.ncache.runtime.dependencies.ExtensibleDependency) {
            hint = new ExtensibleDependency((com.alachisoft.ncache.runtime.dependencies.ExtensibleDependency)(cacheDependency instanceof com.alachisoft.ncache.runtime.dependencies.ExtensibleDependency ? cacheDependency : null));
            aggregateHint.Add(hint);
        } else if (cacheDependency instanceof AggregateCacheDependency) {
            AggregateCacheDependency dependency = (AggregateCacheDependency)cacheDependency;
            for (CacheDependency dep : dependency.getDependencies()) {
                hint = DependencyHelper.GetExpirationHint(dep, aggregateHint);
            }
        }
        if (aggregateHint.getHints().length == 0) {
            return null;
        }
        if (aggregateHint.getHints().length == 1) {
            return aggregateHint.getHints()[0];
        }
        return aggregateHint;
    }

    private static void addToDependency(RefObject<CacheDependency> cacheDependency, CacheDependency newDependency) {
        if (cacheDependency.argvalue != null) {
            ((CacheDependency)cacheDependency.argvalue).getDependencies().add(newDependency);
        } else {
            cacheDependency.argvalue = new CacheDependency(newDependency);
        }
    }
}

