/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.AutoExpiration;

import Alachisoft.NCache.Caching.AutoExpiration.CacheDbSyncManager;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.IdleExpiration;
import Alachisoft.NCache.Caching.AutoExpiration.NotificationBasedDependencyManager;
import Alachisoft.NCache.Caching.Cache;
import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Caching.ItemRemoveReason;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Common.AppUtil;
import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.ServiceConfiguration;
import Alachisoft.NCache.Common.ServicePropValues;
import Alachisoft.NCache.Common.Threading.TimeScheduler;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ExpirationManager
implements IDisposable {
    private static Object _DATA = new Object();
    public HashMap _dependencyKeys = new HashMap();
    public boolean AllowClusteredExpiry = false;
    private Cache _topLevelCache;
    private CacheRuntimeContext _context;
    private AutoExpirationTask _taskExpiry;
    private int _cleanInterval = 30000;
    private float _cleanRatio = 1.0f;
    private boolean _allowClusteredExpiry = true;
    private long _runCount;
    private HashMap _mainIndex = new HashMap(25000, 0.7f);
    private HashMap _transitoryIndex = new HashMap(25000, 0.7f);
    private boolean _indexCleared;
    private boolean _cacheCleared = false;
    private Object _status_mutex = new Object();
    private long _sleepInterval = 0L;
    private int _removeThreshhold = 10;
    private boolean _allowExplicitGCCollection = true;
    private boolean _inProgress;
    private CacheDbSyncManager _cdbSyncMgr;
    private NotificationBasedDependencyManager _notifBasedDepMgr;
    private boolean _isCoordinator = true;
    private boolean _isSubCoordinator = false;
    private ILogger _ncacheLog;
    private int _cacheLastAccessLoggingInterval = 20;
    private int _cacheLastAccessLoggingIntervalPassed;
    private int _cacheLastAccessInterval;
    private boolean _cacheLastAccessCountEnabled;
    private boolean _cacheLastAccessCountLoggingEnabled;

    public ExpirationManager(Map properties, CacheRuntimeContext context) {
        this._context = context;
        this._ncacheLog = context.getNCacheLog();
        this.Initialize(properties);
        this._cdbSyncMgr = new CacheDbSyncManager(this._ncacheLog);
        this._cdbSyncMgr.GetCacheID(context.getCacheRoot().getName());
        this._notifBasedDepMgr = new NotificationBasedDependencyManager(this._context);
        if (ServicePropValues.CacheServer_ExpirationBulkRemoveDelay != null) {
            this._sleepInterval = Integer.decode(ServicePropValues.CacheServer_ExpirationBulkRemoveDelay) * 1000;
        }
        if (ServicePropValues.CacheServer_ExpirationBulkRemoveSize != null) {
            this._removeThreshhold = Integer.decode(ServicePropValues.CacheServer_ExpirationBulkRemoveSize);
        }
        this._sleepInterval = Integer.parseInt(ServiceConfiguration.getExpirationBulkRemoveDelay());
        this._removeThreshhold = Integer.parseInt(ServiceConfiguration.getExpirationBulkRemoveSize());
        if (ServicePropValues.CacheServer_EnableGCCollection != null) {
            this._allowExplicitGCCollection = Boolean.parseBoolean(ServicePropValues.CacheServer_EnableGCCollection);
        }
    }

    private ILogger getNCacheLog() {
        return this._ncacheLog;
    }

    public final boolean getIsCoordinatorNode() {
        return this._isCoordinator;
    }

    public final void setIsCoordinatorNode(boolean value) {
        this._isCoordinator = value;
    }

    public final boolean getIsSubCoordinatorNode() {
        return this._isSubCoordinator;
    }

    public final void setIsSubCoordinatorNode(boolean value) {
        this._isSubCoordinator = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getIsInProgress() {
        Object object = this._status_mutex;
        synchronized (object) {
            return this._inProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setIsInProgress(boolean value) {
        Object object = this._status_mutex;
        synchronized (object) {
            this._inProgress = value;
        }
    }

    public final Cache getTopLevelCache() {
        return this._topLevelCache;
    }

    public final void setTopLevelCache(Cache value) {
        this._topLevelCache = value;
    }

    private boolean getIsCacheLastAccessCountEnabled() {
        boolean isCachelastAccessEnabled = false;
        try {
            String str = ServicePropValues.CacheServer_EnableCacheLastAccessCount;
            if (str != null && !str.equals("")) {
                isCachelastAccessEnabled = Boolean.parseBoolean(str);
            }
        }
        catch (Exception e) {
            this.getNCacheLog().Error("ExpirationManager.IsCacheLastAccessCountEnabled", "invalid value provided for NCacheServer.EnableCacheLastAccessCount");
        }
        return isCachelastAccessEnabled;
    }

    private boolean getIsCacheLastAccessLoggingEnabled() {
        boolean isCachelastAccessLogEnabled = false;
        try {
            String str = ServicePropValues.CacheServer_EnableCacheLastAccessCountLogging;
            if (str != null && !str.equals("")) {
                isCachelastAccessLogEnabled = Boolean.parseBoolean(str);
            }
        }
        catch (Exception e) {
            this.getNCacheLog().Error("ExpirationManager.IsCacheLastAccessLoggingEnabled", "invalid value provided for NCacheServer.EnableCacheLastAccessCount");
        }
        if (this.getIsCacheLastAccessCountEnabled() && isCachelastAccessLogEnabled) {
            String path = Common.combinePath((String)AppUtil.getInstallDir(), (String[])new String[]{ServicePropValues.LOGS_FOLDER});
            this.getNCacheLog().Info(this._context.getSerializationContext() + (this._context.getIsStartedAsMirror() ? "-replica" : "") + ".cache-last-acc-log " + path);
        }
        return isCachelastAccessLogEnabled;
    }

    private int getCacheLastAccessCountInterval() {
        int isCachelastAccessInterval = this._cacheLastAccessInterval;
        try {
            String str = ServicePropValues.CacheServer_CacheLastAccessCountInterval;
            if (str != null && !str.equals("")) {
                isCachelastAccessInterval = Integer.parseInt(str);
            }
        }
        catch (Exception e) {
            this.getNCacheLog().Error("ExpirationManager.CacheLastAccessCountInterval", "invalid value provided for NCacheServer.CacheLastAccessCountInterval");
        }
        return isCachelastAccessInterval;
    }

    private int getCacheLastAccessLoggingInterval() {
        int isCachelastAccessLogingInterval = this._cacheLastAccessLoggingInterval;
        try {
            String str = ServicePropValues.CacheServer_CacheLastAccessLogInterval;
            if (str != null && !str.equals("")) {
                isCachelastAccessLogingInterval = Integer.parseInt(str);
            }
        }
        catch (Exception e) {
            this.getNCacheLog().Error("ExpirationManager.CacheLastAccessLogInterval", "invalid value provided for NCacheServer.CacheLastAccessLogInterval");
        }
        return isCachelastAccessLogingInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this._taskExpiry != null) {
            this._taskExpiry.Cancel();
            this._taskExpiry = null;
        }
        if (this._cdbSyncMgr != null) {
            this._cdbSyncMgr.ClearResourcePools();
            this._cdbSyncMgr.Clear();
        }
        if (this._notifBasedDepMgr != null) {
            this._notifBasedDepMgr.dispose(false);
            this._notifBasedDepMgr = null;
        }
        Object object = this._status_mutex;
        synchronized (object) {
            this._mainIndex.clear();
            this._mainIndex = null;
            this._transitoryIndex.clear();
            this._transitoryIndex = null;
        }
    }

    public final long getCleanInterval() {
        return this._taskExpiry.getInterval();
    }

    public final void setCleanInterval(long value) {
        this._taskExpiry.setInterval(value);
    }

    public final boolean getIsDisposed() {
        return this._taskExpiry == null || this._taskExpiry.getIsCancelled();
    }

    public final HashMap getDependencyKeys() {
        return this._dependencyKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getAllowClusteredExpiry() {
        ExpirationManager expirationManager = this;
        synchronized (expirationManager) {
            return this._allowClusteredExpiry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAllowClusteredExpiry(boolean value) {
        ExpirationManager expirationManager = this;
        synchronized (expirationManager) {
            this._allowClusteredExpiry = value;
        }
    }

    public final NotificationBasedDependencyManager getNotifBasedDepManager() {
        return this._notifBasedDepMgr;
    }

    public final CacheDbSyncManager getCacheDbSyncManager() {
        return this._cdbSyncMgr;
    }

    private void Initialize(Map properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: properties");
        }
        if (properties.containsKey("clean-interval")) {
            this._cleanInterval = Integer.decode(properties.get("clean-interval").toString()) * 1000;
        }
        this._cacheLastAccessCountEnabled = this.getIsCacheLastAccessCountEnabled();
        this._cacheLastAccessCountLoggingEnabled = this.getIsCacheLastAccessLoggingEnabled();
        this._cacheLastAccessInterval = this.getCacheLastAccessCountInterval();
        this._cacheLastAccessLoggingInterval = this.getCacheLastAccessLoggingInterval();
    }

    public final void Start() {
        if (this._taskExpiry == null) {
            this._taskExpiry = new AutoExpirationTask(this, this._cleanInterval);
            this._context.TimeSched.AddTask((TimeScheduler.Task)this._taskExpiry);
        }
    }

    public final void Stop() {
        if (this._taskExpiry != null) {
            this._taskExpiry.Cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ResetHint(ExpirationHint oldHint, ExpirationHint newHint) throws OperationFailedException {
        ExpirationManager expirationManager = this;
        synchronized (expirationManager) {
            if (newHint != null) {
                if (oldHint != null) {
                    oldHint.dispose();
                }
                newHint.Reset(this._context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ResetVariant(ExpirationHint hint) throws OperationFailedException {
        ExpirationManager expirationManager = this;
        synchronized (expirationManager) {
            hint.ResetVariant(this._context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Clear() {
        Object object = this;
        synchronized (object) {
            this._cdbSyncMgr.Clear();
            this._notifBasedDepMgr.Clear();
            this._cacheCleared = true;
        }
        object = this._status_mutex;
        synchronized (object) {
            if (!this.getIsInProgress()) {
                this._mainIndex.clear();
            } else {
                this._transitoryIndex.clear();
                this._indexCleared = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final boolean Expire() throws InterruptedException, IllegalArgumentException {
        block152: {
            block150: {
                block151: {
                    expired = false;
                    currentRun = 0L;
                    var4_3 = this;
                    synchronized (var4_3) {
                        currentRun = this._runCount++;
                    }
                    this._sleepInterval = Integer.parseInt(ServiceConfiguration.getExpirationBulkRemoveDelay());
                    this._removeThreshhold = Integer.parseInt(ServiceConfiguration.getExpirationBulkRemoveSize());
                    notifThreshold = 30720;
                    cacheInst = this._context.getCacheImpl();
                    cache = this._context.getCacheInternal();
                    rootCache = this._context.getCacheRoot();
                    keys = null;
                    values = null;
                    if (cache == null) {
                        throw new UnsupportedOperationException("No cache instance defined");
                    }
                    v0 = allowExpire = this.getAllowClusteredExpiry() != false && this._context.getIsBridgeTargetCache() == false;
                    if (!allowExpire) {
                        return false;
                    }
                    selectedKeys = new ArrayList<K>();
                    cascadedKeys = new ArrayList<E>();
                    oldItemsCount = 0;
                    oldeItems = null;
                    this.StartLogging();
                    currentTime = AppUtil.DiffSeconds((Date)NCDateTime.getUTCNow());
                    if (!this._context.getIsDbSyncCoordinator()) ** GOTO lbl168
                    this._cdbSyncMgr.AcquireSyncData();
                    dbkeys = this._cdbSyncMgr.GetExpiredKeys();
                    if (dbkeys.size() <= 0) ** GOTO lbl168
                    expire = dbkeys.get("expire-items") instanceof ArrayList != false ? dbkeys.get("expire-items") : null;
                    resync = dbkeys.get("resync-items") instanceof ArrayList != false ? dbkeys.get("resync-items") : null;
                    if (this._context.getCacheImpl() != null) break block150;
                    var19_25 = false;
                    this._context.PerfStatsColl.incrementCacheLastAccessCountStats(oldItemsCount);
                    this.ApplyLoggs();
                    dependentItems = new ArrayList<E>();
                    removedItems = null;
                    startTime = new Date();
                    try {
                        if (selectedKeys.size() > 0) {
                            keysTobeRemoved = new ArrayList<E>();
                            for (i = 0; i < selectedKeys.size() && !this._cacheCleared; ++i) {
                                keysTobeRemoved.add(selectedKeys.get(i));
                                if (keysTobeRemoved.size() % this._removeThreshhold != 0) continue;
                                try {
                                    if (this.getIsDisposed()) break;
                                    operationContext = new OperationContext();
                                    operationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                                    operationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                                    tempVar = cache.RemoveSync(keysTobeRemoved.toArray(new Object[0]), ItemRemoveReason.Expired, false, operationContext);
                                    removedItems = (ArrayList)(tempVar instanceof ArrayList != false ? tempVar : null);
                                    expired = true;
                                    if (this._context.PerfStatsColl != null) {
                                        this._context.PerfStatsColl.incrementExpiryPerSecStatsBy(keysTobeRemoved.size());
                                    }
                                }
                                catch (Exception e) {
                                    this.getNCacheLog().Error("ExpiryManager.Expire", "an error occured while removing expired items. Error " + e.toString());
                                }
                                keysTobeRemoved.clear();
                                if (removedItems != null && removedItems.size() > 0) {
                                    dependentItems.addAll(removedItems);
                                }
                                Thread.sleep(this._sleepInterval * 1000L);
                            }
                            if (!this.getIsDisposed() && keysTobeRemoved.size() > 0) {
                                try {
                                    operationContext = new OperationContext();
                                    operationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                                    operationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                                    tempVar2 = cache.RemoveSync(keysTobeRemoved.toArray(new Object[0]), ItemRemoveReason.Expired, false, operationContext);
                                    removedItems = (ArrayList)(tempVar2 instanceof ArrayList != false ? tempVar2 : null);
                                    expired = true;
                                    if (this._context.PerfStatsColl != null) {
                                        this._context.PerfStatsColl.incrementExpiryPerSecStatsBy(keysTobeRemoved.size());
                                    }
                                    if (removedItems != null && removedItems.size() > 0) {
                                        dependentItems.addAll(removedItems);
                                    }
                                }
                                catch (Exception e) {
                                    this.getNCacheLog().Error("ExpiryManager.Expire", "an error occured while removing expired items. Error " + e.toString());
                                }
                            }
                        }
                        if (this.getIsDisposed() || dependentItems.size() <= 0) break block151;
                        removableList = new ArrayList<E>();
                        if (rootCache == null) break block151;
                        for (E depenentItme : dependentItems) {
                            if (depenentItme == null) continue;
                            removableList.add(depenentItme);
                            if (removableList.size() % 100 != 0) continue;
                            try {
                                if (this.getIsDisposed()) break;
                                operationContext = new OperationContext();
                                operationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                                operationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                                rootCache.CascadedRemove(removableList.toArray(new Object[0]), ItemRemoveReason.Expired, true, operationContext);
                                if (this._context.PerfStatsColl != null) {
                                    this._context.PerfStatsColl.incrementExpiryPerSecStatsBy(removableList.size());
                                }
                            }
                            catch (Exception exc) {
                                this.getNCacheLog().Error("ExpiryManager.Expire", "an error occured while removing dependent items. Error " + exc.toString());
                            }
                            removableList.clear();
                        }
                        if (this.getIsDisposed() || removableList.size() <= 0) break block151;
                        try {
                            operationContext = new OperationContext();
                            operationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                            operationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                            rootCache.CascadedRemove(removableList.toArray(new Object[0]), ItemRemoveReason.Expired, true, operationContext);
                            if (this._context.PerfStatsColl != null) {
                                this._context.PerfStatsColl.incrementExpiryPerSecStatsBy(removableList.size());
                            }
                        }
                        catch (Exception exc) {
                            this.getNCacheLog().Error("ExpiryManager.Expire", "an error occured while removing dependent items. Error " + exc.toString());
                        }
                        removableList.clear();
                    }
                    finally {
                        this._transitoryIndex.clear();
                        removableList = this;
                        synchronized (removableList) {
                            this._cacheCleared = false;
                        }
                        if (oldeItems != null) {
                            sb = new StringBuilder();
                            ide = oldeItems.entrySet().iterator();
                            count = 1;
                            while (ide.hasNext()) {
                                pair = ide.next();
                                sb.append(pair.getKey() + ", ");
                                if (count % 10 == 0) {
                                    sb.append("\r\n");
                                    count = 1;
                                    continue;
                                }
                                ++count;
                            }
                            this.getNCacheLog().Info(sb.toString().trim());
                        }
                    }
                }
                return var19_25;
            }
            if (expire.size() > 0) {
                this._topLevelCache.CascadedRemove(expire.toArray(new Object[0]), ItemRemoveReason.DependencyChanged, true, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                this._cdbSyncMgr.FlushSyncData();
                expired = true;
            }
            if (resync.size() > 0 && this._context.getDsMgr() != null) {
                e = resync.iterator();
                while (e.hasNext()) {
                    value = e.next().toString();
                    oldEntry = cache.Get(value, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                    if (oldEntry != null) {
                        this._context.getDsMgr().ResyncCacheItemAsync(value, oldEntry.getExpirationHint(), null, oldEntry.getGroupInfo(), oldEntry.getQueryInfo(), oldEntry.getResyncProviderName());
                        continue;
                    }
                    this._context.getDsMgr().ResyncCacheItemAsync(value, oldEntry.getExpirationHint(), null, null, null, oldEntry != null ? oldEntry.getResyncProviderName() : null);
                }
            }
lbl168:
            // 5 sources

            cleanSize = (int)Math.ceil((float)cache.getCount() * this._cleanRatio);
            if (this._cacheLastAccessLoggingIntervalPassed >= this._cacheLastAccessLoggingInterval) {
                this._cacheLastAccessLoggingInterval = this.getCacheLastAccessLoggingInterval();
                this._cacheLastAccessCountEnabled = this.getIsCacheLastAccessCountEnabled();
                this._cacheLastAccessCountLoggingEnabled = this.getIsCacheLastAccessLoggingEnabled();
                this._cacheLastAccessInterval = this.getCacheLastAccessCountInterval();
            } else {
                ++this._cacheLastAccessLoggingIntervalPassed;
            }
            if (this._cacheLastAccessCountEnabled && this._cacheLastAccessCountLoggingEnabled && this._cacheLastAccessLoggingIntervalPassed >= this._cacheLastAccessLoggingInterval) {
                this._cacheLastAccessLoggingIntervalPassed = 0;
                oldeItems = new HashMap<K, V>();
            }
            expire = this._mainIndex;
            synchronized (expire) {
                em = this._mainIndex.entrySet().iterator();
                if (em != null) {
                    while (em.hasNext()) {
                        pair = em.next();
                        expirtyEntry = pair.getValue() instanceof ExpiryIndexEntry != false ? pair.getValue() : null;
                        hint = expirtyEntry.getHint();
                        if (hint != null && this._cacheLastAccessCountEnabled && hint instanceof IdleExpiration) {
                            slidingExpHint = (IdleExpiration)(hint instanceof IdleExpiration != false ? hint : null);
                            diff = TimeSpan.subtract((Date)AppUtil.GetDateTime((int)AppUtil.DiffSeconds((Date)Calendar.getInstance().getTime())), (Date)AppUtil.GetDateTime((int)slidingExpHint.getLastAccessTime()));
                            if (diff.getTotalMinutes() >= (double)this._cacheLastAccessInterval) {
                                ++oldItemsCount;
                                if (oldeItems != null) {
                                    oldeItems.put(pair.getKey(), null);
                                }
                            }
                        }
                        if (hint == null || new Integer(hint.getSortKey()).compareTo(currentTime) >= 0 || !allowExpire && hint.getIsRoutable() || !hint.DetermineExpiration(this._context)) continue;
                        if (hint.getNeedsReSync() && this._context.getDsMgr() != null) {
                            oldEntry = cache.Get(pair.getKey(), new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                            if (oldEntry != null) {
                                this._context.getDsMgr().ResyncCacheItemAsync(pair.getKey(), hint, null, oldEntry.getGroupInfo(), oldEntry.getQueryInfo(), oldEntry.getResyncProviderName());
                            } else {
                                this._context.getDsMgr().ResyncCacheItemAsync(pair.getKey(), hint, null, null, null, oldEntry != null ? oldEntry.getResyncProviderName() : null);
                            }
                        } else {
                            selectedKeys.add(pair.getKey());
                        }
                        if (cleanSize <= 0 || selectedKeys.size() != cleanSize) continue;
                        break;
                    }
                }
            }
            if (this.getNCacheLog().getIsInfoEnabled()) {
                this.getNCacheLog().Info("ExpirationManager.Expire()", String.format("Expiry time for {0}/{1} Items: " + TimeSpan.subtract((Date)NCDateTime.getUTCNow(), (Date)new Date()), new Object[]{selectedKeys.size(), cache.getCount()}));
            }
            this._context.PerfStatsColl.incrementCacheLastAccessCountStats(oldItemsCount);
            this.ApplyLoggs();
            dependentItems = new ArrayList<E>();
            removedItems = null;
            startTime = new Date();
            try {
                if (selectedKeys.size() > 0) {
                    keysTobeRemoved = new ArrayList<E>();
                    for (i = 0; i < selectedKeys.size() && !this._cacheCleared; ++i) {
                        keysTobeRemoved.add(selectedKeys.get(i));
                        if (keysTobeRemoved.size() % this._removeThreshhold != 0) continue;
                        try {
                            if (this.getIsDisposed()) break;
                            operationContext = new OperationContext();
                            operationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                            operationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                            tempVar = cache.RemoveSync(keysTobeRemoved.toArray(new Object[0]), ItemRemoveReason.Expired, false, operationContext);
                            removedItems = (ArrayList)(tempVar instanceof ArrayList != false ? tempVar : null);
                            expired = true;
                            if (this._context.PerfStatsColl != null) {
                                this._context.PerfStatsColl.incrementExpiryPerSecStatsBy(keysTobeRemoved.size());
                            }
                        }
                        catch (Exception e) {
                            this.getNCacheLog().Error("ExpiryManager.Expire", "an error occured while removing expired items. Error " + e.toString());
                        }
                        keysTobeRemoved.clear();
                        if (removedItems != null && removedItems.size() > 0) {
                            dependentItems.addAll(removedItems);
                        }
                        Thread.sleep(this._sleepInterval * 1000L);
                    }
                    if (!this.getIsDisposed() && keysTobeRemoved.size() > 0) {
                        try {
                            operationContext = new OperationContext();
                            operationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                            operationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                            tempVar2 = cache.RemoveSync(keysTobeRemoved.toArray(new Object[0]), ItemRemoveReason.Expired, false, operationContext);
                            removedItems = (ArrayList)(tempVar2 instanceof ArrayList != false ? tempVar2 : null);
                            expired = true;
                            if (this._context.PerfStatsColl != null) {
                                this._context.PerfStatsColl.incrementExpiryPerSecStatsBy(keysTobeRemoved.size());
                            }
                            if (removedItems != null && removedItems.size() > 0) {
                                dependentItems.addAll(removedItems);
                            }
                        }
                        catch (Exception e) {
                            this.getNCacheLog().Error("ExpiryManager.Expire", "an error occured while removing expired items. Error " + e.toString());
                        }
                    }
                }
                if (this.getIsDisposed() || dependentItems.size() <= 0) ** GOTO lbl548
                removableList = new ArrayList<E>();
                if (rootCache == null) ** GOTO lbl548
                for (E depenentItme : dependentItems) {
                    if (depenentItme == null) continue;
                    removableList.add(depenentItme);
                    if (removableList.size() % 100 != 0) continue;
                    try {
                        if (this.getIsDisposed()) break;
                        operationContext = new OperationContext();
                        operationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                        operationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                        rootCache.CascadedRemove(removableList.toArray(new Object[0]), ItemRemoveReason.Expired, true, operationContext);
                        if (this._context.PerfStatsColl != null) {
                            this._context.PerfStatsColl.incrementExpiryPerSecStatsBy(removableList.size());
                        }
                    }
                    catch (Exception exc) {
                        this.getNCacheLog().Error("ExpiryManager.Expire", "an error occured while removing dependent items. Error " + exc.toString());
                    }
                    removableList.clear();
                }
                if (this.getIsDisposed() || removableList.size() <= 0) ** GOTO lbl548
                try {
                    operationContext = new OperationContext();
                    operationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                    operationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                    rootCache.CascadedRemove(removableList.toArray(new Object[0]), ItemRemoveReason.Expired, true, operationContext);
                    if (this._context.PerfStatsColl != null) {
                        this._context.PerfStatsColl.incrementExpiryPerSecStatsBy(removableList.size());
                    }
                }
                catch (Exception exc) {
                    this.getNCacheLog().Error("ExpiryManager.Expire", "an error occured while removing dependent items. Error " + exc.toString());
                }
                removableList.clear();
            }
            finally {
                this._transitoryIndex.clear();
                removableList = this;
                synchronized (removableList) {
                    this._cacheCleared = false;
                }
                if (oldeItems != null) {
                    sb = new StringBuilder();
                    ide = oldeItems.entrySet().iterator();
                    count = 1;
                    while (ide.hasNext()) {
                        pair = ide.next();
                        sb.append(pair.getKey() + ", ");
                        if (count % 10 == 0) {
                            sb.append("\r\n");
                            count = 1;
                            continue;
                        }
                        ++count;
                    }
                    this.getNCacheLog().Info(sb.toString().trim());
                }
            }
            catch (Exception e) {
                this.getNCacheLog().Error("ExpirationManager.Expire(bool)", "LocalCache(Expire): " + e.toString());
                this._context.PerfStatsColl.incrementCacheLastAccessCountStats(oldItemsCount);
                this.ApplyLoggs();
                dependentItems = new ArrayList<E>();
                removedItems = null;
                startTime = new Date();
                try {
                    if (selectedKeys.size() > 0) {
                        keysTobeRemoved = new ArrayList<E>();
                        for (i = 0; i < selectedKeys.size() && !this._cacheCleared; ++i) {
                            keysTobeRemoved.add(selectedKeys.get(i));
                            if (keysTobeRemoved.size() % this._removeThreshhold != 0) continue;
                            try {
                                if (this.getIsDisposed()) break;
                                operationContext = new OperationContext();
                                operationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                                operationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                                tempVar = cache.RemoveSync(keysTobeRemoved.toArray(new Object[0]), ItemRemoveReason.Expired, false, operationContext);
                                removedItems = (ArrayList)(tempVar instanceof ArrayList != false ? tempVar : null);
                                expired = true;
                                if (this._context.PerfStatsColl != null) {
                                    this._context.PerfStatsColl.incrementExpiryPerSecStatsBy(keysTobeRemoved.size());
                                }
                            }
                            catch (Exception e) {
                                this.getNCacheLog().Error("ExpiryManager.Expire", "an error occured while removing expired items. Error " + e.toString());
                            }
                            keysTobeRemoved.clear();
                            if (removedItems != null && removedItems.size() > 0) {
                                dependentItems.addAll(removedItems);
                            }
                            Thread.sleep(this._sleepInterval * 1000L);
                        }
                        if (!this.getIsDisposed() && keysTobeRemoved.size() > 0) {
                            try {
                                operationContext = new OperationContext();
                                operationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                                operationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                                tempVar2 = cache.RemoveSync(keysTobeRemoved.toArray(new Object[0]), ItemRemoveReason.Expired, false, operationContext);
                                removedItems = (ArrayList)(tempVar2 instanceof ArrayList != false ? tempVar2 : null);
                                expired = true;
                                if (this._context.PerfStatsColl != null) {
                                    this._context.PerfStatsColl.incrementExpiryPerSecStatsBy(keysTobeRemoved.size());
                                }
                                if (removedItems != null && removedItems.size() > 0) {
                                    dependentItems.addAll(removedItems);
                                }
                            }
                            catch (Exception e) {
                                this.getNCacheLog().Error("ExpiryManager.Expire", "an error occured while removing expired items. Error " + e.toString());
                            }
                        }
                    }
                    if (this.getIsDisposed() || dependentItems.size() <= 0) break block152;
                    removableList = new ArrayList<E>();
                    if (rootCache == null) break block152;
                    for (E depenentItme : dependentItems) {
                        if (depenentItme == null) continue;
                        removableList.add(depenentItme);
                        if (removableList.size() % 100 != 0) continue;
                        try {
                            if (this.getIsDisposed()) break;
                            operationContext = new OperationContext();
                            operationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                            operationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                            rootCache.CascadedRemove(removableList.toArray(new Object[0]), ItemRemoveReason.Expired, true, operationContext);
                            if (this._context.PerfStatsColl != null) {
                                this._context.PerfStatsColl.incrementExpiryPerSecStatsBy(removableList.size());
                            }
                        }
                        catch (Exception exc) {
                            this.getNCacheLog().Error("ExpiryManager.Expire", "an error occured while removing dependent items. Error " + exc.toString());
                        }
                        removableList.clear();
                    }
                    if (this.getIsDisposed() || removableList.size() <= 0) break block152;
                    try {
                        operationContext = new OperationContext();
                        operationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                        operationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                        rootCache.CascadedRemove(removableList.toArray(new Object[0]), ItemRemoveReason.Expired, true, operationContext);
                        if (this._context.PerfStatsColl != null) {
                            this._context.PerfStatsColl.incrementExpiryPerSecStatsBy(removableList.size());
                        }
                    }
                    catch (Exception exc) {
                        this.getNCacheLog().Error("ExpiryManager.Expire", "an error occured while removing dependent items. Error " + exc.toString());
                    }
                    removableList.clear();
                    break block152;
                }
                finally {
                    this._transitoryIndex.clear();
                    removableList = this;
                    synchronized (removableList) {
                        this._cacheCleared = false;
                    }
                    if (oldeItems != null) {
                        sb = new StringBuilder();
                        ide = oldeItems.entrySet().iterator();
                        count = 1;
                        while (ide.hasNext()) {
                            pair = ide.next();
                            sb.append(pair.getKey() + ", ");
                            if (count % 10 == 0) {
                                sb.append("\r\n");
                                count = 1;
                                continue;
                            }
                            ++count;
                        }
                        this.getNCacheLog().Info(sb.toString().trim());
                    }
                }
                catch (Throwable var46_88) {
                    block153: {
                        this._context.PerfStatsColl.incrementCacheLastAccessCountStats(oldItemsCount);
                        this.ApplyLoggs();
                        dependentItems = new ArrayList<E>();
                        removedItems = null;
                        startTime = new Date();
                        try {
                            if (selectedKeys.size() > 0) {
                                keysTobeRemoved = new ArrayList<E>();
                                for (i = 0; i < selectedKeys.size() && !this._cacheCleared; ++i) {
                                    keysTobeRemoved.add(selectedKeys.get(i));
                                    if (keysTobeRemoved.size() % this._removeThreshhold != 0) continue;
                                    try {
                                        if (this.getIsDisposed()) break;
                                        operationContext = new OperationContext();
                                        operationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                                        operationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                                        tempVar = cache.RemoveSync(keysTobeRemoved.toArray(new Object[0]), ItemRemoveReason.Expired, false, operationContext);
                                        removedItems = (ArrayList)(tempVar instanceof ArrayList != false ? tempVar : null);
                                        expired = true;
                                        if (this._context.PerfStatsColl != null) {
                                            this._context.PerfStatsColl.incrementExpiryPerSecStatsBy(keysTobeRemoved.size());
                                        }
                                    }
                                    catch (Exception e) {
                                        this.getNCacheLog().Error("ExpiryManager.Expire", "an error occured while removing expired items. Error " + e.toString());
                                    }
                                    keysTobeRemoved.clear();
                                    if (removedItems != null && removedItems.size() > 0) {
                                        dependentItems.addAll(removedItems);
                                    }
                                    Thread.sleep(this._sleepInterval * 1000L);
                                }
                                if (!this.getIsDisposed() && keysTobeRemoved.size() > 0) {
                                    try {
                                        operationContext = new OperationContext();
                                        operationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                                        operationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                                        tempVar2 = cache.RemoveSync(keysTobeRemoved.toArray(new Object[0]), ItemRemoveReason.Expired, false, operationContext);
                                        removedItems = (ArrayList)(tempVar2 instanceof ArrayList != false ? tempVar2 : null);
                                        expired = true;
                                        if (this._context.PerfStatsColl != null) {
                                            this._context.PerfStatsColl.incrementExpiryPerSecStatsBy(keysTobeRemoved.size());
                                        }
                                        if (removedItems != null && removedItems.size() > 0) {
                                            dependentItems.addAll(removedItems);
                                        }
                                    }
                                    catch (Exception e) {
                                        this.getNCacheLog().Error("ExpiryManager.Expire", "an error occured while removing expired items. Error " + e.toString());
                                    }
                                }
                            }
                            if (this.getIsDisposed() || dependentItems.size() <= 0) break block153;
                            removableList = new ArrayList<E>();
                            if (rootCache == null) break block153;
                            for (E depenentItme : dependentItems) {
                                if (depenentItme == null) continue;
                                removableList.add(depenentItme);
                                if (removableList.size() % 100 != 0) continue;
                                try {
                                    if (this.getIsDisposed()) break;
                                    operationContext = new OperationContext();
                                    operationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                                    operationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                                    rootCache.CascadedRemove(removableList.toArray(new Object[0]), ItemRemoveReason.Expired, true, operationContext);
                                    if (this._context.PerfStatsColl != null) {
                                        this._context.PerfStatsColl.incrementExpiryPerSecStatsBy(removableList.size());
                                    }
                                }
                                catch (Exception exc) {
                                    this.getNCacheLog().Error("ExpiryManager.Expire", "an error occured while removing dependent items. Error " + exc.toString());
                                }
                                removableList.clear();
                            }
                            if (this.getIsDisposed() || removableList.size() <= 0) break block153;
                            try {
                                operationContext = new OperationContext();
                                operationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                                operationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                                rootCache.CascadedRemove(removableList.toArray(new Object[0]), ItemRemoveReason.Expired, true, operationContext);
                                if (this._context.PerfStatsColl != null) {
                                    this._context.PerfStatsColl.incrementExpiryPerSecStatsBy(removableList.size());
                                }
                            }
                            catch (Exception exc) {
                                this.getNCacheLog().Error("ExpiryManager.Expire", "an error occured while removing dependent items. Error " + exc.toString());
                            }
                            removableList.clear();
                        }
                        finally {
                            this._transitoryIndex.clear();
                            removableList = this;
                            synchronized (removableList) {
                                this._cacheCleared = false;
                            }
                            if (oldeItems != null) {
                                sb = new StringBuilder();
                                ide = oldeItems.entrySet().iterator();
                                count = 1;
                                while (ide.hasNext()) {
                                    pair = ide.next();
                                    sb.append(pair.getKey() + ", ");
                                    if (count % 10 == 0) {
                                        sb.append("\r\n");
                                        count = 1;
                                        continue;
                                    }
                                    ++count;
                                }
                                this.getNCacheLog().Info(sb.toString().trim());
                            }
                        }
                    }
                    throw var46_88;
                }
            }
        }
        return expired;
    }

    public final void UpdateIndex(Object key, CacheEntry entry) {
        if (entry == null || entry.getExpirationHint() == null) {
            return;
        }
        boolean hasDependentKeys = entry.getKeysDependingOnMe() != null && entry.getKeysDependingOnMe().size() > 0;
        this.UpdateIndex(key, entry.getExpirationHint(), hasDependentKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void UpdateIndex(Object key, ExpirationHint hint, boolean hasDependentKeys) {
        if (key == null || hint == null) {
            return;
        }
        Object object = this._status_mutex;
        synchronized (object) {
            if (!this.getIsInProgress()) {
                if (!this._mainIndex.containsKey(key)) {
                    this._mainIndex.put(key, new ExpiryIndexEntry(hint, hasDependentKeys));
                } else {
                    ExpiryIndexEntry expEntry = this._mainIndex.get(key) instanceof ExpiryIndexEntry ? this._mainIndex.get(key) : null;
                    if (expEntry != null) {
                        expEntry.setHint(hint);
                        expEntry.setHasDependentKeys(hasDependentKeys);
                    }
                }
            } else if (this._transitoryIndex.get(key) == null) {
                this._transitoryIndex.put(key, new ExpiryIndexEntry(hint, hasDependentKeys));
            } else {
                ExpiryIndexEntry expEntry = this._transitoryIndex.get(key) instanceof ExpiryIndexEntry ? this._transitoryIndex.get(key) : null;
                if (expEntry != null) {
                    expEntry.setHint(hint);
                    expEntry.setHasDependentKeys(hasDependentKeys);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RemoveFromIndex(Object key) {
        Object object = this._status_mutex;
        synchronized (object) {
            if (!this.getIsInProgress()) {
                this._mainIndex.remove(key);
            } else {
                this._transitoryIndex.put(key, null);
            }
        }
    }

    private void StartLogging() {
        this.setIsInProgress(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ApplyLoggs() {
        Object object = this._status_mutex;
        synchronized (object) {
            this.setIsInProgress(false);
            if (this._indexCleared) {
                this._mainIndex.clear();
                this._indexCleared = false;
            }
            for (Map.Entry pair : this._transitoryIndex.entrySet()) {
                Object key = pair.getKey();
                ExpiryIndexEntry expEntry = pair.getValue() instanceof ExpiryIndexEntry ? pair.getValue() : null;
                if (expEntry != null) {
                    this._mainIndex.put(key, expEntry);
                    continue;
                }
                this._mainIndex.remove(key);
            }
        }
    }

    private static class ExpiryIndexEntry {
        private ExpirationHint _hint;
        private boolean _hasDependentKeys;

        public ExpiryIndexEntry(ExpirationHint hint, boolean hasDependentKeys) {
            this._hint = hint;
            this._hasDependentKeys = hasDependentKeys;
        }

        public ExpiryIndexEntry(ExpirationHint hint) {
            this(hint, false);
        }

        public final boolean IsExpired(CacheRuntimeContext context) {
            if (this._hint != null) {
                return this._hint.DetermineExpiration(context);
            }
            return false;
        }

        public final boolean getHasDependentKeys() {
            return this._hasDependentKeys;
        }

        public final void setHasDependentKeys(boolean value) {
            this._hasDependentKeys = value;
        }

        public final ExpirationHint getHint() {
            return this._hint;
        }

        public final void setHint(ExpirationHint value) {
            this._hint = value;
        }
    }

    private static class AutoExpirationTask
    implements TimeScheduler.Task {
        private ExpirationManager _parent = null;
        private long _interval = 1000L;

        public AutoExpirationTask(ExpirationManager parent, long interval) {
            this._parent = parent;
            this._interval = interval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final long getInterval() {
            AutoExpirationTask autoExpirationTask = this;
            synchronized (autoExpirationTask) {
                return this._interval;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void setInterval(long value) {
            AutoExpirationTask autoExpirationTask = this;
            synchronized (autoExpirationTask) {
                this._interval = value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void Cancel() {
            AutoExpirationTask autoExpirationTask = this;
            synchronized (autoExpirationTask) {
                this._parent = null;
            }
        }

        public final boolean getIsCancelled() {
            return this._parent == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean IsCancelled() {
            AutoExpirationTask autoExpirationTask = this;
            synchronized (autoExpirationTask) {
                return this._parent == null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long GetNextInterval() {
            AutoExpirationTask autoExpirationTask = this;
            synchronized (autoExpirationTask) {
                return this._interval;
            }
        }

        public void Run() {
            if (this._parent == null) {
                return;
            }
            try {
                boolean bl = this._parent.Expire();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

