/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.AutoExpiration;

import Alachisoft.NCache.Common.AppUtil;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.util.Date;

public class LockExpiration
implements ICompactSerializable {
    private long _lastTimeStamp;
    private long _lockTTL;
    private TimeSpan _ttl = new TimeSpan();

    public LockExpiration() {
    }

    public LockExpiration(TimeSpan lockTimeout) {
        this._ttl = lockTimeout;
    }

    public final void Set() {
        this._lockTTL = this._ttl.getTotalTicks();
        try {
            this._lastTimeStamp = AppUtil.DiffTicks((Date)new Date());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private long getSortKey() {
        return this._lastTimeStamp + this._lockTTL;
    }

    public final boolean HasExpired() {
        try {
            if (new Long(this.getSortKey()).compareTo(AppUtil.DiffTicks((Date)new Date())) < 0) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    public final void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        this._lockTTL = reader.readLong();
        this._lastTimeStamp = reader.readLong();
        this._ttl = (TimeSpan)reader.readObject();
    }

    public final void serialize(NCacheObjectOutput writer) throws IOException {
        writer.writeLong(this._lockTTL);
        writer.writeLong(this._lastTimeStamp);
        writer.writeObject((Object)this._ttl);
    }
}

