/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.AutoExpiration;

import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHintType;
import Alachisoft.NCache.Caching.AutoExpiration.OracleCommandParams;
import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Caching.CallbackEntry;
import Alachisoft.NCache.Caching.ItemRemoveReason;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Caching.Util.DbConnectionPool;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Threading.Monitor;
import com.alachisoft.ncache.common.protobuf.DependencyProtocol;
import com.alachisoft.ncache.runtime.dependencies.CommandType;
import com.alachisoft.ncache.runtime.dependencies.OracleCmdParamsType;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleStatement;
import oracle.jdbc.dcn.DatabaseChangeEvent;
import oracle.jdbc.dcn.DatabaseChangeListener;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.dcn.RowChangeDescription;
import oracle.jdbc.dcn.TableChangeDescription;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class NotificationBasedDependencyManager {
    private HashMap _listeners;
    private HashMap _silentListeners;
    private CacheRuntimeContext _context;
    private DbConnectionPool _dbConPool;
    private HashMap _dependencyTable = new HashMap();
    private AsyncOnDepenencyChange _asyncDepChange;

    public NotificationBasedDependencyManager(CacheRuntimeContext context) {
        this._context = context;
        this._listeners = new HashMap();
        this._silentListeners = new HashMap();
        this._dbConPool = new DbConnectionPool(this._context.getNCacheLog());
        this._asyncDepChange = new AsyncOnDepenencyChange(this);
        this._asyncDepChange.Start();
    }

    public final AsyncOnDepenencyChange getAsyncOnDependencyChange() {
        return this._asyncDepChange;
    }

    public final HashMap getNotifBasedDependencyListeners() {
        return this._listeners;
    }

    public final HashMap getSilentListeners() {
        return this._silentListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean Add(String key, String connString, String queryString, boolean doInitialize, ExpirationHintType hintType) throws SQLException, Exception {
        DependencyListener listener = null;
        if (this._context.IsClientCache) {
            return true;
        }
        if (hintType == ExpirationHintType.OracleCacheDependency) {
            listener = new OracleDependencyListener(key, connString, queryString, this._context, hintType);
        }
        if (doInitialize) {
            listener.Initialize();
            HashMap hashMap = this._listeners;
            synchronized (hashMap) {
                if (!this._listeners.containsKey(listener.getCacheKey())) {
                    this._listeners.put(listener.getCacheKey(), listener);
                } else {
                    DependencyListener depLisner = this._listeners.get(listener.getCacheKey()) instanceof DependencyListener ? this._listeners.get(listener.getCacheKey()) : null;
                    if (depLisner != null) {
                        depLisner.Stop();
                    }
                    this._listeners.put(listener.getCacheKey(), listener);
                }
            }
        }
        HashMap hashMap = this._silentListeners;
        synchronized (hashMap) {
            this._silentListeners.put(listener.getCacheKey(), listener);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean Add(String key, String connString, String queryString, boolean doInitialize, ExpirationHintType hintType, CommandType cmdType, LinkedHashMap cmdParams) throws SQLException, Exception {
        DependencyListener listener = null;
        if (hintType == ExpirationHintType.OracleCacheDependency) {
            listener = new OracleDependencyListener(key, connString, queryString, this._context, hintType, cmdType, cmdParams);
        }
        if (doInitialize) {
            listener.Initialize();
            HashMap hashMap = this._listeners;
            synchronized (hashMap) {
                if (!this._listeners.containsKey(listener.getCacheKey())) {
                    ArrayList<DependencyListener> _dblistner = new ArrayList<DependencyListener>();
                    _dblistner.add(listener);
                    this._listeners.put(listener.getCacheKey(), _dblistner);
                } else {
                    ArrayList _dblistner = (ArrayList)this._listeners.get(listener.getCacheKey());
                    _dblistner.add(listener);
                    this._listeners.put(listener.getCacheKey(), _dblistner);
                }
            }
        }
        HashMap hashMap = this._silentListeners;
        synchronized (hashMap) {
            this._silentListeners.put(listener.getCacheKey(), listener);
        }
        return true;
    }

    public final boolean Contains(String key) {
        return this._listeners.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Remove(String key) {
        ArrayList _dblistner = (ArrayList)this._listeners.get(key);
        HashMap hashMap = this._listeners;
        synchronized (hashMap) {
            DependencyListener depLisner;
            if (_dblistner != null) {
                for (int i = 0; i < _dblistner.size(); ++i) {
                    Object tempVar = _dblistner.get(i);
                    DependencyListener dependencyListener = depLisner = tempVar instanceof DependencyListener ? (DependencyListener)tempVar : null;
                    if (depLisner == null) continue;
                    depLisner.Stop();
                }
            }
            this._listeners.remove(key);
            depLisner = null;
        }
        hashMap = this._silentListeners;
        synchronized (hashMap) {
            DependencyListener listener = (DependencyListener)this._silentListeners.get(key);
            if (listener != null) {
                this._silentListeners.remove(key);
                listener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RemoveWithoutStop(String key) {
        HashMap hashMap = this._listeners;
        synchronized (hashMap) {
            DependencyListener listener = (DependencyListener)this._listeners.get(key);
            if (listener != null) {
                this._listeners.remove(key);
                listener = null;
            }
        }
        hashMap = this._silentListeners;
        synchronized (hashMap) {
            ArrayList _dblistner = (ArrayList)this._listeners.get(key);
            if (_dblistner != null) {
                this._listeners.remove(key);
                Object var3_3 = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Clear() {
        HashMap hashMap = this._listeners;
        synchronized (hashMap) {
            for (Map.Entry entry : this._listeners.entrySet()) {
                ArrayList _dblistner = (ArrayList)entry.getValue();
                if (_dblistner != null) {
                    for (int i = 0; i < _dblistner.size(); ++i) {
                        DependencyListener depLisner;
                        Object tempVar = _dblistner.get(i);
                        DependencyListener dependencyListener = depLisner = tempVar instanceof DependencyListener ? (DependencyListener)tempVar : null;
                        if (depLisner == null) continue;
                        depLisner.Stop();
                    }
                }
                Object var5_5 = null;
            }
            this._listeners.clear();
        }
        this._silentListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ActivateSilentListeners() {
        HashMap hashMap = this._listeners;
        synchronized (hashMap) {
            block10: {
                try {
                    for (Map.Entry value : this._silentListeners.entrySet()) {
                        DependencyListener listener = (DependencyListener)value.getValue();
                        listener.Initialize();
                        HashMap hashMap2 = this._listeners;
                        synchronized (hashMap2) {
                            this._listeners.put(listener.getCacheKey(), listener);
                        }
                    }
                    this._silentListeners.clear();
                }
                catch (Exception e) {
                    if (!this._context.getNCacheLog().getIsErrorEnabled()) break block10;
                    this._context.getNCacheLog().Error("YukonDependencyManager", "silent Listeners Activated. Listeners: " + this._listeners.size() + " SilentListeners: " + this._silentListeners.size());
                }
            }
        }
        if (this._context.getNCacheLog().getIsErrorEnabled()) {
            this._context.getNCacheLog().Error("YukonDependencyManager", "silent Listeners Activated. Listeners: " + this._listeners.size() + " SilentListeners: " + this._silentListeners.size());
        }
    }

    public final Connection AddToDbConnectionPool(String connectionString, Connection poolConnection) throws SQLException {
        return this._dbConPool.PoolConnection(connectionString, poolConnection);
    }

    public final void RemoveFromDbConnectionPool(String connectionString, boolean isConnectionInvalid) {
        if (isConnectionInvalid) {
            this._dbConPool.RemoveSeveredConnection(connectionString);
        } else {
            this._dbConPool.RemoveConnection(connectionString);
        }
    }

    public final void RemoveFromDbConnectionPool(String connectionString) {
        this._dbConPool.RemoveConnection(connectionString);
    }

    public void dispose(boolean graceful) {
        this.Clear();
        if (this._dbConPool != null) {
            this._dbConPool.dispose();
        }
        if (this._asyncDepChange != null) {
            this._asyncDepChange.Stop(graceful);
        }
    }

    private static final class OracleDependencyListener
    extends DependencyListener
    implements DatabaseChangeListener {
        private DependencyProtocol.OracleDependency _oracleDep = null;
        private ArrayList _rowids = new ArrayList(1);
        private Map _cmdParams;
        private CommandType _cmdType;
        private DatabaseChangeRegistration dcr;

        public OracleDependencyListener(String key, String connString, String queryString, CacheRuntimeContext context, ExpirationHintType hintType) {
            super(key, connString, queryString, context, hintType);
        }

        public OracleDependencyListener(String key, String connString, String queryString, CacheRuntimeContext context, ExpirationHintType hintType, CommandType cmdType, LinkedHashMap cmdParams) {
            super(key, connString, queryString, context, hintType);
            this._cmdParams = cmdParams;
            this._cmdType = cmdType;
        }

        @Override
        public boolean Initialize() throws SQLException, Exception {
            block10: {
                Statement statement = null;
                Connection connection = null;
                Connection conn = null;
                Object orcl = null;
                Object callStmt = null;
                try {
                    connection = this._notifBasedDepManager.AddToDbConnectionPool(this._connString, conn);
                    Properties props = new Properties();
                    props.setProperty("DCN_NOTIFY_ROWIDS", "true");
                    props.setProperty("DCN_QUERY_CHANGE_NOTIFICATION", "true");
                    this.dcr = ((OracleConnection)connection).registerDatabaseChangeNotification(props);
                    this.dcr.addListener((DatabaseChangeListener)this);
                    statement = this.createStatement(connection);
                }
                catch (Exception ex) {
                    throw new SQLException(ex);
                }
                if (statement != null) {
                    try {
                        this.RegisterNotification(statement);
                        return true;
                    }
                    catch (SQLException sqlex) {
                        throw sqlex;
                    }
                    catch (Exception ex) {
                        try {
                            this.getNCacheLog().Error("NotificationBasedDependencyManager.OracleDependencyListener: " + ex.toString());
                            connection.close();
                            this._notifBasedDepManager.RemoveFromDbConnectionPool(this._connString, true);
                            connection = this._notifBasedDepManager.AddToDbConnectionPool(this._connString, conn);
                            if (statement == null) break block10;
                            try {
                                statement.close();
                                connection.close();
                            }
                            catch (Exception e) {
                                this._notifBasedDepManager.RemoveFromDbConnectionPool(this._connString);
                                connection.close();
                                throw e;
                            }
                        }
                        catch (SQLException sqlex) {
                            Logger.getLogger(NotificationBasedDependencyManager.class.getName()).log(Level.SEVERE, null, sqlex);
                            throw sqlex;
                        }
                    }
                }
            }
            return false;
        }

        private Statement createStatement(Connection connection) throws SQLException {
            if (this._cmdType == CommandType.StoredProcedure) {
                Object arg = "(";
                for (int i = 1; i <= this._cmdParams.size(); ++i) {
                    arg = (String)arg + "?";
                    if (this._cmdParams.size() <= i) continue;
                    arg = (String)arg + ",";
                }
                arg = (String)arg + ")";
                String sp = "{call " + this._queryString + (String)arg + "}";
                CallableStatement statement = connection.prepareCall(sp);
                if (this._cmdParams != null && this._cmdParams.size() > 0) {
                    for (Map.Entry val : this._cmdParams.entrySet()) {
                        OracleCommandParams param = (OracleCommandParams)val.getValue();
                        switch (param.getDirection()) {
                            case 1: {
                                statement.registerOutParameter(val.getKey().toString(), param.getType().getValue());
                                break;
                            }
                            case 0: {
                                statement.setObject(val.getKey().toString(), param.getValue());
                            }
                        }
                    }
                }
                return statement;
            }
            return connection.createStatement();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void RegisterNotification(Statement oraclelCmd) throws SQLException {
            ResultSet reader = null;
            try {
                ((OracleStatement)oraclelCmd).setDatabaseChangeRegistration(this.dcr);
                try {
                    if (oraclelCmd != null && oraclelCmd instanceof CallableStatement) {
                        ((CallableStatement)oraclelCmd).executeQuery();
                    } else {
                        reader = oraclelCmd.executeQuery(this._queryString);
                        this._rowids.clear();
                        while (reader.next()) {
                        }
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (SQLException e) {
                    this.getNCacheLog().Error(e.getMessage());
                    throw e;
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (oraclelCmd != null) {
                    oraclelCmd.close();
                }
            }
        }

        private void registerInputParameter(String parameterName, OracleCmdParamsType type, Object valObject, CallableStatement stat) {
            try {
                switch (type) {
                    case BFile: {
                        stat.setBinaryStream(parameterName, (InputStream)valObject);
                        break;
                    }
                    case Blob: {
                        stat.setBlob(parameterName, (Blob)((BLOB)valObject));
                        break;
                    }
                    case Byte: {
                        stat.setByte(parameterName, (byte)((Byte)valObject));
                        break;
                    }
                    case Char: {
                        stat.setCharacterStream(parameterName, (Reader)valObject);
                        break;
                    }
                    case Clob: {
                        stat.setClob(parameterName, (Clob)((CLOB)valObject));
                        break;
                    }
                    case Date: {
                        stat.setDate(parameterName, (Date)valObject);
                        break;
                    }
                    case Decimal: {
                        stat.setFloat(parameterName, ((Float)valObject).floatValue());
                        break;
                    }
                    case Double: {
                        stat.setDouble(parameterName, (double)((Double)valObject));
                        break;
                    }
                    case Int16: {
                        stat.setInt(parameterName, Integer.parseInt(valObject.toString()));
                        break;
                    }
                    case Int32: {
                        stat.setInt(parameterName, Integer.parseInt(valObject.toString()));
                        break;
                    }
                    case Int64: {
                        stat.setInt(parameterName, Integer.parseInt(valObject.toString()));
                        break;
                    }
                    case IntervalDS: {
                        stat.setObject(parameterName, valObject);
                        break;
                    }
                    case IntervalYM: {
                        stat.setObject(parameterName, valObject);
                        break;
                    }
                    case Long: {
                        stat.setLong(parameterName, (long)((Long)valObject));
                        break;
                    }
                    case LongRaw: {
                        stat.setObject(parameterName, valObject);
                        break;
                    }
                    case NChar: {
                        stat.setNCharacterStream(parameterName, (Reader)valObject);
                        break;
                    }
                    case NClob: {
                        stat.setNClob(parameterName, (NClob)valObject);
                        break;
                    }
                    case NVarchar2: {
                        stat.setObject(parameterName, valObject);
                        break;
                    }
                    case Raw: {
                        stat.setObject(parameterName, valObject);
                        break;
                    }
                    case RefCursor: {
                        stat.setCursorName(valObject.toString());
                        break;
                    }
                    case Single: {
                        stat.setFloat(parameterName, ((Float)valObject).floatValue());
                        break;
                    }
                    case TimeStamp: {
                        stat.setTimestamp(parameterName, (Timestamp)valObject);
                        break;
                    }
                    case TimeStampLTZ: {
                        stat.setTimestamp(parameterName, (Timestamp)valObject);
                        break;
                    }
                    case TimeStampTZ: {
                        stat.setTimestamp(parameterName, (Timestamp)valObject);
                        break;
                    }
                    case Varchar2: {
                        stat.setObject(parameterName, valObject);
                        break;
                    }
                    case XmlType: {
                        stat.setSQLXML(parameterName, (SQLXML)valObject);
                        break;
                    }
                    default: {
                        stat.setCharacterStream(parameterName, (Reader)valObject);
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.getNCacheLog().DevTrace(e.getMessage());
            }
        }

        private boolean Contains(TableChangeDescription[] tblChange) {
            for (TableChangeDescription table : tblChange) {
                RowChangeDescription[] rowChangeDesc;
                for (RowChangeDescription row : rowChangeDesc = table.getRowChangeDescription()) {
                    if (!this._rowids.contains(row.getRowid().stringValue())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void Stop() {
            try {
                OracleConnection connection = (OracleConnection)this._notifBasedDepManager._dbConPool.GetConnection(this._connString);
                if (connection != null) {
                    connection.unregisterDatabaseChangeNotification(this.dcr);
                }
                this._rowids.clear();
            }
            catch (UnsupportedOperationException connection) {
            }
            catch (Exception exc) {
                this.getNCacheLog().Error("NotificationBasedDependencyManager.OracleDependencyListener", exc.toString());
            }
            finally {
                super.Stop();
            }
        }

        public int hashCode() {
            return this._cacheKey.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof OracleDependencyListener) {
                boolean key = this._cacheKey.equals(((OracleDependencyListener)obj)._cacheKey);
                boolean conn = this._connString.equals(((OracleDependencyListener)obj)._connString);
                boolean query = this._queryString.equals(((OracleDependencyListener)obj)._queryString);
                if (key && conn && query) {
                    return true;
                }
            }
            return false;
        }

        public void onDatabaseChangeNotification(DatabaseChangeEvent dce) {
            TableChangeDescription[] tblChange = dce.getTableChangeDescription();
            if (dce.getEventType() != DatabaseChangeEvent.EventType.STARTUP) {
                super.OnDependencyChanged(dce.getEventType() == DatabaseChangeEvent.EventType.QUERYCHANGE || dce.getEventType() == DatabaseChangeEvent.EventType.OBJCHANGE, dce.getEventType() == DatabaseChangeEvent.EventType.SHUTDOWN, dce.getEventType() == DatabaseChangeEvent.EventType.DEREG, false);
            }
        }
    }

    public static class AsyncOnDepenencyChange {
        private boolean _isThreadStopped = true;
        private Thread _dependencyChangeThread;
        private boolean _trimToSize = false;
        private NotificationBasedDependencyManager _notificationManager;
        private LinkedList _queue;

        public AsyncOnDepenencyChange(NotificationBasedDependencyManager notif) {
            this._notificationManager = notif;
        }

        public final LinkedList getQueue() {
            return this._queue;
        }

        public final void Start() {
            if (this._isThreadStopped) {
                this._queue = new LinkedList();
                this._isThreadStopped = false;
                this._dependencyChangeThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        this.Run();
                    }
                });
                this._dependencyChangeThread.setName("AsyncOnDepenencyChange.Run");
                this._dependencyChangeThread.setDaemon(true);
                this._dependencyChangeThread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void Stop(boolean graceFullStop) {
            this._isThreadStopped = true;
            if (this._dependencyChangeThread != null && this._dependencyChangeThread.isAlive()) {
                LinkedList linkedList = this.getQueue();
                synchronized (linkedList) {
                    this._queue.clear();
                    Monitor.pulse((Object)this.getQueue());
                }
                if (graceFullStop) {
                    try {
                        this._dependencyChangeThread.join(5000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(NotificationBasedDependencyManager.class.getName()).log(Level.SEVERE, null, ex);
                        return;
                    }
                    try {
                        if (this._dependencyChangeThread.isAlive()) {
                            this._dependencyChangeThread.stop();
                            this._dependencyChangeThread.interrupt();
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        if (this._dependencyChangeThread.isAlive()) {
                            this._dependencyChangeThread.stop();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void Run() {
            while (this._isThreadStopped && !Thread.currentThread().isInterrupted()) {
                LinkedList linkedList = this.getQueue();
                synchronized (linkedList) {
                    if (this.getQueue().isEmpty()) {
                        try {
                            Monitor.wait((Object)this.getQueue(), (long)3000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(NotificationBasedDependencyManager.class.getName()).log(Level.SEVERE, null, ex);
                            return;
                        }
                    }
                    if (this.getQueue().isEmpty()) {
                        if (!this._trimToSize) {
                            continue;
                        }
                        this.getQueue().size();
                        this._trimToSize = false;
                        continue;
                    }
                    if (this.getQueue().size() > 100) {
                        this._trimToSize = true;
                    }
                }
                DependencyListnerInformation instance = null;
                LinkedList ex = this.getQueue();
                synchronized (ex) {
                    Object tempVar = this.getQueue().poll();
                    instance = (DependencyListnerInformation)(tempVar instanceof DependencyListnerInformation ? tempVar : null);
                    if (instance == null) {
                        continue;
                    }
                }
                try {
                    Object tempVar2;
                    CallbackEntry cbEtnry;
                    Serializable ent;
                    CacheEntry entry;
                    DependencyListener depListner = instance.getListner();
                    if (instance.getisChanged() || instance.getisRestart() || instance.getisError()) {
                        if (this._notificationManager._context.getCacheImpl() == null) continue;
                        entry = this._notificationManager._context.getCacheImpl().Get(instance.getCacheKey(), new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                        if (entry != null && entry.getExpirationHint() != null && entry.getExpirationHint().getNeedsReSync() && this._notificationManager._context.getDsMgr() != null) {
                            this._notificationManager._context.getDsMgr().ResyncCacheItemAsync(instance.getCacheKey(), entry.getExpirationHint(), null, entry.getGroupInfo(), entry.getQueryInfo(), entry.getResyncProviderName());
                        } else {
                            if (instance.getisRestart()) {
                                this._notificationManager._context.getNCacheLog().Info("Database Service reset/shutdown");
                            }
                            this._notificationManager._context.getNCacheLog().Info("DependencyListener.OnDependencyChanged", String.format("Removing %1$s ", instance.getCacheKey()));
                            ent = this._notificationManager._context.getCacheImpl().Remove(instance.getCacheKey(), ItemRemoveReason.DependencyChanged, true, null, 0L, LockAccessType.IGNORE_LOCK, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                            if (ent != null) {
                                this._notificationManager._context.getCacheImpl().RemoveCascadingDependencies(instance.getCacheKey(), (CacheEntry)ent, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                            }
                        }
                        ent = ((NotificationBasedDependencyManager)this._notificationManager)._context.ExpiryMgr.getNotifBasedDepManager().getNotifBasedDependencyListeners();
                        synchronized (ent) {
                            ((NotificationBasedDependencyManager)this._notificationManager)._context.ExpiryMgr.getNotifBasedDepManager().Remove(instance.getCacheKey());
                            continue;
                        }
                    }
                    if (!instance.getisInvalid() || this._notificationManager._context.getCacheImpl() == null) continue;
                    entry = this._notificationManager._context.getCacheImpl().Get(instance.getCacheKey(), new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                    this._notificationManager._context.getNCacheLog().Error("DependencyListener.OnDependencyChanged", String.format("Removing %1$s because SQLDependency cannot be registered SqlNotificationEventArgs.Info is returned with Invalid status", instance.getCacheKey()));
                    ent = this._notificationManager._context.getCacheImpl().Remove(instance.getCacheKey(), ItemRemoveReason.DependencyInvalid, true, null, 0L, LockAccessType.IGNORE_LOCK, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                    if (ent != null) {
                        this._notificationManager._context.getCacheImpl().RemoveCascadingDependencies(instance.getCacheKey(), (CacheEntry)ent, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                    }
                    if (ent != null && ((CacheEntry)ent).getValue() instanceof CallbackEntry && (cbEtnry = (CallbackEntry)((tempVar2 = ((CacheEntry)ent).getValue()) instanceof CallbackEntry ? tempVar2 : null)) != null && cbEtnry.getItemRemoveCallbackListener() != null && cbEtnry.getItemRemoveCallbackListener().size() > 0) {
                        this._notificationManager._context.getCacheInternal().NotifyCustomRemoveCallback(instance.getCacheKey(), cbEtnry, ItemRemoveReason.DependencyInvalid, true, null, null);
                    }
                    HashMap hashMap = ((NotificationBasedDependencyManager)this._notificationManager)._context.ExpiryMgr.getNotifBasedDepManager().getNotifBasedDependencyListeners();
                    synchronized (hashMap) {
                        ((NotificationBasedDependencyManager)this._notificationManager)._context.ExpiryMgr.getNotifBasedDepManager().Remove(instance.getCacheKey());
                    }
                }
                catch (Exception exception) {
                    this._notificationManager._context.getNCacheLog().Error("DependencyListener.OnDependencyChanged", exception.toString());
                }
            }
        }
    }

    public static class DependencyListnerInformation {
        private DependencyListener _listner;
        private String _cacheKey;
        private boolean _change;
        private boolean _restart;
        private boolean _error;
        private boolean _invalid;
        private NotificationBasedDependencyManager _notifBasedDepManager;

        public DependencyListnerInformation(String cacheKey, boolean change, boolean restart, boolean error, boolean invalid, DependencyListener listner) {
            this._cacheKey = cacheKey;
            this._change = change;
            this._restart = restart;
            this._invalid = invalid;
            this._error = error;
            this._listner = listner;
        }

        public final DependencyListener getListner() {
            return this._listner;
        }

        public final void setListner(DependencyListener value) {
            this._listner = value;
        }

        public final String getCacheKey() {
            return this._cacheKey;
        }

        public final void setCacheKey(String value) {
            this._cacheKey = value;
        }

        public final boolean getisChanged() {
            return this._change;
        }

        public final void setisChanged(boolean value) {
            this._change = value;
        }

        public final boolean getisRestart() {
            return this._restart;
        }

        public final void setisRestart(boolean value) {
            this._restart = value;
        }

        public final boolean getisError() {
            return this._error;
        }

        public final void setisError(boolean value) {
            this._error = value;
        }

        public final boolean getisInvalid() {
            return this._invalid;
        }

        public final void setisInvalid(boolean value) {
            this._invalid = value;
        }

        public final NotificationBasedDependencyManager getNotifBasedDepManager() {
            return this._notifBasedDepManager;
        }

        public final void setNotifBasedDepManager(NotificationBasedDependencyManager value) {
            this._notifBasedDepManager = value;
        }
    }

    public static class DependencyListener
    implements IDisposable {
        protected NotificationBasedDependencyManager _notifBasedDepManager = null;
        protected CacheRuntimeContext _context;
        protected String _cacheKey;
        protected String _connString;
        protected String _queryString;
        protected ExpirationHintType _hintType = ExpirationHintType.values()[0];
        protected ILogger _ncacheLog;
        private Object _syncLock = new Object();

        protected DependencyListener(String key, String connString, String queryString, CacheRuntimeContext context, ExpirationHintType hintType) {
            this._cacheKey = key;
            this._context = context;
            this._connString = connString;
            this._queryString = queryString;
            this._notifBasedDepManager = this._context.ExpiryMgr.getNotifBasedDepManager();
            this._hintType = hintType;
            this._ncacheLog = context.getNCacheLog();
        }

        protected final ILogger getNCacheLog() {
            return this._ncacheLog;
        }

        public final ExpirationHintType getExpHintType() {
            return this._hintType;
        }

        public final String getConnString() {
            return this._connString;
        }

        public final String getQueryString() {
            return this._queryString;
        }

        public final String getCacheKey() {
            return this._cacheKey;
        }

        public boolean Initialize() throws SQLException, Exception {
            return false;
        }

        public void Stop() {
            this._notifBasedDepManager.RemoveFromDbConnectionPool(this._connString);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void OnDependencyChanged(boolean changed, boolean restart, boolean error, boolean invalid) {
            LinkedList linkedList = this._notifBasedDepManager.getAsyncOnDependencyChange().getQueue();
            synchronized (linkedList) {
                this._notifBasedDepManager.getAsyncOnDependencyChange().getQueue().offer(new DependencyListnerInformation(this._cacheKey, changed, restart, error, invalid, this));
                Monitor.pulse((Object)this._notifBasedDepManager.getAsyncOnDependencyChange().getQueue());
            }
        }

        public final void dispose() {
            this.Stop();
        }
    }
}

