/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.AutoExpiration;

import Alachisoft.NCache.Caching.AutoExpiration.CacheDbSyncManager;
import Alachisoft.NCache.Caching.AutoExpiration.DependencyHint;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHintType;
import Alachisoft.NCache.Caching.AutoExpiration.NotificationBasedDependencyManager;
import Alachisoft.NCache.Caching.AutoExpiration.OracleCommandParams;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import com.alachisoft.ncache.runtime.dependencies.CommandType;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

public class OracleCacheDependency
extends DependencyHint
implements ICompactSerializable {
    private transient CacheDbSyncManager _cdbSyncManager = null;
    private transient NotificationBasedDependencyManager _notifBasedDepManager = null;
    private LinkedHashMap _cmdParams;
    private CommandType _cmdType = CommandType.Text;
    private String _conStr;
    private String _queryStr;

    public OracleCacheDependency() {
        this._hintType = ExpirationHintType.OracleCacheDependency;
    }

    public OracleCacheDependency(String conStr, String queryStr) {
        this(conStr, queryStr, CommandType.Text, new LinkedHashMap());
    }

    public OracleCacheDependency(String conStr, String queryStr, CommandType cmdType, LinkedHashMap cmdParams) {
        this._hintType = ExpirationHintType.OracleCacheDependency;
        if (conStr == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: connectionString");
        }
        if (queryStr == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: querystring");
        }
        this._conStr = conStr;
        this._queryStr = queryStr;
        this._cmdType = cmdType;
        this._cmdParams = cmdParams;
    }

    public final CommandType getCommandType() {
        return this._cmdType;
    }

    public final String getConnectionString() {
        return this._conStr;
    }

    public final String getQueryString() {
        return this._queryStr;
    }

    public final Map getCommandParams() {
        return this._cmdParams;
    }

    @Override
    public boolean Reset(CacheRuntimeContext context) throws OperationFailedException {
        try {
            if (context.IsClientCache) {
                return true;
            }
            super.Reset(context);
            this._cdbSyncManager = context.ExpiryMgr.getCacheDbSyncManager();
            this._notifBasedDepManager = context.ExpiryMgr.getNotifBasedDepManager();
            if (this._notifBasedDepManager != null) {
                return this._notifBasedDepManager.Add(this.getCacheKey(), this._conStr, this._queryStr, context.getIsDbSyncCoordinator() && !context.getIsBridgeTargetCache(), this._hintType, this._cmdType, this._cmdParams);
            }
            return false;
        }
        catch (SQLException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean DetermineExpiration(CacheRuntimeContext context) {
        return false;
    }

    @Override
    public boolean getHasChanged() {
        return false;
    }

    @Override
    protected void DisposeInternal() {
        if (this._cdbSyncManager != null) {
            this._cdbSyncManager.RemoveFromSqlConnectionPool(this._conStr);
        }
        if (this._notifBasedDepManager != null) {
            this._notifBasedDepManager.Remove(this.getCacheKey());
        }
    }

    private String GetParametersString() {
        if (this._cmdParams == null || this._cmdParams.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry val : this._cmdParams.entrySet()) {
            sb.append("\"" + val.getKey() + "\"");
            sb.append((OracleCommandParams)val.getValue()).toString();
        }
        return sb.toString();
    }

    private int CommandTypeToInt() {
        return this._cmdType.ordinal();
    }

    public String toString() {
        String cmdParametersString = this.GetParametersString();
        return "ORACLEDEPENDENCY \"" + this._conStr + "\"" + this._queryStr + "\"" + new Integer(this.CommandTypeToInt()).toString() + "\"" + (String)(!cmdParametersString.equals("") ? "$cmd-params$" + this.GetParametersString() : "") + "\"\r\n";
    }

    @Override
    public void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        super.deserialize(reader);
        Object tempVar = reader.readObject();
        this._conStr = (String)(tempVar instanceof String ? tempVar : null);
        tempVar = reader.readObject();
        this._queryStr = (String)(tempVar instanceof String ? tempVar : null);
        tempVar = reader.readObject();
        this._cmdType = (CommandType)(tempVar instanceof CommandType ? tempVar : null);
        this._cmdParams = new LinkedHashMap();
        int len = reader.readInt();
        for (int i = 0; i < len; ++i) {
            String key = (String)reader.readObject();
            OracleCommandParams Value = (OracleCommandParams)reader.readObject();
            this._cmdParams.put(key, Value);
        }
        tempVar = reader.readObject();
        this.setCacheKey((String)(tempVar instanceof String ? tempVar : null));
    }

    @Override
    public void serialize(NCacheObjectOutput writer) throws IOException {
        super.serialize(writer);
        writer.writeObject((Object)this._conStr);
        writer.writeObject((Object)this._queryStr);
        writer.writeObject((Object)this._cmdType);
        int len = this._cmdParams.size();
        writer.writeInt(len);
        if (len > 0) {
            for (Map.Entry pair : this._cmdParams.entrySet()) {
                writer.writeObject(pair.getKey());
                writer.writeObject(pair.getValue());
            }
        }
        writer.writeObject((Object)this.getCacheKey());
    }
}

