/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Bridge;

import Alachisoft.NCache.Caching.Bridge.BridgeConflictResolver;
import Alachisoft.NCache.Caching.Bridge.BridgeOperationsHistoryMgr;
import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Caching.CallbackEntry;
import Alachisoft.NCache.Common.AppUtil;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.CompressionUtil;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Util.AuthenticateFeature;
import Alachisoft.NCache.Common.Util.LanguageContext;
import com.alachisoft.ncache.runtime.bridge.BridgeItemOpCodes;
import com.alachisoft.ncache.runtime.bridge.BridgeItemVersion;
import com.alachisoft.ncache.runtime.bridge.ConflictResolution;
import com.alachisoft.ncache.runtime.bridge.ProviderBridgeItem;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.serialization.util.SerializationBitSet;
import com.alachisoft.ncache.serialization.util.SerializationUtil;
import com.alachisoft.ncache.serialization.util.TypeInfoMap;
import java.util.HashMap;
import java.util.Map;

public class BridgeConflictResolutionMgr
implements IDisposable {
    private BridgeConflictResolver _bridgeConflictResolver;
    private String _cacheName;
    private BridgeOperationsHistoryMgr _bridgeOpHistoryMgr;
    private boolean _isDeserializeValue = false;
    private LanguageContext _languageContext = LanguageContext.NONE;
    private boolean _isEnabled = false;

    public BridgeConflictResolutionMgr(CacheRuntimeContext context) {
        this._bridgeConflictResolver = new BridgeConflictResolver();
        this._bridgeOpHistoryMgr = new BridgeOperationsHistoryMgr(context.getNCacheLog(), context.TimeSched);
    }

    public BridgeConflictResolutionMgr(CacheRuntimeContext context, Map properties) throws ConfigurationException {
        this._cacheName = context.getCacheRoot().getName();
        this.Initialize(properties, context);
    }

    private final String getCacheId() {
        return this._cacheName;
    }

    private final boolean getIsDeserializeValue() {
        return this._isDeserializeValue;
    }

    private final BridgeOperationsHistoryMgr getBridgeOpHistoryMgr() {
        return this._bridgeOpHistoryMgr;
    }

    public final void dispose() {
    }

    private void Initialize(Map properties, CacheRuntimeContext context) throws ConfigurationException {
        if (properties == null) {
            throw new IllegalArgumentException("properties");
        }
        try {
            if (!properties.containsKey("assembly-name")) {
                throw new ConfigurationException("Missing assembly name for conflict-resolver option");
            }
            if (!properties.containsKey("class-name")) {
                throw new ConfigurationException("Missing class name for conflict-resolver option");
            }
            if (!properties.containsKey("enabled")) {
                throw new ConfigurationException("Missing enabled/Disabled flag for conflict-resolver option");
            }
            if (!properties.containsKey("deserialize")) {
                throw new ConfigurationException("Missing deserialize value flag for conflict-resolver option");
            }
            String assembly = String.valueOf(properties.get("assembly-name"));
            String classname = String.valueOf(properties.get("class-name"));
            String assemblyFullName = String.valueOf(properties.get("full-name"));
            this._isEnabled = Boolean.parseBoolean(properties.get("enabled").toString());
            this._isDeserializeValue = Boolean.parseBoolean(properties.get("deserialize").toString());
            HashMap startupparams = properties.get("parameters") instanceof Map ? properties.get("parameters") : null;
            if (startupparams == null) {
                startupparams = new HashMap();
            }
            if (this._isEnabled) {
                String extension = ".dll";
                if (properties.containsKey("full-name")) {
                    extension = assemblyFullName.split("\\.")[assemblyFullName.split("\\.").length - 1];
                }
                if (extension.endsWith(".dll") || extension.endsWith(".exe")) {
                    throw new UnsupportedOperationException(".exe or .dll not allowed as of yet");
                }
                if (extension.endsWith(".jar") || extension.endsWith(".class")) {
                    AuthenticateFeature.Authenticate((LanguageContext)LanguageContext.JAVA);
                    this._languageContext = LanguageContext.JAVA;
                    String path = AppUtil.DeployedAssemblyDir + context.getCacheRoot().getName().toLowerCase() + "\\" + assembly;
                    if (classname.contains(".")) {
                        classname = classname.replace(".", "/");
                    }
                    this._bridgeOpHistoryMgr = new BridgeOperationsHistoryMgr(context.getNCacheLog(), context.TimeSched);
                    SerializationUtil.registerTypeInfoMap((String)context.getCacheRoot().getName(), (TypeInfoMap)context.getCacheRoot().GetTypeInfoMap());
                }
            } else {
                this._bridgeConflictResolver = new BridgeConflictResolver();
                this._bridgeOpHistoryMgr = new BridgeOperationsHistoryMgr(context.getNCacheLog(), context.TimeSched);
            }
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("The class specified in Bridge Conflict Resolver does not implement IBridgeConflictResolver");
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Configuration Error: " + e.toString(), (Throwable)e);
        }
    }

    private final ConflictResolution Resolve(String key, CacheEntry oldEntry, CacheEntry newEntry, BridgeItemOpCodes opCode) throws OperationFailedException {
        try {
            if (oldEntry.getBridgeOpTimeStamp().compareTo((Object)newEntry.getBridgeOpTimeStamp()) > 0) {
                ProviderBridgeItem oldItem = new ProviderBridgeItem(key, this.GetValue(oldEntry), opCode, BridgeItemVersion.LATEST);
                ProviderBridgeItem newItem = new ProviderBridgeItem(key, this.GetValue(newEntry), opCode, BridgeItemVersion.OLD);
            } else if (oldEntry.getBridgeOpTimeStamp().compareTo((Object)newEntry.getBridgeOpTimeStamp()) < 0) {
                ProviderBridgeItem oldItem = new ProviderBridgeItem(key, this.GetValue(oldEntry), opCode, BridgeItemVersion.OLD);
                ProviderBridgeItem newItem = new ProviderBridgeItem(key, this.GetValue(newEntry), opCode, BridgeItemVersion.LATEST);
            } else {
                ProviderBridgeItem oldItem = new ProviderBridgeItem(key, this.GetValue(oldEntry), opCode, BridgeItemVersion.SAME);
                ProviderBridgeItem newItem = new ProviderBridgeItem(key, this.GetValue(newEntry), opCode, BridgeItemVersion.SAME);
            }
            return null;
        }
        catch (Exception e) {
            throw new OperationFailedException("IBridgeConflictResolver.Resolve failed. Error: " + e.getMessage(), (Throwable)e);
        }
    }

    private Object GetValue(CacheEntry cacheEntry) throws Exception {
        Object value = cacheEntry.getValue() instanceof CallbackEntry ? ((CallbackEntry)cacheEntry.getValue()).getValue() : cacheEntry.getValue();
        if (value != null) {
            value = CompressionUtil.Decompress((byte[])((byte[])((value = (Object)((UserBinaryObject)value).getFullObject()) instanceof byte[] ? value : null)), (BitSet)cacheEntry.getFlag());
        }
        if (this._isDeserializeValue) {
            switch (this._languageContext) {
                case DOTNET: {
                    SerializationBitSet tempFlag = new SerializationBitSet(cacheEntry.getFlag().getData());
                    byte[] obj = SerializationUtil.safeSerialize((Object)value, (String)this._cacheName, (SerializationBitSet)tempFlag);
                    cacheEntry.getFlag().setData(tempFlag.getData());
                    return obj;
                }
                case JAVA: {
                    SerializationBitSet tempFlag = new SerializationBitSet(cacheEntry.getFlag().getData());
                    byte[] obj = SerializationUtil.safeSerialize((Object)value, (String)this._cacheName, (SerializationBitSet)tempFlag);
                    cacheEntry.getFlag().setData(tempFlag.getData());
                    return obj;
                }
            }
        }
        return value;
    }
}

