/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Bridge;

import Alachisoft.NCache.Caching.Bridge.BridgeOperationExpirationInfo;
import Alachisoft.NCache.Caching.Bridge.BridgeOperationExpirationTask;
import Alachisoft.NCache.Common.AppUtil;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Stats.HPTime;
import Alachisoft.NCache.Common.Threading.TimeScheduler;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.util.Date;
import java.util.HashMap;

public class BridgeOperationsHistoryMgr {
    public TimeScheduler _timeSched;
    private HashMap _bridgeOperations = new HashMap();
    private int _expirationInterval = 1;
    private int _cleanInterval = 5000;
    private ILogger _ncacheLog;
    private BridgeOperationExpirationTask _taskExpiry;

    public BridgeOperationsHistoryMgr(ILogger NCacheLog, TimeScheduler timeSched) {
        this._timeSched = timeSched;
        this._ncacheLog = NCacheLog;
    }

    private ILogger getNCacheLog() {
        return this._ncacheLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean AddToLogSuccessful(Object key, HPTime bridgeOpTimeStamp) {
        HashMap hashMap = this._bridgeOperations;
        synchronized (hashMap) {
            BridgeOperationExpirationInfo info = null;
            if (this._bridgeOperations.get(key) == null) {
                info = new BridgeOperationExpirationInfo();
                info._key = key;
                info._bridgeOpTimeStamp = bridgeOpTimeStamp;
                try {
                    info._arrivalTime = AppUtil.DiffSeconds((Date)new Date());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._bridgeOperations.put(key, info);
                return true;
            }
            info = this._bridgeOperations.get(key) instanceof BridgeOperationExpirationInfo ? this._bridgeOperations.get(key) : null;
            if (info._bridgeOpTimeStamp.compareTo((Object)bridgeOpTimeStamp) == 0) {
                return false;
            }
            if (info._bridgeOpTimeStamp.compareTo((Object)bridgeOpTimeStamp) < 0) {
                info._bridgeOpTimeStamp = bridgeOpTimeStamp;
                this._bridgeOperations.put(key, info);
            }
            info = null;
            return true;
        }
    }

    public final void Start() {
        if (this._taskExpiry == null) {
            this._taskExpiry = new BridgeOperationExpirationTask(this, this._cleanInterval);
            this._timeSched.AddTask((TimeScheduler.Task)this._taskExpiry);
        }
    }

    public final void Stop() {
        try {
            if (this._taskExpiry != null) {
                this._taskExpiry.Cancel();
            }
            if (this._timeSched != null) {
                this._timeSched.dispose();
                this._timeSched = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Expire() {
        block6: {
            try {
                if (this._bridgeOperations.size() <= 0) break block6;
                HashMap hashMap = this._bridgeOperations;
                synchronized (hashMap) {
                    Object[] keys = new Object[this._bridgeOperations.keySet().size()];
                    this._bridgeOperations.keySet().toArray(keys);
                    for (Object o : keys) {
                        TimeSpan diff;
                        BridgeOperationExpirationInfo info = this._bridgeOperations.get(o) instanceof BridgeOperationExpirationInfo ? this._bridgeOperations.get(o) : null;
                        if (info == null || !((diff = TimeSpan.subtract((Date)AppUtil.GetDateTime((int)AppUtil.DiffSeconds((Date)new Date())), (Date)AppUtil.GetDateTime((int)info._arrivalTime))).getTotalMinutes() >= (double)this._expirationInterval)) continue;
                        this._bridgeOperations.remove(o);
                    }
                }
            }
            catch (Exception ex) {
                this.getNCacheLog().Error("BridgeOperationsBackLogMgr.Expire(): " + ex.toString());
            }
        }
    }

    public void dispose() {
        if (this._taskExpiry != null) {
            this._taskExpiry.Cancel();
            this._taskExpiry = null;
        }
    }
}

