/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching;

import Alachisoft.NCache.Caching.AlertsPropagators.EmailNotifierArgs;
import Alachisoft.NCache.Caching.AllowedOperationType;
import Alachisoft.NCache.Caching.AsyncOpCode;
import Alachisoft.NCache.Caching.AutoExpiration.AggregateExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationManager;
import Alachisoft.NCache.Caching.AutoExpiration.LockExpiration;
import Alachisoft.NCache.Caching.Bridge.BridgeConflictResolutionMgr;
import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.CacheLoader.CacheStartupLoader;
import Alachisoft.NCache.Caching.CacheLoader.LoadCacheTask;
import Alachisoft.NCache.Caching.CacheRenderer;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Caching.CacheSynchronization.CacheSyncDependency;
import Alachisoft.NCache.Caching.CacheSynchronization.CacheSyncManager;
import Alachisoft.NCache.Caching.CallbackEntry;
import Alachisoft.NCache.Caching.CallbackInfo;
import Alachisoft.NCache.Caching.CompactCacheEntry;
import Alachisoft.NCache.Caching.CompressedValueEntry;
import Alachisoft.NCache.Caching.DataGrouping.GroupInfo;
import Alachisoft.NCache.Caching.DataSourceUpdateOptions;
import Alachisoft.NCache.Caching.DataTypes.Responses.InsertCollectionResponse;
import Alachisoft.NCache.Caching.DatasourceProviders.DSWriteBehindOperation;
import Alachisoft.NCache.Caching.DatasourceProviders.DatasourceMgr;
import Alachisoft.NCache.Caching.DatasourceProviders.WriteBehindAsyncProcessor;
import Alachisoft.NCache.Caching.EmailAlertPropagator.EmailAlertNotifier;
import Alachisoft.NCache.Caching.Enumeration.CacheSnapshotPool;
import Alachisoft.NCache.Caching.EventContext;
import Alachisoft.NCache.Caching.EventContextFieldName;
import Alachisoft.NCache.Caching.EventStatus;
import Alachisoft.NCache.Caching.EvictionPolicies.EvictionHint;
import Alachisoft.NCache.Caching.EvictionPolicies.PriorityEvictionHint;
import Alachisoft.NCache.Caching.GracefulTimeout;
import Alachisoft.NCache.Caching.ItemRemoveReason;
import Alachisoft.NCache.Caching.OpCode;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Caching.Queries.ActiveQueryAnalyzer;
import Alachisoft.NCache.Caching.Queries.CQCallbackInfo;
import Alachisoft.NCache.Caching.Queries.DeleteQueryResultSet;
import Alachisoft.NCache.Caching.Queries.QueryChangeType;
import Alachisoft.NCache.Caching.Queries.QueryDataFilters;
import Alachisoft.NCache.Caching.Queries.QueryResultSet;
import Alachisoft.NCache.Caching.SQLDependencySettings;
import Alachisoft.NCache.Caching.ShutDownServerInfo;
import Alachisoft.NCache.Caching.SocketServerStats;
import Alachisoft.NCache.Caching.Statistics.CacheStatistics;
import Alachisoft.NCache.Caching.Statistics.NodeInfo;
import Alachisoft.NCache.Caching.TagComparisonType;
import Alachisoft.NCache.Caching.Topologies.CacheAddResult;
import Alachisoft.NCache.Caching.Topologies.CacheBase;
import Alachisoft.NCache.Caching.Topologies.CacheInsResult;
import Alachisoft.NCache.Caching.Topologies.CacheInsResultWithEntry;
import Alachisoft.NCache.Caching.Topologies.ICacheEventsListener;
import Alachisoft.NCache.Caching.Topologies.IClusterEventsListener;
import Alachisoft.NCache.Caching.Topologies.Local.IndexedLocalCache;
import Alachisoft.NCache.Caching.Topologies.Local.LocalCache;
import Alachisoft.NCache.Caching.Topologies.Local.LocalCacheImpl;
import Alachisoft.NCache.Caching.Util.AlertTypeHelper;
import Alachisoft.NCache.Caching.Util.AsyncAdd;
import Alachisoft.NCache.Caching.Util.AsyncClear;
import Alachisoft.NCache.Caching.Util.AsyncInsert;
import Alachisoft.NCache.Caching.Util.AsyncRemove;
import Alachisoft.NCache.Caching.Util.CacheEnumerator;
import Alachisoft.NCache.Caching.Util.CacheHelper;
import Alachisoft.NCache.Caching.Util.CacheInfo;
import Alachisoft.NCache.Caching.Util.HotConfig;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.CompressionUtil;
import Alachisoft.NCache.Common.ConvHelper;
import Alachisoft.NCache.Common.DataStructures.EnumerationDataChunk;
import Alachisoft.NCache.Common.DataStructures.EnumerationPointer;
import Alachisoft.NCache.Common.DataStructures.NewHashmap;
import Alachisoft.NCache.Common.DataStructures.VirtualArray;
import Alachisoft.NCache.Common.DataTypes.CollectionOperation;
import Alachisoft.NCache.Common.DataTypes.Counter.CounterGetOperation;
import Alachisoft.NCache.Common.DataTypes.Counter.CounterOperation;
import Alachisoft.NCache.Common.DataTypes.Dictionary.DictionaryAddOperation;
import Alachisoft.NCache.Common.DataTypes.Dictionary.DictionaryContainsOperation;
import Alachisoft.NCache.Common.DataTypes.Dictionary.DictionaryGetOperation;
import Alachisoft.NCache.Common.DataTypes.Dictionary.DictionaryRemoveOperation;
import Alachisoft.NCache.Common.DataTypes.GetCollectionChunkOperation;
import Alachisoft.NCache.Common.DataTypes.HashSet.HashSetAddOperation;
import Alachisoft.NCache.Common.DataTypes.HashSet.HashSetContainsOperation;
import Alachisoft.NCache.Common.DataTypes.HashSet.HashSetGetRandomOperation;
import Alachisoft.NCache.Common.DataTypes.HashSet.HashSetRemoveOperation;
import Alachisoft.NCache.Common.DataTypes.HashSet.HashSetRemoveRandomOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListAddWithPivotOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListAddWithoutIndexOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListGetBulkOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListGetItemOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListInsertWithIndexOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListRemoveWithIndexOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListRemoveWithoutIndexOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListSearchOperation;
import Alachisoft.NCache.Common.DataTypes.Queue.QueueDequeueOperation;
import Alachisoft.NCache.Common.DataTypes.Queue.QueueEnqueueOperation;
import Alachisoft.NCache.Common.DataTypes.Queue.QueuePeekOperation;
import Alachisoft.NCache.Common.DataTypes.Queue.QueueSearchOperation;
import Alachisoft.NCache.Common.Enum.DataFormat;
import Alachisoft.NCache.Common.Enum.EventType;
import Alachisoft.NCache.Common.Enum.SerializationFormat;
import Alachisoft.NCache.Common.Enum.Time;
import Alachisoft.NCache.Common.Event.NEvent;
import Alachisoft.NCache.Common.Event.NEventEnd;
import Alachisoft.NCache.Common.Event.NEventStart;
import Alachisoft.NCache.Common.Exceptions.SuspectedException;
import Alachisoft.NCache.Common.Exceptions.TimeoutException;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.JSON.ExtendedJsonValueBase;
import Alachisoft.NCache.Common.LockOptions;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import Alachisoft.NCache.Common.Logger.EventLogger;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Logger.JLogger;
import Alachisoft.NCache.Common.Monitoring.CacheNodeStatistics;
import Alachisoft.NCache.Common.Monitoring.CacheNodeStatus;
import Alachisoft.NCache.Common.Monitoring.ServerMonitor;
import Alachisoft.NCache.Common.Net.Address;
import Alachisoft.NCache.Common.Propagator.AlertNotificationTypes;
import Alachisoft.NCache.Common.Propagator.IAlertPropagator;
import Alachisoft.NCache.Common.Remoting.RemotingChannels;
import Alachisoft.NCache.Common.ServicePropValues;
import Alachisoft.NCache.Common.Stats.HPTime;
import Alachisoft.NCache.Common.Stats.HPTimeStats;
import Alachisoft.NCache.Common.StreamModes;
import Alachisoft.NCache.Common.Threading.AsyncProcessor;
import Alachisoft.NCache.Common.Threading.Latch;
import Alachisoft.NCache.Common.Threading.Monitor;
import Alachisoft.NCache.Common.Threading.TimeScheduler;
import Alachisoft.NCache.Common.Util.AuthenticateFeature;
import Alachisoft.NCache.Config.ConfigHelper;
import Alachisoft.NCache.Config.ConfigReader;
import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import Alachisoft.NCache.Config.NewDom.Provider;
import Alachisoft.NCache.Config.PropsConfigReader;
import Alachisoft.NCache.Parser.AttributeIndexNotDefined;
import Alachisoft.NCache.Persistence.Event;
import Alachisoft.NCache.Util.EncryptionUtil;
import Alachisoft.NCache.Util.MiscUtil;
import com.alachisoft.ncache.caching.statistics.PerfStatsCollector;
import com.alachisoft.ncache.licensing.LicenseManager;
import com.alachisoft.ncache.ncactivate.utils.AppUtil;
import com.alachisoft.ncache.ncactivate.utils.GUID;
import com.alachisoft.ncache.runtime.CacheItemPriority;
import com.alachisoft.ncache.runtime.caching.ReadThruOptions;
import com.alachisoft.ncache.runtime.datasourceprovider.OperationResult;
import com.alachisoft.ncache.runtime.datasourceprovider.WriteOperation;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.ChannelClosedException;
import com.alachisoft.ncache.runtime.exceptions.ChannelException;
import com.alachisoft.ncache.runtime.exceptions.CompactSerializationException;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.LicensingException;
import com.alachisoft.ncache.runtime.exceptions.LockingException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.StateTransferInProgressException;
import com.alachisoft.ncache.runtime.exceptions.StreamException;
import com.alachisoft.ncache.runtime.exceptions.StreamNotFoundException;
import com.alachisoft.ncache.runtime.exceptions.TypeIndexNotDefined;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.alachisoft.ncache.security.ApiSecurityProvider;
import com.alachisoft.ncache.security.ICacheSecurityProvider;
import com.alachisoft.ncache.security.encryption.EncryptionMgr;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheArgumentException;
import com.alachisoft.ncache.serialization.standard.FormatterServices;
import com.alachisoft.ncache.serialization.util.SerializationUtil;
import com.alachisoft.ncache.serialization.util.TypeInfoMap;
import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import tangible.RefObject;

public class Cache
implements Iterable,
ICacheEventsListener,
IClusterEventsListener,
IDisposable {
    public static final int COMPRESSIONTHRESHOLD = 2;
    public static boolean isCloudEdition;
    public static CacheStoppedEvent OnCacheStopped;
    private static boolean _isClientCache;
    public static CacheStartedEvent OnCacheStarted;
    public static int ServerPort;
    private static float s_clientsRequests;
    private static float s_clientsBytesRecieved;
    private static float s_clientsBytesSent;
    private static boolean s_logClientEvents;
    public String _logFile;
    public AsyncProcessor _asyncProcessor;
    public IAlertPropagator EmailAlertPropagator;
    public ICacheSecurityProvider CacheSecurityProvider;
    long startTime;
    private CacheInfo _cacheInfo = new CacheInfo();
    private CacheRuntimeContext _context = new CacheRuntimeContext();
    private RemotingChannels _channels;
    private NEvent _itemAdded;
    private NEvent _itemUpdated;
    private NEvent _itemRemoved;
    private NEvent _cacheCleared;
    private NEvent _cusotmNotif;
    private NEvent _customRemoveNotif;
    private NEvent _customUpdateNotif;
    private NEvent _activeQueryNotif;
    private NEvent _asyncOperationCompleted;
    private NEvent _dataSourceUpdated;
    private NEvent _cacheStopped;
    private NEvent _cacheBecomeActive;
    private NEvent _memberJoined;
    private NEvent _memberLeft;
    private NEvent _blockClientActivity;
    private NEvent _unblockClientActivity;
    private NEvent _hashmapChanged;
    private NEvent _configurationModified;
    private NEvent _compactTypeModified;
    private ArrayList _connectedClients = new ArrayList();
    private boolean _inProc;
    private boolean _compressionEnabled = true;
    private long _compressionThresholdSize = 2L;
    private long _lockIdTicker = 0L;
    private String _cacheType;
    private HashMap _encryptionInfo = new HashMap();
    private boolean _isPersistEnabled = false;
    private int _persistenceInterval = 5;
    private Object _shutdownMutex = new Object();
    private String _uniqueId;
    private String _blockserverIP;
    private long _blockinterval = 180L;
    private Date _startShutDown = new Date(0L);
    private Latch _shutDownStatusLatch = new Latch(1);
    private SQLDependencySettings _sqlDependencySettings;
    private Thread _instantStatsUpdateTimer;
    private boolean threadRunning = true;
    private TimeSpan InstantStatsUpdateInterval = new TimeSpan(0, 0, 1);
    private boolean _isBridgeTargetCache;
    private String _bridgeId;

    public Cache() {
        this._context.setCacheRoot(this);
    }

    protected Cache(String configString) throws ConfigurationException {
        this._context.setCacheRoot(this);
        this._cacheInfo = ConfigHelper.GetCacheInfo(configString);
    }

    protected Cache(String configString, CacheRenderer renderer) throws ConfigurationException {
        this._context.setCacheRoot(this);
        this._cacheInfo = ConfigHelper.GetCacheInfo(configString);
        this._context.setRender(renderer);
    }

    public static void Resize(RefObject<Object[]> array, int newLength) {
        if (array.argvalue == null) {
            return;
        }
        if (((Object[])array.argvalue).length == newLength) {
            return;
        }
        if (array.argvalue instanceof String[]) {
            String[] copyArray = new String[newLength];
            for (int i = 0; i < newLength && i < ((Object[])array.argvalue).length; ++i) {
                copyArray[i] = (String)((Object[])array.argvalue)[i];
            }
            array.argvalue = copyArray;
        } else if (array.argvalue instanceof CacheEntry[]) {
            CacheEntry[] copyArray = new CacheEntry[newLength];
            for (int i = 0; i < newLength && i < ((Object[])array.argvalue).length; ++i) {
                copyArray[i] = (CacheEntry)((Object[])array.argvalue)[i];
            }
            array.argvalue = copyArray;
        } else {
            Object[] copyArray = new Object[newLength];
            for (int i = 0; i < newLength && i < ((Object[])array.argvalue).length; ++i) {
                copyArray[i] = ((Object[])array.argvalue)[i];
            }
            array.argvalue = copyArray;
        }
    }

    public static float getClientsRequests() {
        RefObject tempRef_s_clientsRequests = new RefObject((Object)Float.valueOf(s_clientsRequests));
        AtomicReference<RefObject> atom3 = new AtomicReference<RefObject>(tempRef_s_clientsRequests);
        float tempVar = ((Float)atom3.getAndSet((RefObject)new RefObject((Object)Float.valueOf((float)0.0f))).argvalue).floatValue();
        s_clientsRequests = ((Float)tempRef_s_clientsRequests.argvalue).floatValue();
        return tempVar;
    }

    public static float getClientsBytesSent() {
        RefObject tempRef_s_clientsBytesSent = new RefObject((Object)Float.valueOf(s_clientsBytesSent));
        AtomicReference<RefObject> atom = new AtomicReference<RefObject>(tempRef_s_clientsBytesSent);
        float tempVar = ((Float)atom.getAndSet((RefObject)new RefObject((Object)Float.valueOf((float)0.0f))).argvalue).floatValue();
        s_clientsBytesSent = ((Float)tempRef_s_clientsBytesSent.argvalue).floatValue();
        return tempVar;
    }

    public static float getClientsBytesRecieved() {
        RefObject tempRef_s_clientsBytesRecieved = new RefObject((Object)Float.valueOf(s_clientsBytesRecieved));
        AtomicReference<RefObject> atom3 = new AtomicReference<RefObject>(tempRef_s_clientsBytesRecieved);
        float tempVar = ((Float)atom3.getAndSet((RefObject)new RefObject((Object)Float.valueOf((float)0.0f))).argvalue).floatValue();
        s_clientsBytesRecieved = ((Float)tempRef_s_clientsBytesRecieved.argvalue).floatValue();
        return tempVar;
    }

    public Iterator iterator() {
        try {
            return this.GetEnumerator();
        }
        catch (OperationFailedException operationFailedException) {
            throw new RuntimeException(operationFailedException.getMessage(), operationFailedException.getCause());
        }
    }

    public final long getBlockInterval() {
        long timeout = this._blockinterval * 1000L - ((Calendar.getInstance().getTime().getTime() - 621355968000000000L) / 10000L - this.startTime) * 1000L;
        return timeout / 1000L;
    }

    public final void setBlockInterval(long value) {
        this._blockinterval = value;
    }

    public final boolean getIsInProc() {
        return this._inProc;
    }

    public final CacheRuntimeContext getContext() {
        return this._context;
    }

    public boolean getIsPersistEnabled() {
        return this._isPersistEnabled;
    }

    public void setIsPersistEnabled(boolean value) {
        this._isPersistEnabled = value;
    }

    public int getPersistenceInterval() {
        return this._persistenceInterval;
    }

    public void setPersistenceInterval(int value) {
        this._persistenceInterval = value;
    }

    public HashMap getEncryptionInfo() {
        return this._encryptionInfo;
    }

    public final ILogger getNCacheLog() {
        return this._context.getNCacheLog();
    }

    protected void finalize() throws Throwable {
        this.dispose(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dispose(boolean disposing) {
        Cache cache = this;
        synchronized (cache) {
            if (this._cacheStopped != null && !this.getCacheType().equals("mirror-server")) {
                HashMap invocationList = this._cacheStopped.getInvocationList();
                for (Map.Entry subscriber : invocationList.entrySet()) {
                    try {
                        ((NEventStart)subscriber.getKey()).hanleEvent(new Object[]{this._cacheInfo.getName(), null});
                    }
                    catch (Exception e) {
                        this.getNCacheLog().Error("Cache.Dispose", "Error occured while invoking cache stopped event: " + e.toString());
                    }
                    finally {
                        this._cacheStopped.removeNEventListners((NEventStart)subscriber.getKey());
                    }
                }
            }
            try {
                if (!this._inProc) {
                    // empty if block
                }
            }
            catch (Exception invocationList) {
                // empty catch block
            }
            if (this._context.getCacheImpl() != null) {
                try {
                    this._context.getCacheImpl().StopServices();
                }
                catch (InterruptedException interruptedException) {
                    this.getNCacheLog().Error("Cache.Dispose", "StopService " + interruptedException.getMessage());
                }
            }
            if (this._context.getDsMgr() != null) {
                this._context.getDsMgr().dispose();
                this._context.setDsMgr(null);
            }
            if (this._context.getCSLMgr() != null) {
                this._context.getCSLMgr().dispose();
                this._context.setCSLMgr(null);
            }
            if (this._cacheStopped != null && this.getCacheType().equals("mirror-server")) {
                HashMap cacheStop = this._cacheStopped.getInvocationList();
                for (Map.Entry object : cacheStop.entrySet()) {
                    try {
                        ((NEventStart)object.getKey()).hanleEvent(new Object[]{this._cacheInfo.getName(), null});
                    }
                    catch (SocketException socketException) {
                    }
                    catch (Exception exception) {}
                }
            }
            if (this._context.getSyncManager() != null) {
                this._context.getSyncManager().dispose();
                this._context.setSyncManager(null);
            }
            if (this._asyncProcessor != null) {
                this._asyncProcessor.Stop();
                this._asyncProcessor = null;
            }
            if (this._connectedClients != null) {
                ArrayList arrayList = this._connectedClients;
                synchronized (arrayList) {
                    this._connectedClients.clear();
                }
            }
            this.ClearCallbacks();
            this._cacheStopped = null;
            this._cacheCleared = null;
            this._itemAdded = null;
            this._itemUpdated = null;
            this._itemRemoved = null;
            this._cusotmNotif = null;
            if (this.getNCacheLog() != null) {
                this.getNCacheLog().CriticalInfo("Cache.Dispose", "Cache stopped successfully");
                this.getNCacheLog().Flush();
                this.getNCacheLog().close();
            }
            try {
                if (this._channels == null) {
                    // empty if block
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._channels = null;
            System.gc();
            if (disposing) {
                // empty if block
            }
            if (this._context != null) {
                this._context.dispose();
            }
            if (!disposing) return;
            CacheSnapshotPool.getInstance().DisposePool(this._context.getCacheRoot().getName());
            return;
        }
    }

    public void dispose() {
        block3: {
            try {
                this.dispose(true);
                if (this.EmailAlertPropagator != null) {
                    this.EmailAlertPropagator.RaiseAlert(1001, "NCache", "\"" + this.getName() + "\" stopped successfully.");
                }
            }
            catch (Exception exp) {
                if (this.EmailAlertPropagator == null) break block3;
                this.EmailAlertPropagator.RaiseAlert(1001, "NCache", "\"" + this.getName() + "\" cannot be stopped.");
            }
        }
    }

    public final String getName() {
        return this._cacheInfo.getName();
    }

    public final String getConfigString() {
        return this._cacheInfo.getConfigString();
    }

    public final void setConfigString(String value) {
        this._cacheInfo.setConfigString(value);
    }

    public final boolean getIsBridgeTargetCache() {
        return this._isBridgeTargetCache;
    }

    public final void setIsBridgeTargetCache(boolean value) {
        this._isBridgeTargetCache = value;
    }

    public final String getBridgeId() {
        return this._bridgeId;
    }

    public final void setBridgeId(String value) {
        this._bridgeId = value;
    }

    public final boolean getIsRunning() {
        return this._context.getCacheImpl() != null;
    }

    public final boolean getIsCoordinator() {
        return false;
    }

    public final String getCacheType() {
        return this._cacheType;
    }

    public final boolean getSerializationEnabled() {
        return true;
    }

    public final HashMap getCompactRegisteredTypesForDotNet() {
        return this.getContext().getCompactKnownTypesNET();
    }

    public final HashMap getCompactRegisteredTypesForJava() {
        return this.getContext().getCompactKnownTypesJAVA();
    }

    public final long getCount() throws GeneralFailureException, OperationFailedException, CacheException {
        if (!this.getIsRunning()) {
            return 0L;
        }
        return this._context.getCacheImpl().getCount();
    }

    public final String getTargetCacheUniqueID() {
        return "";
    }

    public final CacheStatistics getStatistics() {
        if (!this.getIsRunning()) {
            return new CacheStatistics("", this._cacheInfo.getClassName());
        }
        return this._context.getCacheImpl().getStatistics();
    }

    public final ArrayList<CacheNodeStatistics> GetCacheNodeStatistics() throws GeneralFailureException, OperationFailedException, CacheException {
        ArrayList<Object> statistics = null;
        if (!this.getIsRunning()) {
            statistics = new ArrayList();
            CacheNodeStatistics nodeStats = new CacheNodeStatistics(null);
            nodeStats.setStatus(CacheNodeStatus.Stopped);
            statistics.add(nodeStats);
        } else {
            statistics = this._context.getCacheImpl().GetCacheNodeStatistics();
            if (statistics != null && statistics.size() > 0) {
                ((CacheNodeStatistics)statistics.get(0)).setClientCount((short)this._connectedClients.size());
            }
        }
        return statistics;
    }

    public final long getCompressThresholdSize() {
        return this._compressionThresholdSize * 1024L;
    }

    public final boolean getCompressionEnabled() {
        return this._compressionEnabled;
    }

    public final void GetLeastLoadedServer(RefObject<String> ipAddress, RefObject<Integer> serverPort) {
    }

    public HashMap<String, Integer> GetRunningServers(String ipAddress, Integer serverPort) {
        return new HashMap<String, Integer>();
    }

    public final void MakeCacheActivePassive(boolean makeActive) throws OperationFailedException {
        try {
            if (!LicenseManager.isProCacheServer()) {
                this._context.getCacheImpl().MakeBridgeTargetCacheActive(makeActive);
            }
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.MakeCacheActivePassive()", inner.toString());
            throw new OperationFailedException("MakeCacheActivePassive operation failed. Error: " + inner.getMessage(), (Throwable)inner);
        }
    }

    public final void MakeCacheActiveNCManager(boolean makeActive) {
        if (makeActive) {
            this._isBridgeTargetCache = false;
            this._context.setIsBridgeTargetCache(false);
            this._context.getCacheRoot().setIsBridgeTargetCache(false);
            this._context.getCacheImpl().CacheBecomeActive();
        } else {
            this._isBridgeTargetCache = true;
            this._context.setIsBridgeTargetCache(true);
            this._context.getCacheRoot().setIsBridgeTargetCache(true);
        }
    }

    public final void GetActiveNode(RefObject<String> ipAddress, RefObject<Integer> serverPort, List nodes) {
        String connectedIpAddress = (String)ipAddress.argvalue;
        Object localNodeInfo = null;
        for (NodeInfo i : nodes) {
            if (!i.getIsActive() || this._context.getCacheImpl().IsShutdownServer(i.getAddress())) continue;
            if (i.getRendererAddress() != null) {
                ipAddress.argvalue = i.getRendererAddress().getIpAddress().getHostAddress();
                serverPort.argvalue = i.getRendererAddress().getPort();
                break;
            }
            ipAddress.argvalue = i.getAddress().getIpAddress().getHostAddress();
            break;
        }
    }

    public final void GetActiveServer(RefObject<String> ipAddress, RefObject<Integer> serverPort) {
    }

    public final Object getItem(Object key) throws OperationFailedException {
        Object lockId = null;
        TimeZone utc = TimeZone.getTimeZone("UTC");
        Calendar cal = Calendar.getInstance(utc);
        Date lockDate = cal.getTime();
        long version = 0L;
        RefObject tempRef_version = new RefObject((Object)version);
        RefObject tempRef_lockId = new RefObject(lockId);
        RefObject tempRef_lockDate = new RefObject((Object)lockDate);
        Object tempVar = this.GetGroup(key, new BitSet(), null, null, (RefObject<Long>)tempRef_version, (RefObject<Object>)tempRef_lockId, (RefObject<Date>)tempRef_lockDate, TimeSpan.Zero, LockAccessType.IGNORE_LOCK, null, "", new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation)).getValue();
        version = (Long)tempRef_version.argvalue;
        lockId = tempRef_lockId.argvalue;
        lockDate = (Date)tempRef_lockDate.argvalue;
        return tempVar;
    }

    public final void setItem(Object key, Object value) throws OperationFailedException {
        this.Insert(key, value);
    }

    public void addItemAddedListner(NEventStart start, NEventEnd end) {
        this._itemAdded.addNEventListnersSync(start, end);
    }

    public void removeItemAddListner(NEventStart start) {
        this._itemAdded.removeNEventListnersSync(start);
    }

    public void addAsyncOperationCallbackListner(NEventStart start, NEventEnd end) {
        this._asyncOperationCompleted.addNEventListners(start, end);
    }

    public void removeAsyncOperationCallbackListner(NEventStart start) {
        this._asyncOperationCompleted.removeNEventListners(start);
    }

    public void addItemUpdatedListner(NEventStart start, NEventEnd end) {
        this._itemUpdated.addNEventListnersSync(start, end);
    }

    public void removeItemUpdatedListner(NEventStart start) {
        this._itemUpdated.removeNEventListnersSync(start);
    }

    public void addItemRemovedListner(NEventStart start, NEventEnd end) {
        this._itemRemoved.addNEventListnersSync(start, end);
    }

    public void removeItemRemovedListner(NEventStart start) {
        this._itemRemoved.removeNEventListnersSync(start);
    }

    public void addCacheClearedListner(NEventStart start, NEventEnd end) {
        this._cacheCleared.addNEventListnersSync(start, end);
    }

    public void removeCacheClearedListner(NEventStart start) {
        this._cacheCleared.removeNEventListnersSync(start);
    }

    public void addCustomNotifListner(NEventStart start, NEventEnd end) {
        this._cusotmNotif.addNEventListners(start, end);
    }

    public void removeCustomNotifListner(NEventStart start) {
        this._cusotmNotif.removeNEventListners(start);
    }

    public void addDsUpdatedListner(NEventStart start, NEventEnd end) {
        this._dataSourceUpdated.addNEventListners(start, end);
    }

    public void removeDsUpdatedListner(NEventStart start) {
        this._dataSourceUpdated.removeNEventListners(start);
    }

    public void addActiveQueryListner(NEventStart start, NEventEnd end) {
        this._activeQueryNotif.addNEventListners(start, end);
    }

    public void removeActiveQueryListner(NEventStart start) {
        this._activeQueryNotif.removeNEventListners(start);
    }

    public void addNodeJoinedListner(NEventStart start, NEventEnd end) {
        this._memberJoined.addNEventListners(start, end);
    }

    public void removeNodeJoinedListner(NEventStart start) {
        this._memberJoined.removeNEventListners(start);
    }

    public void addNodeLeftListner(NEventStart start, NEventEnd end) {
        this._memberLeft.addNEventListners(start, end);
    }

    public void removeNodeLeftListner(NEventStart start) {
        this._memberLeft.removeNEventListners(start);
    }

    public void addCacheStoppedListner(NEventStart start, NEventEnd end) {
        this._cacheStopped.addNEventListners(start, end);
    }

    public void removeCacheStoppedListner(NEventStart start) {
        this._cacheStopped.removeNEventListners(start);
    }

    public void addHashmapChangedListner(NEventStart start, NEventEnd end) {
        this._hashmapChanged.addNEventListners(start, end);
    }

    public void removeHashmapChangedListner(NEventStart start) {
        this._hashmapChanged.removeNEventListners(start);
    }

    public void addBlockActivity(NEventStart start, NEventEnd end) {
        this._blockClientActivity.addNEventListners(start, end);
    }

    public void removeBlockActivity(NEventStart start) {
        this._blockClientActivity.removeNEventListners(start);
    }

    public void addUnBlockActivity(NEventStart start, NEventEnd end) {
        this._unblockClientActivity.addNEventListners(start, end);
    }

    public void removeUnBlockActivity(NEventStart start) {
        this._unblockClientActivity.removeNEventListners(start);
    }

    public void addCustomUpdateNotifListner(NEventStart start, NEventEnd end) {
        this._customUpdateNotif.addNEventListners(start, end);
    }

    public void removeCustomUpdateNotifListner(NEventStart start) {
        this._customUpdateNotif.removeNEventListners(start);
    }

    public void addCustomRemoveNotifListner(NEventStart start, NEventEnd end) {
        this._customRemoveNotif.addNEventListners(start, end);
    }

    public void removeCustomRemoveNotifListner(NEventStart start) {
        this._customRemoveNotif.removeNEventListners(start);
    }

    protected void Start(CacheRenderer renderer, String userId, String password, boolean twoPhaseInitialization) throws Exception {
        this.Start(renderer, userId, password, false, twoPhaseInitialization);
    }

    public void StartPhase2() throws ChannelClosedException, ChannelException {
    }

    protected void Start(CacheRenderer renderer, String userId, String password, boolean isStartingAsMirror, boolean twoPhaseInitialization) throws Exception {
        try {
            if (this.getIsRunning()) {
                this.Stop(false);
            }
            PropsConfigReader propReader = new PropsConfigReader(this.getConfigString());
            this._context.setRender(renderer);
            if (renderer != null) {
                renderer.addClientConnectedListner(new NEventStart(){

                    public Object hanleEvent(Object ... obj) throws SocketException, OperationFailedException {
                        Cache.this.OnClientConnected((String)obj[0], (String)obj[0]);
                        return null;
                    }
                }, null);
                renderer.addClientDisconnectedListner(new NEventStart(){

                    public Object hanleEvent(Object ... obj) throws SocketException, OperationFailedException {
                        Cache.this.OnClientDisconnected((String)obj[0], (String)obj[0]);
                        return null;
                    }
                }, null);
            }
            this.Initialize(((ConfigReader)propReader).getProperties(), false, userId, password, isStartingAsMirror, twoPhaseInitialization);
            if (this.EmailAlertPropagator != null) {
                this.EmailAlertPropagator.RaiseAlert(1000, "NCache", "\"" + this.getName() + "\" started successfully.");
            }
        }
        catch (Exception exception) {
            if (this.EmailAlertPropagator != null) {
                this.EmailAlertPropagator.RaiseAlert(1000, "NCache", "\"" + this.getName() + "\" cannot be started.");
            }
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void OnClientDisconnected(String client, String cacheId) throws OperationFailedException {
        if (this._context.getCacheImpl() != null) {
            ArrayList arrayList = this._connectedClients;
            synchronized (arrayList) {
                this._connectedClients.remove(client);
            }
            this._context.getCacheImpl().ClientDisconnected(client, this._inProc);
            if (s_logClientEvents) {
                EventLogger.LogEvent((String)"NCache", (String)("Client \"" + client + "\" has disconnected from " + this._cacheInfo.getName()), (EventType)EventType.INFORMATION, (short)3, (int)1005);
            }
            this._context.getNCacheLog().CriticalInfo("Cache.OnClientDisconnected", "Client \"" + client + "\" has disconnected from cache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void OnClientConnected(String client, String cacheId) throws OperationFailedException {
        if (this._context.getCacheImpl() != null) {
            if (!this._connectedClients.contains(client)) {
                ArrayList arrayList = this._connectedClients;
                synchronized (arrayList) {
                    this._connectedClients.add(client);
                }
            }
            this._context.getCacheImpl().ClientConnected(client, this._inProc);
            EventLogger.LogEvent((String)"NCache", (String)("Client \"" + client + "\" has connected to " + this._cacheInfo.getName()), (EventType)EventType.INFORMATION, (short)3, (int)1004);
            this._context.getNCacheLog().CriticalInfo("Cache.OnClientConnected", "Client \"" + client + "\" has connected to cache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Stop(boolean isGracefullShutdown) throws Exception {
        this._startShutDown = new Date();
        this.startTime = (Calendar.getInstance().getTime().getTime() - 621355968000000000L) / 10000L;
        if (isGracefullShutdown) {
            this._shutDownStatusLatch.SetStatusBit((byte)2, (byte)1);
            int shutdownTimeout = 180;
            int blockTimeout = 3;
            RefObject tempRef_shutdownTimeout = new RefObject((Object)shutdownTimeout);
            RefObject tempRef_blockTimeout = new RefObject((Object)blockTimeout);
            String expMsg = GracefulTimeout.GetGracefulShutDownTimeout((RefObject<Integer>)tempRef_shutdownTimeout, (RefObject<Integer>)tempRef_blockTimeout);
            shutdownTimeout = (Integer)tempRef_shutdownTimeout.argvalue;
            blockTimeout = (Integer)tempRef_blockTimeout.argvalue;
            if (expMsg != null) {
                this._context.getNCacheLog().CriticalInfo("Cache.GracefulShutDown", expMsg);
            }
            this._context.getNCacheLog().CriticalInfo("Cache.Stop", "Graceful Shutdown Timeout: " + shutdownTimeout);
            this._context.getNCacheLog().CriticalInfo("Cache.Stop", "Starting Graceful Shutdown Processor...");
            Object object = this._shutdownMutex;
            synchronized (object) {
                Thread _gracefulStopThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Cache.this.ShutDownGraceful();
                    }
                });
                _gracefulStopThread.setName(this._cacheInfo.getName() + ".GraceFullShutDownProcessor");
                _gracefulStopThread.setDaemon(true);
                _gracefulStopThread.start();
                try {
                    Monitor.wait((Object)this._shutdownMutex, (long)((shutdownTimeout + 1) * 1000));
                }
                catch (Exception ex) {
                    this._context.getNCacheLog().Error("Cache.Stop", "Graceful Shutdown Process has intruppted. " + ex.getMessage());
                }
            }
            this._context.getNCacheLog().CriticalInfo("Cache.Stop", "Graceful Shutdown Process has ended.");
        }
        this.dispose();
    }

    public boolean VerifyNodeShutDown(boolean isGraceful) {
        ArrayList<ShutDownServerInfo> servers;
        return !isGraceful || (servers = this.GetShutDownServers()) == null;
    }

    public final ArrayList<ShutDownServerInfo> GetShutDownServers() {
        return this._context.getCacheImpl().GetShutDownServers();
    }

    public final void NotifyBlockActivityToClients(String uniqueId, String server, long interval, int port) {
        this._uniqueId = uniqueId;
        this._blockserverIP = server;
        this._blockinterval = interval;
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)5)) {
            this._shutDownStatusLatch.SetStatusBit((byte)2, (byte)5);
        }
        if (this._blockClientActivity == null) {
            return;
        }
        this._context.getNCacheLog().CriticalInfo("Cache.NotifyBlockActivityToClients", "Notifying " + this._blockClientActivity.getCount() + " clients to block activity.");
        this._blockClientActivity.fireEvents(true, new Object[]{uniqueId, server, interval, port});
    }

    public final void NotifyUnBlockActivityToClients(String uniqueId, String server, int port) {
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2)) {
            this._shutDownStatusLatch.SetStatusBit((byte)4, (byte)2);
        }
        if (this._unblockClientActivity == null) {
            return;
        }
        this._context.getNCacheLog().CriticalInfo("Cache.NotifyUnBlockActivityToClients", "Notifying " + this._unblockClientActivity.getCount() + " clients to unblock activity.");
        this._unblockClientActivity.fireEvents(true, new Object[]{uniqueId, server, port});
        this._uniqueId = null;
        this._blockserverIP = null;
        this._blockinterval = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ShutDownGraceful() {
        int shutdownTimeout = 180;
        int blockTimeout = 3;
        RefObject tempRef_shutdownTimeout = new RefObject((Object)shutdownTimeout);
        RefObject tempRef_blockTimeout = new RefObject((Object)blockTimeout);
        String expMsg = GracefulTimeout.GetGracefulShutDownTimeout((RefObject<Integer>)tempRef_shutdownTimeout, (RefObject<Integer>)tempRef_blockTimeout);
        shutdownTimeout = (Integer)tempRef_shutdownTimeout.argvalue;
        blockTimeout = (Integer)tempRef_blockTimeout.argvalue;
        if (expMsg != null) {
            this._context.getNCacheLog().CriticalInfo("Cache.GracefulShutDown", expMsg);
        }
        this.setBlockInterval(shutdownTimeout);
        try {
            this._context.getNCacheLog().CriticalInfo("Cache.ShutDownGraceful", "Waiting for " + blockTimeout + "seconds...");
            String uniqueID = new GUID().toString();
            this._context.getNCacheLog().CriticalInfo("Cache.ShutDownGraceful", "Notifying Cluster and Clients to block activity.");
            this._context.getCacheImpl().NotifyBlockActivity(uniqueID, this.getBlockInterval());
            this._context.getNCacheLog().CriticalInfo("Cache.ShutDownGraceful", "Waiting for Background process completion.");
            Thread.sleep(blockTimeout * 1000);
            this._context.getNCacheLog().CriticalInfo("Cache.ShutDownGraceful", "Starting Windup Tasks.");
            if (this._asyncProcessor != null) {
                this._asyncProcessor.WindUpTask();
            }
            if (this._context.getDsMgr() != null && this._context.getDsMgr().getIsWriteBehindEnabled() && this._context.getDsMgr()._writeBehindAsyncProcess != null) {
                this._context.getDsMgr().WindUpTask();
            }
            this._context.getCacheImpl().WindUpReplicatorTask();
            this._context.getNCacheLog().CriticalInfo("Cache.ShutDownGraceful", "Windup Tasks Ended.");
            if (this._context.getCSLMgr() != null && !this._context.getCSLMgr().getIsCacheLoaderTaskCompleted() && this._context.getCSLMgr().getIsCacheloaderEnabled()) {
                this._context.getCacheImpl().NotifyCacheLoaderExecution();
            }
            if (this._asyncProcessor != null && this.getBlockInterval() > 0L) {
                this._asyncProcessor.WaitForShutDown(this.getBlockInterval());
            }
            if (this._context.getDsMgr() != null && this._context.getDsMgr().getIsWriteBehindEnabled() && this._context.getDsMgr()._writeBehindAsyncProcess != null && this.getBlockInterval() > 0L) {
                this._context.getDsMgr().WaitForShutDown(this.getBlockInterval());
            }
            if (this.getBlockInterval() > 0L) {
                this._context.getCacheImpl().WaitForReplicatorTask(this.getBlockInterval());
            }
            this._context.getCacheImpl().NotifyUnBlockActivity(uniqueID);
        }
        catch (InterruptedException ti) {
            this._context.getNCacheLog().Error("Cache.ShutdownGraceful", "Graceful Shutdown have stopped. " + ti.toString());
        }
        catch (Exception e) {
            this._context.getNCacheLog().Error("Cache.GracefulShutDown", "Graceful Shutdown have stopped. " + e.toString());
        }
        finally {
            Object ti = this._shutdownMutex;
            synchronized (ti) {
                Monitor.pulse((Object)this._shutdownMutex);
            }
        }
    }

    private void CompressionThresholdSize(Map properties) {
        if (properties.containsKey("threshold")) {
            try {
                this._compressionThresholdSize = Long.parseLong(properties.get("threshold").toString());
                this._compressionEnabled = Boolean.parseBoolean(properties.get("enabled").toString());
            }
            catch (Exception e) {
                this._compressionThresholdSize = 2L;
                this._compressionEnabled = true;
            }
        } else {
            this._compressionThresholdSize = 2L;
            this._compressionEnabled = true;
        }
    }

    public final boolean AcceptClient(InetAddress clientAddress) {
        if (this._context.getCacheImpl() != null) {
            return this._context.getCacheImpl().AcceptClient(clientAddress);
        }
        return false;
    }

    public final void DisconnectClient(InetAddress clientAddress) {
        if (this._context.getCacheImpl() != null) {
            this._context.getCacheImpl().DisconnectClient(clientAddress);
        }
    }

    public final String GetDefaultReadThruProvider() {
        Provider[] providers;
        String defaultProvider = null;
        for (Provider pro : providers = this._cacheInfo.getConfiguration().getBackingSource().getReadthru().getProviders()) {
            if (!pro.getIsDefaultProvider()) continue;
            defaultProvider = pro.getProviderName();
        }
        return defaultProvider;
    }

    public final String GetDefaultWriteThruProvider() {
        Provider[] providers;
        String defaultProvider = null;
        for (Provider pro : providers = this._cacheInfo.getConfiguration().getBackingSource().getWritethru().getProviders()) {
            if (!pro.getIsDefaultProvider()) continue;
            defaultProvider = pro.getProviderName();
        }
        return defaultProvider;
    }

    public final void Initialize(Map properties, boolean inProc, String userId, String password) throws ConfigurationException {
        this.Initialize(properties, inProc, userId, password, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Initialize(Map properties, boolean inProc, String userId, String password, boolean isStartingAsMirror, boolean twoPhaseInitialization) throws ConfigurationException {
        if (this._context._cmptKnownTypesforJava == null) {
            this._context._cmptKnownTypesforJava = new HashMap();
        }
        if (this._context._cmptKnownTypesforNet == null) {
            this._context._cmptKnownTypesforNet = new HashMap();
        }
        if (this._context._dataSharingKnownTypesforJava == null) {
            this._context._dataSharingKnownTypesforJava = new HashMap();
        }
        if (this._context._dataSharingKnownTypesforNet == null) {
            this._context._dataSharingKnownTypesforNet = new HashMap();
        }
        this._itemAdded = new NEvent("Cache.OnItemAdded()", this._context.getNCacheLog());
        this._itemUpdated = new NEvent("Cache.OnItemUpdated()", this._context.getNCacheLog());
        this._itemRemoved = new NEvent("Cache.OnItemUpdated()", this._context.getNCacheLog());
        this._cacheCleared = new NEvent("Cache.OnCacheCleared()", this._context.getNCacheLog());
        this._cusotmNotif = new NEvent("Cache.OnCustomEvent()", this._context.getNCacheLog());
        this._asyncOperationCompleted = new NEvent("Cache.OnAsyncOperationCompletedCallback()", this._context.getNCacheLog());
        this._dataSourceUpdated = new NEvent("Cache.OnWriteBehindOperationCompletedCallback", this._context.getNCacheLog());
        this._cacheStopped = new NEvent("Cache.Dispose", this._context.getNCacheLog());
        this._activeQueryNotif = new NEvent("Cache.RemoveAsyncCallbackHandler", this._context.getNCacheLog());
        this._cacheBecomeActive = new NEvent("Cache.CacheBecomeActive", this._context.getNCacheLog());
        this._memberJoined = new NEvent("Cache.OnMemberJoined()", this._context.getNCacheLog());
        this._memberLeft = new NEvent("Cache.OnMemberLeft()", this._context.getNCacheLog());
        this._configurationModified = new NEvent("configurationModified", this._context.getNCacheLog());
        this._hashmapChanged = new NEvent("Cache.OnHashmapChanged", this._context.getNCacheLog());
        this._customRemoveNotif = new NEvent("Cache.OnCustomRemoveCallback()", this._context.getNCacheLog());
        this._customUpdateNotif = new NEvent("Cache.OnCustomUpdateCallback()", this._context.getNCacheLog());
        this._blockClientActivity = new NEvent("Cache.BlockClientActivity", this._context.getNCacheLog());
        this._unblockClientActivity = new NEvent("Cache.UnBlockClientActivity", this._context.getNCacheLog());
        HPTime.initialize();
        this._inProc = inProc;
        if (properties == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: properties");
        }
        try {
            Cache cache = this;
            synchronized (cache) {
                if (!properties.containsKey("cache")) {
                    throw new ConfigurationException("Missing configuration attribute 'cache'");
                }
                Map cacheConfig = (Map)properties.get("cache");
                if (LicenseManager.isEnterprise()) {
                    this._context.setSQLDepSettings(new SQLDependencySettings());
                    this._sqlDependencySettings = this._context.getSQLDepSettings();
                    if (cacheConfig.containsKey("alerts")) {
                        Map alertConfig = (Map)cacheConfig.get("alerts");
                        if (alertConfig.containsKey("alerts-types")) {
                            this._context.setCacheAlertTypes(AlertTypeHelper.Initialize(alertConfig.get("alerts-types") instanceof Map ? alertConfig.get("alerts-types") : null));
                        } else {
                            this._context.setCacheAlertTypes(new AlertNotificationTypes());
                        }
                        if (alertConfig.containsKey("email-notification")) {
                            try {
                                this._context.setEmailAlertNotifier(new EmailAlertNotifier());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            EmailNotifierArgs emailNotifierArgs = new EmailNotifierArgs(alertConfig.get("email-notification") instanceof Map ? alertConfig.get("email-notification") : null, this._context);
                            this._context.getEmailAlertNotifier().Initialize((Object)emailNotifierArgs, this._context.getCacheAlertTypes());
                        }
                    }
                    this.EmailAlertPropagator = this._context.getEmailAlertNotifier();
                    if (cacheConfig.containsKey("security")) {
                        this._context.setCacheSecurityProvider((ICacheSecurityProvider)new ApiSecurityProvider());
                        this._context.getCacheSecurityProvider().Initialize(cacheConfig.get("security"));
                    } else {
                        this._context.setCacheSecurityProvider((ICacheSecurityProvider)new ApiSecurityProvider());
                    }
                    this.CacheSecurityProvider = this._context.getCacheSecurityProvider();
                    if (cacheConfig.containsKey("compression")) {
                        this.CompressionThresholdSize(cacheConfig.get("compression") instanceof Map ? cacheConfig.get("compression") : null);
                        this._context.setCompressionEnabled(this._compressionEnabled);
                        this._context.setCompressionThreshold(this.getCompressThresholdSize());
                    }
                }
                if (cacheConfig.containsKey("name")) {
                    this._cacheInfo.setName(String.valueOf(cacheConfig.get("name")).trim());
                }
                this._cacheInfo.setCurrentPartitionId(this.GetCurrentPartitionId(this._cacheInfo.getName(), cacheConfig));
                if (cacheConfig.containsKey("log")) {
                    this._context.setNCacheLog((ILogger)new JLogger());
                    this._context.getNCacheLog().Initialize((Map)(cacheConfig.get("log") instanceof Map ? cacheConfig.get("log") : null), this._cacheInfo.getCurrentPartitionId(), this._cacheInfo.getName(), isStartingAsMirror, inProc);
                } else {
                    this._context.setNCacheLog((ILogger)new JLogger());
                    this._context.getNCacheLog().Initialize(null, this._cacheInfo.getCurrentPartitionId(), this._cacheInfo.getName());
                }
                this._context.setSerializationContext(this._cacheInfo.getName());
                this._context.TimeSched = new TimeScheduler();
                this._context.AsyncProc = new AsyncProcessor(this._context.getNCacheLog());
                this._asyncProcessor = new AsyncProcessor(this._context.getNCacheLog());
                this._context.setSyncManager(new CacheSyncManager(this, this._context));
                if (!inProc) {
                    this._context.PerfStatsColl = !this._cacheInfo.getCurrentPartitionId().equals("") ? new PerfStatsCollector(this.getName() + "-" + this._cacheInfo.getCurrentPartitionId(), inProc) : new PerfStatsCollector(this.getName(), inProc);
                } else {
                    this._context.PerfStatsColl = isStartingAsMirror ? new PerfStatsCollector(this.getName() + "-replica", false) : new PerfStatsCollector(this.getName(), inProc);
                    this._context.PerfStatsColl.setNCacheLog(this._context.getNCacheLog());
                }
                this._context.setIsStartedAsMirror(isStartingAsMirror);
                if (LicenseManager.isEnterprise()) {
                    Object cmptSettings;
                    RefObject temp2;
                    RefObject temp1;
                    String msg;
                    if (cacheConfig.containsKey("backing-source")) {
                        try {
                            long reminderTimeout = 10000L;
                            Map cacheClass = (Map)cacheConfig.get("cache-classes");
                            if (cacheClass != null && (cacheClass = (Map)cacheClass.get(this._cacheInfo.getName().toLowerCase())) != null && cacheClass.containsKey("op-timeout")) {
                                reminderTimeout = Long.parseLong(cacheClass.get("op-timeout").toString());
                                if (reminderTimeout < 100L) {
                                    reminderTimeout = 100L;
                                }
                                if (reminderTimeout > 30000L) {
                                    reminderTimeout = 30000L;
                                }
                            }
                            Map dsConfig = (Map)cacheConfig.get("backing-source");
                            this._context.setDsMgr(new DatasourceMgr(this.getName(), dsConfig, this._context, reminderTimeout));
                            if (this._context.getDsMgr()._dsUpdateProcessor != null) {
                                this._context.getDsMgr()._dsUpdateProcessor.Start();
                            }
                            if (this._context.getDsMgr().getIsReadThruEnabled()) {
                                this._context.getDsMgr().setDefaultReadThruProvider(this.GetDefaultReadThruProvider());
                            }
                            if (this._context.getDsMgr().getIsWriteThruEnabled()) {
                                this._context.getDsMgr().setDefaultWriteThruProvider(this.GetDefaultWriteThruProvider());
                            }
                        }
                        catch (Exception e) {
                            if (e instanceof ConfigurationException) {
                                this._context.getNCacheLog().Error("Cache.Initialize()", e.toString());
                                msg = String.format("Datasource provider (ReadThru/WriteThru) could not be initialized because of the following error: %1$s", e.getMessage());
                                EventLogger.LogEvent((String)msg, (EventType)EventType.WARNING);
                                throw new Exception(msg);
                            }
                            this._context.getNCacheLog().Error("Cache.Initialize()", e.toString());
                            msg = String.format("Failed to initialize datasource sync. read-through/write-through will not be available, Error %1$s", e.getMessage());
                            EventLogger.LogEvent((String)msg, (EventType)EventType.WARNING);
                            throw new Exception(msg, e);
                        }
                    }
                    if (cacheConfig.containsKey("conflict-resolver")) {
                        Map crlConfig = (Map)cacheConfig.get("conflict-resolver");
                        this._context.setBridgeConflictMgr(new BridgeConflictResolutionMgr(this._context, crlConfig));
                    } else {
                        this._context.setBridgeConflictMgr(new BridgeConflictResolutionMgr(this._context));
                    }
                    if (cacheConfig.containsKey("cache-loader")) {
                        try {
                            Map cslConfig = (Map)cacheConfig.get("cache-loader");
                            this._context.setCSLMgr(new CacheStartupLoader(cslConfig, this, this._context.getNCacheLog()));
                        }
                        catch (Exception e) {
                            this._context.getNCacheLog().Error("Cache.Initialize()", e.toString());
                            msg = String.format("Failed to initialize cache startup loader, Error %1$s", e.toString());
                            EventLogger.LogEvent((String)msg, (EventType)EventType.WARNING);
                            throw e;
                        }
                        if (cacheConfig.containsKey("encryption")) {
                            this._encryptionInfo = (HashMap)cacheConfig.get("encryption");
                            EncryptionMgr.InitializeEncryption((boolean)Boolean.parseBoolean(this._encryptionInfo.get("enabled").toString()), (String)((String)this._encryptionInfo.get("key")), (String)this.getName(), (String)((String)this._encryptionInfo.get("provider")));
                        }
                    }
                    boolean isDataSharing = false;
                    if (properties.containsKey("data-sharing")) {
                        Object dataSharingSettings = properties.get("data-sharing");
                        this.getContext()._dataSharingKnownTypesforNet = (HashMap)dataSharingSettings;
                        this.getContext()._dataSharingKnownTypesforNet = (HashMap)this.getContext().getDataSharingKnowTypesNET().clone();
                        if (dataSharingSettings instanceof HashMap) {
                            this.getContext().setCompactKnownTypes((HashMap)dataSharingSettings);
                            temp1 = new RefObject((Object)this.getContext()._cmptKnownTypesforNet);
                            temp2 = new RefObject((Object)this.getContext()._cmptKnownTypesforJava);
                            this.FilterOutDotNetTypes(this.getContext().getCompactKnownTypes(), (RefObject<HashMap>)temp1, (RefObject<HashMap>)temp2, true, false);
                            this.getContext()._cmptKnownTypesforNet = (HashMap)temp1.argvalue;
                            this.getContext()._cmptKnownTypesforJava = (HashMap)temp2.argvalue;
                            isDataSharing = true;
                            if (this._context.getDsMgr() != null && this._context.getDsMgr().getLoadCompactTypes() || this._context.getCSLMgr() != null && this._context.getCSLMgr().getIsCacheloaderEnabled()) {
                                if (AuthenticateFeature.getIsJavaEnabled() && !this._inProc && this.getContext()._cmptKnownTypesforJava.size() > 0) {
                                    SerializationUtil.initialize((String)SerializationUtil.GetProtocolStringFromTypeMap((HashMap)this.getContext()._cmptKnownTypesforJava), (String)this.getName());
                                }
                                this.InitializeCompactFramework(this.getContext()._cmptKnownTypesforNet, !this._inProc);
                            }
                        }
                    }
                    if (properties.containsKey("compact-serialization") && (cmptSettings = properties.get("compact-serialization")) instanceof HashMap) {
                        if (this.getContext().getCompactKnownTypes() != null && this.getContext().getCompactKnownTypes().size() > 0 && isDataSharing) {
                            HashMap temp = (HashMap)cmptSettings;
                            Set keys = temp.keySet();
                            for (String var : keys) {
                                if (this.getContext().getCompactKnownTypes().containsKey(var)) continue;
                                this.getContext().getCompactKnownTypes().put(var, temp.get(var));
                            }
                        } else {
                            this.getContext().setCompactKnownTypes((HashMap)cmptSettings);
                        }
                        temp1 = new RefObject((Object)this.getContext()._cmptKnownTypesforNet);
                        temp2 = new RefObject((Object)this.getContext()._cmptKnownTypesforJava);
                        this.FilterOutDotNetTypes(this.getContext().getCompactKnownTypes(), (RefObject<HashMap>)temp1, (RefObject<HashMap>)temp2, isDataSharing, true);
                        this.getContext()._cmptKnownTypesforNet = (HashMap)temp1.argvalue;
                        this.getContext()._cmptKnownTypesforJava = (HashMap)temp2.argvalue;
                        if (this._context.getDsMgr() != null && this._context.getDsMgr().getLoadCompactTypes() || this._context.getCSLMgr() != null && this._context.getCSLMgr().getIsCacheloaderEnabled()) {
                            if (AuthenticateFeature.getIsJavaEnabled() && !this._inProc && this.getCompactRegisteredTypesForJava().size() > 0) {
                                SerializationUtil.initialize((String)SerializationUtil.GetProtocolStringFromTypeMap((HashMap)this.getCompactRegisteredTypesForJava()), (String)this.getName());
                            }
                            this.InitializeCompactFramework(this.getContext()._cmptKnownTypesforNet, !this._inProc);
                        }
                    }
                }
                this.CreateInternalCache(cacheConfig, userId, password, isStartingAsMirror, twoPhaseInitialization);
                if (this._context.getCacheImpl() != null && this._context.getDsMgr() != null) {
                    this._context.getDsMgr().setCacheImpl(this._context.getCacheImpl());
                }
                if (!this._context.getIsClusteredImpl() && this._context.getDsMgr() != null) {
                    this._context.getDsMgr().StartWriteBehindProcessor();
                }
                if (inProc && this._context.getCacheImpl() != null) {
                    this._context.getCacheImpl().setKeepDeflattedValues(this._context.getCacheImpl() instanceof LocalCacheImpl);
                }
                this._context.PerfStatsColl.setCountStats(CacheHelper.GetLocalCount(this._context.getCacheImpl()));
                this._context.PerfStatsColl.setCacheSizeStats(CacheHelper.getCacheSize(this._context.getCacheImpl()));
                this._cacheInfo.setConfigString(ConfigHelper.CreatePropertyString(properties));
                if (this._context.getCSLMgr() != null && this._context.getCSLMgr().getIsCacheloaderEnabled()) {
                    try {
                        LoadCacheTask loadCacheThread = new LoadCacheTask(this._context.getCSLMgr());
                        this._context.getCSLMgr().setTask(loadCacheThread);
                        Thread t = new Thread(loadCacheThread);
                        t.setDaemon(true);
                        t.start();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this._context.getNCacheLog().CriticalInfo("Cache '" + this._context.getCacheRoot().getName() + "' started successfully.");
        }
        catch (ConfigurationException e) {
            this.dispose();
            throw e;
        }
        catch (Exception e) {
            this.dispose();
            throw new ConfigurationException("Configuration Error: " + e.getMessage(), (Throwable)e);
        }
    }

    private void FilterOutDotNetTypes(HashMap _cmptKnownTypes, RefObject<HashMap> cmptKnownTypesdotNet, RefObject<HashMap> cmptKnownTypesJava, boolean isDataSharing, boolean compact) {
        block14: {
            Map.Entry pair;
            cmptKnownTypesdotNet.argvalue = new HashMap();
            cmptKnownTypesJava.argvalue = new HashMap();
            if (compact && isDataSharing) {
                RefObject temp1 = new RefObject((Object)this.getContext()._cmptKnownTypesforNet);
                RefObject temp2 = new RefObject((Object)this.getContext()._cmptKnownTypesforJava);
                this.FilterOutDotNetTypes(this.getContext().getDataSharingKnowTypes(), (RefObject<HashMap>)temp1, (RefObject<HashMap>)temp2, true, false);
            }
            if (_cmptKnownTypes == null) break block14;
            Iterator ide = _cmptKnownTypes.entrySet().iterator();
            if (!compact) {
                while (ide.hasNext()) {
                    pair = ide.next();
                    HashMap compactType = (HashMap)pair.getValue();
                    HashMap classes = (HashMap)compactType.get("known-classes");
                    if (classes == null) continue;
                    for (Map.Entry pair2 : classes.entrySet()) {
                        HashMap typeInfo = (HashMap)pair2.getValue();
                        if (typeInfo.get("type").toString().toLowerCase().equals("java")) {
                            if (!((HashMap)cmptKnownTypesJava.argvalue).containsKey((String)pair.getKey())) {
                                ((HashMap)cmptKnownTypesJava.argvalue).put((String)pair.getKey(), new HashMap());
                            }
                            ((HashMap)((HashMap)cmptKnownTypesJava.argvalue).get((String)pair.getKey())).put((String)typeInfo.get("name"), typeInfo);
                            if (typeInfo.containsKey("portable")) continue;
                            typeInfo.put("portable", compactType.get("portable"));
                            continue;
                        }
                        if (!typeInfo.get("type").toString().toLowerCase().equals("net")) continue;
                        if (!((HashMap)cmptKnownTypesdotNet.argvalue).containsKey((String)pair.getKey())) {
                            ((HashMap)cmptKnownTypesdotNet.argvalue).put((String)pair.getKey(), new HashMap());
                        }
                        ((HashMap)((HashMap)cmptKnownTypesdotNet.argvalue).get((String)pair.getKey())).put((String)typeInfo.get("name"), typeInfo);
                        if (typeInfo.containsKey("portable")) continue;
                        typeInfo.put("portable", compactType.get("portable"));
                    }
                    if (!Boolean.parseBoolean(compactType.get("portable").toString())) continue;
                    if (((HashMap)cmptKnownTypesJava.argvalue).size() > 0 && (HashMap)((HashMap)cmptKnownTypesJava.argvalue).get((String)pair.getKey()) != null) {
                        ((HashMap)((HashMap)cmptKnownTypesJava.argvalue).get((String)pair.getKey())).put("Alachisoft.NCache.AttributeUnion", compactType.get("attribute-union-list"));
                    }
                    if (((HashMap)cmptKnownTypesdotNet.argvalue).size() <= 0 || (HashMap)((HashMap)cmptKnownTypesdotNet.argvalue).get((String)pair.getKey()) == null) continue;
                    ((HashMap)((HashMap)cmptKnownTypesdotNet.argvalue).get((String)pair.getKey())).put("Alachisoft.NCache.AttributeUnion", compactType.get("attribute-union-list"));
                }
            } else {
                while (ide.hasNext()) {
                    pair = ide.next();
                    HashMap compactType = (HashMap)pair.getValue();
                    if (compactType.get("type") == null) continue;
                    if (compactType.get("type").toString().toLowerCase().equals("java")) {
                        if (!((HashMap)cmptKnownTypesJava.argvalue).containsKey((String)pair.getKey())) {
                            ((HashMap)cmptKnownTypesJava.argvalue).put((String)pair.getKey(), new HashMap());
                        }
                        ((HashMap)((HashMap)cmptKnownTypesJava.argvalue).get((String)pair.getKey())).put((String)compactType.get("name"), compactType);
                        continue;
                    }
                    if (!compactType.get("type").toString().toLowerCase().equals("net")) continue;
                    if (compactType.containsKey("arg-types")) {
                        compactType.put("arg-types", this.FilterOutNestedGenerics((HashMap)compactType.get("arg-types")));
                    }
                    if (!((HashMap)cmptKnownTypesdotNet.argvalue).containsKey((String)pair.getKey())) {
                        ((HashMap)cmptKnownTypesdotNet.argvalue).put((String)pair.getKey(), new HashMap());
                    }
                    ((HashMap)((HashMap)cmptKnownTypesdotNet.argvalue).get((String)pair.getKey())).put((String)compactType.get("name"), compactType);
                }
            }
        }
    }

    private HashMap FilterOutNestedGenerics(HashMap htArgTypes) {
        HashMap htArgTypes2 = null;
        if (htArgTypes != null && htArgTypes.size() > 0) {
            htArgTypes2 = new HashMap();
            for (Map.Entry pair : htArgTypes.entrySet()) {
                HashMap innerGenericType = new HashMap();
                htArgTypes2.put(pair.getKey().toString(), innerGenericType);
                HashMap argInstances = (HashMap)pair.getValue();
                for (Map.Entry pair12 : argInstances.entrySet()) {
                    HashMap instanceArgType = (HashMap)pair12.getValue();
                    if (instanceArgType.containsKey("arg-types")) {
                        instanceArgType.put("arg-types", this.FilterOutNestedGenerics((HashMap)instanceArgType.get("arg-types")));
                    }
                    HashMap<String, HashMap> innerGenericTypeDetail = new HashMap<String, HashMap>();
                    innerGenericTypeDetail.put(instanceArgType.get("name").toString(), instanceArgType);
                    innerGenericType.put(pair12.getKey().toString(), innerGenericTypeDetail);
                }
            }
        }
        return htArgTypes2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Initialize2(Map properties, boolean inProc, String userId, String password) throws ConfigurationException {
        if (this._context._cmptKnownTypesforJava == null) {
            this._context._cmptKnownTypesforJava = new HashMap();
        }
        if (this._context._cmptKnownTypesforNet == null) {
            this._context._cmptKnownTypesforNet = new HashMap();
        }
        if (this._context._dataSharingKnownTypesforJava == null) {
            this._context._dataSharingKnownTypesforJava = new HashMap();
        }
        if (this._context._dataSharingKnownTypesforNet == null) {
            this._context._dataSharingKnownTypesforNet = new HashMap();
        }
        HPTime time = HPTime.getNow();
        for (int i = 1; i < 1000; ++i) {
            time = HPTime.getNow();
        }
        this._inProc = inProc;
        if (properties == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: properties");
        }
        try {
            Cache i = this;
            synchronized (i) {
                if (properties.containsKey("name")) {
                    this._cacheInfo.setName(String.valueOf(properties.get("name")).trim());
                }
                if (properties.containsKey("log")) {
                    this._context.setNCacheLog((ILogger)new JLogger());
                    this._context.getNCacheLog().Initialize((Map)(properties.get("log") instanceof Map ? properties.get("log") : null), this._cacheInfo.getCurrentPartitionId(), this._cacheInfo.getName());
                } else {
                    this._context.setNCacheLog((ILogger)new JLogger());
                    this._context.getNCacheLog().Initialize(null, this._cacheInfo.getCurrentPartitionId(), this._cacheInfo.getName());
                }
                this._context.setSerializationContext(this._cacheInfo.getName());
                this._context.TimeSched = new TimeScheduler();
                this._context.AsyncProc = new AsyncProcessor(this._context.getNCacheLog());
                this._asyncProcessor = new AsyncProcessor(this._context.getNCacheLog());
                this._context.setSyncManager(new CacheSyncManager(this, this._context));
                if (!inProc) {
                    // empty if block
                }
                this.CreateInternalCache2(properties, userId, password);
                this._context.PerfStatsColl.setCountStats(CacheHelper.GetLocalCount(this._context.getCacheImpl()));
                this._context.PerfStatsColl.setCacheSizeStats(CacheHelper.getCacheSize(this._context.getCacheImpl()));
                this._cacheInfo.setConfigString(ConfigHelper.CreatePropertyString(properties));
            }
        }
        catch (ConfigurationException e) {
            this.dispose();
            throw e;
        }
        catch (Exception e) {
            this.dispose();
            throw new ConfigurationException("Configuration Error: " + e.getMessage(), (Throwable)e);
        }
    }

    private String GetCurrentPartitionId(String cacheId, Map config) {
        String type;
        cacheId = cacheId.toLowerCase();
        if (config.containsKey("cache-classes") && (config = (HashMap)(config.get("cache-classes") instanceof HashMap ? config.get("cache-classes") : null)).containsKey(cacheId) && (config = (HashMap)(config.get(cacheId) instanceof HashMap ? config.get(cacheId) : null)).containsKey("type") && (type = (String)(config.get("type") instanceof String ? config.get("type") : null)).equals("partitioned-replicas-server") && config.containsKey("cluster") && (config = (HashMap)(config.get("cluster") instanceof HashMap ? config.get("cluster") : null)).containsKey("sub-group-id")) {
            return config.get("sub-group-id") instanceof String ? config.get("sub-group-id") : null;
        }
        return "";
    }

    public final void InitializeCompactFramework(HashMap properties, boolean throwExceptions) throws NCacheArgumentException, CompactSerializationException, Exception {
        HashMap framework = new HashMap();
        framework = SerializationUtil.getCompactTypes((Map)properties, (boolean)throwExceptions, (String)this._cacheInfo.getName());
        for (Map.Entry pair : framework.entrySet()) {
            FormatterServices impl = FormatterServices.getDefault();
            HashMap handleNonCompactFieldMap = (HashMap)pair.getValue();
            Short typeHandle = (Short)handleNonCompactFieldMap.get("handle");
            HashMap nonCompactFieldsMap = (HashMap)handleNonCompactFieldMap.get("non-compact-fields");
            try {
                impl.registerKnownType((Class)pair.getKey(), typeHandle.shortValue(), SerializationUtil.GetSubTypeHandle((String)this.getName(), (String)typeHandle.toString(), (Class)((Class)pair.getKey())), this.getName(), SerializationUtil.getPortability((short)typeHandle, (String)this.getName()), nonCompactFieldsMap);
            }
            catch (NCacheArgumentException nCacheArgumentException) {
                if (!throwExceptions) continue;
                throw nCacheArgumentException;
            }
        }
    }

    private void CreateInternalCache(Map properties, String userId, String password, boolean isStartingAsMirror, boolean twoPhaseInitialization) throws ConfigurationException {
        if (properties == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: properties");
        }
        try {
            if (!properties.containsKey("class")) {
                throw new ConfigurationException("Missing configuration attribute 'class'");
            }
            String cacheScheme = String.valueOf(properties.get("class"));
            if (!properties.containsKey("cache-classes")) {
                throw new ConfigurationException("Missing configuration section 'cache-classes'");
            }
            Map cacheClasses = (Map)properties.get("cache-classes");
            if (!cacheClasses.containsKey(cacheScheme.toLowerCase())) {
                throw new ConfigurationException("Can not find cache class '" + cacheScheme + "'");
            }
            Map schemeProps = (Map)cacheClasses.get(cacheScheme.toLowerCase());
            if (!schemeProps.containsKey("type")) {
                throw new ConfigurationException("Can not find the type of cache, invalid configuration for cache class '" + cacheScheme + "'");
            }
            if (this.getName().length() < 1) {
                this._cacheInfo.setName(cacheScheme);
            }
            boolean bEnableCounter = true;
            if (properties.containsKey("perf-counters")) {
                bEnableCounter = Boolean.parseBoolean(properties.get("perf-counters").toString());
            }
            boolean inProc = false;
            if (properties.containsKey("inproc")) {
                Object obj = properties.get("inproc");
                inProc = (Boolean)obj;
            }
            if (!inProc) {
                LicenseManager.LicenseType type = LicenseManager.LicenseMode((int)AppUtil.getEditionID(), (String)AppUtil.getVersion());
                if (type == LicenseManager.LicenseType.Expired) {
                    throw new LicensingException("Your license for using NCache has expired. Please contact sales@alachisoft.com for further terms and conditions.");
                }
            }
            this._context.ExpiryMgr = new ExpirationManager(schemeProps, this._context);
            this._context.ExpiryMgr.setTopLevelCache(this);
            this._cacheInfo.setClassName(String.valueOf(schemeProps.get("type")).toLowerCase());
            this._context.AsyncProc.Start();
            this._asyncProcessor.Start();
            if (this._cacheInfo.getClassName().compareTo("local-cache") != 0) {
                throw new ConfigurationException("Specified cache class '" + this._cacheInfo.getClassName() + "' is not available in this edition of NCache.");
            }
            LocalCacheImpl cache = new LocalCacheImpl();
            ActiveQueryAnalyzer analyzer = new ActiveQueryAnalyzer(cache, schemeProps, this._cacheInfo.getName(), this._context._dataSharingKnownTypesforNet);
            cache.setInternal(CacheBase.Synchronized(new IndexedLocalCache(cacheClasses, cache, schemeProps, this, this._context, analyzer)));
            this._context.setCacheImpl(cache);
            this._cacheType = this._cacheInfo.getClassName();
            if (this._context.getCacheImpl() != null) {
                if (!isStartingAsMirror) {
                    this._context.ExpiryMgr.Start();
                }
                if (bEnableCounter) {
                    this._context.PerfStatsColl.initializePerfCounters(isStartingAsMirror ? !isStartingAsMirror : this._inProc);
                }
            } else {
                this._context.ExpiryMgr.dispose();
                LicenseManager.RaiseClusterNotAvailableEvent();
            }
        }
        catch (ConfigurationException e) {
            this._context.getNCacheLog().Error("Cache.CreateInternalCache()", e.toString());
            this._context.setCacheImpl(null);
            this.dispose();
            throw e;
        }
        catch (Exception e) {
            this._context.getNCacheLog().Error("Cache.CreateInternalCache()", e.toString());
            this._context.setCacheImpl(null);
            this.dispose();
            throw new ConfigurationException("Configuration Error: " + e.toString(), (Throwable)e);
        }
    }

    private void CreateInternalCache2(Map properties, String userId, String password) throws ConfigurationException {
        if (properties == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: properties");
        }
        try {
            HashMap perfCountersProps;
            String cacheScheme = String.valueOf(properties.get("name")).trim();
            if (this.getName().length() < 1) {
                this._cacheInfo.setName(cacheScheme);
            }
            boolean bEnableCounter = true;
            if (properties.containsKey("perf-counters") && (perfCountersProps = (HashMap)(properties.get("perf-counters") instanceof HashMap ? properties.get("perf-counters") : null)) != null && perfCountersProps.containsKey("enabled")) {
                bEnableCounter = (Boolean)perfCountersProps.get("enabled");
            }
            boolean isClusterable = true;
            this._context.ExpiryMgr = new ExpirationManager(properties, this._context);
            this._context.ExpiryMgr.setTopLevelCache(this);
            Map clusterProps = null;
            if (properties.containsKey("cluster")) {
                clusterProps = properties.get("cluster") instanceof Map ? properties.get("cluster") : null;
                if (clusterProps.containsKey("topology")) {
                    this._cacheInfo.setClassName(String.valueOf(clusterProps.get("topology")).trim());
                }
            } else {
                this._cacheInfo.setClassName("local");
            }
            this._context.AsyncProc.Start();
            this._asyncProcessor.Start();
            if (this._cacheInfo.getClassName().compareTo("local") != 0) {
                throw new ConfigurationException("Specified cache class '" + this._cacheInfo.getClassName() + "' is not available in this edition of NCache.");
            }
            LocalCacheImpl cache = new LocalCacheImpl();
            cache.setInternal(CacheBase.Synchronized(new LocalCache(properties, cache, properties, this, this._context, null)));
            this._context.setCacheImpl(cache);
            this._cacheType = this._cacheInfo.getClassName();
            if (this._context.getCacheImpl() != null) {
                this._context.ExpiryMgr.Start();
                if (bEnableCounter) {
                    this._context.PerfStatsColl.initializePerfCounters(this._inProc);
                }
            } else {
                this._context.ExpiryMgr.dispose();
                LicenseManager.RaiseClusterNotAvailableEvent();
            }
        }
        catch (ConfigurationException e) {
            this._context.getNCacheLog().Error("Cache.CreateInternalCache()", e.toString());
            this._context.setCacheImpl(null);
            this.dispose();
            throw e;
        }
        catch (Exception e) {
            this._context.getNCacheLog().Error("Cache.CreateInternalCache()", e.toString());
            this._context.setCacheImpl(null);
            this.dispose();
            throw new ConfigurationException("Configuration Error: " + e.toString(), (Throwable)e);
        }
    }

    private void CheckDataSourceAvailabilityAndOptions(DataSourceUpdateOptions updateOpts) throws OperationFailedException {
        if (updateOpts != DataSourceUpdateOptions.None) {
            if (this._context.getDsMgr() != null && (this._context.getDsMgr().getIsWriteThruEnabled() && updateOpts == DataSourceUpdateOptions.WriteThru || updateOpts == DataSourceUpdateOptions.WriteBehind || updateOpts == DataSourceUpdateOptions.WriteThru)) {
                return;
            }
            throw new OperationFailedException("Backing source not available. Verify backing source settings");
        }
    }

    public final void Clear() throws OperationFailedException {
        this.Clear(new BitSet(), null, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
    }

    public final void Clear(OperationContext operationContext) throws OperationFailedException {
        this.Clear(new BitSet(), null, operationContext);
    }

    public final void Clear(BitSet flag, CallbackEntry cbEntry, OperationContext operationContext) throws OperationFailedException {
        if (!this.getIsRunning()) {
            return;
        }
        Object block = null;
        boolean isNoBlock = false;
        block = operationContext.GetValueByField(OperationContextFieldName.NoGracefulBlock);
        if (block != null) {
            isNoBlock = (Boolean)block;
        }
        if (!isNoBlock && this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(AllowedOperationType.BulkWrite, operationContext)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        DataSourceUpdateOptions updateOpts = this.UpdateOption(flag);
        this.CheckDataSourceAvailabilityAndOptions(updateOpts);
        try {
            String providerName = null;
            if (operationContext.Contains(OperationContextFieldName.ReadThruProviderName)) {
                providerName = (String)operationContext.GetValueByField(OperationContextFieldName.ReadThruProviderName);
            }
            this._context.getCacheImpl().Clear(cbEntry, updateOpts, operationContext);
            if (updateOpts == DataSourceUpdateOptions.WriteThru) {
                this._context.getDsMgr().WriteThru(null, null, OpCode.Clear, providerName, operationContext);
            } else if (!this._context.getIsClusteredImpl() && updateOpts == DataSourceUpdateOptions.WriteBehind && !this._context.getIsBridgeTargetCache()) {
                CacheEntry entry = null;
                if (cbEntry != null) {
                    entry = new CacheEntry(cbEntry, null, null);
                }
                this._context.getDsMgr().WriteBehind(this._context.getCacheImpl(), null, entry, null, null, providerName, OpCode.Clear, WriteBehindAsyncProcessor.TaskState.Execute);
            }
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.Clear()", inner.toString());
            throw new OperationFailedException("Clear operation failed. Error: " + inner.getMessage(), (Throwable)inner);
        }
    }

    public final void ClearAsync(BitSet flagMap, CallbackEntry cbEntry, OperationContext operationContext) {
        if (!this.getIsRunning()) {
            return;
        }
        this._asyncProcessor.Enqueue((AsyncProcessor.IAsyncTask)new AsyncClear(this, cbEntry, flagMap, operationContext));
    }

    public final boolean Contains(Object key, OperationContext operationContext) throws OperationFailedException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"Cache.Contains", (String)"");
        }
        if (key == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
        }
        if (!(key instanceof Serializable)) {
            throw new IllegalArgumentException("key is not serializable");
        }
        if (!this.getIsRunning()) {
            return false;
        }
        try {
            if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(key, AllowedOperationType.AtomicRead)) {
                this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
            }
            return this._context.getCacheImpl().Contains(key, operationContext);
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.Contains()", inner.toString());
            throw new OperationFailedException("Contains operation failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
    }

    public final HashMap Contains(String[] keys, OperationContext operationContext) throws CacheException {
        if (keys == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: keys");
        }
        if (!this.getIsRunning()) {
            return null;
        }
        try {
            if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(keys, AllowedOperationType.BulkRead, operationContext)) {
                this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
            }
            return this._context.getCacheImpl().Contains(keys, operationContext);
        }
        catch (RuntimeException inner) {
            this._context.getNCacheLog().Error("Cache.Contains()", inner.toString());
            throw new OperationFailedException("Contains operation failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
    }

    public final Object GetCacheEntry(Object key, String group, String subGroup, RefObject<Object> lockId, RefObject<Date> lockDate, TimeSpan lockTimeout, RefObject<Long> version, LockAccessType accessType, OperationContext operationContext) throws OperationFailedException {
        if (key == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
        }
        if (!(key instanceof Serializable)) {
            throw new IllegalArgumentException("key is not serializable");
        }
        if (!this.getIsRunning()) {
            return null;
        }
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(key, AllowedOperationType.AtomicRead)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        try {
            this._context.PerfStatsColl.mSecPerGetBeginSample();
            this._context.PerfStatsColl.incrementGetPerSecStats();
            CacheEntry entry = null;
            LockExpiration lockExpiration = null;
            if ((lockId.argvalue != null && lockId.argvalue.toString().equals("") || lockId.argvalue == null) && accessType == LockAccessType.ACQUIRE) {
                lockId.argvalue = this.GetLockId(key);
                lockDate.argvalue = new Date();
                if (!TimeSpan.Zero.equals(lockTimeout)) {
                    lockExpiration = new LockExpiration(lockTimeout);
                }
            }
            Object generatedLockId = lockId.argvalue;
            entry = group == null && subGroup == null && (accessType == LockAccessType.IGNORE_LOCK || accessType == LockAccessType.DONT_ACQUIRE) ? this._context.getCacheImpl().Get(key, operationContext) : (group != null && subGroup != null ? this._context.getCacheImpl().GetGroup(key, group, subGroup, version, lockId, lockDate, null, LockAccessType.IGNORE_LOCK, operationContext) : this._context.getCacheImpl().Get(key, version, lockId, lockDate, lockExpiration, accessType, operationContext));
            if (entry == null && accessType == LockAccessType.ACQUIRE && (lockId.argvalue == null || generatedLockId.equals(lockId.argvalue))) {
                lockId.argvalue = null;
                lockDate.argvalue = new Date(0L);
            }
            ReadThruOptions readOptions = null;
            if (operationContext.Contains(OperationContextFieldName.ReadThru)) {
                readOptions = (ReadThruOptions)operationContext.GetValueByField(OperationContextFieldName.ReadThru);
                boolean isReadThruFlagSet = true;
                String providerName = null;
                boolean itemIsLocked = false;
                if (accessType == LockAccessType.DONT_ACQUIRE) {
                    if (generatedLockId == null && lockId.argvalue != null && ((String)lockId.argvalue).compareTo("") != 0) {
                        itemIsLocked = true;
                    }
                } else if (accessType == LockAccessType.ACQUIRE && generatedLockId != null && lockId.argvalue != null && ((String)lockId.argvalue).compareTo("") != 0 && !generatedLockId.equals(lockId.argvalue)) {
                    itemIsLocked = true;
                }
                if (entry == null && !itemIsLocked && isReadThruFlagSet && this._context.getDsMgr() != null && this._context.getDsMgr().getIsReadThruEnabled()) {
                    BitSet bitset = new BitSet();
                    RefObject tempRef_entry = new RefObject((Object)entry);
                    RefObject tempRef_bitset = new RefObject((Object)bitset);
                    this._context.getDsMgr().ResyncCacheItem((String)(key instanceof String ? key : null), (RefObject<CacheEntry>)tempRef_entry, (RefObject<BitSet>)tempRef_bitset, group, subGroup, providerName, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                    entry = (CacheEntry)tempRef_entry.argvalue;
                    bitset = (BitSet)tempRef_bitset.argvalue;
                }
            }
            this._context.PerfStatsColl.mSecPerGetEndSample();
            if (entry != null) {
                this._context.PerfStatsColl.incrementHitsPerSecStats();
            } else {
                this._context.PerfStatsColl.incrementMissPerSecStats();
            }
            return entry;
        }
        catch (OperationFailedException inner) {
            if (inner.getIsTracable()) {
                this._context.getNCacheLog().Error("Cache.Get()", inner.toString());
            }
            throw inner;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.Get()", inner.toString());
            throw new OperationFailedException("Get operation failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
    }

    public final CompressedValueEntry Get(Object key) throws OperationFailedException {
        return this.GetGroup(key, new BitSet(), null, null, null, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
    }

    public final HashMap GetByTag(String[] tags, TagComparisonType comparisonType, OperationContext operationContext) throws OperationFailedException {
        if (!this.getIsRunning()) {
            return null;
        }
        HashMap table = null;
        try {
            if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(AllowedOperationType.BulkRead, operationContext)) {
                this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
            }
            if ((table = this._context.getCacheImpl().GetTagData(tags, comparisonType, operationContext)) != null) {
                for (Map.Entry pair : ((HashMap)table.clone()).entrySet()) {
                    Object key = pair.getKey();
                    CacheEntry entry = pair.getValue() instanceof CacheEntry ? pair.getValue() : null;
                    CompressedValueEntry val = new CompressedValueEntry();
                    val.setValue((byte[])(entry.getValue() instanceof CallbackEntry ? ((CallbackEntry)entry.getValue()).getValue() : entry.getValue()));
                    val.setFlag(entry.getFlag());
                    table.put(key, val);
                }
            }
        }
        catch (OperationFailedException inner) {
            if (inner.getIsTracable()) {
                this._context.getNCacheLog().Error("Cache.GetByTag()", inner.toString());
            }
            throw inner;
        }
        catch (StateTransferInProgressException inner) {
            throw inner;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.GetByTag()", inner.toString());
            throw new OperationFailedException("GetByTag operation failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
        return table;
    }

    public final ArrayList GetKeysByTag(String[] tags, TagComparisonType comparisonType, OperationContext operationContext) throws OperationFailedException {
        if (!this.getIsRunning()) {
            return null;
        }
        try {
            if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(AllowedOperationType.BulkRead, operationContext)) {
                this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
            }
            return this._context.getCacheImpl().GetTagKeys(tags, comparisonType, operationContext);
        }
        catch (OperationFailedException inner) {
            if (inner.getIsTracable()) {
                this._context.getNCacheLog().Error("Cache.GetKeysByTag()", inner.toString());
            }
            throw inner;
        }
        catch (StateTransferInProgressException inner) {
            throw inner;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.GetKeysByTag()", inner.toString());
            throw new OperationFailedException("GetKeysByTag operation failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
    }

    public final void RemoveByTag(String[] sTags, TagComparisonType comparisonType, OperationContext operationContext) throws OperationFailedException {
        if (!this.getIsRunning()) {
            return;
        }
        try {
            this.CascadedRemove(sTags, comparisonType, true, operationContext);
        }
        catch (StateTransferInProgressException se) {
            throw se;
        }
        catch (OperationFailedException inner) {
            if (inner.getIsTracable()) {
                this._context.getNCacheLog().Error("Cache.RemoveByTag()", inner.toString());
            }
            throw inner;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.RemoveByTag()", inner.toString());
            throw new OperationFailedException("RemoveByTag operation failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
    }

    public final void Unlock(Object key, Object lockId, boolean isPreemptive, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        if (this.getIsRunning()) {
            if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(key, AllowedOperationType.AtomicWrite)) {
                this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
            }
            this._context.getCacheImpl().UnLock(key, lockId, isPreemptive, operationContext);
        }
    }

    public final boolean IsLocked(Object key, RefObject<Object> lockId, RefObject<Date> lockDate, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        if (this.getIsRunning()) {
            if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(key, AllowedOperationType.AtomicRead)) {
                this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
            }
            Object passedLockId = lockId.argvalue;
            LockOptions lockInfo = this._context.getCacheImpl().IsLocked(key, lockId, lockDate, operationContext);
            if (lockInfo != null) {
                if (lockInfo.getLockId() == null) {
                    return false;
                }
                lockId.argvalue = lockInfo.getLockId();
                lockDate.argvalue = lockInfo.getLockDate();
                return !lockInfo.getLockId().equals(passedLockId);
            }
            return false;
        }
        return false;
    }

    public final boolean Lock(Object key, TimeSpan lockTimeout, RefObject<Object> lockId, RefObject<Date> lockDate, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        lockId.argvalue = null;
        lockDate.argvalue = NCDateTime.getUTCNow();
        LockExpiration lockExpiration = null;
        TimeSpan timeSpan = lockTimeout = lockTimeout != null ? lockTimeout : TimeSpan.Zero;
        if (!TimeSpan.Zero.equals(lockTimeout)) {
            lockExpiration = new LockExpiration(lockTimeout);
        }
        if (this.getIsRunning()) {
            if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(key, AllowedOperationType.AtomicWrite)) {
                this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
            }
            Object generatedLockId = lockId.argvalue = this.GetLockId(key);
            LockOptions lockInfo = this._context.getCacheImpl().Lock(key, lockExpiration, lockId, lockDate, operationContext);
            if (lockInfo != null) {
                lockId.argvalue = lockInfo.getLockId();
                lockDate.argvalue = lockInfo.getLockDate();
                return generatedLockId.equals(lockInfo.getLockId());
            }
            lockId.argvalue = null;
            return false;
        }
        return false;
    }

    public final CompressedValueEntry GetGroup(Object key, BitSet flagMap, String group, String subGroup, String providerName, OperationContext operationContext) throws OperationFailedException {
        Object lockId = null;
        Date lockDate = NCDateTime.getUTCNow();
        long version = 0L;
        RefObject tempRef_version = new RefObject((Object)version);
        RefObject tempRef_lockId = new RefObject(lockId);
        RefObject tempRef_lockDate = new RefObject((Object)lockDate);
        CompressedValueEntry tempVar = this.GetGroup(key, flagMap, group, subGroup, (RefObject<Long>)tempRef_version, (RefObject<Object>)tempRef_lockId, (RefObject<Date>)tempRef_lockDate, TimeSpan.Zero, LockAccessType.IGNORE_LOCK, null, providerName, operationContext);
        version = (Long)tempRef_version.argvalue;
        lockId = tempRef_lockId.argvalue;
        lockDate = (Date)tempRef_lockDate.argvalue;
        return tempVar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object GetLockId(Object key) {
        long nextId = 0L;
        Cache cache = this;
        synchronized (cache) {
            nextId = this._lockIdTicker++;
        }
        return ManagementFactory.getRuntimeMXBean().getName() + "-" + System.getProperty("user.name") + "-" + key.toString() + "-" + nextId;
    }

    public final CompressedValueEntry GetGroup(Object key, BitSet flagMap, String group, String subGroup, RefObject<Long> version, RefObject<Object> lockId, RefObject<Date> lockDate, TimeSpan lockTimeout, LockAccessType accessType, ReadThruOptions readThruOptions, String providerName, OperationContext operationContext) throws OperationFailedException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"Cache.GetGrp", (String)"");
        }
        if (!this.getIsRunning()) {
            return null;
        }
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(key, AllowedOperationType.AtomicRead)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        boolean groupSpecified = false;
        CompressedValueEntry result = new CompressedValueEntry();
        CacheEntry e = null;
        try {
            this._context.PerfStatsColl.mSecPerGetBeginSample();
            this._context.PerfStatsColl.incrementGetPerSecStats();
            this._context.PerfStatsColl.incrementHitsRatioPerSecBaseStats();
            HPTimeStats getTime = new HPTimeStats();
            getTime.BeginSample();
            LockExpiration lockExpiration = null;
            if (accessType == LockAccessType.ACQUIRE) {
                lockId.argvalue = this.GetLockId(key);
                lockDate.argvalue = NCDateTime.getUTCNow();
                TimeSpan timeSpan = lockTimeout = lockTimeout != null ? lockTimeout : TimeSpan.Zero;
                if (!TimeSpan.Zero.equals(lockTimeout)) {
                    lockExpiration = new LockExpiration(lockTimeout);
                }
            }
            Object generatedLockId = lockId.argvalue;
            if (group == null && subGroup == null) {
                e = this._context.getCacheImpl().Get(key, version, lockId, lockDate, lockExpiration, accessType, operationContext);
            } else {
                groupSpecified = true;
                e = this._context.getCacheImpl().GetGroup(key, group, subGroup, version, lockId, lockDate, lockExpiration, accessType, operationContext);
            }
            if (e == null && accessType == LockAccessType.ACQUIRE && (lockId.argvalue == null || generatedLockId.equals(lockId.argvalue))) {
                lockId.argvalue = null;
                lockDate.argvalue = new NCDateTime(1970, 1, 1, 0, 0, 0, 0).getDate();
            }
            if (flagMap != null) {
                boolean isReadThruFlagSet = flagMap.IsBitSet((byte)16);
                boolean readThru = false;
                if (e != null) {
                    this._context.PerfStatsColl.mSecPerGetEndSample();
                    result.setValue(e.getValue());
                    result.setFlag(e.getFlag());
                }
                boolean itemIsLocked = false;
                if (accessType == LockAccessType.DONT_ACQUIRE) {
                    if (generatedLockId == null && lockId.argvalue != null && ((String)lockId.argvalue).compareTo("") != 0) {
                        itemIsLocked = true;
                    }
                } else if (accessType == LockAccessType.ACQUIRE && generatedLockId != null && lockId.argvalue != null && ((String)lockId.argvalue).compareTo("") != 0 && !generatedLockId.equals(lockId.argvalue)) {
                    itemIsLocked = true;
                }
                if (e == null && !itemIsLocked && isReadThruFlagSet && this._context.getDsMgr() != null && this._context.getDsMgr().getIsReadThruEnabled()) {
                    result.setFlag(new BitSet());
                    RefObject tempRef_e = new RefObject((Object)e);
                    RefObject tempRef_Flag = new RefObject((Object)result.getFlag());
                    result.setValue((byte[])this._context.getDsMgr().ResyncCacheItem((String)(key instanceof String ? key : null), (RefObject<CacheEntry>)tempRef_e, (RefObject<BitSet>)tempRef_Flag, group, subGroup, providerName, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation)));
                    e = (CacheEntry)tempRef_e.argvalue;
                    result.setFlag((BitSet)tempRef_Flag.argvalue);
                }
            }
            this._context.PerfStatsColl.mSecPerGetEndSample();
            getTime.EndSample();
            if (result.getValue() != null) {
                this._context.PerfStatsColl.incrementHitsRatioPerSecStats();
                this._context.PerfStatsColl.incrementHitsPerSecStats();
            } else {
                this._context.PerfStatsColl.incrementMissPerSecStats();
            }
            if (result.getValue() instanceof CallbackEntry) {
                result.setValue(((CallbackEntry)result.getValue()).getValue());
            }
        }
        catch (OperationFailedException inner) {
            if (inner.getIsTracable()) {
                this._context.getNCacheLog().Error("Cache.Get()", "Get operation failed. Error : " + inner.toString());
            }
            throw inner;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.Get()", "Get operation failed. Error : " + inner.toString());
            throw new OperationFailedException("Get operation failed. Error :" + inner.getMessage(), (Throwable)inner);
        }
        return result;
    }

    private String GetDefaultProvider() {
        return "";
    }

    public final ArrayList GetGroupKeys(String group, String subGroup, OperationContext operationContext) throws OperationFailedException {
        if (group == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: group");
        }
        if (!this.getIsRunning()) {
            return null;
        }
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(AllowedOperationType.BulkRead, operationContext)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        try {
            HPTimeStats getTime = new HPTimeStats();
            getTime.BeginSample();
            ArrayList result = this._context.getCacheImpl().GetGroupKeys(group, subGroup, operationContext);
            getTime.EndSample();
            if (result != null) {
                this._context.PerfStatsColl.incrementGetPerSecStatsBy(result.size());
            }
            return result;
        }
        catch (OperationFailedException inner) {
            if (inner.getIsTracable()) {
                this._context.getNCacheLog().Error("Cache.Get()", "Get operation failed. Error :" + inner.toString());
            }
            throw inner;
        }
        catch (StateTransferInProgressException inner) {
            throw inner;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.Get()", "Get operation failed. Error :" + inner.toString());
            throw new OperationFailedException("Get operation failed. Error :" + inner.getMessage(), (Throwable)inner);
        }
    }

    public final HashMap GetGroupData(String group, String subGroup, OperationContext operationContext) throws OperationFailedException {
        if (group == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: group");
        }
        if (!this.getIsRunning()) {
            return null;
        }
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(AllowedOperationType.BulkRead, operationContext)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        try {
            HPTimeStats getTime = new HPTimeStats();
            getTime.BeginSample();
            HashMap table = this._context.getCacheImpl().GetGroupData(group, subGroup, operationContext);
            if (table != null) {
                Object[] keyArr = new Object[table.size()];
                System.arraycopy(table.keySet().toArray(), 0, keyArr, 0, table.keySet().size());
                Iterator<Object> ie = Arrays.asList(keyArr).iterator();
                CompressedValueEntry val = null;
                while (ie.hasNext()) {
                    Object obj = ie.next();
                    val = new CompressedValueEntry();
                    CacheEntry entry = (CacheEntry)table.get(obj);
                    val.setValue(entry.getValue());
                    if (val.getValue() instanceof CallbackEntry) {
                        val.setValue(((CallbackEntry)val.getValue()).getValue());
                    }
                    val.setFlag(entry.getFlag());
                    table.put(obj, val);
                }
                getTime.EndSample();
                this._context.PerfStatsColl.incrementGetPerSecStatsBy(table.size());
            }
            return table;
        }
        catch (OperationFailedException inner) {
            if (inner.getIsTracable()) {
                this._context.getNCacheLog().Error("Cache.Get()", "Get operation failed. Error : " + inner.toString());
            }
            throw inner;
        }
        catch (StateTransferInProgressException inner) {
            throw inner;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.Get()", "Get operation failed. Error : " + inner.toString());
            throw new OperationFailedException("Get operation failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
    }

    public final Map GetBulk(Object[] keys, BitSet flagMap, String providerName, OperationContext operationContext) throws OperationFailedException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"Cache.GetBlk", (String)"");
        }
        if (keys == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: keys");
        }
        if (!this.getIsRunning()) {
            return null;
        }
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(keys, AllowedOperationType.BulkRead, operationContext)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        HashMap table = null;
        try {
            HPTimeStats getTime = new HPTimeStats();
            getTime.BeginSample();
            table = this._context.getCacheImpl().Get(keys, operationContext);
            if (table != null) {
                boolean readThruEnabled = this._context.getDsMgr() != null && this._context.getDsMgr().getIsReadThruEnabled();
                int[] resyncIndexes = null;
                int counter = 0;
                if (readThruEnabled) {
                    resyncIndexes = new int[keys.length];
                }
                for (int i = 0; i < keys.length; ++i) {
                    if (table.containsKey(keys[i])) {
                        if (table.get(keys[i]) == null) continue;
                        CacheEntry entry = table.get(keys[i]) instanceof CacheEntry ? table.get(keys[i]) : null;
                        CompressedValueEntry val = new CompressedValueEntry();
                        val.setValue(entry.getValue() instanceof CallbackEntry ? ((CallbackEntry)entry.getValue()).getValue() : entry.getValue());
                        val.setFlag(entry.getFlag());
                        table.put(keys[i], val);
                        continue;
                    }
                    if (!readThruEnabled || !flagMap.IsBitSet((byte)16)) continue;
                    resyncIndexes[counter++] = i;
                }
                if (readThruEnabled && counter > 0) {
                    if (providerName == null || providerName.equals("")) {
                        providerName = this._context.getDsMgr().getDefaultReadThruProvider();
                    }
                    String[] failedKeys = new String[counter];
                    CacheEntry[] enteries = new CacheEntry[counter];
                    BitSet[] flags = new BitSet[counter];
                    for (int i = 0; i < counter; ++i) {
                        int index = resyncIndexes[i];
                        failedKeys[i] = (String)(keys[index] instanceof String ? keys[index] : null);
                        enteries[i] = table.get(keys[index]) instanceof CacheEntry ? table.get(keys[index]) : null;
                        flags[i] = enteries[i] == null ? new BitSet() : enteries[i].getFlag();
                    }
                    this._context.getDsMgr().ResyncCacheItem(table, failedKeys, enteries, flags, providerName, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                }
                getTime.EndSample();
            }
        }
        catch (OperationFailedException inner) {
            if (inner.getIsTracable()) {
                this._context.getNCacheLog().Error("Cache.Get()", inner.toString());
            }
            throw inner;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.Get()", inner.toString());
            throw new OperationFailedException("Get operation failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
        return table;
    }

    private CacheEntry MakeCacheEntry(CompactCacheEntry cce) {
        ExpirationHint eh;
        boolean isAbsolute = false;
        boolean isResync = false;
        int priority = CacheItemPriority.Normal.value();
        int opt = cce.getOptions();
        if (opt != 255) {
            isAbsolute = (opt & 1) != 0 ? Boolean.TRUE : Boolean.FALSE;
            isResync = ((opt >>= 1) & 1) != 0 ? Boolean.TRUE : Boolean.FALSE;
            priority = (opt >>= 1) - 2;
        }
        if ((eh = ConvHelper.MakeExpirationHint(cce.getExpiration(), isAbsolute)) != null && cce.getDependency() != null) {
            eh = new AggregateExpirationHint(cce.getDependency(), eh);
        }
        if (eh == null) {
            eh = cce.getDependency();
        }
        if (eh != null && isResync) {
            eh.SetBit(2);
        }
        CacheEntry e = new CacheEntry(cce.getValue(), eh, new PriorityEvictionHint(CacheItemPriority.forValue((int)priority)));
        if (cce.getGroup() != null) {
            e.setGroupInfo(new GroupInfo(cce.getGroup(), cce.getSubGroup()));
        }
        e.setQueryInfo(cce.getQueryInfo());
        e.setFlag(cce.getFlag());
        e.setSyncDependency(cce.getSyncDependency());
        e.setLockId(cce.getLockId());
        e.setLockAccessType(cce.getLockAccessType());
        e.setVersion(cce.getVersion());
        e.setResyncProviderName(cce.getResyncProviderName());
        e.setProviderName(cce.getProviderName());
        return e;
    }

    public final boolean AddExpirationHint(Object key, ExpirationHint hint, OperationContext operationContext) throws CacheException {
        if (!this.getIsRunning()) {
            return false;
        }
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(key, AllowedOperationType.AtomicWrite)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        try {
            return this._context.getCacheImpl().Add(key, hint, operationContext);
        }
        catch (Exception ex) {
            this._context.getNCacheLog().Error("Add operation failed. Error: " + ex.toString());
            throw ex;
        }
    }

    public final boolean AddSyncDependency(Object key, CacheSyncDependency syncDependency, OperationContext operationContext) throws Exception {
        if (!this.getIsRunning()) {
            return false;
        }
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(key, AllowedOperationType.AtomicWrite)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        try {
            if (!this._context.getCacheImpl().Add(key, syncDependency, operationContext)) {
                return false;
            }
        }
        catch (Exception ex) {
            this._context.getNCacheLog().Error("Add operation failed. Error: " + ex.toString());
            throw ex;
        }
        return true;
    }

    public final void AddEntry(Object entry, OperationContext operationContext) throws OperationFailedException {
        if (!this.getIsRunning()) {
            return;
        }
        CompactCacheEntry cce = null;
        cce = (CompactCacheEntry)entry;
        CacheEntry e = this.MakeCacheEntry(cce);
        if (e != null) {
            e.setSyncDependency(cce.getSyncDependency());
        }
        String group = null;
        String subgroup = null;
        if (e.getGroupInfo() != null && e.getGroupInfo().getGroup() != null) {
            group = e.getGroupInfo().getGroup();
            subgroup = e.getGroupInfo().getSubGroup();
        }
        this.Add(cce.getKey(), e.getValue(), e.getExpirationHint(), e.getSyncDependency(), e.getEvictionHint(), group, subgroup, e.getQueryInfo(), e.getFlag(), cce.getProviderName(), e.getResyncProviderName(), operationContext, null);
    }

    public final void Add(Object key, Object value) throws OperationFailedException {
        this.Add(key, value, null, null, null, null, null, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
    }

    public final void Add(Object key, Object value, ExpirationHint expiryHint, OperationContext operationContext) throws OperationFailedException {
        this.Add(key, value, expiryHint, null, null, null, null, operationContext);
    }

    public final void Add(Object key, Object value, EvictionHint evictionHint) throws OperationFailedException {
        this.Add(key, value, null, null, evictionHint, null, null, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
    }

    public final void Add(Object key, Object value, ExpirationHint expiryHint, CacheSyncDependency syncDependency, EvictionHint evictionHint, String group, String subGroup, OperationContext operationContext) throws OperationFailedException {
        this.Add(key, value, expiryHint, syncDependency, evictionHint, group, subGroup, null, operationContext);
    }

    public final void Add(Object key, Object value, ExpirationHint expiryHint, CacheSyncDependency syncDependency, EvictionHint evictionHint, String group, String subGroup, HashMap queryInfo, OperationContext operationContext) throws OperationFailedException {
        this.Add(key, value, expiryHint, syncDependency, evictionHint, group, subGroup, queryInfo, new BitSet(), null, null, operationContext, null);
    }

    public final void Add(Object key, Object value, ExpirationHint expiryHint, CacheSyncDependency syncDependency, EvictionHint evictionHint, String group, String subGroup, HashMap queryInfo, BitSet flag, String providerName, String resyncProviderName, OperationContext operationContext, HPTime bridgeOperationTime) throws OperationFailedException {
        if (key == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: value");
        }
        if (!(key instanceof Serializable)) {
            throw new IllegalArgumentException("key is not serializable");
        }
        if (expiryHint != null && !(expiryHint instanceof Serializable)) {
            throw new IllegalArgumentException("expiryHint is not serializable");
        }
        if (evictionHint != null && !(evictionHint instanceof Serializable)) {
            throw new IllegalArgumentException("evictionHint is not serializable");
        }
        if (!this.getIsRunning()) {
            return;
        }
        DataSourceUpdateOptions updateOpts = this.UpdateOption(flag);
        this.CheckDataSourceAvailabilityAndOptions(updateOpts);
        GroupInfo grpInfo = new GroupInfo(group, subGroup);
        CacheEntry e = new CacheEntry(value, expiryHint, evictionHint);
        e.setGroupInfo(grpInfo);
        Object dataSize = operationContext.GetValueByField(OperationContextFieldName.ValueDataSize);
        if (dataSize != null) {
            int tempSize = Integer.parseInt(dataSize.toString());
            e.setDataSize(tempSize);
        }
        e.setResyncProviderName(resyncProviderName);
        e.setProviderName(providerName);
        e.setSyncDependency(syncDependency);
        e.setQueryInfo(queryInfo);
        e.getFlag().setData((byte)(e.getFlag().getData() | flag.getData()));
        e.setBridgeOpTimeStamp(bridgeOperationTime);
        try {
            HPTimeStats addTime = new HPTimeStats();
            this._context.PerfStatsColl.mSecPerAddBeginSample();
            CacheEntry clone = (updateOpts == DataSourceUpdateOptions.WriteThru || updateOpts == DataSourceUpdateOptions.WriteBehind) && e.getHasQueryInfo() ? (CacheEntry)e.clone() : e;
            addTime.BeginSample();
            this.Add(key, e, operationContext);
            addTime.EndSample();
            this._context.PerfStatsColl.mSecPerAddEndSample();
            OperationResult dsResult = null;
            String taskId = new GUID().toString();
            if (updateOpts == DataSourceUpdateOptions.WriteThru) {
                WriteOperation operation;
                dsResult = this._context.getDsMgr().WriteThru((String)(key instanceof String ? key : null), clone, OpCode.Add, providerName, operationContext);
                if (dsResult != null && dsResult.getOperationStatus() == OperationResult.Status.FailureRetry && (operation = (WriteOperation)dsResult.getOperation()) != null) {
                    this._context.getNCacheLog().Info("Retrying Write Operation" + operation.getOperationType() + " operation for key:" + operation.getKey());
                    DSWriteBehindOperation dsOperation = new DSWriteBehindOperation(this.getName(), operation.getKey(), null, clone, OpCode.Add, providerName, 0L, taskId, null, WriteBehindAsyncProcessor.TaskState.Execute);
                    this._context.getCacheImpl().EnqueueDSOperation(dsOperation);
                }
            } else if (!this._context.getIsClusteredImpl() && updateOpts == DataSourceUpdateOptions.WriteBehind && !this._context.getIsBridgeTargetCache()) {
                this._context.getDsMgr().WriteBehind(this._context.getCacheImpl(), key, clone, null, taskId, providerName, OpCode.Add, WriteBehindAsyncProcessor.TaskState.Execute);
            }
        }
        catch (Exception inner) {
            throw new OperationFailedException("Add operation failed:" + inner.getMessage(), (Throwable)inner);
        }
    }

    public final void SendNotification(Object notifId, Object data) throws CacheException {
        if (!this.getIsRunning()) {
            return;
        }
        if (notifId != null && !(notifId instanceof Serializable)) {
            throw new IllegalArgumentException("notifId is not serializable");
        }
        if (data != null && !(data instanceof Serializable)) {
            throw new IllegalArgumentException("data is not serializable");
        }
        this._context.getCacheImpl().SendNotification(notifId, data);
    }

    public final void AddAsyncEntry(Object entry, OperationContext operationContext) throws IOException, ClassNotFoundException {
        ExpirationHint eh;
        if (!this.getIsRunning()) {
            return;
        }
        CompactCacheEntry cce = (CompactCacheEntry)SerializationUtil.safeDeserialize((Object)entry, (String)this._context.getSerializationContext(), null);
        boolean isAbsolute = false;
        boolean isResync = false;
        int priority = CacheItemPriority.Normal.value();
        int opt = cce.getOptions();
        if (opt != 255) {
            isAbsolute = (opt & 1) != 0 ? Boolean.TRUE : Boolean.FALSE;
            isResync = ((opt >>= 1) & 1) != 0 ? Boolean.TRUE : Boolean.FALSE;
            priority = (opt >>= 1) - 2;
        }
        if ((eh = ConvHelper.MakeExpirationHint(cce.getExpiration(), isAbsolute)) != null && cce.getDependency() != null) {
            eh = new AggregateExpirationHint(cce.getDependency(), eh);
        }
        if (eh == null) {
            eh = cce.getDependency();
        }
        if (eh != null && isResync) {
            eh.SetBit(2);
        }
        this.AddAsync(cce.getKey(), cce.getValue(), eh, cce.getSyncDependency(), new PriorityEvictionHint(CacheItemPriority.forValue((int)priority)), cce.getGroup(), cce.getSubGroup(), cce.getFlag(), cce.getQueryInfo(), cce.getProviderName(), cce.getResyncProviderName(), operationContext);
    }

    public final void AddAsync(Object key, Object value, ExpirationHint expiryHint, CacheSyncDependency syncDependency, EvictionHint evictionHint, String group, String subGroup, OperationContext operationContext) throws IOException, ClassNotFoundException {
        this.AddAsync(key, value, expiryHint, syncDependency, evictionHint, group, subGroup, new BitSet(), null, null, null, operationContext);
    }

    public final void AddAsync(Object key, Object value, ExpirationHint expiryHint, CacheSyncDependency syncDependency, EvictionHint evictionHint, String group, String subGroup, BitSet Flag, HashMap queryInfo, String providerName, String resyncProviderName, OperationContext operationContext) throws IOException, ClassNotFoundException {
        if (key == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: value");
        }
        if (!this._inProc) {
            if (key instanceof byte[]) {
                key = SerializationUtil.safeDeserialize((Object)((byte[])key), (String)this._context.getSerializationContext(), null);
            }
            if (value instanceof byte[]) {
                value = SerializationUtil.safeDeserialize((Object)((byte[])value), (String)this._context.getSerializationContext(), null);
            }
        }
        if (!(key.getClass() instanceof Serializable)) {
            throw new IllegalArgumentException("key is not serializable");
        }
        if (expiryHint != null && !(expiryHint instanceof Serializable)) {
            throw new IllegalArgumentException("expiryHint is not not serializable");
        }
        if (evictionHint != null && !(evictionHint instanceof Serializable)) {
            throw new IllegalArgumentException("evictionHint is not serializable");
        }
        if (!this.getIsRunning()) {
            return;
        }
        this._asyncProcessor.Enqueue((AsyncProcessor.IAsyncTask)new AsyncAdd(this, key, value, expiryHint, syncDependency, evictionHint, group, subGroup, Flag, queryInfo, providerName, resyncProviderName, operationContext));
    }

    private void Add(Object key, CacheEntry e, OperationContext operationContext) throws OperationFailedException {
        Object value = e.getValue();
        try {
            CacheAddResult result = CacheAddResult.Failure;
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"Cache.Add", (String)((String)(key instanceof String ? key : null)));
            }
            Object block = null;
            Boolean isNoBlock = false;
            block = operationContext.GetValueByField(OperationContextFieldName.NoGracefulBlock);
            if (block != null) {
                isNoBlock = (Boolean)block;
            }
            if (!isNoBlock.booleanValue() && this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(key, AllowedOperationType.AtomicWrite)) {
                this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
            }
            result = this._context.getCacheImpl().Add(key, e, true, operationContext);
            switch (result) {
                case Failure: {
                    break;
                }
                case NeedsEviction: {
                    throw new OperationFailedException("The cache is full and not enough items could be evicted.", false);
                }
                case KeyExists: {
                    throw new OperationFailedException("The specified key already exists.", false);
                }
                case Success: {
                    this._context.PerfStatsColl.incrementAddPerSecStats();
                }
            }
        }
        catch (OperationFailedException inner) {
            if (inner.getIsTracable()) {
                this._context.getNCacheLog().Error("Cache.Add():", inner.toString());
            }
            throw inner;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.Add():", inner.toString());
            throw new OperationFailedException("Add operation failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
    }

    public final HashMap AddEntries(Object[] entries, Map itemVersions, OperationContext operationContext) throws OperationFailedException, Exception {
        if (!this.getIsRunning()) {
            return null;
        }
        String[] keys = new String[entries.length];
        Object[] values = new Object[entries.length];
        CallbackEntry[] callbackEnteries = new CallbackEntry[entries.length];
        ExpirationHint[] exp = new ExpirationHint[entries.length];
        EvictionHint[] evc = new EvictionHint[entries.length];
        CacheSyncDependency[] csd = new CacheSyncDependency[entries.length];
        BitSet[] flags = new BitSet[entries.length];
        HashMap[] queryInfo = new HashMap[entries.length];
        GroupInfo[] groupInfo = new GroupInfo[entries.length];
        CallbackEntry cbEntry = null;
        for (int i = 0; i < entries.length; ++i) {
            CompactCacheEntry cce = (CompactCacheEntry)SerializationUtil.safeDeserialize((Object)entries[i], (String)this._context.getSerializationContext(), null);
            Object tempVar = cce.getKey();
            keys[i] = (String)(tempVar instanceof String ? tempVar : null);
            CacheEntry ce = this.MakeCacheEntry(cce);
            if (ce != null) {
                if (ce.getValue() instanceof CallbackEntry) {
                    Object tempVar2 = ce.getValue();
                    cbEntry = (CallbackEntry)(tempVar2 instanceof CallbackEntry ? tempVar2 : null);
                }
            } else {
                cbEntry = null;
            }
            callbackEnteries[i] = cbEntry;
            Object tempVar3 = ce.getValue();
            CallbackEntry value = (CallbackEntry)(tempVar3 instanceof CallbackEntry ? tempVar3 : null);
            values[i] = value == null ? ce.getValue() : ((CallbackEntry)ce.getValue()).getValue();
            exp[i] = ce.getExpirationHint();
            evc[i] = ce.getEvictionHint();
            csd[i] = ce.getSyncDependency();
            queryInfo[i] = ce.getQueryInfo();
            flags[i] = ce.getFlag();
            groupInfo[i] = new GroupInfo(cce.getGroup(), cce.getSubGroup());
        }
        HashMap items = this.Add(keys, values, callbackEnteries, exp, csd, evc, groupInfo, queryInfo, flags, null, null, itemVersions, operationContext);
        if (items != null) {
            this.CompileReturnSet(items);
        }
        return items;
    }

    private void CompileReturnSet(HashMap returnSet) {
        if (returnSet != null && returnSet.size() > 0) {
            HashMap tmp = (HashMap)returnSet.clone();
            for (Map.Entry keyPair : tmp.entrySet()) {
                if (keyPair.getValue() instanceof OperationResult.Status) {
                    OperationResult.Status status = (OperationResult.Status)keyPair.getValue();
                    if (status != OperationResult.Status.Success && status != OperationResult.Status.FailureRetry) continue;
                    returnSet.remove(keyPair.getKey());
                    continue;
                }
                if (!(keyPair.getValue() instanceof Exception)) continue;
                returnSet.put(keyPair.getKey(), new OperationFailedException(((Exception)keyPair.getValue()).getMessage()));
            }
        }
    }

    public final Map Add(Object[] keys, Object[] values, ExpirationHint expiryHint, EvictionHint evictionHint, String group, String subGroup, OperationContext operationContext) throws Exception {
        if (keys == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: keys");
        }
        if (values == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: items");
        }
        if (keys.length != values.length) {
            throw new IllegalArgumentException("keys count is not equal to values count");
        }
        CacheEntry[] ce = new CacheEntry[values.length];
        for (int i = 0; i < values.length; ++i) {
            Object key = keys[i];
            Object value = values[i];
            if (key == null) {
                throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
            }
            if (value == null) {
                throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: value");
            }
            if (!(key instanceof Serializable)) {
                throw new IllegalArgumentException("key is not serializable");
            }
            if (expiryHint != null && !(expiryHint instanceof Serializable)) {
                throw new IllegalArgumentException("expiryHint is not serializable");
            }
            if (evictionHint != null && !(evictionHint instanceof Serializable)) {
                throw new IllegalArgumentException("evictionHint is not serializable");
            }
            if (!this.getIsRunning()) {
                return null;
            }
            ce[i] = new CacheEntry(value, expiryHint, evictionHint);
            GroupInfo grpInfo = new GroupInfo(group, subGroup);
            ce[i].setGroupInfo(grpInfo);
        }
        return this.Add(keys, ce, operationContext);
    }

    public final HashMap Add(String[] keys, Object[] values, CallbackEntry[] callbackEnteries, ExpirationHint[] expirations, CacheSyncDependency[] syncDependencies, EvictionHint[] evictions, GroupInfo[] groupInfos, HashMap[] queryInfos, BitSet[] flags, String providerName, String resyncProviderName, Map itemVersions, OperationContext operationContext) throws OperationFailedException, Exception {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"Cache.InsertBlk", (String)"");
        }
        if (keys == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: keys");
        }
        if (values == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: items");
        }
        if (keys.length != values.length) {
            throw new IllegalArgumentException("keys count is not equal to values count");
        }
        itemVersions = new HashMap<String, Long>();
        DataSourceUpdateOptions updateOpts = this.UpdateOption(flags[0]);
        this.CheckDataSourceAvailabilityAndOptions(updateOpts);
        CacheEntry[] enteries = new CacheEntry[values.length];
        Object dataSize = operationContext.GetValueByField(OperationContextFieldName.ValueDataSize);
        long[] sizes = null;
        if (dataSize != null) {
            sizes = new long[keys.length];
            int count = 0;
            long[] lArray = (long[])dataSize;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                long sizeValue;
                sizes[count] = sizeValue = lArray[i];
                ++count;
            }
        }
        for (int i = 0; i < values.length; ++i) {
            if (keys[i] == null) {
                throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
            }
            if (values[i] == null) {
                throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: value");
            }
            if (!(keys[i] instanceof Serializable)) {
                throw new IllegalArgumentException("key is not serializable");
            }
            if (expirations[i] != null && !(expirations[i] instanceof Serializable)) {
                throw new IllegalArgumentException("expiryHint is not serializable");
            }
            if (evictions[i] != null && !(evictions[i] instanceof Serializable)) {
                throw new IllegalArgumentException("evictionHint is not serializable");
            }
            if (!this.getIsRunning()) {
                return null;
            }
            enteries[i] = new CacheEntry(values[i], expirations[i], evictions[i]);
            enteries[i].setSyncDependency(syncDependencies[i]);
            enteries[i].setGroupInfo(groupInfos[i]);
            enteries[i].setQueryInfo(queryInfos[i]);
            enteries[i].getFlag().setData((byte)(enteries[i].getFlag().getData() | flags[i].getData()));
            enteries[i].setResyncProviderName(resyncProviderName);
            enteries[i].setProviderName(providerName);
            itemVersions.put(keys[i], enteries[i].getVersion());
            if (sizes != null) {
                enteries[i].setDataSize(sizes[i]);
            }
            if (callbackEnteries[i] == null) continue;
            Object tempVar = callbackEnteries[i].clone();
            CallbackEntry cloned = (CallbackEntry)(tempVar instanceof CallbackEntry ? tempVar : null);
            cloned.setValue(values[i]);
            cloned.setFlag(enteries[i].getFlag());
            enteries[i].setValue(cloned);
        }
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(keys, AllowedOperationType.BulkWrite, operationContext)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        HPTimeStats addTime = new HPTimeStats();
        CacheEntry[] clone = null;
        if (updateOpts == DataSourceUpdateOptions.WriteBehind || updateOpts == DataSourceUpdateOptions.WriteThru) {
            clone = new CacheEntry[enteries.length];
            for (int i = 0; i < enteries.length; ++i) {
                clone[i] = enteries[i].getHasQueryInfo() ? (CacheEntry)enteries[i].clone() : enteries[i];
            }
        }
        addTime.BeginSample();
        HashMap result = this.Add(keys, enteries, operationContext);
        addTime.EndSample();
        Object[] filteredKeys = null;
        Object[] filteredValues = null;
        if (updateOpts != DataSourceUpdateOptions.None && keys.length > result.size()) {
            filteredKeys = new String[keys.length - result.size()];
            filteredValues = new Object[keys.length - result.size()];
            int j = 0;
            for (int i = 0; i < keys.length; ++i) {
                if (result.containsKey(keys[i])) continue;
                filteredKeys[j] = keys[i];
                if (!this._inProc) {
                    UserBinaryObject ubObject = (UserBinaryObject)(values[i] instanceof UserBinaryObject ? values[i] : null);
                    filteredValues[j] = CompressionUtil.Decompress((byte[])ubObject.getFullObject(), (BitSet)enteries[i].getFlag());
                    filteredValues[j] = EncryptionUtil.DecryptData((byte[])filteredValues[j], this._context.getSerializationContext());
                }
                ++j;
            }
            OperationResult[] dsResults = null;
            String taskId = new GUID().toString();
            if (updateOpts == DataSourceUpdateOptions.WriteThru && !this._context.getIsBridgeTargetCache()) {
                dsResults = this._context.getDsMgr().WriteThru((String[])filteredKeys, filteredValues, clone, result instanceof HashMap ? result : null, OpCode.Add, providerName, operationContext);
                if (dsResults != null) {
                    this.EnqueueRetryOperations((String[])filteredKeys, filteredValues, clone, result instanceof HashMap ? result : null, OpCode.Add, providerName, taskId, operationContext);
                }
            } else if (!this._context.getIsClusteredImpl() && updateOpts == DataSourceUpdateOptions.WriteBehind) {
                this._context.getDsMgr().WriteBehind(this._context.getCacheImpl(), filteredKeys, filteredValues, clone, null, taskId, providerName, OpCode.Add, WriteBehindAsyncProcessor.TaskState.Execute);
            }
        }
        return result;
    }

    private void EnqueueRetryOperations(String[] keys, Object[] values, CacheEntry[] entries, HashMap returnSet, OpCode opCode, String providerName, String taskId, OperationContext operationContext) throws Exception {
        ArrayList<DSWriteBehindOperation> operations = new ArrayList<DSWriteBehindOperation>();
        DSWriteBehindOperation dsOperation = null;
        if (values == null) {
            values = new Object[keys.length];
        }
        for (int i = 0; i < keys.length; ++i) {
            OperationResult.Status status;
            if (!returnSet.containsKey(keys[i]) || !(returnSet.get(keys[i]) instanceof OperationResult.Status) || (status = (OperationResult.Status)returnSet.get(keys[i])) != OperationResult.Status.FailureRetry) continue;
            this._context.getNCacheLog().Info("Retrying Write Operation: " + opCode + " for key:" + keys[i]);
            dsOperation = new DSWriteBehindOperation(this.getName(), keys[i], values[i], entries[i], opCode, providerName, 0L, taskId, null, WriteBehindAsyncProcessor.TaskState.Execute);
            operations.add(dsOperation);
        }
        if (operations.size() > 0) {
            this._context.getCacheImpl().EnqueueDSOperation(operations);
        }
    }

    private HashMap Add(Object[] keys, CacheEntry[] entries, OperationContext operationContext) throws OperationFailedException {
        try {
            HashMap result = new HashMap();
            result = this._context.getCacheImpl().Add(keys, entries, true, operationContext);
            if (result != null) {
                HashMap tmp = (HashMap)result.clone();
                for (Map.Entry entry : tmp.entrySet()) {
                    CacheAddResult addResult = CacheAddResult.Failure;
                    if (!(entry.getValue() instanceof CacheAddResult)) continue;
                    addResult = (CacheAddResult)((Object)entry.getValue());
                    switch (addResult) {
                        case Failure: {
                            break;
                        }
                        case KeyExists: {
                            result.put(entry.getKey(), new OperationFailedException("The specified key already exists."));
                            break;
                        }
                        case NeedsEviction: {
                            result.put(entry.getKey(), new OperationFailedException("The cache is full and not enough items could be evicted."));
                            break;
                        }
                        case Success: {
                            result.remove(entry.getKey());
                        }
                    }
                }
            }
            return result;
        }
        catch (OperationFailedException inner) {
            if (inner.getIsTracable()) {
                this._context.getNCacheLog().Error("Cache.Add():", inner.toString());
            }
            throw inner;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.Add():", inner.toString());
            throw new OperationFailedException("Add operation failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
    }

    public final long InsertEntry(Object entry, OperationContext operationContext) throws OperationFailedException, Exception {
        if (!this.getIsRunning()) {
            return 0L;
        }
        CompactCacheEntry cce = null;
        cce = (CompactCacheEntry)entry;
        CacheEntry e = this.MakeCacheEntry(cce);
        String group = null;
        String subgroup = null;
        if (e.getGroupInfo() != null && e.getGroupInfo().getGroup() != null) {
            group = e.getGroupInfo().getGroup();
            subgroup = e.getGroupInfo().getSubGroup();
        }
        return this.Insert(cce.getKey(), e.getValue(), e.getExpirationHint(), e.getSyncDependency(), e.getEvictionHint(), group, subgroup, e.getQueryInfo(), e.getFlag(), e.getLockId(), e.getVersion(), e.getLockAccessType(), e.getProviderName(), e.getResyncProviderName(), operationContext);
    }

    public final long Insert(Object key, Object value) throws OperationFailedException {
        return this.Insert(key, value, null, null, null, null, null, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
    }

    public final long Insert(Object key, Object value, ExpirationHint expiryHint) throws OperationFailedException {
        return this.Insert(key, value, expiryHint, null, null, null, null, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
    }

    public final long Insert(Object key, Object value, EvictionHint evictionHint) throws OperationFailedException {
        return this.Insert(key, value, null, null, evictionHint, null, null, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
    }

    public final long Insert(Object key, Object value, ExpirationHint expiryHint, CacheSyncDependency syncDependency, EvictionHint evictionHint, String group, String subGroup, OperationContext operationContext) throws OperationFailedException {
        return this.Insert(key, value, expiryHint, syncDependency, evictionHint, group, subGroup, null, operationContext);
    }

    public final long Insert(Object key, Object value, ExpirationHint expiryHint, CacheSyncDependency syncDependency, EvictionHint evictionHint, String group, String subGroup, HashMap queryInfo, OperationContext operationContext) throws OperationFailedException {
        return this.Insert(key, value, expiryHint, syncDependency, evictionHint, group, subGroup, queryInfo, new BitSet(), operationContext, null);
    }

    public final long Insert(Object key, Object value, ExpirationHint expiryHint, CacheSyncDependency syncDependency, EvictionHint evictionHint, String group, String subGroup, HashMap queryInfo, BitSet flag, OperationContext operationContext, HPTime bridgeOperationTime) throws OperationFailedException {
        if (key == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: value");
        }
        if (!(key instanceof Serializable)) {
            throw new IllegalArgumentException("key is not serializable");
        }
        if (expiryHint != null && !(expiryHint instanceof Serializable)) {
            throw new IllegalArgumentException("expiryHint is not not serializable");
        }
        if (evictionHint != null && !(evictionHint instanceof Serializable)) {
            throw new IllegalArgumentException("evictionHint is not serializable");
        }
        if (!this.getIsRunning()) {
            return 0L;
        }
        DataSourceUpdateOptions updateOpts = this.UpdateOption(flag);
        this.CheckDataSourceAvailabilityAndOptions(updateOpts);
        GroupInfo grpInfo = new GroupInfo(group, subGroup);
        CacheEntry e = new CacheEntry(value, expiryHint, evictionHint);
        e.setGroupInfo(grpInfo);
        e.setSyncDependency(syncDependency);
        e.setQueryInfo(queryInfo);
        e.getFlag().setData((byte)(e.getFlag().getData() | flag.getData()));
        e.setBridgeOpTimeStamp(bridgeOperationTime);
        long version = 0L;
        try {
            this._context.PerfStatsColl.mSecPerUpdBeginSample();
            version = this.Insert(key, e, null, 0L, LockAccessType.IGNORE_LOCK, operationContext);
            this._context.PerfStatsColl.mSecPerUpdEndSample();
            OperationResult dsResult = null;
            String taskId = new GUID().toString();
            if (updateOpts == DataSourceUpdateOptions.WriteThru) {
                WriteOperation operation;
                dsResult = this._context.getDsMgr().WriteThru((String)(key instanceof String ? key : null), e, OpCode.Update, null, operationContext);
                if (dsResult != null && dsResult.getOperationStatus() == OperationResult.Status.FailureRetry && (operation = (WriteOperation)dsResult.getOperation()) != null) {
                    this._context.getNCacheLog().Info("Retrying Write Operation" + operation.getOperationType() + " operation for key:" + operation.getKey());
                    DSWriteBehindOperation dsOperation = new DSWriteBehindOperation(this.getName(), operation.getKey(), null, e, OpCode.Update, null, 0L, taskId, null, WriteBehindAsyncProcessor.TaskState.Execute);
                    this._context.getCacheImpl().EnqueueDSOperation(dsOperation);
                }
            } else if (!this._context.getIsClusteredImpl() && updateOpts == DataSourceUpdateOptions.WriteBehind && !this._context.getIsBridgeTargetCache()) {
                this._context.getDsMgr().WriteBehind(this._context.getCacheImpl(), key, e, null, taskId, null, OpCode.Update, WriteBehindAsyncProcessor.TaskState.Execute);
            }
        }
        catch (Exception inner) {
            throw new OperationFailedException((Throwable)inner);
        }
        return version;
    }

    public final long Insert(Object key, Object value, ExpirationHint expiryHint, CacheSyncDependency syncDependency, EvictionHint evictionHint, String group, String subGroup, HashMap queryInfo, BitSet flag, long version, OperationContext operationContext, HPTime bridgeOperationTime) throws OperationFailedException {
        if (key == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: value");
        }
        if (!(key instanceof Serializable)) {
            throw new IllegalArgumentException("key is not serializable");
        }
        if (expiryHint != null && !(expiryHint instanceof Serializable)) {
            throw new IllegalArgumentException("expiryHint is not not serializable");
        }
        if (evictionHint != null && !(evictionHint instanceof Serializable)) {
            throw new IllegalArgumentException("evictionHint is not serializable");
        }
        if (!this.getIsRunning()) {
            return 0L;
        }
        DataSourceUpdateOptions updateOpts = this.UpdateOption(flag);
        this.CheckDataSourceAvailabilityAndOptions(updateOpts);
        GroupInfo grpInfo = new GroupInfo(group, subGroup);
        CacheEntry e = new CacheEntry(value, expiryHint, evictionHint);
        e.setGroupInfo(grpInfo);
        e.setSyncDependency(syncDependency);
        e.setQueryInfo(queryInfo);
        e.getFlag().setData((byte)(e.getFlag().getData() | flag.getData()));
        e.setBridgeOpTimeStamp(bridgeOperationTime);
        long itemVersion = 0L;
        try {
            this._context.PerfStatsColl.mSecPerUpdBeginSample();
            itemVersion = this.Insert(key, e, null, version, LockAccessType.PRESERVE_VERSION, operationContext);
            this._context.PerfStatsColl.mSecPerUpdEndSample();
            OperationResult dsResult = null;
            String taskId = new GUID().toString();
            if (updateOpts == DataSourceUpdateOptions.WriteThru) {
                WriteOperation operation;
                dsResult = this._context.getDsMgr().WriteThru((String)(key instanceof String ? key : null), e, OpCode.Update, null, operationContext);
                if (dsResult != null && dsResult.getOperationStatus() == OperationResult.Status.FailureRetry && (operation = (WriteOperation)dsResult.getOperation()) != null) {
                    this._context.getNCacheLog().Info("Retrying Write Operation" + operation.getOperationType() + " operation for key:" + operation.getKey());
                    DSWriteBehindOperation dsOperation = new DSWriteBehindOperation(this.getName(), operation.getKey(), null, e, OpCode.Update, null, 0L, taskId, null, WriteBehindAsyncProcessor.TaskState.Execute);
                    this._context.getCacheImpl().EnqueueDSOperation(dsOperation);
                }
            } else if (!this._context.getIsClusteredImpl() && updateOpts == DataSourceUpdateOptions.WriteBehind && !this._context.getIsBridgeTargetCache()) {
                this._context.getDsMgr().WriteBehind(this._context.getCacheImpl(), key, e, null, taskId, null, OpCode.Update, WriteBehindAsyncProcessor.TaskState.Execute);
            }
        }
        catch (Exception inner) {
            throw new OperationFailedException((Throwable)inner);
        }
        return itemVersion;
    }

    public final long Insert(Object key, Object value, ExpirationHint expiryHint, CacheSyncDependency syncDependency, EvictionHint evictionHint, String group, String subGroup, HashMap queryInfo, BitSet flag, Object lockId, long version, LockAccessType accessType, String providerName, String resyncProviderName, OperationContext operationContext) throws OperationFailedException, Exception {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"Cache.Insert", (String)"");
        }
        if (key == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: value");
        }
        if (!(key instanceof Serializable)) {
            throw new IllegalArgumentException("key is not serializable");
        }
        if (expiryHint != null && !(expiryHint instanceof Serializable)) {
            throw new IllegalArgumentException("expiryHint is not not serializable");
        }
        if (evictionHint != null && !(evictionHint instanceof Serializable)) {
            throw new IllegalArgumentException("evictionHint is not serializable");
        }
        if (!this.getIsRunning()) {
            return 0L;
        }
        DataSourceUpdateOptions updateOpts = this.UpdateOption(flag);
        this.CheckDataSourceAvailabilityAndOptions(updateOpts);
        GroupInfo grpInfo = new GroupInfo(group, subGroup);
        CacheEntry e = new CacheEntry(value, expiryHint, evictionHint);
        e.setGroupInfo(grpInfo);
        e.setSyncDependency(syncDependency);
        e.setQueryInfo(queryInfo);
        e.getFlag().setData((byte)(e.getFlag().getData() | flag.getData()));
        e.setResyncProviderName(resyncProviderName);
        e.setProviderName(providerName);
        Object dataSize = operationContext.GetValueByField(OperationContextFieldName.ValueDataSize);
        if (operationContext != null && operationContext.Contains(OperationContextFieldName.ItemVersion)) {
            e.setVersion((Long)operationContext.GetValueByField(OperationContextFieldName.ItemVersion));
        } else {
            e.setVersion(NCDateTime.getUTCNow().getTime() - Time.ReferenceTime.getTime());
        }
        if (dataSize != null) {
            int tempSize = Integer.parseInt(dataSize.toString());
            e.setDataSize(tempSize);
        }
        long itemVersion = 0L;
        CacheEntry clone = updateOpts == DataSourceUpdateOptions.WriteThru || updateOpts == DataSourceUpdateOptions.WriteBehind ? (CacheEntry)e.clone() : e;
        if (_isClientCache) {
            operationContext.Add(OperationContextFieldName.WriteThru, 4);
            operationContext.Add(OperationContextFieldName.WriteBehind, 8);
            if (providerName != null) {
                operationContext.Add(OperationContextFieldName.WriteThruProviderName, providerName);
            }
        }
        this._context.PerfStatsColl.mSecPerUpdBeginSample();
        itemVersion = this.Insert(key, e, lockId, version, accessType, operationContext);
        this._context.PerfStatsColl.mSecPerUpdEndSample();
        OperationResult dsResult = null;
        String taskId = new GUID().toString();
        if (updateOpts == DataSourceUpdateOptions.WriteThru) {
            WriteOperation operation;
            dsResult = this._context.getDsMgr().WriteThru((String)(key instanceof String ? key : null), clone, OpCode.Update, providerName, operationContext);
            if (dsResult != null && dsResult.getOperationStatus() == OperationResult.Status.FailureRetry && (operation = (WriteOperation)dsResult.getOperation()) != null) {
                this._context.getNCacheLog().Info("Retrying Write Operation" + operation.getOperationType() + " operation for key:" + operation.getKey());
                DSWriteBehindOperation dsOperation = new DSWriteBehindOperation(this.getName(), operation.getKey(), null, clone, OpCode.Update, providerName, 0L, taskId, null, WriteBehindAsyncProcessor.TaskState.Execute);
                this._context.getCacheImpl().EnqueueDSOperation(dsOperation);
            }
        } else if (!this._context.getIsClusteredImpl() && updateOpts == DataSourceUpdateOptions.WriteBehind && !this._context.getIsBridgeTargetCache()) {
            this._context.getDsMgr().WriteBehind(this._context.getCacheImpl(), key, clone, null, taskId, providerName, OpCode.Update, WriteBehindAsyncProcessor.TaskState.Execute);
        }
        return itemVersion;
    }

    private DataSourceUpdateOptions UpdateOption(BitSet flag) {
        if (flag.IsBitSet((byte)4)) {
            return DataSourceUpdateOptions.WriteThru;
        }
        if (flag.IsBitSet((byte)8)) {
            return DataSourceUpdateOptions.WriteBehind;
        }
        return DataSourceUpdateOptions.None;
    }

    public final void InsertAsyncEntry(Object entry, OperationContext operationContext) throws OperationFailedException {
        ExpirationHint eh;
        if (!this.getIsRunning()) {
            return;
        }
        CompactCacheEntry cce = null;
        try {
            cce = (CompactCacheEntry)SerializationUtil.safeDeserialize((Object)entry, (String)this._context.getSerializationContext(), null);
        }
        catch (IOException iOException) {
            throw new OperationFailedException((Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new OperationFailedException((Throwable)classNotFoundException);
        }
        boolean isAbsolute = false;
        boolean isResync = false;
        int priority = CacheItemPriority.Normal.value();
        int opt = cce.getOptions();
        if (opt != 255) {
            isAbsolute = (opt & 1) != 0 ? Boolean.TRUE : Boolean.FALSE;
            isResync = ((opt >>= 1) & 1) != 0 ? Boolean.TRUE : Boolean.FALSE;
            priority = (opt >>= 1) - 2;
        }
        if ((eh = ConvHelper.MakeExpirationHint(cce.getExpiration(), isAbsolute)) != null && cce.getDependency() != null) {
            eh = new AggregateExpirationHint(cce.getDependency(), eh);
        }
        if (eh == null) {
            eh = cce.getDependency();
        }
        if (eh != null && isResync) {
            eh.SetBit(2);
        }
        this.InsertAsync(cce.getKey(), cce.getValue(), eh, cce.getSyncDependency(), new PriorityEvictionHint(CacheItemPriority.forValue((int)priority)), cce.getGroup(), cce.getSubGroup(), cce.getFlag(), cce.getQueryInfo(), cce.getProviderName(), cce.getResyncProviderName(), operationContext);
    }

    public final void InsertAsync(Object key, Object value, ExpirationHint expiryHint, CacheSyncDependency syncDependency, EvictionHint evictionHint, String group, String subGroup, OperationContext operationContext) {
        this.InsertAsync(key, value, expiryHint, syncDependency, evictionHint, group, subGroup, new BitSet(), null, null, null, operationContext);
    }

    public final void InsertAsync(Object key, Object value, ExpirationHint expiryHint, CacheSyncDependency syncDependency, EvictionHint evictionHint, String group, String subGroup, BitSet Flag, HashMap queryInfo, String providerName, String resyncProviderName, OperationContext operationContext) {
        if (key == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: value");
        }
        if (!(key instanceof Serializable)) {
            throw new IllegalArgumentException("key is not serializable");
        }
        if (expiryHint != null && !(expiryHint instanceof Serializable)) {
            throw new IllegalArgumentException("expiryHint is not not serializable");
        }
        if (evictionHint != null && !(evictionHint instanceof Serializable)) {
            throw new IllegalArgumentException("evictionHint is not serializable");
        }
        if (!this.getIsRunning()) {
            return;
        }
        this._asyncProcessor.Enqueue((AsyncProcessor.IAsyncTask)new AsyncInsert(this, key, value, expiryHint, syncDependency, evictionHint, group, subGroup, Flag, queryInfo, providerName, resyncProviderName, operationContext));
    }

    private long Insert(Object key, CacheEntry e, Object lockId, long version, LockAccessType accessType, OperationContext operationContext) throws OperationFailedException {
        HPTimeStats insertTime = new HPTimeStats();
        insertTime.BeginSample();
        Object value = e.getValue();
        try {
            CacheInsResultWithEntry retVal = this.CascadedInsert(key, e, true, lockId, version, accessType, operationContext);
            insertTime.EndSample();
            switch (retVal.getResult()) {
                case Failure: {
                    break;
                }
                case NeedsEviction: 
                case NeedsEvictionNotRemove: {
                    throw new OperationFailedException("The cache is full and not enough items could be evicted.", false);
                }
                case SuccessOverwrite: {
                    this._context.PerfStatsColl.incrementUpdPerSecStats();
                    return retVal.getEntry() == null ? 1L : retVal.getEntry().getVersion() + 1L;
                }
                case Success: {
                    this._context.PerfStatsColl.incrementAddPerSecStats();
                    return retVal.getEntry() == null ? e.getVersion() : retVal.getEntry().getVersion();
                }
                case IncompatibleGroup: {
                    throw new OperationFailedException("Data group of the inserted item does not match the existing item's data group.");
                }
                case ItemLocked: {
                    throw new LockingException("Item is locked.");
                }
                case VersionMismatch: {
                    throw new LockingException("Item does not exist at the specified version.");
                }
            }
        }
        catch (OperationFailedException inner) {
            if (inner.getIsTracable()) {
                this._context.getNCacheLog().Error("Cache.Insert():", inner.toString());
            }
            throw inner;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.Insert():", inner.toString());
            throw new OperationFailedException("Insert operation failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
        return 0L;
    }

    public final Map InsertEntries(Object[] entries, OperationContext operationContext) throws OperationFailedException, Exception {
        if (!this.getIsRunning()) {
            return null;
        }
        Object[] keys = new String[entries.length];
        Object[] values = new Object[entries.length];
        CallbackEntry[] callbackEnteries = new CallbackEntry[entries.length];
        ExpirationHint[] exp = new ExpirationHint[entries.length];
        EvictionHint[] evc = new EvictionHint[entries.length];
        CacheSyncDependency[] csd = new CacheSyncDependency[entries.length];
        BitSet[] flags = new BitSet[entries.length];
        HashMap[] queryInfo = new HashMap[entries.length];
        GroupInfo[] groupInfos = new GroupInfo[entries.length];
        CallbackEntry cbEntry = null;
        for (int i = 0; i < entries.length; ++i) {
            CompactCacheEntry cce = (CompactCacheEntry)SerializationUtil.safeDeserialize((Object)entries[i], (String)this._context.getSerializationContext(), null);
            Object tempVar = cce.getKey();
            keys[i] = (String)(tempVar instanceof String ? tempVar : null);
            CacheEntry ce = this.MakeCacheEntry(cce);
            if (ce != null) {
                if (ce.getValue() instanceof CallbackEntry) {
                    Object tempVar2 = ce.getValue();
                    cbEntry = (CallbackEntry)(tempVar2 instanceof CallbackEntry ? tempVar2 : null);
                }
            } else {
                cbEntry = null;
            }
            callbackEnteries[i] = cbEntry;
            Object tempVar3 = ce.getValue();
            CallbackEntry value = (CallbackEntry)(tempVar3 instanceof CallbackEntry ? tempVar3 : null);
            values[i] = value == null ? ce.getValue() : ((CallbackEntry)ce.getValue()).getValue();
            exp[i] = ce.getExpirationHint();
            evc[i] = ce.getEvictionHint();
            csd[i] = ce.getSyncDependency();
            queryInfo[i] = ce.getQueryInfo();
            groupInfos[i] = ce.getGroupInfo();
            flags[i] = ce.getFlag();
        }
        Map items = this.Insert(keys, values, callbackEnteries, exp, csd, evc, groupInfos, queryInfo, flags, null, null, operationContext);
        if (items != null) {
            this.CompileReturnSet((HashMap)items);
        }
        return items;
    }

    public final Map Insert(Object[] keys, Object[] values, ExpirationHint expiryHint, OperationContext operationContext) throws OperationFailedException {
        return this.Insert(keys, values, expiryHint, null, null, null, operationContext);
    }

    public final Map Insert(Object[] keys, Object[] values, EvictionHint evictionHint, OperationContext operationContext) throws OperationFailedException {
        return this.Insert(keys, values, null, evictionHint, null, null, operationContext);
    }

    public final Map Insert(Object[] keys, Object[] values, ExpirationHint expiryHint, EvictionHint evictionHint, String group, String subGroup, OperationContext operationContext) throws OperationFailedException {
        if (keys == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: keys");
        }
        if (values == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: values");
        }
        if (keys.length != values.length) {
            throw new IllegalArgumentException("keys count is not equal to values count");
        }
        CacheEntry[] ce = new CacheEntry[values.length];
        for (int i = 0; i < values.length; ++i) {
            Object key = keys[i];
            Object value = values[i];
            if (key == null) {
                throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
            }
            if (value == null) {
                throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: value");
            }
            if (!(key instanceof Serializable)) {
                throw new IllegalArgumentException("key is not serializable");
            }
            if (expiryHint != null && !(expiryHint instanceof Serializable)) {
                throw new IllegalArgumentException("expiryHint is not not serializable");
            }
            if (evictionHint != null && !(evictionHint instanceof Serializable)) {
                throw new IllegalArgumentException("evictionHint is not serializable");
            }
            if (!this.getIsRunning()) {
                return null;
            }
            ce[i] = new CacheEntry(value, expiryHint, evictionHint);
            GroupInfo grpInfo = new GroupInfo(group, subGroup);
            ce[i].setGroupInfo(grpInfo);
        }
        try {
            return this.Insert(keys, ce, operationContext);
        }
        catch (Exception inner) {
            throw new OperationFailedException((Throwable)inner);
        }
    }

    public final Map Insert(Object[] keys, Object[] values, CallbackEntry[] callbackEnteries, ExpirationHint[] expirations, CacheSyncDependency[] syncDependencies, EvictionHint[] evictions, GroupInfo[] groupInfos, HashMap[] queryInfos, BitSet[] flags, String providername, String resyncProviderName, OperationContext operationContext) throws OperationFailedException, Exception {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"Cache.InsertBlk", (String)"");
        }
        if (keys == null) {
            throw new IllegalArgumentException("keys");
        }
        if (values == null) {
            throw new IllegalArgumentException("items");
        }
        if (keys.length != values.length) {
            throw new IllegalArgumentException("keys count is not equal to values count");
        }
        DataSourceUpdateOptions updateOpts = this.UpdateOption(flags[0]);
        this.CheckDataSourceAvailabilityAndOptions(updateOpts);
        CacheEntry[] ce = new CacheEntry[values.length];
        Object dataSize = operationContext.GetValueByField(OperationContextFieldName.ValueDataSize);
        long[] sizes = null;
        if (dataSize != null) {
            sizes = new long[keys.length];
            int count = 0;
            long[] lArray = (long[])dataSize;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                long sizeValue;
                sizes[count] = sizeValue = lArray[i];
                ++count;
            }
        }
        for (int i = 0; i < values.length; ++i) {
            if (keys[i] == null) {
                throw new IllegalArgumentException("Value cannot be null" + System.lineSeparator() + "Parameter name: key");
            }
            if (values[i] == null) {
                throw new IllegalArgumentException("Value cannot be null" + System.lineSeparator() + "Parameter name: value");
            }
            if (!(keys[i] instanceof Serializable)) {
                throw new IllegalArgumentException("key is not serializable");
            }
            if (expirations[i] != null && !(expirations[i] instanceof Serializable)) {
                throw new IllegalArgumentException("expiryHint is not not serializable");
            }
            if (evictions[i] != null && !(evictions[i] instanceof Serializable)) {
                throw new IllegalArgumentException("evictionHint is not serializable");
            }
            if (!this.getIsRunning()) {
                return null;
            }
            ce[i] = new CacheEntry(values[i], expirations[i], evictions[i]);
            ce[i].setSyncDependency(syncDependencies[i]);
            ce[i].setGroupInfo(groupInfos[i]);
            ce[i].setQueryInfo(queryInfos[i]);
            ce[i].getFlag().setData((byte)(ce[i].getFlag().getData() | flags[i].getData()));
            ce[i].setProviderName(providername);
            if (sizes != null) {
                ce[i].setDataSize(sizes[i]);
            }
            if (callbackEnteries[i] == null) continue;
            Object tempVar = callbackEnteries[i].clone();
            CallbackEntry cloned = (CallbackEntry)(tempVar instanceof CallbackEntry ? tempVar : null);
            cloned.setValue(values[i]);
            cloned.setFlag(ce[i].getFlag());
            ce[i].setValue(cloned);
        }
        CacheEntry[] clone = null;
        if (updateOpts == DataSourceUpdateOptions.WriteBehind || updateOpts == DataSourceUpdateOptions.WriteThru) {
            clone = new CacheEntry[ce.length];
            for (int i = 0; i < ce.length; ++i) {
                clone[i] = ce[i].getHasQueryInfo() ? (CacheEntry)ce[i].clone() : ce[i];
            }
        }
        HPTimeStats insertTime = new HPTimeStats();
        insertTime.BeginSample();
        HashMap result = this.Insert(keys, ce, operationContext);
        insertTime.EndSample();
        Object[] filteredKeys = null;
        Object[] filteredValues = null;
        if (updateOpts != DataSourceUpdateOptions.None && keys.length > result.size()) {
            filteredKeys = new String[keys.length - result.size()];
            filteredValues = new Object[keys.length - result.size()];
            int j = 0;
            for (int i = 0; i < keys.length; ++i) {
                if (result.containsKey(keys[i])) continue;
                filteredKeys[j] = (String)(keys[i] instanceof String ? keys[i] : null);
                if (!this._inProc) {
                    UserBinaryObject ubObject = (UserBinaryObject)(values[i] instanceof UserBinaryObject ? values[i] : null);
                    filteredValues[j] = CompressionUtil.Decompress((byte[])ubObject.getFullObject(), (BitSet)ce[i].getFlag());
                    filteredValues[j] = EncryptionUtil.DecryptData((byte[])filteredValues[j], this._context.getSerializationContext());
                }
                ++j;
            }
            OperationResult[] dsResults = null;
            String taskId = new GUID().toString();
            if (updateOpts == DataSourceUpdateOptions.WriteThru && !this._context.getIsBridgeTargetCache()) {
                dsResults = this._context.getDsMgr().WriteThru((String[])filteredKeys, filteredValues, clone, result instanceof HashMap ? result : null, OpCode.Update, providername, operationContext);
                if (dsResults != null) {
                    this.EnqueueRetryOperations((String[])filteredKeys, filteredValues, clone, result instanceof HashMap ? result : null, OpCode.Update, providername, taskId, operationContext);
                }
            } else if (!this._context.getIsClusteredImpl() && updateOpts == DataSourceUpdateOptions.WriteBehind) {
                this._context.getDsMgr().WriteBehind(this._context.getCacheImpl(), filteredKeys, filteredValues, clone, null, taskId, providername, OpCode.Update, WriteBehindAsyncProcessor.TaskState.Execute);
            }
        }
        return result;
    }

    private HashMap Insert(Object[] keys, CacheEntry[] entries, OperationContext operationContext) throws OperationFailedException {
        try {
            HashMap result = this.CascadedInsert(keys, entries, true, operationContext);
            if (result != null) {
                HashMap tmp = (HashMap)result.clone();
                for (Map.Entry pair : tmp.entrySet()) {
                    CacheInsResultWithEntry insResult = null;
                    if (!(pair.getValue() instanceof CacheInsResultWithEntry)) continue;
                    insResult = (CacheInsResultWithEntry)pair.getValue();
                    switch (insResult.getResult()) {
                        case Failure: {
                            break;
                        }
                        case NeedsEviction: {
                            result.put(pair.getKey(), new OperationFailedException("The cache is full and not enough items could be evicted."));
                            break;
                        }
                        case Success: {
                            result.remove(pair.getKey());
                            break;
                        }
                        case SuccessOverwrite: {
                            result.remove(pair.getKey());
                            break;
                        }
                        case IncompatibleGroup: {
                            result.put(pair.getKey(), new OperationFailedException("Data group of the inserted item does not match the existing item's data group"));
                        }
                    }
                }
            }
            return result;
        }
        catch (OperationFailedException inner) {
            if (inner.getIsTracable()) {
                this._context.getNCacheLog().Error("Cache.Insert()", inner.toString());
            }
            throw inner;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.Insert()", inner.toString());
            throw new OperationFailedException("Insert operation failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
    }

    public final CompressedValueEntry Remove(Object key, OperationContext operationContext) throws OperationFailedException {
        return this.Remove((String)(key instanceof String ? key : null), new BitSet(), null, null, 0L, LockAccessType.IGNORE_LOCK, null, operationContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void Remove(String group, String subGroup, OperationContext operationContext) throws OperationFailedException {
        if (group == null) {
            throw new IllegalArgumentException("group");
        }
        if (!this.getIsRunning()) {
            return;
        }
        try {
            HPTimeStats removeTime = new HPTimeStats();
            removeTime.BeginSample();
            HashMap removed = this.CascadedRemove(group, subGroup, true, operationContext);
            removeTime.EndSample();
            if (removed != null) return;
        }
        catch (StateTransferInProgressException se) {
            throw se;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.Remove()", inner.toString());
            throw new OperationFailedException("Remove operation failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
    }

    public final CompressedValueEntry Remove(String key, BitSet flag, CallbackEntry cbEntry, Object lockId, long version, LockAccessType accessType, String providerName, OperationContext operationContext) throws OperationFailedException {
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        if (!(key instanceof Serializable)) {
            throw new IllegalArgumentException("key is not serializable");
        }
        if (!this.getIsRunning()) {
            return null;
        }
        DataSourceUpdateOptions updateOpts = this.UpdateOption(flag);
        this.CheckDataSourceAvailabilityAndOptions(updateOpts);
        try {
            HPTimeStats removeTime = new HPTimeStats();
            removeTime.BeginSample();
            this._context.PerfStatsColl.mSecPerDelBeginSample();
            Object[] packedKey = key;
            if (this._context.getIsClusteredImpl() && updateOpts == DataSourceUpdateOptions.WriteBehind) {
                packedKey = new Object[]{key, updateOpts, cbEntry, providerName};
            }
            CacheEntry e = this.CascadedRemove(key, packedKey, ItemRemoveReason.Removed, true, lockId, version, accessType, operationContext);
            this._context.PerfStatsColl.mSecPerDelEndSample();
            this._context.PerfStatsColl.incrementDelPerSecStats();
            removeTime.EndSample();
            if (e != null) {
                OperationResult dsResult = null;
                String taskId = new GUID().toString();
                if (updateOpts == DataSourceUpdateOptions.WriteThru && !this._context.getIsBridgeTargetCache() && !this._context.getIsBridgeTargetCache()) {
                    WriteOperation operation;
                    dsResult = this._context.getDsMgr().WriteThru((String)(key instanceof String ? key : null), e, OpCode.Remove, providerName, operationContext);
                    if (dsResult != null && dsResult.getOperationStatus() == OperationResult.Status.FailureRetry && (operation = (WriteOperation)dsResult.getOperation()) != null) {
                        this._context.getNCacheLog().Info("Retrying Write Operation" + operation.getOperationType() + " operation for key:" + operation.getKey());
                        DSWriteBehindOperation dsOperation = new DSWriteBehindOperation(this.getName(), operation.getKey(), null, e, OpCode.Remove, providerName, 0L, taskId, null, WriteBehindAsyncProcessor.TaskState.Execute);
                        this._context.getCacheImpl().EnqueueDSOperation(dsOperation);
                    }
                } else if (!this._context.getIsClusteredImpl() && updateOpts == DataSourceUpdateOptions.WriteBehind) {
                    if (cbEntry != null) {
                        if (e.getValue() instanceof CallbackEntry) {
                            ((CallbackEntry)e.getValue()).setWriteBehindOperationCompletedCallback(cbEntry.getWriteBehindOperationCompletedCallback());
                        } else {
                            cbEntry.setValue(e.getValue());
                            e.setValue(cbEntry);
                        }
                    }
                    this._context.getDsMgr().WriteBehind(this._context.getCacheImpl(), key instanceof String ? key : null, e, null, taskId, providerName, OpCode.Remove, WriteBehindAsyncProcessor.TaskState.Execute);
                }
            }
            if (e != null) {
                CompressedValueEntry obj = new CompressedValueEntry();
                obj.setValue(e.getValue());
                obj.setFlag(e.getFlag());
                if (obj.value instanceof CallbackEntry) {
                    obj.value = ((CallbackEntry)obj.value).getValue();
                }
                return obj;
            }
        }
        catch (OperationFailedException ex) {
            if (ex.getIsTracable()) {
                this._context.getNCacheLog().Error("Cache.Remove()", ex.toString());
            }
            throw ex;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.Remove()", inner.toString());
            throw new OperationFailedException("Remove operation failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
        return null;
    }

    public final void Delete(String key, BitSet flag, CallbackEntry cbEntry, Object lockId, long version, LockAccessType accessType, String providerName, OperationContext operationContext) throws OperationFailedException {
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        if (!(key instanceof Serializable)) {
            throw new IllegalArgumentException("key is not serializable");
        }
        if (!this.getIsRunning()) {
            return;
        }
        DataSourceUpdateOptions updateOpts = this.UpdateOption(flag);
        this.CheckDataSourceAvailabilityAndOptions(updateOpts);
        try {
            HPTimeStats removeTime = new HPTimeStats();
            removeTime.BeginSample();
            this._context.PerfStatsColl.mSecPerDelBeginSample();
            Object[] packedKey = key;
            if (this._context.getIsClusteredImpl() && updateOpts == DataSourceUpdateOptions.WriteBehind) {
                packedKey = new Object[]{key, updateOpts, cbEntry, providerName};
            }
            CacheEntry e = this.CascadedRemove(key, packedKey, ItemRemoveReason.Removed, true, lockId, version, accessType, operationContext);
            this._context.PerfStatsColl.mSecPerDelEndSample();
            this._context.PerfStatsColl.incrementDelPerSecStats();
            removeTime.EndSample();
            if (e != null) {
                OperationResult dsResult = null;
                String taskId = new GUID().toString();
                if (updateOpts == DataSourceUpdateOptions.WriteThru && !this._context.getIsBridgeTargetCache() && !this._context.getIsBridgeTargetCache()) {
                    WriteOperation operation;
                    dsResult = this._context.getDsMgr().WriteThru((String)(key instanceof String ? key : null), e, OpCode.Remove, providerName, operationContext);
                    if (dsResult != null && dsResult.getOperationStatus() == OperationResult.Status.FailureRetry && (operation = (WriteOperation)dsResult.getOperation()) != null) {
                        this._context.getNCacheLog().Info("Retrying Write Operation" + operation.getOperationType() + " operation for key:" + operation.getKey());
                        DSWriteBehindOperation dsOperation = new DSWriteBehindOperation(this.getName(), operation.getKey(), null, e, OpCode.Remove, providerName, 0L, taskId, null, WriteBehindAsyncProcessor.TaskState.Execute);
                        this._context.getCacheImpl().EnqueueDSOperation(dsOperation);
                    }
                } else if (!this._context.getIsClusteredImpl() && updateOpts == DataSourceUpdateOptions.WriteBehind) {
                    if (cbEntry != null) {
                        if (e.getValue() instanceof CallbackEntry) {
                            ((CallbackEntry)e.getValue()).setWriteBehindOperationCompletedCallback(cbEntry.getWriteBehindOperationCompletedCallback());
                        } else {
                            cbEntry.setValue(e.getValue());
                            e.setValue(cbEntry);
                        }
                    }
                    this._context.getDsMgr().WriteBehind(this._context.getCacheImpl(), key instanceof String ? key : null, e, null, taskId, providerName, OpCode.Remove, WriteBehindAsyncProcessor.TaskState.Execute);
                }
            }
        }
        catch (OperationFailedException ex) {
            if (ex.getIsTracable()) {
                this._context.getNCacheLog().Error("Cache.Delete()", ex.toString());
            }
            throw ex;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.Delete()", inner.toString());
            throw new OperationFailedException("Delete operation failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
    }

    public final void RemoveAsync(Object key, OperationContext operationContext) {
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        if (!(key instanceof Serializable)) {
            throw new IllegalArgumentException("key is not serializable");
        }
        if (!this.getIsRunning()) {
            return;
        }
        this._asyncProcessor.Enqueue((AsyncProcessor.IAsyncTask)new AsyncRemove(this, key, operationContext));
    }

    public final Map Remove(Object[] keys, BitSet flagMap, CallbackEntry cbEntry, String providerName, OperationContext operationContext) throws OperationFailedException {
        if (keys == null) {
            throw new IllegalArgumentException("keys");
        }
        if (!this.getIsRunning()) {
            return null;
        }
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(keys, AllowedOperationType.BulkWrite, operationContext)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        DataSourceUpdateOptions updateOpts = this.UpdateOption(flagMap);
        this.CheckDataSourceAvailabilityAndOptions(updateOpts);
        try {
            HPTimeStats removeTime = new HPTimeStats();
            removeTime.BeginSample();
            if (this._context.getIsClusteredImpl() && updateOpts == DataSourceUpdateOptions.WriteBehind) {
                Object[] pack;
                keys[0] = pack = new Object[]{keys[0], updateOpts, cbEntry, providerName};
            }
            HashMap removed = this.CascadedRemove(keys, ItemRemoveReason.Removed, true, operationContext);
            removeTime.EndSample();
            if (!(updateOpts == DataSourceUpdateOptions.None || removed == null || removed.size() <= 0 || this._context.getIsClusteredImpl() && updateOpts == DataSourceUpdateOptions.WriteBehind)) {
                Object[] filteredKeys = null;
                CacheEntry[] filteredEntries = null;
                filteredKeys = new String[removed.size()];
                filteredEntries = new CacheEntry[removed.size()];
                int j = 0;
                for (int i = 0; i < keys.length; ++i) {
                    if (!(removed.get(keys[i]) instanceof CacheEntry)) continue;
                    filteredKeys[j] = (String)(keys[i] instanceof String ? keys[i] : null);
                    filteredEntries[j++] = removed.get(keys[i]) instanceof CacheEntry ? removed.get(keys[i]) : null;
                }
                if (removed.size() > j) {
                    RefObject tempRef_filteredKeys = new RefObject((Object)filteredKeys);
                    Cache.Resize((RefObject<Object[]>)tempRef_filteredKeys, j);
                    filteredKeys = (String[])tempRef_filteredKeys.argvalue;
                    RefObject tempRef_filteredEntries = new RefObject((Object)filteredEntries);
                    Cache.Resize((RefObject<Object[]>)tempRef_filteredEntries, j);
                    filteredEntries = (CacheEntry[])tempRef_filteredEntries.argvalue;
                }
                OperationResult[] dsResults = null;
                String taskId = new GUID().toString();
                if (updateOpts == DataSourceUpdateOptions.WriteThru && !this._context.getIsBridgeTargetCache()) {
                    HashMap returnSet = new HashMap();
                    dsResults = this._context.getDsMgr().WriteThru((String[])filteredKeys, null, filteredEntries, returnSet, OpCode.Remove, providerName, operationContext);
                    if (dsResults != null) {
                        this.EnqueueRetryOperations((String[])filteredKeys, null, filteredEntries, returnSet, OpCode.Remove, providerName, taskId, operationContext);
                    }
                } else if (!this._context.getIsClusteredImpl() && updateOpts == DataSourceUpdateOptions.WriteBehind) {
                    if (cbEntry != null && filteredEntries != null) {
                        for (int i = 0; i < filteredEntries.length; ++i) {
                            if (filteredEntries[i].getValue() instanceof CallbackEntry) {
                                ((CallbackEntry)filteredEntries[i].getValue()).setWriteBehindOperationCompletedCallback(cbEntry.getWriteBehindOperationCompletedCallback());
                                continue;
                            }
                            cbEntry.setValue(filteredEntries[i].getValue());
                            filteredEntries[i].setValue(cbEntry);
                        }
                    }
                    this._context.getDsMgr().WriteBehind(this._context.getCacheImpl(), filteredKeys, null, filteredEntries, null, taskId, providerName, OpCode.Remove, WriteBehindAsyncProcessor.TaskState.Execute);
                }
            }
            CompressedValueEntry val = null;
            if (removed != null) {
                Object[] keysCollection = new Object[removed.size()];
                System.arraycopy(removed.keySet().toArray(), 0, keysCollection, 0, removed.keySet().size());
                for (Object curVal : Arrays.asList(keysCollection)) {
                    CacheEntry entry = removed.get(curVal) instanceof CacheEntry ? removed.get(curVal) : null;
                    if (entry == null) continue;
                    val = new CompressedValueEntry();
                    val.value = entry.getValue();
                    if (val.value instanceof CallbackEntry) {
                        val.value = ((CallbackEntry)val.value).getValue();
                    }
                    val.setFlag(entry.getFlag());
                    removed.put(curVal, val);
                }
            }
            return removed;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.Remove()", inner.toString());
            throw new OperationFailedException("Remove operation failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
    }

    public final void Delete(Object[] keys, BitSet flagMap, CallbackEntry cbEntry, String providerName, OperationContext operationContext) throws OperationFailedException {
        if (keys == null) {
            throw new IllegalArgumentException("keys");
        }
        if (!this.getIsRunning()) {
            return;
        }
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(keys, AllowedOperationType.BulkWrite, operationContext)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        DataSourceUpdateOptions updateOpts = this.UpdateOption(flagMap);
        this.CheckDataSourceAvailabilityAndOptions(updateOpts);
        try {
            HPTimeStats removeTime = new HPTimeStats();
            removeTime.BeginSample();
            if (this._context.getIsClusteredImpl() && updateOpts == DataSourceUpdateOptions.WriteBehind) {
                Object[] pack;
                keys[0] = pack = new Object[]{keys[0], updateOpts, cbEntry, providerName};
            }
            HashMap removed = this.CascadedRemove(keys, ItemRemoveReason.Removed, true, operationContext);
            removeTime.EndSample();
            if (!(updateOpts == DataSourceUpdateOptions.None || removed == null || removed.size() <= 0 || this._context.getIsClusteredImpl() && updateOpts == DataSourceUpdateOptions.WriteBehind)) {
                Object[] filteredKeys = null;
                CacheEntry[] filteredEntries = null;
                filteredKeys = new String[removed.size()];
                filteredEntries = new CacheEntry[removed.size()];
                int j = 0;
                for (int i = 0; i < keys.length; ++i) {
                    if (!(removed.get(keys[i]) instanceof CacheEntry)) continue;
                    filteredKeys[j] = (String)(keys[i] instanceof String ? keys[i] : null);
                    filteredEntries[j++] = removed.get(keys[i]) instanceof CacheEntry ? removed.get(keys[i]) : null;
                }
                if (removed.size() > j) {
                    RefObject tempRef_filteredKeys = new RefObject((Object)filteredKeys);
                    Cache.Resize((RefObject<Object[]>)tempRef_filteredKeys, j);
                    filteredKeys = (String[])tempRef_filteredKeys.argvalue;
                    RefObject tempRef_filteredEntries = new RefObject((Object)filteredEntries);
                    Cache.Resize((RefObject<Object[]>)tempRef_filteredEntries, j);
                    filteredEntries = (CacheEntry[])tempRef_filteredEntries.argvalue;
                }
                OperationResult[] dsResults = null;
                String taskId = new GUID().toString();
                if (updateOpts == DataSourceUpdateOptions.WriteThru && !this._context.getIsBridgeTargetCache()) {
                    HashMap returnSet = new HashMap();
                    dsResults = this._context.getDsMgr().WriteThru((String[])filteredKeys, null, filteredEntries, returnSet, OpCode.Remove, providerName, operationContext);
                    if (dsResults != null) {
                        this.EnqueueRetryOperations((String[])filteredKeys, null, filteredEntries, returnSet, OpCode.Remove, providerName, taskId, operationContext);
                    }
                } else if (!this._context.getIsClusteredImpl() && updateOpts == DataSourceUpdateOptions.WriteBehind) {
                    if (cbEntry != null && filteredEntries != null) {
                        for (int i = 0; i < filteredEntries.length; ++i) {
                            if (filteredEntries[i].getValue() instanceof CallbackEntry) {
                                ((CallbackEntry)filteredEntries[i].getValue()).setWriteBehindOperationCompletedCallback(cbEntry.getWriteBehindOperationCompletedCallback());
                                continue;
                            }
                            cbEntry.setValue(filteredEntries[i].getValue());
                            filteredEntries[i].setValue(cbEntry);
                        }
                    }
                    this._context.getDsMgr().WriteBehind(this._context.getCacheImpl(), filteredKeys, null, filteredEntries, null, taskId, providerName, OpCode.Remove, WriteBehindAsyncProcessor.TaskState.Execute);
                }
            }
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.Delete()", inner.toString());
            throw new OperationFailedException("Delete operation failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
    }

    public final Iterator GetEnumerator() throws OperationFailedException {
        if (!this.getIsRunning()) {
            return null;
        }
        try {
            if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(AllowedOperationType.ClusterRead, new OperationContext())) {
                this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
            }
            return new CacheEnumerator(this._context.getSerializationContext(), this._context.getCacheImpl().GetEnumerator());
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.GetEnumerator()", inner.toString());
            throw new OperationFailedException("GetEnumerator failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
    }

    public final EnumerationDataChunk GetNextChunk(EnumerationPointer pointer, OperationContext operationContext) throws OperationFailedException {
        EnumerationDataChunk chunk = null;
        if (!this.getIsRunning()) {
            return null;
        }
        try {
            if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(AllowedOperationType.BulkWrite, operationContext)) {
                this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
            }
            chunk = this._context.getCacheImpl().GetNextChunk(pointer, operationContext);
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.GetNextChunk()", inner.toString());
            throw new OperationFailedException("GetNextChunk failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
        return chunk;
    }

    public ArrayList<Event> GetFilteredEvents(String clientID, HashMap events, EventStatus registeredEventStatus) throws Exception {
        if (this._context.PersistenceMgr != null) {
            if (this._context.PersistenceMgr.HasCompleteData()) {
                return this._context.PersistenceMgr.GetFilteredEventsList(clientID, events, registeredEventStatus);
            }
            return this._context.getCacheImpl().GetFilteredEvents(clientID, events, registeredEventStatus);
        }
        return null;
    }

    @Override
    public void OnItemAdded(Object key, OperationContext operationContext, EventContext eventContext) {
        if (this._itemAdded != null) {
            try {
                key = SerializationUtil.compactSerialize((Object)key, (String)this._context.getSerializationContext());
            }
            catch (IOException iOException) {
                this._context.getNCacheLog().Error("Cache.OnItemAdded()", iOException.toString());
                return;
            }
            this._itemAdded.fireEventsSynchronous(true, new Object[]{key, eventContext});
        }
    }

    @Override
    public void OnItemUpdated(Object key, OperationContext operationContext, EventContext eventContext) {
        if (this._itemUpdated != null) {
            try {
                key = SerializationUtil.compactSerialize((Object)key, (String)this._context.getSerializationContext());
            }
            catch (IOException iOException) {
                this._context.getNCacheLog().Error("Cache.OnItemUpdated()", iOException.toString());
                return;
            }
            this._itemUpdated.fireEventsSynchronous(true, new Object[]{key, eventContext});
        }
    }

    @Override
    public final void OnItemRemoved(Object key, Object value, ItemRemoveReason reason, OperationContext operationContext, EventContext eventContext) {
        Object data = null;
        if (value != null) {
            data = ((CacheEntry)value).getValue();
        }
        try {
            key = SerializationUtil.compactSerialize((Object)key, (String)this._context.getSerializationContext());
        }
        catch (IOException iOException) {
            this._context.getNCacheLog().Error("Cache.OnItemRemoved()", iOException.toString());
            return;
        }
        if (this._itemRemoved != null) {
            BitSet flag = null;
            if (eventContext != null && eventContext.getItem() != null && eventContext.getItem().getFlags() != null) {
                flag = eventContext.getItem().getFlags();
            }
            this._itemRemoved.fireEventsSynchronous(true, new Object[]{key, data, reason, flag, eventContext});
        }
    }

    @Override
    public final void OnItemsRemoved(Object[] keys, Object[] value, ItemRemoveReason reason, OperationContext operationContext, EventContext[] eventContext) {
        try {
            if (this._itemRemoved != null) {
                for (int i = 0; i < keys.length; ++i) {
                    this.OnItemRemoved(keys[i], null, reason, operationContext, eventContext[i]);
                }
            }
        }
        catch (Exception e) {
            this._context.getNCacheLog().Error("Cache.OnItemsRemoved()", e.toString());
        }
    }

    @Override
    public void OnCacheCleared(OperationContext operationContext, EventContext eventContext) {
        if (this._cacheCleared != null) {
            this._cacheCleared.fireEventsSynchronous(s_logClientEvents, new Object[]{null, eventContext});
        }
    }

    @Override
    public void OnCustomEvent(Object notifId, Object data, OperationContext operationContext, EventContext eventContext) {
        if (this._cusotmNotif != null) {
            this._cusotmNotif.fireEvents(true, new Object[]{notifId, data, eventContext});
        }
    }

    @Override
    public void OnCustomRemoveCallback(Object key, Object value, ItemRemoveReason reason, OperationContext operationContext, EventContext eventContext) {
        CallbackEntry cbEntry = (CallbackEntry)(value instanceof CallbackEntry ? value : null);
        Object tempVar = eventContext.GetValueByField(EventContextFieldName.ItemRemoveCallbackList);
        List removeCallbacklist = (List)(tempVar instanceof List ? tempVar : null);
        if (removeCallbacklist != null && removeCallbacklist.size() > 0) {
            for (CallbackInfo cbInfo : removeCallbacklist) {
                if (this._connectedClients == null || !this._connectedClients.contains(cbInfo.getClient()) || this._customRemoveNotif == null) continue;
                this._customRemoveNotif.fireEvents(true, new Object[]{key, new Object[]{null, cbInfo}, reason, null, eventContext});
            }
        }
    }

    @Override
    public void OnCustomUpdateCallback(Object key, Object value, OperationContext operationContext, EventContext eventContext) {
        List updateListeners = (List)(value instanceof List ? value : null);
        if (updateListeners != null && updateListeners.size() > 0) {
            List tempVar = updateListeners;
            updateListeners = tempVar instanceof List ? tempVar : null;
            for (CallbackInfo cbInfo : updateListeners) {
                if (this._connectedClients == null || !this._connectedClients.contains(cbInfo.getClient()) || this._customUpdateNotif == null) continue;
                this._customUpdateNotif.fireEvents(true, new Object[]{key, cbInfo, eventContext});
            }
        }
    }

    @Override
    public void OnHashmapChanged(NewHashmap newHashmap, boolean updateClientMap) {
        if (LicenseManager.isEntCacheServer()) {
            if (this._hashmapChanged == null) {
                return;
            }
            this._hashmapChanged.fireEvents(true, new Object[]{newHashmap, null});
        }
    }

    @Override
    public void OnWriteBehindOperationCompletedCallback(OpCode operationCode, Object result, CallbackEntry cbEntry) {
        if (cbEntry.getWriteBehindOperationCompletedCallback() == null) {
            return;
        }
        if (this._dataSourceUpdated == null) {
            return;
        }
        this._dataSourceUpdated.fireEvents(true, new Object[]{result, cbEntry, operationCode});
    }

    public final void OnAsyncOperationCompleted(AsyncOpCode opCode, Object result) {
        if (this._asyncOperationCompleted != null) {
            this._asyncOperationCompleted.fireEvents(true, new Object[]{opCode, result, null});
        }
    }

    private void ClearCallbacks() {
        if (this._asyncOperationCompleted != null) {
            this._asyncOperationCompleted.unsubscribeAllListners();
        }
        if (this._cacheStopped != null) {
            this._cacheStopped.unsubscribeAllListners();
        }
        if (this._cacheCleared != null) {
            this._cacheCleared.unsubscribeAllListners();
        }
        if (this._itemUpdated != null) {
            this._itemUpdated.unsubscribeAllListners();
        }
        if (this._itemRemoved != null) {
            this._itemRemoved.unsubscribeAllListners();
        }
        if (this._itemAdded != null) {
            this._itemAdded.unsubscribeAllListners();
        }
        if (this._customUpdateNotif != null) {
            this._customUpdateNotif.unsubscribeAllListners();
        }
        if (this._customRemoveNotif != null) {
            this._customRemoveNotif.unsubscribeAllListners();
        }
        if (this._cusotmNotif != null) {
            this._cusotmNotif.unsubscribeAllListners();
        }
    }

    @Override
    public void OnActiveQueryChanged(Object key, QueryChangeType changeType, ArrayList<CQCallbackInfo> activeQueries, OperationContext operationContext, EventContext eventContext) {
        try {
            key = SerializationUtil.compactSerialize((Object)key, (String)this._context.getSerializationContext());
        }
        catch (IOException iOException) {
            this._context.getNCacheLog().Error("Cache.OnActiveQueryChanged", "Unable to serializeKey: " + iOException.toString());
        }
        if (activeQueries != null && activeQueries.size() > 0 && this._activeQueryNotif != null) {
            this._activeQueryNotif.fireEvents(true, new Object[]{key, changeType, activeQueries, eventContext});
        }
    }

    public final QueryResultSet Search(String query, Map values, OperationContext operationContext) throws OperationFailedException, TypeIndexNotDefined {
        if (!this.getIsRunning()) {
            return null;
        }
        if (query == null || query.equals("")) {
            throw new IllegalArgumentException("query");
        }
        try {
            if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(AllowedOperationType.BulkRead, operationContext)) {
                this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
            }
            return this._context.getCacheImpl().Search(query, values, operationContext);
        }
        catch (OperationFailedException ex) {
            if (ex.getIsTracable() && this._context.getNCacheLog().getIsErrorEnabled()) {
                this._context.getNCacheLog().Error("search operation failed. Error: " + ex.toString());
            }
            if (ex.getMessage().contains("Index is not defined for")) {
                throw new TypeIndexNotDefined(ex.getMessage());
            }
            throw ex;
        }
        catch (StateTransferInProgressException inner) {
            throw inner;
        }
        catch (Alachisoft.NCache.Parser.TypeIndexNotDefined inner) {
            throw new Alachisoft.NCache.Parser.TypeIndexNotDefined(inner.getMessage());
        }
        catch (Exception ex) {
            if (this._context.getNCacheLog().getIsErrorEnabled()) {
                this._context.getNCacheLog().Error("search operation failed. Error: " + ex.toString());
            }
            if (ex.getMessage().contains("Index is not defined for")) {
                throw new TypeIndexNotDefined(ex.getMessage());
            }
            throw new OperationFailedException("search operation failed. Error: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public final QueryResultSet SearchEntries(String query, Map values, OperationContext operationContext) throws OperationFailedException, TypeIndexNotDefined {
        if (!this.getIsRunning()) {
            return null;
        }
        if (query == null || query.equals("")) {
            throw new IllegalArgumentException("query");
        }
        try {
            if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(AllowedOperationType.BulkRead, operationContext)) {
                this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
            }
            return this._context.getCacheImpl().SearchEntries(query, values, operationContext);
        }
        catch (OperationFailedException ex) {
            if (ex.getIsTracable() && this._context.getNCacheLog().getIsErrorEnabled()) {
                this._context.getNCacheLog().Error("search operation failed. Error: " + ex.toString());
            }
            if (ex.getMessage().contains("Index is not defined for")) {
                throw new TypeIndexNotDefined(ex.getMessage());
            }
            throw ex;
        }
        catch (StateTransferInProgressException inner) {
            throw inner;
        }
        catch (Exception ex) {
            if (this._context.getNCacheLog().getIsErrorEnabled()) {
                this._context.getNCacheLog().Error("search operation failed. Error: " + ex.toString());
            }
            if (ex instanceof Alachisoft.NCache.Parser.TypeIndexNotDefined) {
                throw new Alachisoft.NCache.Parser.TypeIndexNotDefined("search operation failed. Error: " + ex.getMessage());
            }
            if (ex instanceof AttributeIndexNotDefined) {
                throw new AttributeIndexNotDefined("search operation failed. Error: " + ex.getMessage());
            }
            throw new OperationFailedException("search operation failed. Error: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public final QueryResultSet SearchCQ(String query, Map values, String clientUniqueId, String clientId, boolean notifyAdd, boolean notifyUpdate, boolean notifyRemove, OperationContext operationContext, QueryDataFilters dataFilters) throws OperationFailedException, Exception {
        if (!this.getIsRunning()) {
            return null;
        }
        if (query == null || query.equals("")) {
            throw new IllegalArgumentException("query");
        }
        try {
            if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(AllowedOperationType.BulkWrite, operationContext)) {
                this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
            }
            return this._context.getCacheImpl().SearchCQ(query, values, clientUniqueId, clientId, notifyAdd, notifyUpdate, notifyRemove, operationContext, dataFilters);
        }
        catch (OperationFailedException ex) {
            if (ex.getIsTracable() && this._context.getNCacheLog().getIsErrorEnabled()) {
                this._context.getNCacheLog().Error("search operation failed. Error: " + ex.toString());
            }
            if (ex.getMessage().contains("Index is not defined for attribute")) {
                throw new com.alachisoft.ncache.runtime.exceptions.AttributeIndexNotDefined(ex.getMessage());
            }
            if (ex.getMessage().contains("Index is not defined for")) {
                throw new TypeIndexNotDefined(ex.getMessage());
            }
            throw ex;
        }
        catch (StateTransferInProgressException inner) {
            throw inner;
        }
        catch (Exception ex) {
            if (this._context.getNCacheLog().getIsErrorEnabled()) {
                this._context.getNCacheLog().Error("search operation failed. Error: " + ex.toString());
            }
            throw new OperationFailedException("search operation failed. Error: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public final QueryResultSet SearchEntriesCQ(String query, Map values, String clientUniqueId, String clientId, boolean notifyAdd, boolean notifyUpdate, boolean notifyRemove, OperationContext operationContext, QueryDataFilters dataFilters) throws OperationFailedException, Exception {
        if (!this.getIsRunning()) {
            return null;
        }
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(AllowedOperationType.BulkWrite, operationContext)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        if (query == null || query.equals("")) {
            throw new IllegalArgumentException("query");
        }
        try {
            return this._context.getCacheImpl().SearchEntriesCQ(query, values, clientUniqueId, clientId, notifyAdd, notifyUpdate, notifyRemove, operationContext, dataFilters);
        }
        catch (OperationFailedException ex) {
            if (ex.getIsTracable() && this._context.getNCacheLog().getIsErrorEnabled()) {
                this._context.getNCacheLog().Error("search operation failed. Error: " + ex.toString());
            }
            if (ex.getMessage().contains("Index is not defined for attribute")) {
                throw new com.alachisoft.ncache.runtime.exceptions.AttributeIndexNotDefined(ex.getMessage());
            }
            if (ex.getMessage().contains("Index is not defined for")) {
                throw new TypeIndexNotDefined(ex.getMessage());
            }
            throw ex;
        }
        catch (StateTransferInProgressException inner) {
            throw inner;
        }
        catch (Exception ex) {
            if (this._context.getNCacheLog().getIsErrorEnabled()) {
                this._context.getNCacheLog().Error("search operation failed. Error: " + ex.toString());
            }
            throw new OperationFailedException("search operation failed. Error: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public void DeleteQuery(String query, Map values, OperationContext operationContext) throws OperationFailedException, Exception {
        if (!this.getIsRunning()) {
            return;
        }
        if (query == null || query.equals("")) {
            throw new IllegalArgumentException("query");
        }
        try {
            if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(AllowedOperationType.BulkRead, operationContext)) {
                this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
            }
            operationContext.Add(OperationContextFieldName.NotifyRemove, true);
            DeleteQueryResultSet result = this._context.getCacheImpl().DeleteQuery(query, values, true, true, ItemRemoveReason.Removed, operationContext);
            operationContext.Add(OperationContextFieldName.NotifyRemove, false);
            if (result != null) {
                this.RemoveCascadedDependencies(result.getKeysDependingOnMe(), operationContext);
            }
        }
        catch (StateTransferInProgressException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (this._context.getNCacheLog().getIsErrorEnabled()) {
                this._context.getNCacheLog().Error("delete query operation failed. Error: " + ex.toString());
            }
            throw new OperationFailedException("search operation failed. Error: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public int RemoveQuery(String query, Map values, OperationContext operationContext) throws OperationFailedException, Exception {
        if (!this.getIsRunning()) {
            return 0;
        }
        if (query == null || query.equals("")) {
            throw new IllegalArgumentException("query");
        }
        try {
            if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(AllowedOperationType.BulkRead, operationContext)) {
                this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
            }
            operationContext.Add(OperationContextFieldName.NotifyRemove, true);
            DeleteQueryResultSet result = this._context.getCacheImpl().DeleteQuery(query, values, true, true, ItemRemoveReason.Removed, operationContext);
            operationContext.Add(OperationContextFieldName.NotifyRemove, false);
            if (result != null) {
                this.RemoveCascadedDependencies(result.getKeysDependingOnMe(), operationContext);
            }
            if (this._context.PerfStatsColl != null) {
                this._context.PerfStatsColl.incrementDelPerSecStatsBy(result.getKeysEffectedCount() + result.getKeysDependingOnMe().size());
            }
            if (result != null) {
                return result.getKeysEffectedCount();
            }
            return 0;
        }
        catch (OperationFailedException ex) {
            if (ex.getIsTracable() && this._context.getNCacheLog().getIsErrorEnabled()) {
                this._context.getNCacheLog().Error("search operation failed. Error: " + ex.toString());
            }
            if (ex.getMessage().contains("Index is not defined for attribute")) {
                throw new com.alachisoft.ncache.runtime.exceptions.AttributeIndexNotDefined(ex.getMessage());
            }
            if (ex.getMessage().contains("Index is not defined for")) {
                throw new TypeIndexNotDefined(ex.getMessage());
            }
            throw ex;
        }
        catch (StateTransferInProgressException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (this._context.getNCacheLog().getIsErrorEnabled()) {
                this._context.getNCacheLog().Error("Remove operation failed. Error: " + ex.toString());
            }
            throw new OperationFailedException("Remove operation failed. Error: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public final CacheInsResultWithEntry CascadedInsert(Object key, CacheEntry entry, boolean notify, Object lockId, long version, LockAccessType accessType, OperationContext operationContext) throws OperationFailedException, GeneralFailureException, LockingException, CacheException {
        CacheInsResultWithEntry result;
        Object block = null;
        Boolean isNoBlock = false;
        block = operationContext.GetValueByField(OperationContextFieldName.NoGracefulBlock);
        if (block != null) {
            isNoBlock = (Boolean)block;
        }
        if (!isNoBlock.booleanValue() && this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(key, AllowedOperationType.AtomicWrite)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        if ((result = this._context.getCacheImpl().Insert(key, entry, notify, lockId, version, accessType, operationContext)).getEntry() != null && result.getResult() != CacheInsResult.IncompatibleGroup) {
            this._context.getCacheImpl().RemoveCascadingDependencies(key, result.getEntry(), operationContext);
        }
        return result;
    }

    public final HashMap CascadedInsert(Object[] keys, CacheEntry[] cacheEntries, boolean notify, OperationContext operationContext) throws OperationFailedException, GeneralFailureException, LockingException, CacheException {
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(keys, AllowedOperationType.BulkWrite, operationContext)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        HashMap table = this._context.getCacheImpl().Insert(keys, cacheEntries, notify, operationContext);
        this._context.getCacheImpl().RemoveCascadingDependencies(table, operationContext);
        return table;
    }

    public final CacheEntry CascadedRemove(Object key, Object pack, ItemRemoveReason reason, boolean notify, Object lockId, long version, LockAccessType accessType, OperationContext operationContext) throws OperationFailedException, GeneralFailureException, LockingException, CacheException {
        CacheEntry oldEntry;
        Object block = null;
        Boolean isNoBlock = false;
        block = operationContext.GetValueByField(OperationContextFieldName.NoGracefulBlock);
        if (block != null) {
            isNoBlock = (Boolean)block;
        }
        if (!isNoBlock.booleanValue() && this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(key, AllowedOperationType.AtomicWrite)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        if ((oldEntry = this._context.getCacheImpl().Remove(pack, reason, notify, lockId, version, accessType, operationContext)) != null) {
            this._context.getCacheImpl().RemoveCascadingDependencies(key, oldEntry, operationContext);
        }
        return oldEntry;
    }

    public final HashMap CascadedRemove(Object[] keys, ItemRemoveReason reason, boolean notify, OperationContext operationContext) throws OperationFailedException, GeneralFailureException, LockingException, CacheException {
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(keys, AllowedOperationType.BulkWrite, operationContext)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        HashMap table = this._context.getCacheImpl().Remove(keys, reason, notify, operationContext);
        this._context.getCacheImpl().RemoveCascadingDependencies(table, operationContext);
        return table;
    }

    public final HashMap CascadedRemove(String group, String subGroup, boolean notify, OperationContext operationContext) throws OperationFailedException, GeneralFailureException, LockingException, CacheException {
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(AllowedOperationType.BulkWrite, operationContext)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        HashMap table = this._context.getCacheImpl().Remove(group, subGroup, notify, operationContext);
        this._context.getCacheImpl().RemoveCascadingDependencies(table, operationContext);
        return table;
    }

    public final HashMap CascadedRemove(String[] tags, TagComparisonType comaprisonType, boolean notify, OperationContext operationContext) throws OperationFailedException, GeneralFailureException, LockingException, CacheException {
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(AllowedOperationType.BulkWrite, operationContext)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        HashMap table = this._context.getCacheImpl().Remove(tags, comaprisonType, notify, operationContext);
        this._context.getCacheImpl().RemoveCascadingDependencies(table, operationContext);
        return table;
    }

    public void RemoveCascadedDependencies(HashMap keys, OperationContext operationContext) throws OperationFailedException, CacheException, LockingException, GeneralFailureException {
        this._context.getCacheImpl().RemoveDeleteQueryCascadingDependencies(keys, operationContext);
    }

    public final int GetNumberOfClientsToDisconect() {
        return 0;
    }

    @Override
    public final void OnMemberJoined(Address clusterAddress, Address serverAddress) {
        int clientsToDisconnect = 0;
        try {
            if (LicenseManager.isEntCacheServer()) {
                clientsToDisconnect = this.GetNumberOfClientsToDisconect();
            }
        }
        catch (Exception e) {
            clientsToDisconnect = 0;
        }
        try {
            if (this._memberJoined != null) {
                HashMap hd = this._memberJoined.getInvocationList();
                Iterator ide = hd.entrySet().iterator();
                for (int i = hd.size() - 1; i >= 0; --i) {
                    Map.Entry pair = ide.next();
                    if (i > clientsToDisconnect - 1) {
                        this.MemberJoinedAsyncCallbackHandler((NEventStart)pair.getKey(), clusterAddress, serverAddress, false, null);
                        continue;
                    }
                    this.MemberJoinedAsyncCallbackHandler((NEventStart)pair.getKey(), clusterAddress, serverAddress, true);
                }
            }
        }
        catch (Exception e) {
            this._context.getNCacheLog().Error("Cache.MemberJoinedAsyncCallbackHandler", e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void MemberJoinedAsyncCallbackHandler(NEventStart ar, Object ... value) {
        try {
            ar.hanleEvent(value);
        }
        catch (SocketException ex) {
            this._context.getNCacheLog().Error("Cache.MemberJoinedAsyncCallbackHandler", ex.toString());
            NEvent nEvent = this._memberJoined;
            synchronized (nEvent) {
                this._memberJoined.removeNEventListners(ar);
            }
        }
        catch (Exception e) {
            this._context.getNCacheLog().Error("Cache.MemberJoinedAsyncCallbackHandler", e.toString());
        }
    }

    @Override
    public final void OnMemberLeft(Address clusterAddress, Address serverAddress) {
        if (this._memberLeft != null) {
            this._memberLeft.fireEvents(true, new Object[]{clusterAddress, serverAddress, null});
        }
    }

    public final void RegisterKeyNotificationCallback(String key, CallbackInfo updateCallback, CallbackInfo removeCallback, OperationContext operationContext) throws OperationFailedException {
        if (!this.getIsRunning()) {
            return;
        }
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        if (updateCallback == null && removeCallback == null) {
            throw new IllegalArgumentException();
        }
        try {
            this._context.getCacheImpl().RegisterKeyNotification(key, updateCallback, removeCallback, operationContext);
        }
        catch (OperationFailedException inner) {
            if (inner.getIsTracable()) {
                this._context.getNCacheLog().Error("Cache.RegisterKeyNotificationCallback() ", inner.toString());
            }
            throw inner;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.RegisterKeyNotificationCallback() ", inner.toString());
            throw new OperationFailedException("RegisterKeyNotification failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
    }

    public final void RegisterKeyNotificationCallback(String[] keys, CallbackInfo updateCallback, CallbackInfo removeCallback, OperationContext operationContext) throws OperationFailedException {
        if (!this.getIsRunning()) {
            return;
        }
        if (keys == null) {
            throw new IllegalArgumentException("keys");
        }
        if (keys.length == 0) {
            throw new IllegalArgumentException("Keys count can not be zero");
        }
        if (updateCallback == null && removeCallback == null) {
            throw new IllegalArgumentException();
        }
        try {
            this._context.getCacheImpl().RegisterKeyNotification(keys, updateCallback, removeCallback, operationContext);
        }
        catch (OperationFailedException inner) {
            if (inner.getIsTracable()) {
                this._context.getNCacheLog().Error("Cache.RegisterKeyNotificationCallback() ", inner.toString());
            }
            throw inner;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.RegisterKeyNotificationCallback() ", inner.toString());
            throw new OperationFailedException("RegisterKeyNotification failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
    }

    public final void UnregisterKeyNotificationCallback(String key, CallbackInfo updateCallback, CallbackInfo removeCallback, OperationContext operationContext) throws OperationFailedException {
        if (!this.getIsRunning()) {
            return;
        }
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        if (updateCallback == null && removeCallback == null) {
            throw new IllegalArgumentException();
        }
        try {
            this._context.getCacheImpl().UnregisterKeyNotification(key, updateCallback, removeCallback, operationContext);
        }
        catch (OperationFailedException inner) {
            if (inner.getIsTracable()) {
                this._context.getNCacheLog().Error("Cache.UnregisterKeyNotificationCallback() ", inner.toString());
            }
            throw inner;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.UnregisterKeyNotificationCallback()", inner.toString());
            throw new OperationFailedException("UnregisterKeyNotification failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
    }

    public final void UnregisterKeyNotificationCallback(String[] keys, CallbackInfo updateCallback, CallbackInfo removeCallback, OperationContext operationContext) throws OperationFailedException {
        if (!this.getIsRunning()) {
            return;
        }
        if (keys == null) {
            throw new IllegalArgumentException("keys");
        }
        if (keys.length == 0) {
            throw new IllegalArgumentException("Keys count can not be zero");
        }
        if (updateCallback == null && removeCallback == null) {
            throw new IllegalArgumentException();
        }
        try {
            this._context.getCacheImpl().UnregisterKeyNotification(keys, updateCallback, removeCallback, operationContext);
        }
        catch (OperationFailedException inner) {
            if (inner.getIsTracable()) {
                this._context.getNCacheLog().Error("Cache.UnregisterKeyNotificationCallback() ", inner.toString());
            }
            throw inner;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.UnregisterKeyNotificationCallback()", inner.toString());
            throw new OperationFailedException("UnregisterKeyNotification failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
    }

    public final Exception CanApplyHotConfig(HotConfig hotConfig) {
        if (this._context.getCacheImpl() != null && !this._context.getCacheImpl().getInternalCache().CanChangeCacheSize(hotConfig.get_cacheMaxSize())) {
            return new Exception("You need to remove some data from cache before applying the new size");
        }
        return null;
    }

    public final void ApplyHotConfiguration(HotConfig hotConfig) throws NCacheArgumentException, Exception {
    }

    private HashMap GetUpdatedCompactTypesConfig() {
        return this.getContext()._cmptKnownTypesforNet;
    }

    public final void BalanceDataLoad() throws SuspectedException, TimeoutException, GeneralFailureException {
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(AllowedOperationType.ClusterRead, new OperationContext())) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        this._context.getCacheImpl().BalanceDataLoad();
    }

    public final NewHashmap GetOwnerHashMap(RefObject<Integer> bucketSize) {
        NewHashmap hashMap = this._context.getCacheImpl().GetOwnerHashMapTable(bucketSize);
        return hashMap;
    }

    public final CacheServerConfig getConfiguration() {
        return this._cacheInfo.getConfiguration();
    }

    public final void setConfiguration(CacheServerConfig value) {
        this._cacheInfo.setConfiguration(value);
    }

    public final void UpdateSocketServerStats(SocketServerStats stats) {
        RefObject tempRef_s_clientsRequests = new RefObject((Object)Float.valueOf(s_clientsRequests));
        RefObject tempRef_s_clientsBytesSent = new RefObject((Object)Float.valueOf(s_clientsBytesSent));
        RefObject tempRef_s_clientsBytesRecieved = new RefObject((Object)Float.valueOf(s_clientsBytesRecieved));
        AtomicReference<RefObject> atom1 = new AtomicReference<RefObject>(tempRef_s_clientsRequests);
        AtomicReference<RefObject> atom2 = new AtomicReference<RefObject>(tempRef_s_clientsBytesSent);
        AtomicReference<RefObject> atom3 = new AtomicReference<RefObject>(tempRef_s_clientsBytesRecieved);
        atom1.set(new RefObject((Object)Float.valueOf(s_clientsRequests + stats.getRequests())));
        s_clientsRequests = ((Float)tempRef_s_clientsRequests.argvalue).floatValue();
        atom2.set(new RefObject((Object)Float.valueOf(s_clientsBytesSent + stats.getBytesSent())));
        s_clientsBytesSent = ((Float)tempRef_s_clientsBytesSent.argvalue).floatValue();
        atom3.set(new RefObject((Object)Float.valueOf(s_clientsBytesRecieved + stats.getBytesRecieved())));
        s_clientsBytesRecieved = ((Float)tempRef_s_clientsBytesRecieved.argvalue).floatValue();
    }

    public final TypeInfoMap GetTypeInfoMap() {
        if (!this.getIsRunning()) {
            return null;
        }
        return this._context.getCacheImpl().getTypeInfoMap();
    }

    public final boolean IsServerNodeIp(Address clientAddress) {
        return this._context.getCacheImpl().IsServerNodeIp(clientAddress);
    }

    public final InetAddress getServerJustLeft() {
        return this._context.getCacheImpl().getServerJustLeft();
    }

    public final String OpenStream(String key, StreamModes mode, String group, String subGroup, ExpirationHint expHint, EvictionHint evictionHint, OperationContext operationContext) throws OperationFailedException, CacheException, LockingException, GeneralFailureException, StreamException, SuspectedException, TimeoutException {
        String lockHandle = UUID.randomUUID().toString() + new Long(new NCDateTime(Calendar.getInstance().getTime()).getTicks()).toString();
        return this.OpenStream(key, lockHandle, mode, group, subGroup, expHint, evictionHint, operationContext);
    }

    public final String OpenStream(String key, String lockHandle, StreamModes mode, String group, String subGroup, ExpirationHint expHint, EvictionHint evictionHint, OperationContext operationContext) throws OperationFailedException, CacheException, LockingException, GeneralFailureException, StreamException, SuspectedException, TimeoutException {
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(key, AllowedOperationType.AtomicWrite)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        if (this._context.getCacheImpl().OpenStream(key, lockHandle, mode, group, subGroup, expHint, evictionHint, operationContext)) {
            return lockHandle;
        }
        return null;
    }

    public final void CloseStream(String key, String lockHandle, OperationContext operationContext) throws OperationFailedException, CacheException, LockingException, GeneralFailureException, StreamException, TimeoutException, SuspectedException {
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(key, AllowedOperationType.AtomicWrite)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        this._context.getCacheImpl().CloseStream(key, lockHandle, operationContext);
    }

    public final int ReadFromStream(RefObject<VirtualArray> vBuffer, String key, String lockHandle, int offset, int length, OperationContext operationContext) throws OperationFailedException, CacheException, LockingException, GeneralFailureException, StreamException, TimeoutException, SuspectedException {
        int bytesRead = 0;
        try {
            if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(key, AllowedOperationType.AtomicWrite)) {
                this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
            }
            this._context.PerfStatsColl.incrementGetPerSecStats();
            bytesRead = this._context.getCacheImpl().ReadFromStream(vBuffer, key, lockHandle, offset, length, operationContext);
        }
        catch (StreamNotFoundException e) {
            this._context.PerfStatsColl.incrementMissPerSecStats();
            throw e;
        }
        return bytesRead;
    }

    public final void WriteToStream(String key, String lockHandle, VirtualArray vBuffer, int srcOffset, int dstOffset, int length, OperationContext operationContext) throws Exception {
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(key, AllowedOperationType.AtomicWrite)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        this._context.getCacheImpl().WriteToStream(key, lockHandle, vBuffer, srcOffset, dstOffset, length, operationContext);
        this._context.PerfStatsColl.incrementUpdPerSecStats();
    }

    public final long GetStreamLength(String key, String lockHandle, OperationContext operationContext) throws OperationFailedException, CacheException, LockingException, GeneralFailureException, StreamException, SuspectedException, TimeoutException {
        if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(key, AllowedOperationType.AtomicWrite)) {
            this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
        }
        return this._context.getCacheImpl().GetStreamLength(key, lockHandle, operationContext);
    }

    public final String RegisterCQ(String query, Map values, String clientUniqueId, String clientId, boolean notifyAdd, boolean notifyUpdate, boolean notifyRemove, OperationContext operationContext, QueryDataFilters dataFilter) throws OperationFailedException, Exception {
        if (!this.getIsRunning()) {
            return null;
        }
        try {
            if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(AllowedOperationType.BulkWrite, operationContext)) {
                this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
            }
            return this._context.getCacheImpl().RegisterCQ(query, values, clientUniqueId, clientId, notifyAdd, notifyUpdate, notifyRemove, operationContext, dataFilter);
        }
        catch (OperationFailedException inner) {
            if (inner.getIsTracable()) {
                this._context.getNCacheLog().Error("Cache.RegisterContinuousQuery()", inner.toString());
            }
            if (inner.getMessage().contains("Index is not defined for attribute")) {
                throw new com.alachisoft.ncache.runtime.exceptions.AttributeIndexNotDefined(inner.getMessage());
            }
            if (inner.getMessage().contains("Index is not defined for")) {
                throw new TypeIndexNotDefined(inner.getMessage());
            }
            throw inner;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.RegisterContinuousQuery()", inner.toString());
            throw new OperationFailedException("RegisterContinuousQuery operation failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
    }

    public final void UnRegisterCQ(String serverUniqueId, String clientUniqueId, String clientId) throws OperationFailedException {
        if (!this.getIsRunning()) {
            return;
        }
        try {
            if (this._shutDownStatusLatch.IsAnyBitsSet((byte)2) && !this._context.getCacheImpl().IsOperationAllowed(AllowedOperationType.ClusterRead, new OperationContext())) {
                this._shutDownStatusLatch.WaitForAny((byte)5, this.getBlockInterval() * 1000L);
            }
            this._context.getCacheImpl().UnRegisterCQ(serverUniqueId, clientUniqueId, clientId);
        }
        catch (OperationFailedException inner) {
            if (inner.getIsTracable()) {
                this._context.getNCacheLog().Error("Cache.UnRegisterCQ()", inner.toString());
            }
            throw inner;
        }
        catch (Exception inner) {
            this._context.getNCacheLog().Error("Cache.UnRegisterCQ()", inner.toString());
            throw new OperationFailedException("UnRegisterCQ operation failed. Error : " + inner.getMessage(), (Throwable)inner);
        }
    }

    public void ClearCollection(CollectionOperation operation, OperationContext operationContext) {
    }

    public int GetCollectionCount(CollectionOperation operation, OperationContext operationContext) {
        return 0;
    }

    public Object GetCollectionChunk(GetCollectionChunkOperation operation, OperationContext operationContext) {
        return null;
    }

    public long CounterOperations(CounterOperation operation, OperationContext operationContext) {
        return 0L;
    }

    public long CounterGetOperation(CounterGetOperation operation, OperationContext operationContext) {
        return 0L;
    }

    public int DictionaryRemove(DictionaryRemoveOperation operation, OperationContext operationContext) {
        return 0;
    }

    public void DictionaryAdd(DictionaryAddOperation operation, OperationContext operationContext) {
    }

    public Collection<ExtendedJsonValueBase> DictionaryGet(DictionaryGetOperation operation, OperationContext operationContext) {
        return null;
    }

    public boolean DictionaryContains(DictionaryContainsOperation operation, OperationContext operationContext) {
        return false;
    }

    public void HashSetAdd(HashSetAddOperation operation, OperationContext operationContext) {
    }

    public int HashSetRemove(HashSetRemoveOperation operation, OperationContext operationContext) {
        return 0;
    }

    public List<ExtendedJsonValueBase> HashSetGet(HashSetGetRandomOperation operation, OperationContext operationContext) {
        return null;
    }

    public InsertCollectionResponse HashSetRemoveRndom(HashSetRemoveRandomOperation operation, OperationContext operationContext) {
        return null;
    }

    public boolean HashSetContains(HashSetContainsOperation operation, OperationContext operationContext) {
        return false;
    }

    public void ListAddWithoutIndex(ListAddWithoutIndexOperation operation, OperationContext operationContext) {
    }

    public final boolean ListAddWithPivot(ListAddWithPivotOperation operation, OperationContext context) {
        return false;
    }

    public final List<ExtendedJsonValueBase> ListGetBulk(ListGetBulkOperation operation, OperationContext context) {
        return null;
    }

    public int ListRemoveWithoutIndex(ListRemoveWithoutIndexOperation operation, OperationContext operationContext) {
        return 0;
    }

    public void ListRemoveWithIndex(ListRemoveWithIndexOperation operation, OperationContext operationContext) {
    }

    public void ListInsertWithIndex(ListInsertWithIndexOperation operation, OperationContext operationContext) {
    }

    public int ListSearch(ListSearchOperation operation, OperationContext operationContext) {
        return 0;
    }

    public ExtendedJsonValueBase ListGetItem(ListGetItemOperation operation, OperationContext operationContext) {
        return null;
    }

    public boolean QueueEnqueue(QueueEnqueueOperation operation, OperationContext operationContext) {
        return false;
    }

    public ExtendedJsonValueBase QueueDequeue(QueueDequeueOperation operation, OperationContext operationContext) {
        return null;
    }

    public ExtendedJsonValueBase QueuePeek(QueuePeekOperation operation, OperationContext operationContext) {
        return null;
    }

    public boolean QueueSearch(QueueSearchOperation operation, OperationContext operationContext) {
        return false;
    }

    public SerializationFormat getSerializationFormat() {
        return null;
    }

    public Map getBulkCache(String[] keys, BitSet flagMap, ReadThruOptions readOption, OperationContext operationContext) {
        return null;
    }

    public DataFormat getDataFormat() {
        return null;
    }

    public void Touch(ArrayList<String> keys, OperationContext operationContext) {
    }

    static {
        _isClientCache = true;
        s_clientsRequests = 0.0f;
        s_clientsBytesRecieved = 0.0f;
        s_clientsBytesSent = 0.0f;
        try {
            MiscUtil.RegisterCompactTypes();
        }
        catch (NCacheArgumentException nCacheArgumentException) {
            // empty catch block
        }
        String tmpStr = ServicePropValues.CacheServer_LogClientEvents;
        if (tmpStr != null && !tmpStr.equals("")) {
            s_logClientEvents = Boolean.parseBoolean(tmpStr);
        }
    }

    public static interface CacheStartedEvent {
        public void invoke(String var1);
    }

    public static interface CacheStoppedEvent {
        public void invoke(String var1);
    }
}

