/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.CacheLoader;

import com.alachisoft.ncache.runtime.caching.NamedTagsDictionary;
import com.alachisoft.ncache.runtime.caching.Tag;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.alachisoft.ncache.serialization.util.TypeInfoMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tangible.DotNetToJavaStringHelper;

public class CacheLoaderUtil {
    public static int EvaluateExpirationParameters(Date absoluteExpiration, TimeSpan slidingExpiration) throws IllegalArgumentException {
        if (absoluteExpiration == null && slidingExpiration == null) {
            return 2;
        }
        if (absoluteExpiration == null) {
            if (slidingExpiration.compareTo(TimeSpan.Zero) < 0) {
                throw new IllegalArgumentException("slidingExpiration");
            }
            Calendar date = Calendar.getInstance();
            date.add(1, 1);
            if (slidingExpiration.compareTo(TimeSpan.subtract((Date)date.getTime(), (Date)Calendar.getInstance().getTime())) >= 0) {
                throw new IllegalArgumentException("slidingExpiration");
            }
            return 0;
        }
        if (slidingExpiration == null) {
            return 1;
        }
        throw new IllegalArgumentException("You cannot set both sliding and absolute expirations on the same cache item.");
    }

    public static void EvaluateTagsParameters(HashMap queryInfo, String group) {
        if (queryInfo != null && !DotNetToJavaStringHelper.isNullOrEmpty((String)group) && queryInfo.get("tag-info") != null) {
            throw new IllegalArgumentException("You cannot set both groups and tags on the same cache item.");
        }
    }

    public static HashMap GetJavaTagInfo(String fullName, Tag[] tags) {
        if (tags == null) {
            return null;
        }
        HashMap<String, Object> tagInfo = new HashMap<String, Object>();
        ArrayList<String> tagsList = new ArrayList<String>();
        for (Tag tag : tags) {
            if (tag == null) {
                throw new IllegalArgumentException("Tag");
            }
            if (tag.getTagName() == null) continue;
            tagsList.add(tag.getTagName());
        }
        tagInfo.put("type", fullName);
        tagInfo.put("tags-list", tagsList);
        return tagInfo;
    }

    public static HashMap GetTagInfo(Object value, Tag[] tags) {
        if (tags == null) {
            return null;
        }
        HashMap<String, Object> tagInfo = new HashMap<String, Object>();
        ArrayList<String> tagsList = new ArrayList<String>();
        for (Tag tag : tags) {
            if (tag == null) {
                throw new IllegalArgumentException("Tag cannot be null");
            }
            if (tag.getTagName() == null) continue;
            tagsList.add(tag.getTagName());
        }
        tagInfo.put("type", value.getClass().getName());
        tagInfo.put("tags-list", tagsList);
        return tagInfo;
    }

    public static HashMap GetJavaNamedTagsInfo(String fullName, NamedTagsDictionary namedTags, TypeInfoMap typeMap) throws Exception {
        CacheLoaderUtil.CheckJavaDuplicateIndexName(fullName, namedTags, typeMap);
        if (namedTags == null || namedTags.getCount() == 0) {
            return null;
        }
        HashMap<String, Object> tagInfo = new HashMap<String, Object>();
        HashMap tagsList = new HashMap();
        Iterator ide = namedTags.getIterator();
        while (ide.hasNext()) {
            Map.Entry nameValue = (Map.Entry)ide.next();
            if (nameValue.getValue() == null) {
                throw new IllegalArgumentException("Named Tag value cannot be null");
            }
            tagsList.put(nameValue.getKey(), nameValue.getValue());
        }
        String typeName = fullName;
        typeName = typeName.replace("+", ".");
        tagInfo.put("type", typeName);
        tagInfo.put("named-tags-list", tagsList);
        return tagInfo;
    }

    private static void CheckJavaDuplicateIndexName(String fullName, NamedTagsDictionary namedTags, TypeInfoMap typeMap) throws Exception {
        if (namedTags == null || typeMap == null) {
            return;
        }
        String typeName = fullName;
        int handleId = typeMap.getHandleId(typeName = typeName.replace("+", "."));
        if (handleId != -1) {
            ArrayList attributes = typeMap.getAttribList(handleId);
            for (Object name : attributes) {
                if (!namedTags.contains(name.toString())) continue;
                throw new Exception("Key in named tags conflicts with the indexed attribute name of the specified object.");
            }
        }
    }

    public static HashMap GetNamedTagsInfo(Object value, NamedTagsDictionary namedTags, TypeInfoMap typeMap) throws Exception {
        CacheLoaderUtil.CheckDuplicateIndexName(value, namedTags, typeMap);
        if (namedTags == null || namedTags.getCount() == 0) {
            return null;
        }
        HashMap<String, Object> tagInfo = new HashMap<String, Object>();
        HashMap tagsList = new HashMap();
        Iterator ide = namedTags.getIterator();
        while (ide.hasNext()) {
            Map.Entry nameValue = (Map.Entry)ide.next();
            if (nameValue.getValue() == null) {
                throw new IllegalArgumentException("Named Tag value cannot be null");
            }
            tagsList.put(nameValue.getKey(), nameValue.getValue());
        }
        String typeName = value.getClass().getName();
        typeName = typeName.replace("+", ".");
        tagInfo.put("type", typeName);
        tagInfo.put("named-tags-list", tagsList);
        return tagInfo;
    }

    private static void CheckDuplicateIndexName(Object value, NamedTagsDictionary namedTags, TypeInfoMap typeMap) throws Exception {
        if (namedTags == null || value == null || typeMap == null) {
            return;
        }
        String typeName = value.getClass().getName();
        int handleId = typeMap.getHandleId(typeName = typeName.replace("+", "."));
        if (handleId != -1) {
            ArrayList attributes = typeMap.getAttribList(handleId);
            for (Object name : attributes) {
                if (!namedTags.contains(name.toString())) continue;
                throw new Exception("Key in named tags conflicts with the indexed attribute name of the specified object.");
            }
        }
    }

    public static HashMap GetQueryInfo(Object value, TypeInfoMap typeMap) {
        HashMap queryInfo = null;
        if (typeMap == null) {
            return null;
        }
        try {
            int handleId = typeMap.getHandleId(value.getClass().getName());
            if (handleId != -1) {
                queryInfo = new HashMap();
                Object valType = null;
                ArrayList<Object> attribValues = new ArrayList<Object>();
                ArrayList attributes = typeMap.getAttribList(handleId);
                for (int i = 0; i < attributes.size(); ++i) {
                    Object propertyAttrib = null;
                    if (propertyAttrib != null) continue;
                    Field fieldAttrib = value.getClass().getField((String)attributes.get(i));
                    if (fieldAttrib != null) {
                        Object attribValue = fieldAttrib.get(value);
                        if (attribValue instanceof String) {
                            attribValue = attribValue.toString();
                        }
                        if (attribValue instanceof Date) {
                            NCDateTime ncd = new NCDateTime((Date)attribValue);
                            attribValue = Long.toString(ncd.getTicks());
                        }
                        attribValues.add(attribValue);
                        continue;
                    }
                    throw new Exception("Unable extracting query information from user object.");
                }
                queryInfo.put(handleId, attribValues);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return queryInfo;
    }
}

