/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.CacheLoader;

import Alachisoft.NCache.Caching.Cache;
import Alachisoft.NCache.Caching.CacheLoader.JarFileLoader;
import Alachisoft.NCache.Caching.CacheLoader.LoadCacheTask;
import Alachisoft.NCache.Caching.DatasourceProviders.ClassPaths;
import Alachisoft.NCache.Common.DirectoryUtil;
import Alachisoft.NCache.Common.Enum.EventType;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Logger.EventLogger;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Util.AuthenticateFeature;
import Alachisoft.NCache.Common.Util.LanguageContext;
import com.alachisoft.ncache.runtime.cacheloader.CacheLoader;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.serialization.standard.CompactBinaryFormatter;
import com.alachisoft.ncache.serialization.util.SerializationUtil;
import com.alachisoft.ncache.serialization.util.TypeInfoMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class CacheStartupLoader
implements IDisposable {
    private static final String clInterface = "com.alachisoft.ncache.runtime.cacheloader.CacheLoader";
    private LoadCacheTask _task;
    private CacheLoader _cacheLoader;
    private Cache _cache;
    private int _noOfRetries;
    private int _retryInterval;
    private Map _properties;
    private boolean _loadCache = false;
    private ILogger NCacheLog;
    private boolean _enabled;
    private LanguageContext _languageContext = LanguageContext.NONE;
    private JarFileLoader _loader;
    private boolean _isTaskCompleted = false;
    private boolean _isloaderTaskIntruppted = false;

    public CacheStartupLoader(Map properities, Cache cache, ILogger NCacheLog) throws Exception {
        this._noOfRetries = properities.containsKey("retries") ? Integer.parseInt(properities.get("retries").toString()) : 0;
        this._retryInterval = properities.containsKey("retry-interval") ? Integer.parseInt(properities.get("retry-interval").toString()) : 0;
        if (properities.containsKey("enabled")) {
            this._enabled = Boolean.parseBoolean(properities.get("enabled").toString());
        }
        this._cache = cache;
        this.NCacheLog = NCacheLog;
        this._properties = properities;
        try {
            if (this._enabled) {
                this.Initialize(properities);
            }
        }
        catch (Exception ex) {
            EventLogger.LogEvent((String)("ICacheLoader.Initialize. Error:" + ex.toString()), (EventType)EventType.WARNING);
            NCacheLog.Error("CacheStartupLoader.Initialize", ex.toString());
            throw ex;
        }
    }

    public final boolean getIsCacheLoaderTaskCompleted() {
        return this._isTaskCompleted;
    }

    public final void setIsCacheLoaderTaskCompleted(boolean value) {
        this._isTaskCompleted = value;
    }

    public final boolean getIsCacheLoaderTaskIntruppted() {
        return this._isloaderTaskIntruppted;
    }

    public final void setIsCacheLoaderTaskIntruppted(boolean value) {
        this._isloaderTaskIntruppted = value;
    }

    public final boolean getIsCacheloaderEnabled() {
        return this._enabled;
    }

    public final boolean getExecuteCacheLoader() {
        return this._loadCache;
    }

    public final void setExecuteCacheLoader(boolean value) {
        this._loadCache = value;
    }

    public final LoadCacheTask getTask() {
        return this._task;
    }

    public final void setTask(LoadCacheTask value) {
        this._task = value;
    }

    public final int getNoOfRetries() {
        return this._noOfRetries;
    }

    public final void setNoOfRetries(int value) {
        this._noOfRetries = value;
    }

    public final int getRetryInterval() {
        return this._retryInterval * 1000;
    }

    public final void setRetryInterval(int value) {
        this._retryInterval = value;
    }

    public final Map getProperties() {
        return this._properties;
    }

    public final void setProperties(Map value) {
        this._properties = value;
    }

    public final void Initialize() throws ConfigurationException {
        this.Initialize(this.getProperties());
    }

    private void Initialize(Map properties) throws ConfigurationException {
        if (properties == null) {
            throw new IllegalArgumentException("properties");
        }
        try {
            HashMap startupparams;
            if (!properties.containsKey("assembly")) {
                throw new ConfigurationException("Missing assembly name");
            }
            if (!properties.containsKey("classname")) {
                throw new ConfigurationException("Missing class name");
            }
            String assembly = String.valueOf(properties.get("assembly"));
            String classname = String.valueOf(properties.get("classname"));
            String assemblyFullName = String.valueOf(properties.get("full-name"));
            String extension = ".dll";
            if (properties.containsKey("full-name")) {
                extension = assemblyFullName.split("\\.")[assemblyFullName.split("\\.").length - 1];
            }
            if ((startupparams = (HashMap)(properties.get("parameters") instanceof Map ? properties.get("parameters") : null)) == null) {
                startupparams = new HashMap();
            }
            try {
                if (extension.endsWith(".dll") || extension.endsWith(".exe")) {
                    throw new UnsupportedOperationException(".exe or .dll not allowed as of yet");
                }
                if (extension.endsWith("jar") || extension.endsWith("class")) {
                    AuthenticateFeature.Authenticate((LanguageContext)LanguageContext.JAVA);
                    this._languageContext = LanguageContext.JAVA;
                    File path = DirectoryUtil.createDeployAssemblyFolder((String)this._cache.getName());
                    if (this._loader == null) {
                        this._loader = ClassPaths.addPath(path, this.NCacheLog);
                    }
                    this._cacheLoader = (CacheLoader)this._loader.loadClass(classname).newInstance();
                    SerializationUtil.registerTypeInfoMap((String)this._cache.getName(), (TypeInfoMap)this._cache.GetTypeInfoMap());
                }
            }
            catch (ClassCastException e) {
                throw new ConfigurationException("The class specified does not implement ICacheLoader");
            }
            catch (Exception e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
        catch (ConfigurationException e2) {
            throw e2;
        }
        catch (Exception e) {
            throw new ConfigurationException("Configuration Error: " + e.toString(), (Throwable)e);
        }
    }

    public final void LoadCache() {
    }

    private String[] loadClasses(String path, String interfaceName) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> jarClasses = new ArrayList<String>();
        if (path.endsWith(".jar")) {
            JarEntry jarEntry;
            JarInputStream jarFile = new JarInputStream(new FileInputStream(path));
            while ((jarEntry = jarFile.getNextJarEntry()) != null) {
                if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".class")) continue;
                jarClasses.add(jarEntry.getName().replaceAll("/", "\\."));
            }
            if (jarClasses != null && jarClasses.size() <= 0) {
                return null;
            }
            URL[] urls = new URL[]{};
            JarFileLoader cl = new JarFileLoader(urls);
            cl.addFile(path);
            Class<?> interFace = Class.forName(interfaceName);
            for (int i = 0; i < jarClasses.size(); ++i) {
                boolean match;
                String[] tempClass = jarClasses.get(i).toString().split(".class");
                Class<?> cls = cl.loadClass(tempClass[0]);
                boolean bl = match = !cls.isInterface() && !cls.isEnum() && interFace.isAssignableFrom(cls);
                if (!match) continue;
                list.add(tempClass[0]);
            }
            return list.toArray(new String[0]);
        }
        if (path.endsWith(".class")) {
            boolean match;
            File tempFile = new File(path);
            String pth = path.replaceAll(tempFile.getName(), "");
            File file = new File(pth);
            URL url = file.toURL();
            URL[] urls = new URL[]{url};
            Class<?> interFace = Class.forName(interfaceName);
            String[] tempClass = tempFile.getName().split("\\.");
            URLClassLoader clLoader = new URLClassLoader(urls);
            Class<?> cls = clLoader.loadClass(tempClass[0]);
            boolean bl = match = !cls.isInterface() && !cls.isEnum() && interFace.isAssignableFrom(cls);
            if (match) {
                list.add(tempClass[0]);
            }
        }
        return list.toArray(new String[0]);
    }

    private Object Safeserialize(Object serializableObject) throws IOException {
        if (serializableObject != null) {
            serializableObject = CompactBinaryFormatter.toByteBuffer((Object)serializableObject, (String)this._cache.getName());
        }
        return serializableObject;
    }

    public final void dispose() {
        if (this._cacheLoader != null) {
            try {
                this._cacheLoader.close();
            }
            catch (Exception ex) {
                EventLogger.LogEvent((String)("ICacheLoader.Dispose. Error:" + ex.toString()), (EventType)EventType.ERROR);
                this.NCacheLog.Error("CacheStartupLoader.Dispose(): ", ex.toString());
            }
            this._cacheLoader = null;
        }
        if (this._task != null && this._task.isIsRunnung()) {
            this._task.dispose();
        }
    }
}

