/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.CacheSynchronization;

import Alachisoft.NCache.Caching.AutoExpiration.DependencyHelper;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.Cache;
import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Caching.CacheSynchronization.CacheSyncDependency;
import Alachisoft.NCache.Caching.CacheSynchronization.DependencyStatus;
import Alachisoft.NCache.Caching.CacheSynchronization.ISyncCache;
import Alachisoft.NCache.Caching.CacheSynchronization.ISyncCacheEventsListener;
import Alachisoft.NCache.Caching.EvictionPolicies.PriorityEvictionHint;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Caching.Topologies.CacheAddResult;
import Alachisoft.NCache.Caching.Topologies.CacheInsResult;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.EncryptionUtil;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import Alachisoft.NCache.Common.Logger.ILogger;
import com.alachisoft.ncache.runtime.CacheItemPriority;
import com.alachisoft.ncache.runtime.caching.datasource.ResyncOptions;
import com.alachisoft.ncache.runtime.dependencies.CacheDependency;
import com.alachisoft.ncache.runtime.events.ListenerType;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import tangible.RefObject;

public class CacheSyncManager
implements IDisposable,
Runnable {
    private final Object _pollLockObj = new Object();
    private HashMap _synCaches = new HashMap();
    private HashMap _dependenciesStatus = new HashMap();
    private HashMap _dependenciesKeyMap = new HashMap();
    private HashMap _listeners = new HashMap();
    private Cache _cache;
    private String _userId;
    private String _password;
    private long _version;
    private CacheRuntimeContext _context;
    private HashMap _inactiveDependencies = new HashMap();

    public CacheSyncManager(Cache cache, CacheRuntimeContext context) {
        this._cache = cache;
        this._context = context;
    }

    @Override
    public void run() {
        this.ActivateDependencies();
    }

    private ILogger getNCacheLog() {
        return this._cache.getNCacheLog();
    }

    public final HashMap getInactiveDependencies() {
        return this._inactiveDependencies;
    }

    public void SetSecurityCredentials(byte[] userId, byte[] password) {
        this._userId = EncryptionUtil.Decrypt((byte[])userId);
        this._password = EncryptionUtil.Decrypt((byte[])password);
    }

    public final void AddDependency(Object[] keys, CacheEntry[] entries) {
        for (int i = 0; i < keys.length; ++i) {
            if (entries[i].getSyncDependency() == null) continue;
            this.AddDependency(keys[i], entries[i].getSyncDependency());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Clear() {
        try {
            Object caches;
            if (this._synCaches != null) {
                caches = new Object[this._synCaches.values().size()];
                System.arraycopy(this._synCaches.values().toArray(), 0, caches, 0, this._synCaches.values().toArray().length);
                if (caches != null) {
                    for (Object syncCacheObject : caches) {
                        ISyncCache syncCache = (ISyncCache)syncCacheObject;
                        this.RemoveDependentItems(syncCache.getCacheId(), true, false);
                    }
                }
            }
            caches = this._synCaches;
            synchronized (this._synCaches) {
                this._synCaches.clear();
                // ** MonitorExit[caches /* !! */ ] (shouldn't be in output)
                caches = this._dependenciesStatus;
                synchronized (caches) {
                    this._dependenciesStatus.clear();
                }
                caches = this._listeners;
                synchronized (caches) {
                    this._listeners.clear();
                }
                caches = this._dependenciesKeyMap;
                synchronized (caches) {
                    this._dependenciesKeyMap.clear();
                }
            }
        }
        catch (Exception e) {
            this._cache.getNCacheLog().Error("CacheSyncManager.Clear():", e.toString());
        }
        {
            return;
        }
    }

    public final void RemoveDependency(Object[] keys, CacheEntry[] entries, Map failedKeys) {
        for (int i = 0; i < keys.length; ++i) {
            if (entries[i].getSyncDependency() == null || !failedKeys.containsKey(keys[i])) continue;
            if (failedKeys.get(keys[i]) instanceof CacheAddResult) {
                if ((CacheAddResult)((Object)failedKeys.get(keys[i])) == CacheAddResult.Success) continue;
                this.RemoveDependency(keys[i], entries[i].getSyncDependency());
                continue;
            }
            if (!(failedKeys.get(keys[i]) instanceof CacheInsResult) || (CacheInsResult)((Object)failedKeys.get(keys[i])) == CacheInsResult.Success || (CacheInsResult)((Object)failedKeys.get(keys[i])) == CacheInsResult.SuccessOverwrite) continue;
            this.RemoveDependency(keys[i], entries[i].getSyncDependency());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void AddDependency(Object key, CacheSyncDependency dependency) {
        if (this._context.getIsDbSyncCoordinator()) {
            ISyncCache syncCache = dependency.getSyncCache();
            SyncEventListener listener = null;
            if (dependency != null && dependency.getCacheId() != null && !dependency.getCacheId().isEmpty()) {
                HashMap hashMap = this._dependenciesStatus;
                synchronized (hashMap) {
                    SyncItem syncItem = new SyncItem(key, dependency.getKey(), dependency.getCacheId());
                    ArrayList dependentKeys = null;
                    if (!this._dependenciesKeyMap.containsKey(syncItem)) {
                        dependentKeys = new ArrayList();
                        dependentKeys.add(syncItem.getThisKey());
                        this._dependenciesKeyMap.put(syncItem, dependentKeys);
                    } else {
                        dependentKeys = this._dependenciesKeyMap.get(syncItem) instanceof ArrayList ? this._dependenciesKeyMap.get(syncItem) : null;
                        if (!dependentKeys.contains(syncItem.getThisKey())) {
                            dependentKeys.add(syncItem.getThisKey());
                        }
                    }
                    if (!this._dependenciesStatus.containsKey(syncItem)) {
                        this._dependenciesStatus.put(syncItem, DependencyStatus.Unchanged);
                    }
                    if (this._synCaches.containsKey(dependency.getCacheId())) {
                        listener = this._listeners.get(dependency.getCacheId()) instanceof SyncEventListener ? this._listeners.get(dependency.getCacheId()) : null;
                        syncCache = this._synCaches.get(dependency.getCacheId()) instanceof ISyncCache ? this._synCaches.get(dependency.getCacheId()) : null;
                    } else {
                        try {
                            syncCache.Initialize(this._userId, this._password);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this._synCaches.put(dependency.getCacheId(), syncCache);
                        if (this._listeners.containsKey(dependency.getCacheId())) {
                            listener = this._listeners.get(dependency.getCacheId()) instanceof SyncEventListener ? this._listeners.get(dependency.getCacheId()) : null;
                        } else {
                            listener = new SyncEventListener(dependency.getCacheId(), this);
                            this._listeners.put(dependency.getCacheId(), listener);
                        }
                    }
                    if (dependentKeys != null && dependentKeys.size() < 2) {
                        try {
                            syncCache.RegisterSyncKeyNotifications((String)syncItem.getKey(), listener, ListenerType.PushBasedNotification);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        } else {
            SyncItem syncItem = new SyncItem(key, dependency.getKey(), dependency.getCacheId());
            if (!this._inactiveDependencies.containsKey(syncItem)) {
                this._inactiveDependencies.put(syncItem, dependency);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RemoveDependency(Object key, CacheSyncDependency dependency) {
        if (this._context.getIsDbSyncCoordinator()) {
            if (dependency == null) {
                return;
            }
            try {
                SyncItem item = new SyncItem(key, dependency.getKey(), dependency.getCacheId());
                HashMap hashMap = this._dependenciesStatus;
                synchronized (hashMap) {
                    if (this._dependenciesKeyMap.containsKey(item)) {
                        ArrayList dependentKeys = this._dependenciesKeyMap.get(item) instanceof ArrayList ? this._dependenciesKeyMap.get(item) : null;
                        if (dependentKeys != null) {
                            dependentKeys.remove(key);
                            if (dependentKeys.size() > 0) {
                                return;
                            }
                        }
                        this._dependenciesKeyMap.remove(item);
                    }
                    if (!this._dependenciesStatus.containsKey(item)) {
                        return;
                    }
                    this._dependenciesStatus.remove(item);
                }
                ISyncCache syncCache = this._synCaches.get(item.getCacheId()) instanceof ISyncCache ? this._synCaches.get(item.getCacheId()) : null;
                ISyncCacheEventsListener listener = this._listeners.get(item.getCacheId()) instanceof ISyncCacheEventsListener ? this._listeners.get(item.getCacheId()) : null;
                if (syncCache != null && listener != null) {
                    syncCache.UnRegisterSyncKeyNotifications((String)item.getKey(), listener);
                }
            }
            catch (Exception e) {
                this.getNCacheLog().Error("CacheSyncManager.RemoveDependency():", e.toString());
            }
        } else {
            this._inactiveDependencies.remove(key);
        }
    }

    private Object GetItemFromSyncCache(SyncItem syncItem, RefObject<Long> version, RefObject<BitSet> flag, RefObject<Date> absoluteExpiration, RefObject<TimeSpan> slidingExpiration, RefObject<String> group, RefObject<HashMap> queryInfo, RefObject<CacheDependency> cacheDependency, RefObject<ResyncOptions> resyncOptions, RefObject<CacheItemPriority> priority) {
        ISyncCache cache;
        if (syncItem != null && (cache = (ISyncCache)(this._synCaches.get(syncItem.getCacheId()) instanceof ISyncCache ? this._synCaches.get(syncItem.getCacheId()) : null)) != null) {
            try {
                return cache.Get((String)syncItem.getKey(), version, flag, absoluteExpiration, slidingExpiration, group, queryInfo, cacheDependency, resyncOptions, priority);
            }
            catch (Exception e) {
                this.getNCacheLog().Error("CacheSyncManager.GetItemFromSyncCache():", e.toString());
            }
        }
        return null;
    }

    public final DependencyStatus GetDependencyStatus(SyncItem syncItem) {
        DependencyStatus status = DependencyStatus.Expired;
        if (this._dependenciesStatus.containsKey(syncItem)) {
            status = (DependencyStatus)((Object)this._dependenciesStatus.get(syncItem));
        }
        return status;
    }

    public final void Synchronize(SyncItem syncItem, DependencyStatus status) {
        if (this.SetItemStatus(syncItem, status)) {
            switch (status) {
                case Expired: {
                    this.RemoveSyncItem(syncItem, true);
                    break;
                }
                case HasChanged: {
                    RefObject tempRef_priority;
                    RefObject tempRef_resyncOptions;
                    RefObject tempRef_cacheDependency;
                    RefObject tempRef_queryInfo;
                    RefObject tempRef_group;
                    RefObject tempRef_slidingExpiration;
                    RefObject tempRef_absoluteExpiration;
                    RefObject tempRef_flag;
                    if (this._cache == null) break;
                    long version = 0L;
                    BitSet flag = new BitSet();
                    boolean needsResync = false;
                    String resyncProviderName = null;
                    String group = null;
                    HashMap queryInfo = null;
                    CacheDependency cacheDependency = null;
                    ResyncOptions resyncOptions = null;
                    CacheItemPriority priority = CacheItemPriority.Normal;
                    ISyncCache syncCache = this._synCaches.get(syncItem.getCacheId()) instanceof ISyncCache ? this._synCaches.get(syncItem.getCacheId()) : null;
                    Date absoluteExpiration = null;
                    TimeSpan slidingExpiration = null;
                    RefObject tempRef_version = new RefObject((Object)version);
                    Object updateItem = this.GetItemFromSyncCache(syncItem, (RefObject<Long>)tempRef_version, (RefObject<BitSet>)(tempRef_flag = new RefObject((Object)flag)), (RefObject<Date>)(tempRef_absoluteExpiration = new RefObject(absoluteExpiration)), (RefObject<TimeSpan>)(tempRef_slidingExpiration = new RefObject(slidingExpiration)), (RefObject<String>)(tempRef_group = new RefObject(group)), (RefObject<HashMap>)(tempRef_queryInfo = new RefObject(queryInfo)), (RefObject<CacheDependency>)(tempRef_cacheDependency = new RefObject(cacheDependency)), (RefObject<ResyncOptions>)(tempRef_resyncOptions = new RefObject(resyncOptions)), (RefObject<CacheItemPriority>)(tempRef_priority = new RefObject((Object)priority)));
                    if (updateItem == null) break;
                    version = (Long)tempRef_version.argvalue;
                    flag = (BitSet)tempRef_flag.argvalue;
                    resyncOptions = (ResyncOptions)tempRef_resyncOptions.argvalue;
                    group = (String)tempRef_group.argvalue;
                    queryInfo = (HashMap)tempRef_queryInfo.argvalue;
                    cacheDependency = (CacheDependency)tempRef_cacheDependency.argvalue;
                    priority = (CacheItemPriority)tempRef_priority.argvalue;
                    if (!((Date)tempRef_absoluteExpiration.argvalue).equals(NCDateTime.MaxValue)) {
                        absoluteExpiration = (Date)tempRef_absoluteExpiration.argvalue;
                    }
                    if (!((TimeSpan)tempRef_slidingExpiration.argvalue).equals(TimeSpan.Zero)) {
                        slidingExpiration = (TimeSpan)tempRef_slidingExpiration.argvalue;
                    }
                    if (resyncOptions != null) {
                        needsResync = resyncOptions.getResyncOnExpiration();
                        resyncProviderName = resyncOptions.getProviderName();
                    }
                    PriorityEvictionHint evictionHint = new PriorityEvictionHint(priority);
                    ExpirationHint expirationHint = DependencyHelper.GetExpirationHint(cacheDependency, absoluteExpiration, slidingExpiration);
                    if (expirationHint != null && needsResync) {
                        expirationHint.SetBit(2);
                    }
                    CacheSyncDependency syncDependency = new CacheSyncDependency(syncItem.getCacheId(), (String)syncItem.getKey(), syncCache);
                    ArrayList dependentKeys = this._dependenciesKeyMap.get(syncItem) instanceof ArrayList ? this._dependenciesKeyMap.get(syncItem) : null;
                    try {
                        if (dependentKeys != null) {
                            for (Object key : dependentKeys) {
                                this._cache.Insert(key, updateItem, expirationHint, syncDependency, evictionHint, group, null, queryInfo, flag, null, version, LockAccessType.PRESERVE_VERSION, null, resyncProviderName, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                            }
                        }
                        this.SetItemStatus(syncItem, DependencyStatus.Unchanged);
                        break;
                    }
                    catch (Exception exception) {
                        this.RemoveSyncItem(syncItem, true);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RemoveDependentItems(String cacheId, boolean unregisterCallbacks, boolean removeFromCache) {
        Object[] keys = null;
        HashMap hashMap = this._dependenciesStatus;
        synchronized (hashMap) {
            ISyncCache syncCache;
            if (!unregisterCallbacks && (syncCache = (ISyncCache)(this._synCaches.get(cacheId.toLowerCase()) instanceof ISyncCache ? this._synCaches.get(cacheId.toLowerCase()) : null)) != null) {
                syncCache.Dispose();
                this._synCaches.remove(cacheId.toLowerCase());
            }
            if (removeFromCache && this._dependenciesStatus.size() > 0) {
                keys = new Object[this._dependenciesStatus.keySet().size()];
                System.arraycopy(this._dependenciesStatus.keySet().toArray(), 0, keys, 0, this._dependenciesStatus.keySet().toArray().length);
            }
        }
        if (keys != null) {
            for (HashMap hashMap2 : keys) {
                SyncItem item = (SyncItem)((Object)hashMap2);
                if (!cacheId.toLowerCase().equals(item.getCacheId())) continue;
                this.RemoveSyncItem(item, unregisterCallbacks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void RemoveSyncItem(SyncItem item, boolean unregisterCallbacks) {
        if (this._cache != null) {
            try {
                ArrayList dependentKeys = null;
                HashMap hashMap = this._dependenciesStatus;
                synchronized (hashMap) {
                    this._dependenciesStatus.remove(item);
                    if (this._dependenciesKeyMap.containsKey(item)) {
                        dependentKeys = this._dependenciesKeyMap.get(item) instanceof ArrayList ? this._dependenciesKeyMap.get(item) : null;
                    }
                    this._dependenciesKeyMap.remove(item);
                }
                ISyncCache syncCache = this._synCaches.get(item.getCacheId()) instanceof ISyncCache ? this._synCaches.get(item.getCacheId()) : null;
                ISyncCacheEventsListener listener = this._listeners.get(item.getCacheId()) instanceof ISyncCacheEventsListener ? this._listeners.get(item.getCacheId()) : null;
                if (syncCache != null && listener != null && unregisterCallbacks) {
                    syncCache.UnRegisterSyncKeyNotifications((String)item.getKey(), listener);
                }
                if (dependentKeys != null) {
                    for (Object key : dependentKeys) {
                        this._cache.Remove(key, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                    }
                }
            }
            catch (Exception e) {
                this.getNCacheLog().Error("CacheSyncManager.RemoveSyncItem():", e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean SetItemStatus(SyncItem syncItem, DependencyStatus status) {
        boolean statusSet = false;
        HashMap hashMap = this._dependenciesStatus;
        synchronized (hashMap) {
            if (this._dependenciesStatus.containsKey(syncItem)) {
                this._dependenciesStatus.put(syncItem, status);
                statusSet = true;
            }
        }
        return statusSet;
    }

    public final void dispose() {
        if (this._synCaches != null) {
            Object[] caches = new Object[this._synCaches.values().size()];
            System.arraycopy(this._synCaches.values().toArray(), 0, caches, 0, this._synCaches.values().size());
            if (caches != null) {
                for (Object syncCacheObj : caches) {
                    ISyncCache syncCache = (ISyncCache)syncCacheObj;
                    if (syncCache.getCacheId() == null) continue;
                    this.RemoveDependentItems(syncCache.getCacheId(), false, false);
                }
            }
            this._synCaches.clear();
            this._dependenciesKeyMap.clear();
            this._dependenciesStatus.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ActivateDependencies() {
        try {
            HashMap hashMap = this._inactiveDependencies;
            synchronized (hashMap) {
                for (Map.Entry pair : this._inactiveDependencies.entrySet()) {
                    SyncItem item = (SyncItem)pair.getKey();
                    CacheSyncDependency dependency = (CacheSyncDependency)pair.getValue();
                    this.AddDependency(item.getThisKey(), dependency);
                }
                this._inactiveDependencies.clear();
            }
        }
        catch (Exception e) {
            this.getNCacheLog().Error("CacheSyncManager.ActivateDependencies()", e.toString());
        }
    }

    private static class SyncEventListener
    implements ISyncCacheEventsListener {
        private String _cacheid;
        private CacheSyncManager _synchronizer;

        public SyncEventListener(String cacheId, CacheSyncManager synchronizer) {
            this._cacheid = cacheId;
            this._synchronizer = synchronizer;
        }

        public boolean equals(Object obj) {
            return obj instanceof SyncEventListener && this._cacheid.equals(((SyncEventListener)obj)._cacheid);
        }

        @Override
        public final void SyncItemUpdated(String key) {
            if (this._synchronizer != null) {
                this._synchronizer.Synchronize(new SyncItem(key, this._cacheid), DependencyStatus.HasChanged);
            }
        }

        @Override
        public final void SyncItemRemoved(String key) {
            if (this._synchronizer != null) {
                this._synchronizer.Synchronize(new SyncItem(key, this._cacheid), DependencyStatus.Expired);
            }
        }

        @Override
        public void SyncItemUpdated(String[] keys) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void SyncItemRemoved(String[] keys) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void CacheStopped(String cacheId) {
            if (this._synchronizer != null) {
                this._synchronizer.RemoveDependentItems(this._cacheid, false, true);
            }
        }

        @Override
        public final void CacheCleared() {
            if (this._synchronizer != null) {
                this._synchronizer.RemoveDependentItems(this._cacheid, true, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void PollEventNotified() {
            Object object = this._synchronizer._pollLockObj;
            synchronized (object) {
                this._synchronizer._version++;
                this.notifyAll();
            }
        }
    }

    public static class SyncItem {
        private Object _key;
        private Object _thisKey;
        private String _cacheId;

        public SyncItem(Object key, String cacheid) {
            this._key = key;
            this._cacheId = cacheid;
        }

        public SyncItem(Object thisKey, Object key, String cacheid) {
            this._key = key;
            this._cacheId = cacheid;
            this._thisKey = thisKey;
        }

        public final Object getKey() {
            return this._key;
        }

        public final void setKey(Object value) {
            this._key = value;
        }

        public final Object getThisKey() {
            return this._thisKey;
        }

        public final void setThisKey(Object value) {
            this._thisKey = value;
        }

        public final String getCacheId() {
            return this._cacheId;
        }

        public final void setCacheId(String value) {
            this._cacheId = value != null ? value.toLowerCase() : value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SyncItem) {
                String key2;
                String key;
                SyncItem other = (SyncItem)(obj instanceof SyncItem ? obj : null);
                if (other._cacheId.equals(this._cacheId) && (key = (String)(other._key instanceof String ? other._key : null)).equals(key2 = (String)(this._key instanceof String ? this._key : null))) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            if (this._cacheId != null && this._key != null) {
                return (this._cacheId + this._key).hashCode();
            }
            return super.hashCode();
        }
    }
}

