/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.DatasourceProviders;

import Alachisoft.NCache.Caching.DatasourceProviders.DatasourceMgr;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Threading.Latch;
import Alachisoft.NCache.Common.Threading.Monitor;
import com.alachisoft.ncache.runtime.datasourceprovider.WriteOperation;
import java.util.ArrayList;
import java.util.Iterator;

public class DSAsyncUpdatesProcessor
implements Runnable {
    private Thread _worker;
    private UpdateQueue _updateQueue;
    private Object _processMutex;
    private boolean _isDisposing;
    private DatasourceMgr _dsMgr;
    private ILogger _ncacheLog;
    private Latch _shutdownStatusLatch = new Latch(1);

    public DSAsyncUpdatesProcessor(DatasourceMgr dsMgr, ILogger NCacheLog) {
        this._ncacheLog = NCacheLog;
        this._worker = null;
        this._processMutex = new Object();
        this._isDisposing = false;
        this._dsMgr = dsMgr;
        this._updateQueue = new UpdateQueue();
    }

    private ILogger getNCacheLog() {
        return this._ncacheLog;
    }

    public final boolean getIsRunning() {
        return this._worker != null && this._worker.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Start() {
        DSAsyncUpdatesProcessor dSAsyncUpdatesProcessor = this;
        synchronized (dSAsyncUpdatesProcessor) {
            if (this._worker == null) {
                this._worker = new Thread(this);
                this._worker.setDaemon(true);
                this._worker.setName("DataSourceAsyncUpdatesProcessor");
                this._worker.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Stop() {
        DSAsyncUpdatesProcessor dSAsyncUpdatesProcessor = this;
        synchronized (dSAsyncUpdatesProcessor) {
            Monitor.pulse((Object)this);
            Object object = this._processMutex;
            synchronized (object) {
                this._isDisposing = true;
                if (this._worker != null && this._worker.isAlive()) {
                    this._worker.stop();
                    this._worker = null;
                }
            }
        }
    }

    @Override
    public void run() {
        this.Run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void Run() {
        while (this._worker != null && !this._isDisposing) {
            WriteOperation operation = null;
            try {
                Object object = this;
                synchronized (object) {
                    if (this._updateQueue.getCount() < 1) {
                        if (this._shutdownStatusLatch.IsAnyBitsSet((byte)2)) {
                            this._shutdownStatusLatch.SetStatusBit((byte)4, (byte)2);
                            return;
                        }
                        Monitor.wait((Object)this);
                    }
                    if (this._updateQueue.getCount() > 0) {
                        operation = this._updateQueue.Dequeue();
                    } else if (this._updateQueue.getCount() == 0 && this._shutdownStatusLatch.IsAnyBitsSet((byte)2)) {
                        break;
                    }
                }
                if (operation == null) continue;
                object = this._processMutex;
                synchronized (object) {
                    if (!this._isDisposing && this._dsMgr != null) {
                        this._dsMgr.DSAsyncUpdateInCache(operation);
                    }
                }
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Exception exception) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Enqueue(WriteOperation operation) {
        DSAsyncUpdatesProcessor dSAsyncUpdatesProcessor = this;
        synchronized (dSAsyncUpdatesProcessor) {
            this._updateQueue.Enqueue(operation);
            Monitor.pulse((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void WindUpTask() {
        this._ncacheLog.CriticalInfo("DSAsyncUpdatesProcessor", "WindUp Task Started.");
        if (this._updateQueue != null) {
            this._ncacheLog.CriticalInfo("DSAsyncUpdatesProcessor", "Update processor Queue Count: " + this._updateQueue.getCount());
        }
        this._shutdownStatusLatch.SetStatusBit((byte)2, (byte)1);
        DSAsyncUpdatesProcessor dSAsyncUpdatesProcessor = this;
        synchronized (dSAsyncUpdatesProcessor) {
            Monitor.pulse((Object)this);
        }
        this._ncacheLog.CriticalInfo("DSAsyncUpdatesProcessor", "WindUp Task Ended.");
    }

    public final void WaitForShutDown(long interval) {
        this._ncacheLog.CriticalInfo("DSAsyncUpdatesProcessor", "Waiting for shutdown task completion.");
        if (this._updateQueue.getCount() > 0) {
            this._shutdownStatusLatch.WaitForAny((byte)4, interval * 1000L);
        }
        if (this._updateQueue != null && this._updateQueue.getCount() > 0) {
            this._ncacheLog.CriticalInfo("DSAsyncUpdatesProcessor", "Remaining update processor queue operations: " + this._updateQueue.getCount());
        }
        this._ncacheLog.CriticalInfo("DSAsyncUpdatesProcessor", "Shutdown task completed.");
    }

    public static class UpdateQueue
    implements Cloneable {
        private ArrayList _queue;

        public UpdateQueue() {
            this._queue = new ArrayList();
        }

        public UpdateQueue(int capacity) {
            this._queue = new ArrayList(capacity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void Enqueue(WriteOperation operationResult) {
            ArrayList arrayList = this._queue;
            synchronized (arrayList) {
                this._queue.add(operationResult);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final WriteOperation Dequeue() {
            ArrayList arrayList = this._queue;
            synchronized (arrayList) {
                if (this._queue.isEmpty()) {
                    return null;
                }
                WriteOperation value = this._queue.get(0) instanceof WriteOperation ? this._queue.get(0) : null;
                this._queue.remove(0);
                return value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final WriteOperation Peek() {
            ArrayList arrayList = this._queue;
            synchronized (arrayList) {
                if (this._queue.isEmpty()) {
                    return null;
                }
                return this._queue.get(0) instanceof WriteOperation ? this._queue.get(0) : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final WriteOperation getItem(int index) {
            ArrayList arrayList = this._queue;
            synchronized (arrayList) {
                if (index >= this._queue.size() || index < 0) {
                    throw new IndexOutOfBoundsException();
                }
                return this._queue.get(index) instanceof WriteOperation ? this._queue.get(index) : null;
            }
        }

        public final void setItem(int index, WriteOperation value) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void RemoveAt(int index) {
            ArrayList arrayList = this._queue;
            synchronized (arrayList) {
                if (index >= this._queue.size() || index < 0) {
                    throw new IndexOutOfBoundsException();
                }
                this._queue.remove(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Iterator GetEnumerator() {
            ArrayList arrayList = this._queue;
            synchronized (arrayList) {
                return this._queue.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int getCount() {
            ArrayList arrayList = this._queue;
            synchronized (arrayList) {
                return this._queue.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object clone() {
            ArrayList arrayList = this._queue;
            synchronized (arrayList) {
                return this._queue.clone();
            }
        }
    }
}

