/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Enumeration;

import Alachisoft.NCache.Caching.Cache;
import Alachisoft.NCache.Caching.CompressedValueEntry;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Common.DataStructures.EnumerationDataChunk;
import Alachisoft.NCache.Common.DataStructures.EnumerationPointer;
import Alachisoft.NCache.Common.DataStructures.GroupEnumerationPointer;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import tangible.DotNetToJavaStringHelper;

public class CacheEnumerator
implements Iterator {
    private Cache _cache;
    private EnumerationDataChunk _currentChunk;
    private Iterator<String> _currentChunkEnumerator;
    private CompressedValueEntry _currentValue;
    private String _serializationContext;
    private String _group;
    private String _subGroup;
    private Map.Entry _de;

    public CacheEnumerator(String serializationContext, String group, String subGroup, Cache cache) throws OperationFailedException {
        this._cache = cache;
        this._serializationContext = serializationContext;
        this._group = group;
        this._subGroup = subGroup;
        this.Initialize(this._group, this._subGroup);
    }

    public final void Initialize(String group, String subGroup) throws OperationFailedException {
        Object pointer = null;
        pointer = !DotNetToJavaStringHelper.isNullOrEmpty((String)group) ? new GroupEnumerationPointer(group, subGroup) : new EnumerationPointer();
        this._currentChunk = this._cache.GetNextChunk((EnumerationPointer)pointer, new OperationContext());
        if (this._currentChunk != null && this._currentChunk.getData() != null) {
            ArrayList data = this._currentChunk.getData();
            this._currentChunkEnumerator = data.iterator();
        }
    }

    public final void Reset() throws OperationFailedException {
        if (this._currentChunk != null) {
            this._currentChunk.getPointer().Reset();
        }
        if (this._currentChunkEnumerator != null) {
            this.Initialize(this._group, this._subGroup);
        }
    }

    public final boolean MoveNext() throws OperationFailedException {
        boolean result = false;
        if (this._currentChunkEnumerator != null && !(result = this._currentChunkEnumerator.hasNext()) && this._currentChunk != null && !this._currentChunk.isLastChunk()) {
            this._currentChunk = this._cache.GetNextChunk(this._currentChunk.getPointer(), new OperationContext());
            if (this._currentChunk != null && this._currentChunk.getData() != null) {
                this._currentChunkEnumerator = this._currentChunk.getData().iterator();
                result = this._currentChunkEnumerator.hasNext();
            }
        }
        if (result) {
            this._currentValue = this._cache.Get(this.getKey());
        }
        return result;
    }

    public final Object getCurrent() {
        return this.getEntry();
    }

    public final Map.Entry getEntry() {
        AbstractMap.SimpleEntry<Object, Object> sEntry;
        this._de = sEntry = new AbstractMap.SimpleEntry<Object, Object>(this.getKey(), this.getValue());
        return this._de;
    }

    public final Object getKey() {
        String key = null;
        if (this._currentChunkEnumerator != null) {
            key = this._currentChunkEnumerator.next();
        }
        return key;
    }

    public final Object getValue() {
        return this._currentValue;
    }

    @Override
    public boolean hasNext() {
        boolean result = false;
        if (this._currentChunkEnumerator != null) {
            result = this._currentChunkEnumerator.hasNext();
        }
        return result;
    }

    public Object next() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

